/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.pa.model.ExplorerViewModel;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.ColumnDefinitionHelper;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class PAUniqueRecord
extends ExplorerViewModel
implements IUniqueRecord {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Object[] row = null;

    protected PAUniqueRecord(ColumnDefinition column, Object label, int columnRef, Object[] dataRow) {
        super(column, label, columnRef);
        this.row = dataRow;
    }

    @Override
    public Object[] getRow() {
        return this.row;
    }

    @Override
    public String getTreeLabel() {
        int colPos;
        String treeLabel = super.getTreeLabel();
        if (this.getStructureKey() == DataProviderKey.STARTTIME_APPLID_TRAN && (colPos = this.getSourceProvider().getColumnPosition(ColumnDefinition.TASKTCNT)) > -1) {
            treeLabel = String.valueOf(treeLabel) + " (" + this.getRow()[colPos] + ")";
        }
        return treeLabel;
    }

    @Override
    public void clear() {
        super.clear();
        this.row = null;
    }

    @Override
    public IUniqueRecord findEquivalentIn(Object[] array) {
        return this;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return ColumnDefinitionHelper.createPropertyDescriptors(this.getSourceProvider().getColumnDefinitions());
    }

    public Object getPropertyValue(Object id) {
        return DataTypeUtilities.getAsString(this.getRow()[this.getSourceProvider().getColumnPosition(ColumnDefinition.getByDBColumnRef((String)id))]);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            return this;
        }
        if (adapter == IWorkbenchAdapter.class) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public String getDescription(Object anElement) {
        return (String)this.getLabel();
    }

    public Object getParent(Object o) {
        return this.getParent();
    }

    @Override
    public Map<ColumnDefinition, Object> getCompleteMapping(boolean withMutations) {
        HashMap<ColumnDefinition, Object> map = new HashMap<ColumnDefinition, Object>();
        ColumnDefinition[] columnDefinitionArray = this.getSourceProvider().getColumnDefinitions();
        int n = columnDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition defn = columnDefinitionArray[n2];
            map.put(defn, this.getRow()[this.getSourceProvider().getColumnPosition(defn)]);
            if (withMutations) {
                String[] stringArray = defn.getMutations();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String defn1 = stringArray[n4];
                    map.put(ColumnDefinition.getByDBColumnRef(defn1), this.getRow()[this.getSourceProvider().getColumnPosition(defn)]);
                    ++n4;
                }
            }
            ++n2;
        }
        return map;
    }
}

