/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.wizards;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.ProfilerPairing;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.model.controller.ProfileBucketController;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.cics.pa.ui.views.profiler.ProfileView;
import com.ibm.cics.pa.ui.wizards.ProfileWizardDatePage;
import com.ibm.cics.pa.ui.wizards.ProfileWizardEntityPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ProfilerWizard
extends Wizard
implements IWorkbenchWizard {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Debug debug = new Debug(ProfilerWizard.class);
    private ProfileWizardEntityPage page1;
    private IWorkbenchPartSite site;
    private ISelection startSelection;
    private ProfileWizardDatePage page3;

    public ProfilerWizard(ISelection iSelection) {
        debug.enter("ProfilerWizard", (Object)iSelection);
        this.startSelection = iSelection;
        debug.exit("ProfilerWizard");
    }

    public ProfilerWizard() {
        debug.enter("ProfilerWizard");
        debug.exit("ProfilerWizard");
    }

    public boolean performFinish() {
        debug.enter("performFinish");
        boolean response = false;
        if (PAConnectionTracker.getInstance().isConnected()) {
            final ProfilerPairing pairing = ProfileBucketController.getInstance().createPairing(this.page1.getBase1(), this.page1.getBase2(), this.page3.getBaseDate(), this.page3.getBaseTime(), this.page1.getVariant1(), this.page1.getVariant2(), this.page3.getVariantDate(), this.page3.getVariantTime());
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        ProfileView view = (ProfileView)page.showView("com.ibm.cics.pa.profiler.view");
                        if (view != null) {
                            view.setContent(pairing);
                        }
                    }
                    catch (PartInitException e) {
                        debug.error("performFinish", (Throwable)e);
                    }
                }
            });
            response = true;
        }
        debug.exit("performFinish", (Object)response);
        return response;
    }

    public void addPages() {
        debug.enter("addPages");
        super.addPages();
        this.page1 = new ProfileWizardEntityPage(this.site, Messages.getString("Profiler_Entity_title"));
        if (this.startSelection != null) {
            this.page1.setInitialSelection(this.startSelection);
        }
        this.page1.setTitle(Messages.getString("Profiler_Entity_title"));
        this.page1.setDescription(Messages.getString("Profiler_Entity_description"));
        this.page1.setImageDescriptor(Activator.getDefault().getImageDescriptor("largepro"));
        this.page3 = new ProfileWizardDatePage(this.site, Messages.getString("Profiler_Entity_title"));
        this.page3.setTitle(Messages.getString("Profiler_Entity_title"));
        this.page3.setDescription(Messages.getString("Profiler_Date_description"));
        this.page3.setImageDescriptor(Activator.getDefault().getImageDescriptor("largepro"));
        if (this.startSelection != null) {
            this.page3.setInitialSelection(this.startSelection);
        }
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page3);
        debug.exit("addPages");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.startSelection = selection;
    }
}

