/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.wizards;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.dbfunc.command.Engine;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.command.RowProcessor;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.eclipse.common.Activator;
import com.ibm.cics.pa.model.Column;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.PAContextTracker;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class ProfileWizardDatePage
extends WizardPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Debug debug = new Debug(ProfileWizardDatePage.class);
    private String baseApplid;
    private String baseTransaction;
    private String variantApplid;
    private String variantTransaction;
    protected TreeViewer baseViewer;
    protected TreeViewer variantViewer;
    private String tableused;
    private Job job1;
    protected Date startDate;
    protected Time startTime;
    private LabelProvider treeLabelProvider = new LabelProvider(){

        public Image getImage(Object element) {
            if (element instanceof Time) {
                return Column.getFor(ColumnDefinition.START_TIME).getImage();
            }
            if (element instanceof Date) {
                return Column.getFor(ColumnDefinition.START_DATE).getImage();
            }
            return null;
        }

        public String getText(Object element) {
            return DataTypeUtilities.getAsString(element);
        }
    };
    private ITreeContentProvider contentProvider = new ITreeContentProvider(){
        Map<Date, List<Time>> timeMap = new HashMap<Date, List<Time>>();

        public void dispose() {
        }

        public void inputChanged(final Viewer viewer, Object oldInput, Object newInput) {
            this.timeMap = new HashMap<Date, List<Time>>();
            if (newInput != null) {
                for (Object obj : (List)newInput) {
                    Date date = (Date)((Object[])obj)[0];
                    Time time = (Time)((Object[])obj)[1];
                    if (!this.timeMap.containsKey(date)) {
                        this.timeMap.put(date, new ArrayList());
                    }
                    this.timeMap.get(date).add(time);
                }
            }
            if (!((TreeViewer)viewer).getTree().isDisposed()) {
                viewer.refresh();
            }
            if (ProfileWizardDatePage.this.startDate != null && this.timeMap.containsKey(ProfileWizardDatePage.this.startDate)) {
                Job job = new Job(Messages.getString("SheetProxy.Initializing")){

                    protected IStatus run(IProgressMonitor monitor) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                TreeItem[] treeItemArray = ((TreeViewer)viewer).getTree().getItems();
                                int n = treeItemArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    TreeItem item = treeItemArray[n2];
                                    if (item.getData().equals(((this).this).ProfileWizardDatePage.this.startDate)) {
                                        TreeItem[] treeItemArray2 = item.getItems();
                                        int n3 = treeItemArray2.length;
                                        int n4 = 0;
                                        while (n4 < n3) {
                                            TreeItem time1 = treeItemArray2[n4];
                                            if (time1.getData().equals(((this).this).ProfileWizardDatePage.this.startTime)) {
                                                ((TreeViewer)viewer).getTree().setSelection(time1);
                                                ProfileWizardDatePage.this.setPageComplete(ProfileWizardDatePage.this.validatePage());
                                            }
                                            ++n4;
                                        }
                                    }
                                    ++n2;
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(20);
                IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getAdapter(IWorkbenchSiteProgressService.class);
                siteService.schedule(job, 0L, true);
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.timeMap.keySet().toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (this.timeMap.containsKey(parentElement)) {
                return this.timeMap.get(parentElement).toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.timeMap.containsKey(element);
        }
    };

    protected ProfileWizardDatePage(IWorkbenchPartSite site, String pageName) {
        super(pageName);
        this.setPageComplete(false);
        this.tableused = PAContextTracker.getInstance().getPerformanceTableReference();
    }

    public void createControl(Composite parent) {
        debug.enter("createControl");
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.cics.pa.ui.profilewizardentitypage");
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.createContent(composite);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
        parent.layout();
        debug.exit("createControl");
    }

    private void createContent(Composite composite) {
        debug.enter("createContent");
        Label dumbLabel = new Label(composite, 0);
        dumbLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        dumbLabel = new Label(composite, 0);
        dumbLabel.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        dumbLabel.setText(Messages.getString("Profiler_Base"));
        dumbLabel = new Label(composite, 0);
        dumbLabel = new Label(composite, 0);
        dumbLabel.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        dumbLabel.setText(Messages.getString("Profiler_Variant"));
        dumbLabel = new Label(composite, 0);
        dumbLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        dumbLabel.setText(Messages.getString("IntervalTypes.INT"));
        this.baseViewer = new TreeViewer(composite, 2048);
        this.baseViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.baseViewer.setLabelProvider((IBaseLabelProvider)this.treeLabelProvider);
        this.baseViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.baseViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProfileWizardDatePage.this.setPageComplete(ProfileWizardDatePage.this.validatePage());
            }
        });
        this.baseViewer.setAutoExpandLevel(-1);
        this.baseViewer.getTree().setToolTipText(MessageFormat.format(Messages.getString("Profiler_Tooltip_Date_List"), Messages.getString("Profiler_Base")));
        Button link1 = new Button(composite, 8);
        link1.setImage(Activator.IMGD_LINK_TO_SELECTION.createImage());
        link1.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        link1.setToolTipText(Messages.getString("Profiler_Choose_same"));
        this.variantViewer = new TreeViewer(composite, 2048);
        this.variantViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.variantViewer.setLabelProvider((IBaseLabelProvider)this.treeLabelProvider);
        this.variantViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.variantViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProfileWizardDatePage.this.setPageComplete(ProfileWizardDatePage.this.validatePage());
            }
        });
        this.variantViewer.setAutoExpandLevel(-1);
        this.variantViewer.getTree().setToolTipText(MessageFormat.format(Messages.getString("Profiler_Tooltip_Date_List"), Messages.getString("Profiler_Variant")));
        link1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileWizardDatePage.this.variantViewer.setSelection(ProfileWizardDatePage.this.baseViewer.getSelection());
            }
        });
    }

    boolean validatePage() {
        return !this.baseViewer.getSelection().isEmpty() && ((StructuredSelection)this.baseViewer.getSelection()).getFirstElement() instanceof Time && !this.variantViewer.getSelection().isEmpty() && ((StructuredSelection)this.variantViewer.getSelection()).getFirstElement() instanceof Time;
    }

    private String runDBQuery(final TreeViewer viewer, String jobString, final Selection selectionObj) {
        debug.enter("runDBQuery", (Object)jobString);
        String response = Messages.getString("SheetProxy.Initializing");
        if (PAConnectionTracker.getInstance().isConnected()) {
            this.job1 = new Job(jobString){

                protected IStatus run(IProgressMonitor monitor) {
                    final Engine engine = new Engine("com.ibm.cics.pa.connection", new RowProcessor(){

                        public Map<String, Object> getParameterMap() {
                            return new HashMap<String, Object>();
                        }

                        public SelectionObject getSelectionObject() {
                            return selectionObj;
                        }

                        public Object processRow(ResultSet resultSet) {
                            try {
                                return new Object[]{resultSet.getDate(1), resultSet.getTime(2)};
                            }
                            catch (SQLException e) {
                                debug.error("runDBQuery ", (Throwable)e);
                                return null;
                            }
                        }
                    });
                    engine.setPageSize(90000);
                    engine.addListener(new EngineShell.EngineListener(){
                        List<Object> res = new ArrayList<Object>();

                        public void dataAvailable(Collection<Object> items) {
                            this.getRes().addAll(items);
                        }

                        public void notifyResultCount(int count) {
                        }

                        public void statusUpdate(EngineShell.EngineStatus es) {
                            switch (es) {
                                case Cancelled: 
                                case Error: {
                                    engine.removeListener((EngineShell.EngineListener)this);
                                    break;
                                }
                                case Complete: {
                                    engine.removeListener((EngineShell.EngineListener)this);
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (viewer != null) {
                                                viewer.setInput(this.getRes());
                                            }
                                        }
                                    });
                                    break;
                                }
                            }
                        }

                        protected List<Object> getRes() {
                            return this.res;
                        }
                    });
                    engine.setNotifyOnCount(false);
                    engine.start();
                    return Status.OK_STATUS;
                }
            };
            this.job1.setPriority(20);
            IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getAdapter(IWorkbenchSiteProgressService.class);
            siteService.schedule(this.job1, 0L, true);
        } else {
            response = Messages.getString("Resource.status.disconnected");
        }
        debug.exit("runDBQuery", (Object)response);
        return response;
    }

    private Selection retrieveChildren(TreeViewer viewer, String applid, String transaction) {
        debug.enter("retrieveChildren", (Object)applid, (Object)transaction);
        Selection selection = PresentationFactory.getInstance().createSelectForTable(new String[]{this.tableused}, new String[]{":schema"});
        selection.getSelect().setDistinct(true);
        selection.getSelect().addSelectionColumn(ColumnDefinition.START_DATE.getDBColumnRef(), this.tableused, ColumnDefinition.START_DATE.getType(), ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn(ColumnDefinition.START_TIME.getDBColumnRef(), this.tableused, ColumnDefinition.START_TIME.getType(), ColumnReference.Function.NONE);
        selection.appendCondition(ColumnDefinition.APPLID.getDBColumnRef(), this.tableused, ColumnDefinition.APPLID.getType(), Comparator.EQ, new Object[]{applid}, QueryElement.Predicate.AND, false);
        selection.appendCondition(ColumnDefinition.TRAN.getDBColumnRef(), this.tableused, ColumnDefinition.TRAN.getType(), Comparator.EQ, new Object[]{transaction}, QueryElement.Predicate.AND, false);
        selection.addOrderByCondition(ColumnDefinition.START_DATE.getDBColumnRef(), this.tableused, Direction.ASC);
        selection.addOrderByCondition(ColumnDefinition.START_TIME.getDBColumnRef(), this.tableused, Direction.ASC);
        this.runDBQuery(viewer, String.valueOf(applid) + ' ' + transaction, selection);
        debug.exit("retrieveChildren", (Object)selection);
        return selection;
    }

    public void retrieveChildren(String baseApplid, String baseTransaction, String variantApplid, String variantTransaction) {
        debug.enter("retrieveChildren", (Object)baseApplid, (Object)baseTransaction, (Object)variantApplid, (Object)variantTransaction);
        this.baseApplid = baseApplid;
        this.baseTransaction = baseTransaction;
        this.variantApplid = variantApplid;
        this.variantTransaction = variantTransaction;
        debug.exit("retrieveChildren");
    }

    public void setVisible(boolean visibility) {
        debug.enter("setVisible", (Object)visibility);
        super.setVisible(visibility);
        if (visibility && this.baseViewer != null && StringUtil.hasContent((String)this.baseApplid) && StringUtil.hasContent((String)this.baseTransaction) && StringUtil.hasContent((String)this.variantApplid) && StringUtil.hasContent((String)this.variantTransaction)) {
            this.retrieveChildren(this.baseViewer, this.baseApplid, this.baseTransaction);
            this.retrieveChildren(this.variantViewer, this.variantApplid, this.variantTransaction);
        }
        debug.exit("setVisible");
    }

    public Time getBaseTime() {
        Object response;
        if (!this.baseViewer.getSelection().isEmpty() && (response = ((StructuredSelection)this.baseViewer.getSelection()).getFirstElement()) instanceof Time) {
            return (Time)response;
        }
        return null;
    }

    public Date getBaseDate() {
        TreeItem[] items;
        Object response;
        if (!this.baseViewer.getSelection().isEmpty() && (response = (items = this.baseViewer.getTree().getSelection())[0].getParentItem().getData()) instanceof Date) {
            return (Date)response;
        }
        return null;
    }

    public Time getVariantTime() {
        Object response;
        if (!this.variantViewer.getSelection().isEmpty() && (response = ((StructuredSelection)this.variantViewer.getSelection()).getFirstElement()) instanceof Time) {
            return (Time)response;
        }
        return null;
    }

    public Date getVariantDate() {
        TreeItem[] items;
        Object response;
        if (!this.variantViewer.getSelection().isEmpty() && (response = (items = this.variantViewer.getTree().getSelection())[0].getParentItem().getData()) instanceof Date) {
            return (Date)response;
        }
        return null;
    }

    public void setInitialSelection(ISelection currentSelection) {
        Object element;
        debug.enter("setInitialSelection", (Object)currentSelection);
        if (currentSelection != null && !currentSelection.isEmpty() && (element = ((StructuredSelection)currentSelection).getFirstElement()) instanceof IUniqueRecord) {
            Map<ColumnDefinition, Object> e0 = ((IUniqueRecord)element).getCompleteMapping(false);
            this.startDate = (Date)e0.get(ColumnDefinition.START_DATE);
            this.startTime = (Time)e0.get(ColumnDefinition.START_TIME);
        }
        debug.exit("setInitialSelection");
    }
}

