/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.wizards;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.ui.TextInput;
import com.ibm.cics.eclipse.common.ui.Utilities;
import com.ibm.cics.pa.model.definitions.TableCategorisationEnum;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.QueryCache;
import com.ibm.cics.pa.ui.builder.ResourceChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PAProjectPage
extends WizardPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(PAProjectPage.class.getPackage().getName());
    private static final String FOLDER_QUERIES = Messages.getString("QueriesFolderName");
    private static final int STANDARD_TEXT_FIELD_WIDTH = 250;
    private Text projectNameField;

    public PAProjectPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createControl");
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.cics.pa.ui.projectWizard");
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(composite);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createControl");
    }

    private final void createProjectNameGroup(Composite parent) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createProjectNameGroup");
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText(Messages.getString("NewProject_nameLabel"));
        projectLabel.setFont(parent.getFont());
        this.projectNameField = new Text(projectGroup, 2048);
        TextInput.setAccessibleLabel((Text)this.projectNameField, (Label)projectLabel);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setFont(parent.getFont());
        this.projectNameField.setText(Messages.getString("QueriesProjectName"));
        this.projectNameField.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                boolean valid = PAProjectPage.this.validatePage();
                PAProjectPage.this.setPageComplete(valid);
            }
        });
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createProjectNameGroup");
    }

    protected boolean validatePage() {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"validatePage");
        boolean result = false;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (!Utilities.hasContent((Text)this.projectNameField)) {
            this.setErrorMessage(null);
            this.setMessage(Messages.getString("NewProject_missingname"));
        } else {
            IStatus nameStatus = workspace.validateName(this.projectNameField.getText().trim(), 4);
            if (!nameStatus.isOK()) {
                this.setErrorMessage(nameStatus.getMessage());
            } else {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectNameField.getText().trim());
                if (project.exists()) {
                    this.setErrorMessage(Messages.getString("NewProject_projectExistsMessage"));
                } else {
                    result = true;
                    this.setErrorMessage(null);
                    this.setMessage(null);
                }
            }
        }
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"validatePage", (Object)result);
        return result;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectNameField.setFocus();
        }
    }

    protected boolean createExternalQueriesProject() {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createExternalQueriesProject");
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.addResourceChangeListener((IResourceChangeListener)new ResourceChangeListener());
            IWorkspaceRoot root = workspace.getRoot();
            IProject rootProject = root.getProject(this.projectNameField.getText().trim());
            if (!rootProject.exists()) {
                IResource resource;
                IFolder queriesFolder;
                rootProject.create(null);
                rootProject.open(null);
                if (rootProject.isAccessible() && !rootProject.hasNature("com.ibm.cics.pa.ui.panature")) {
                    this.setNature(rootProject);
                }
                if (rootProject.isAccessible() && (queriesFolder = rootProject.getFolder(FOLDER_QUERIES)) != null && (resource = rootProject.findMember(queriesFolder.getProjectRelativePath())) == null) {
                    queriesFolder.create(true, true, null);
                    Object[] objectArray = TableCategorisationEnum.Root.getChildren();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFolder subFolder1;
                        IResource resource1;
                        Object child = objectArray[n2];
                        if (child instanceof TableCategorisationEnum && (resource1 = queriesFolder.findMember((subFolder1 = queriesFolder.getFolder(((TableCategorisationEnum)((Object)child)).getLabel())).getProjectRelativePath())) == null) {
                            subFolder1.create(true, true, null);
                            Object[] objectArray2 = ((TableCategorisationEnum)((Object)child)).getChildren();
                            int n3 = objectArray2.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IFolder subFolder2;
                                IResource resource2;
                                Object urchin = objectArray2[n4];
                                if (urchin instanceof TableCategorisationEnum && (resource2 = subFolder1.findMember((subFolder2 = subFolder1.getFolder(((TableCategorisationEnum)((Object)urchin)).getLabel())).getProjectRelativePath())) == null) {
                                    subFolder2.create(true, true, null);
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
            }
            rootProject.open(null);
            Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createExternalQueriesProject", (Object)true);
            return true;
        }
        catch (CoreException e) {
            logger.logp(Level.SEVERE, QueryCache.class.getName(), "getExternalQueriesFolder", "Unable to create folder containing the queries", e);
            Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getExternalQueriesFolder", (Object)false);
            return false;
        }
    }

    private void setNature(IProject project) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"setNature");
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            int i = 0;
            while (i < natures.length) {
                if ("com.ibm.cics.pa.ui.panature".equals(natures[i])) {
                    return;
                }
                ++i;
            }
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = "com.ibm.cics.pa.ui.panature";
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            logger.logp(Level.SEVERE, QueryCache.class.getName(), "setNature", "Core exception", e);
        }
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"setNature");
    }
}

