/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views.profiler;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.Column;
import com.ibm.cics.pa.model.PBKey;
import com.ibm.cics.pa.model.ProfilerPairing;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.ProfilerLayout;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.views.profiler.ProfileChart;
import com.ibm.cics.pa.ui.views.profiler.ProfileView;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ProfileComposite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ProfileComposite.class);
    private GridData fillMiddle;
    private ProfilerPairing data;
    private Label baseApplid;
    private Label variantApplid;
    private Label baseTransaction;
    private Label variantTransaction;
    private Label baseDate;
    private Label variantDate;
    private Label baseTime;
    private Label variantTime;
    private DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private DateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss");
    ProfilerLayout currentLayout;
    private ProfileView profileView;
    private Control[][] controls = new Control[0][0];
    private Composite baseBlock;
    private int old_base_datum = -1;
    private int old_variant_datum = -1;

    public ProfileComposite(ProfileView profileView, Composite parent) {
        debug.enter("ProfileComposite");
        this.profileView = profileView;
        this.currentLayout = profileView.getLayout();
        parent.setLayout((Layout)this.leanLayout(new GridLayout(1, false)));
        parent.setLayoutData((Object)new GridData(4, 4, false, true));
        this.fillMiddle = new GridData(0x1000000, 4, false, false);
        this.fillMiddle.widthHint = 100;
        this.baseBlock = new Composite(parent, 0);
        this.baseBlock.setBackground(ColorConstants.white);
        this.baseBlock.setLayoutData((Object)new GridData(4, 4, true, false));
        this.baseBlock.setLayout((Layout)new GridLayout(4, false));
        this.mainSection(this.baseBlock);
        this.applyLayout(this.currentLayout, new ArrayList<ColumnDefinition>());
        debug.exit("ProfileComposite");
    }

    public void applyLayout(ProfilerLayout layout, List<ColumnDefinition> definitions) {
        debug.enter("applyLayout", (Object)layout);
        this.currentLayout = layout;
        int i = 0;
        while (i < this.controls.length) {
            int j = 0;
            while (j < this.controls[i].length) {
                this.controls[i][j].dispose();
                ++j;
            }
            ++i;
        }
        this.controls = new Control[this.currentLayout.getDefinitions().length - 2][];
        i = 0;
        while (i < this.controls.length) {
            this.controls[i] = new Control[4];
            this.controls[i][0] = new Button(this.baseBlock, 32);
            ((Button)this.controls[i][0]).setLayoutData((Object)new GridData(16384, 4, false, false));
            ((Button)this.controls[i][0]).setSelection(definitions.contains(this.currentLayout.getDefinitions()[i + 2]));
            ((Button)this.controls[i][0]).setText(this.currentLayout.getDefinitions()[i + 2].getLabel(null));
            ((Button)this.controls[i][0]).setFont(ProfileChart.fontArialLarge);
            ((Button)this.controls[i][0]).setBackground(this.baseBlock.getBackground());
            ((Button)this.controls[i][0]).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProfileComposite.this.genericCheckTester();
                }
            });
            this.controls[i][1] = new StyledText(this.baseBlock, 0);
            ((StyledText)this.controls[i][1]).setEditable(false);
            ((StyledText)this.controls[i][1]).setBackground(this.baseBlock.getBackground());
            StyleRange range1 = new StyleRange();
            range1.start = 0;
            range1.length = ((StyledText)this.controls[i][1]).getText().length();
            range1.underline = true;
            range1.background = this.baseBlock.getBackground();
            range1.underlineColor = Column.getFor(this.currentLayout.getDefinitions()[i + 2]).getColor();
            range1.underlineStyle = 0;
            ((StyledText)this.controls[i][1]).setStyleRange(range1);
            ((StyledText)this.controls[i][1]).setLayoutData((Object)new GridData(0x1000000, 4, false, false));
            this.controls[i][2] = new StyledText(this.baseBlock, 0);
            ((StyledText)this.controls[i][2]).setBackground(this.baseBlock.getBackground());
            StyleRange range2 = new StyleRange();
            ((StyledText)this.controls[i][2]).setEditable(false);
            range2.start = 0;
            range2.length = ((StyledText)this.controls[i][2]).getText().length();
            range2.underline = true;
            range2.background = this.baseBlock.getBackground();
            range2.underlineColor = Column.getFor(this.currentLayout.getDefinitions()[i + 2]).getColor();
            range2.underlineStyle = 3;
            ((StyledText)this.controls[i][2]).setStyleRange(range2);
            ((StyledText)this.controls[i][2]).setLayoutData((Object)new GridData(0x1000000, 4, false, false));
            this.controls[i][3] = new Label(this.baseBlock, 0);
            ((Label)this.controls[i][3]).setLayoutData((Object)this.fillMiddle);
            ((Label)this.controls[i][3]).setBackground(this.baseBlock.getBackground());
            ++i;
        }
        Point size = this.baseBlock.computeSize(-1, 80 + 30 * definitions.size());
        this.baseBlock.setSize(size);
        if (this.old_base_datum > -1 && this.old_variant_datum > -1) {
            this.updateFeedback(this.old_base_datum, this.old_variant_datum, true);
        }
        this.baseBlock.getParent().layout();
        debug.exit("applyLayout");
    }

    protected void genericCheckTester() {
        ArrayList<ColumnDefinition> definitions = new ArrayList<ColumnDefinition>();
        int i = 0;
        while (i < this.controls.length) {
            if (((Button)this.controls[i][0]).getSelection()) {
                definitions.add(this.currentLayout.getDefinitions()[i + 2]);
            }
            ++i;
        }
        this.profileView.setChecked(definitions);
    }

    private void mainSection(Composite base) {
        Label text = new Label(base, 0);
        text.setLayoutData((Object)new GridData(16384, 4, false, false));
        text = new Label(base, 0);
        text.setBackground(base.getBackground());
        text.setText(Messages.getString("Profiler_Base"));
        text.setFont(ProfileChart.fontArialLarge);
        text.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        text = new Label(base, 0);
        text.setBackground(base.getBackground());
        text.setText(Messages.getString("Profiler_Variant"));
        text.setFont(ProfileChart.fontArialLarge);
        text.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        text = new Label(base, 0);
        text.setBackground(base.getBackground());
        text.setFont(ProfileChart.fontArialLarge);
        text.setText(Messages.getString("Profiler_Percentage_Change"));
        text.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        text = new Label(base, 0);
        text.setBackground(base.getBackground());
        text.setLayoutData((Object)new GridData(16384, 4, false, false));
        text.setText(ColumnDefinition.APPLID.getLabel(null));
        text.setFont(ProfileChart.fontArialLarge);
        this.baseApplid = new Label(base, 0);
        this.baseApplid.setBackground(base.getBackground());
        this.baseApplid.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        this.variantApplid = new Label(base, 0);
        this.variantApplid.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        this.variantApplid.setBackground(base.getBackground());
        text = new Label(base, 0);
        text.setBackground(base.getBackground());
        text.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        text = new Label(base, 0);
        text.setBackground(base.getBackground());
        text.setText(ColumnDefinition.TRAN.getLabel(null));
        text.setFont(ProfileChart.fontArialLarge);
        this.baseTransaction = new Label(base, 0);
        this.baseTransaction.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.baseTransaction.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        this.baseTransaction.setBackground(base.getBackground());
        this.variantTransaction = new Label(base, 0);
        this.variantTransaction.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        this.variantTransaction.setBackground(base.getBackground());
        text = new Label(base, 0);
        text.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        text.setBackground(base.getBackground());
        text = new Label(base, 0);
        text.setLayoutData((Object)new GridData(16384, 4, false, false));
        text.setBackground(base.getBackground());
        text.setText(ColumnDefinition.START_DATE.getLabel(null));
        text.setFont(ProfileChart.fontArialLarge);
        this.baseDate = new Label(base, 0);
        this.baseDate.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        this.baseDate.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        this.baseDate.setBackground(base.getBackground());
        this.variantDate = new Label(base, 0);
        this.variantDate.setBackground(base.getBackground());
        text = new Label(base, 0);
        text.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        text.setBackground(base.getBackground());
        text = new Label(base, 0);
        text.setBackground(base.getBackground());
        text.setText(ColumnDefinition.START_TIME.getLabel(null));
        text.setFont(ProfileChart.fontArialLarge);
        this.baseTime = new Label(base, 0);
        this.baseTime.setBackground(base.getBackground());
        this.baseTime.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        this.variantTime = new Label(base, 0);
        this.variantTime.setBackground(base.getBackground());
        this.variantTime.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        text = new Label(base, 0);
        text.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        text.setBackground(base.getBackground());
        text = new Label(base, 0);
        text.setBackground(base.getBackground());
        text.setLayoutData((Object)new GridData(16384, 4, false, false));
        text = new Label(base, 0);
        text.setBackground(base.getBackground());
        text.setLayoutData((Object)new GridData(16384, 4, false, false));
        text = new Label(base, 0);
        text.setBackground(base.getBackground());
        text.setLayoutData((Object)new GridData(16384, 4, false, false));
        text = new Label(base, 0);
        text.setBackground(base.getBackground());
        text.setLayoutData((Object)new GridData(16384, 4, false, false));
    }

    private GridLayout leanLayout(GridLayout noMargin) {
        noMargin.marginBottom = 0;
        noMargin.marginTop = 0;
        noMargin.marginLeft = 0;
        noMargin.marginRight = 0;
        noMargin.marginWidth = 0;
        noMargin.marginHeight = 0;
        noMargin.verticalSpacing = 0;
        noMargin.horizontalSpacing = 0;
        return noMargin;
    }

    public void updateFeedback(int records_datum1, int records_datum2, boolean force) {
        debug.enter("updateFeedback", (Object)records_datum1, (Object)records_datum2);
        if (records_datum1 != this.old_base_datum || records_datum2 != this.old_variant_datum || force) {
            this.old_base_datum = records_datum1;
            this.old_variant_datum = records_datum2;
            Object[] baseMetrics = new Object[]{};
            PBKey baseKey = this.data.getBaseBucket().getKeyAtLocation(records_datum1);
            if (baseKey != null) {
                String textDate1 = this.dateFormatter.format(baseKey.getDate());
                String textTime1 = this.timeFormatter.format(baseKey.getTime());
                this.baseDate.setText(textDate1);
                this.baseTime.setText(textTime1);
                baseMetrics = this.data.getBaseBucket().getMetricsFor(baseKey);
            } else {
                this.baseDate.setText("yyyy-MM-dd");
                this.baseTime.setText("HH:mm:ss");
            }
            Object[] variantMetrics = new Object[]{};
            PBKey variantKey = this.data.getVariantBucket().getKeyAtLocation(records_datum2);
            if (variantKey != null) {
                String textDate2 = this.dateFormatter.format(variantKey.getDate());
                String textTime2 = this.timeFormatter.format(variantKey.getTime());
                this.variantDate.setText(textDate2);
                this.variantTime.setText(textTime2);
                variantMetrics = this.data.getVariantBucket().getMetricsFor(variantKey);
            } else {
                this.variantDate.setText("yyyy-MM-dd");
                this.variantTime.setText("HH:mm:ss");
            }
            this.baseApplid.setText(this.data.getBaseBucket().getApplid());
            this.baseTransaction.setText(this.data.getBaseBucket().getTransaction());
            this.variantApplid.setText(this.data.getVariantBucket().getApplid());
            this.variantTransaction.setText(this.data.getVariantBucket().getTransaction());
            ColumnDefinition[] defns = this.currentLayout.getDefinitions();
            int i = 0;
            while (i < this.controls.length && ProfilerLayout.getPositionOf(defns[i + 2]) > -1) {
                Double baseValue = baseKey != null ? ((Number)baseMetrics[ProfilerLayout.getPositionOf(defns[i + 2])]).doubleValue() : 0.0;
                Double variantValue = variantKey != null ? ((Number)variantMetrics[ProfilerLayout.getPositionOf(defns[i + 2])]).doubleValue() : 0.0;
                String delta = DataTypeUtilities.getAs2PositionPercentageString((Number)(-(baseValue - variantValue)), baseValue);
                ((StyledText)this.controls[i][1]).setText(DataTypeUtilities.getAsString(baseValue));
                ((StyledText)this.controls[i][2]).setText(DataTypeUtilities.getAsString(variantValue));
                ((Label)this.controls[i][3]).setText(delta);
                ((Label)this.controls[i][3]).setLayoutData((Object)new GridData(0x1000000, 4, false, false));
                StyleRange range1 = new StyleRange();
                range1.start = 0;
                range1.length = ((StyledText)this.controls[i][1]).getText().length();
                range1.underline = true;
                range1.background = ((StyledText)this.controls[i][1]).getParent().getBackground();
                range1.underlineColor = Column.getFor(this.currentLayout.getDefinitions()[i + 2]).getColor();
                range1.underlineStyle = 0;
                ((StyledText)this.controls[i][1]).setStyleRange(range1);
                ((StyledText)this.controls[i][1]).setLayoutData((Object)new GridData(0x1000000, 4, false, false));
                range1 = new StyleRange();
                range1.start = 0;
                range1.length = ((StyledText)this.controls[i][2]).getText().length();
                range1.underline = true;
                range1.background = ((StyledText)this.controls[i][2]).getParent().getBackground();
                range1.underlineColor = Column.getFor(this.currentLayout.getDefinitions()[i + 2]).getColor();
                range1.underlineStyle = 2;
                ((StyledText)this.controls[i][2]).setStyleRange(range1);
                ((StyledText)this.controls[i][2]).setLayoutData((Object)new GridData(0x1000000, 4, false, false));
                ++i;
            }
            this.baseDate.getParent().layout();
        }
        debug.exit("updateFeedback");
    }

    public void setContent(ProfilerPairing pairing, ProfilerLayout layout, List<ColumnDefinition> selected) {
        debug.enter("setContent");
        this.data = pairing;
        this.applyLayout(layout, selected);
        debug.exit("setContent");
    }

    public String toString() {
        ColumnDefinition[] defns = this.currentLayout.getDefinitions();
        StringBuffer buffer = new StringBuffer(Messages.getString("Profiler_Base"));
        buffer.append(' ');
        buffer.append(this.baseApplid.getText());
        buffer.append(' ');
        buffer.append(this.baseTransaction.getText());
        buffer.append(' ');
        buffer.append(this.baseDate.getText());
        buffer.append(' ');
        buffer.append(this.baseTime.getText());
        int i = 0;
        while (i < this.controls.length && ProfilerLayout.getPositionOf(defns[i + 2]) > -1) {
            buffer.append(' ');
            buffer.append(defns[i + 2].getLabel(null));
            buffer.append(' ');
            buffer.append(((StyledText)this.controls[i][1]).getText());
            ++i;
        }
        buffer.append(' ');
        buffer.append(Messages.getString("Profiler_Variant"));
        buffer.append(' ');
        buffer.append(this.variantApplid.getText());
        buffer.append(' ');
        buffer.append(this.variantTransaction.getText());
        buffer.append(' ');
        buffer.append(this.variantDate.getText());
        buffer.append(' ');
        buffer.append(this.variantTime.getText());
        i = 0;
        while (i < this.controls.length && ProfilerLayout.getPositionOf(defns[i + 2]) > -1) {
            buffer.append(' ');
            buffer.append(defns[i + 2].getLabel(null));
            buffer.append(' ');
            buffer.append(((StyledText)this.controls[i][2]).getText());
            ++i;
        }
        buffer.append(' ');
        buffer.append(Messages.getString("Profiler_Percentage_Change"));
        i = 0;
        while (i < this.controls.length && ProfilerLayout.getPositionOf(defns[i + 2]) > -1) {
            buffer.append(' ');
            buffer.append(defns[i + 2].getLabel(null));
            buffer.append(' ');
            buffer.append(((Label)this.controls[i][3]).getText());
            ++i;
        }
        return buffer.toString();
    }
}

