/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views.profiler;

import com.ibm.cics.pa.model.Column;
import com.ibm.cics.pa.model.PBKey;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.ProfilerLayout;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.views.profiler.ProfileChart;
import java.util.Date;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.Panel;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class ProfileChartTimeSlice
extends Figure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String FONT_NAME = Display.getCurrent().getSystemFont().getFontData()[0].getName();
    private static int FONT_SIZE = Display.getCurrent().getSystemFont().getFontData()[0].getHeight();
    private static Font STANDARD_BOLD = new Font((Device)Display.getDefault(), FONT_NAME, FONT_SIZE, 1);
    private double max;
    private Panel tooltip;
    Date date1;
    Date date2;
    PBKey variantKey;
    PBKey baseKey;

    public ProfileChartTimeSlice() {
        this.setBackgroundColor(ColorConstants.blue);
        this.setForegroundColor(ColorConstants.red);
        this.tooltip = new Panel();
        this.tooltip.setLayoutManager((LayoutManager)new GridLayout(4, false));
        this.setToolTip((IFigure)this.tooltip);
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClicked(MouseEvent arg0) {
                ((ProfileChart)ProfileChartTimeSlice.this.getParent()).sliceSelected(ProfileChartTimeSlice.this.baseKey, ProfileChartTimeSlice.this.variantKey);
            }

            public void mousePressed(MouseEvent arg0) {
            }

            public void mouseReleased(MouseEvent arg0) {
            }
        });
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        int height = this.getClientArea().height;
        double factor = 1.1 * this.max / (double)height;
        Math.round(Math.round(this.max / factor));
        graphics.setBackgroundColor(ColorConstants.white);
        graphics.fillRectangle(this.getClientArea());
    }

    public void assignDateData(ProfilerLayout profilerLayout, PBKey pbKey1, Object[] baseValues, PBKey pbKey2, Object[] deltaValues, List<ColumnDefinition> selectedDefinitions) {
        this.baseKey = pbKey1;
        this.variantKey = pbKey2;
        if (pbKey1 != null || pbKey2 != null) {
            this.tooltip.removeAll();
            Label label = new Label();
            this.tooltip.add((IFigure)label);
            label = new Label(DataTypeUtilities.getAsString(Messages.getString("Profiler_Base")));
            this.tooltip.add((IFigure)label);
            label.setFont(STANDARD_BOLD);
            label = new Label(DataTypeUtilities.getAsString(Messages.getString("Profiler_Variant")));
            this.tooltip.add((IFigure)label);
            label.setFont(STANDARD_BOLD);
            label = new Label(DataTypeUtilities.getAsString(Messages.getString("Profiler_Percentage_Change")));
            this.tooltip.add((IFigure)label);
            label.setFont(STANDARD_BOLD);
            ColumnDefinition[] columnDefinitionArray = profilerLayout.getDefinitions();
            int n = columnDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnDefinition definition = columnDefinitionArray[n2];
                if (selectedDefinitions.contains(definition)) {
                    label = new Label(definition.getLabel(null));
                    label.setIcon(Column.getFor(definition).getImage());
                    this.tooltip.add((IFigure)label);
                    Double baseValue = baseValues != null ? ((Number)baseValues[ProfilerLayout.getPositionOf(definition)]).doubleValue() : 0.0;
                    Double deltaValue = deltaValues != null ? ((Number)deltaValues[ProfilerLayout.getPositionOf(definition)]).doubleValue() : 0.0;
                    String delta = baseValue == 0.0 || deltaValue == 0.0 ? Messages.getString("MessagePackage.QuestionMark") : DataTypeUtilities.getAs2PositionPercentageString((Number)(-(baseValue - deltaValue)), deltaValue);
                    label = new Label(baseValue == 0.0 ? Messages.getString("MessagePackage.QuestionMark") : DataTypeUtilities.getAsString(baseValue));
                    this.tooltip.add((IFigure)label);
                    label = new Label(deltaValue == 0.0 ? Messages.getString("MessagePackage.QuestionMark") : DataTypeUtilities.getAsString(deltaValue));
                    this.tooltip.add((IFigure)label);
                    label = new Label(delta);
                    label.setLabelAlignment(4);
                    this.tooltip.add((IFigure)label);
                }
                ++n2;
            }
        }
        this.tooltip.invalidate();
    }

    public String toString() {
        return String.valueOf(this.date1.toString()) + ' ' + this.date2.toString();
    }
}

