/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.eclipse.common.ui.Utilities;
import com.ibm.cics.pa.model.AlertElement;
import com.ibm.cics.pa.model.Column;
import com.ibm.cics.pa.model.PlotModel;
import com.ibm.cics.pa.model.PlotPoint;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.PluginConstants;
import com.ibm.cics.pa.ui.figures.SingleIntervalFigure;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.views.PlotView;
import com.ibm.cics.pa.ui.views.internal.PlotViewVariance;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class SMTPlotViewVariance
extends PlotViewVariance {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(SMTPlotViewVariance.class);
    private ColumnDefinition[] headings = new ColumnDefinition[2];
    private Map<ColumnDefinition, Map<ColumnDefinition, Control>> controls = new HashMap<ColumnDefinition, Map<ColumnDefinition, Control>>();
    private List<ColumnDefinition> ignoreList = new ArrayList<ColumnDefinition>();
    private ColumnDefinition mainDefn;

    public SMTPlotViewVariance(PlotModel plotModel) {
        super(plotModel);
    }

    @Override
    public Composite createDetailSection(PlotView viewPart, Composite parent, Composite sectionClient) {
        debug.enter("createDetailSection");
        this.ignoreList.add(ColumnDefinition.DSA_INDEX);
        this.ignoreList.add(ColumnDefinition.DSA_SIZE_CUR);
        this.ignoreList.add(ColumnDefinition.FREE_STORAGE);
        this.ignoreList.add(ColumnDefinition.DSA_SIZE_USED);
        this.ignoreList.add(ColumnDefinition.DSA_SIZE_PEAK);
        this.ignoreList.add(ColumnDefinition.DSA_SIZE_PEAK_USED);
        this.ignoreList.add(ColumnDefinition.DSA_SIZE_USED_PERCENT);
        this.ignoreList.add(ColumnDefinition.PAGE_STORAGE_PERCENT);
        this.ignoreList.add(ColumnDefinition.TRANSACTIONS);
        this.viewPart = viewPart;
        this.parent = parent;
        this.detailSection = sectionClient;
        this.scrolledComposite = new ScrolledComposite(sectionClient, 512);
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setAlwaysShowScrollBars(true);
        this.detailColumnComposite = new Composite((Composite)this.scrolledComposite, 0);
        this.scrolledComposite.getVerticalBar().setIncrement(10);
        this.scrolledComposite.getVerticalBar().setPageIncrement(100);
        this.detailColumnComposite.setLayout((Layout)this.leanLayout(new GridLayout(3, false)));
        this.detailColumnComposite.setBackground(sectionClient.getBackground());
        this.scrolledComposite.setContent((Control)this.detailColumnComposite);
        this.scrolledComposite.setShowFocusedControl(true);
        this.dsaStyleHeadings(sectionClient.getBackground());
        if (this.model.getSubColumnValueLabel() != null && this.model.hasSubElements() && this.model.getElements().length > 0) {
            switch (this.model.getDSAType()) {
                case DSA: {
                    this.headings[0] = PluginConstants.DSA[0];
                    this.headings[1] = PluginConstants.DSA[1];
                    this.ignoreList.add(ColumnDefinition.MEMLIMIT_SIZE);
                    this.ignoreList.add(ColumnDefinition.EDSA_LIMIT);
                    this.ignoreList.add(ColumnDefinition.EDSA_CURRENT_TOTAL);
                    this.ignoreList.add(ColumnDefinition.EDSA_TOTAL_PEAK);
                    this.ignoreList.add(ColumnDefinition.PEAK_GDSA_ACTIVE);
                    this.ignoreList.add(ColumnDefinition.CURRENT_ACTIV_GDSA);
                    this.mainDefn = ColumnDefinition.DSA_LIMIT;
                    viewPart.setPartName(Messages.getString("ChartDefinition.TASK_SUBPOOLS_OVERVIEW"));
                    break;
                }
                case EDSA: {
                    this.headings[0] = PluginConstants.EDSA[0];
                    this.headings[1] = PluginConstants.EDSA[1];
                    this.ignoreList.add(ColumnDefinition.MEMLIMIT_SIZE);
                    this.ignoreList.add(ColumnDefinition.DSA_LIMIT);
                    this.ignoreList.add(ColumnDefinition.DSA_CURRENT_TOTAL);
                    this.ignoreList.add(ColumnDefinition.DSA_TOTAL_PEAK);
                    this.ignoreList.add(ColumnDefinition.PEAK_GDSA_ACTIVE);
                    this.ignoreList.add(ColumnDefinition.CURRENT_ACTIV_GDSA);
                    this.mainDefn = ColumnDefinition.EDSA_LIMIT;
                    viewPart.setPartName(Messages.getString("ChartDefinition.TASK_SUBPOOLS_OVERVIEW"));
                    break;
                }
                default: {
                    this.headings[0] = PluginConstants.GDSA[0];
                    this.headings[1] = PluginConstants.GDSA[1];
                    this.ignoreList.add(ColumnDefinition.EDSA_LIMIT);
                    this.ignoreList.add(ColumnDefinition.DSA_LIMIT);
                    this.ignoreList.add(ColumnDefinition.DSA_CURRENT_TOTAL);
                    this.ignoreList.add(ColumnDefinition.DSA_TOTAL_PEAK);
                    this.ignoreList.add(ColumnDefinition.EDSA_CURRENT_TOTAL);
                    this.ignoreList.add(ColumnDefinition.EDSA_TOTAL_PEAK);
                    this.mainDefn = ColumnDefinition.MEMLIMIT_SIZE;
                    viewPart.setPartName(Messages.getString("ChartDefinition.TASK_SUBPOOLS_OVERVIEW"));
                }
            }
            ColumnDefinition[] defns = this.model.getColumnDefinitions();
            Group sliver = new Group(this.detailColumnComposite, 0);
            sliver.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
            sliver.setLayout((Layout)new GridLayout(3, false));
            sliver.setBackground(sectionClient.getBackground());
            this.groupSMT(this.mainDefn);
            int i = 7;
            while (i < defns.length) {
                if (!(this.labels.containsKey(defns[i]) || defns[i] == this.model.getSubColumnLabel() || this.model.getSubColumnValueLabel().contains(defns[i]) || this.ignoreList.contains(defns[i]))) {
                    if (defns[i] == ColumnDefinition.DSA_LIMIT || defns[i] == ColumnDefinition.EDSA_LIMIT || defns[i] == ColumnDefinition.MEMLIMIT_SIZE) {
                        this.groupSMT(defns[i]);
                    } else {
                        Label l = new Label((Composite)sliver, 0);
                        l.setBackground(sectionClient.getBackground());
                        if (defns[i] == this.model.getTextNumber()) {
                            l.setText(MessageFormat.format(Messages.getString("ChartDefinition.Parenthesised"), this.model.getTextNumber().getLabel(this.model.getTable())));
                        } else {
                            l.setText(defns[i].getLabel(this.model.getTable()));
                        }
                        if (this.model.getPlotLines().contains(defns[i]) || defns[i] == this.model.getTextNumber()) {
                            l.setFont(STANDARD_BOLD);
                            l.setForeground(Column.getFor(defns[i]).getColor());
                            viewPart.addPaintedLabel((Control)l, defns[i]);
                            l.setData((Object)defns[i]);
                        } else {
                            for (PlotPoint point : this.model.getPlotPoints()) {
                                if (point.getPlotReference() != defns[i]) continue;
                                l.setFont(STANDARD_BOLD);
                                l.setForeground(Column.getFor(defns[i]).getColor());
                                viewPart.addPaintedLabel((Control)l, defns[i]);
                                l.setData((Object)defns[i]);
                            }
                        }
                        Label lt = new Label((Composite)sliver, 8);
                        l.setBackground(sectionClient.getBackground());
                        l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                        if (defns[i] == ColumnDefinition.TRAN_PEAK_ACTIVE) {
                            l.setToolTipText(Messages.getString("PlotView.PEAK_ACTIVE_USER_TRANSACTIONS_PERCENT.tooltip"));
                            lt.setToolTipText(Messages.getString("PlotView.PEAK_ACTIVE_USER_TRANSACTIONS_PERCENT.tooltip"));
                            lt.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
                            lt.setBackground(sectionClient.getBackground());
                            this.labels.put(defns[i], lt);
                            lt = new Label((Composite)sliver, 0);
                            lt.setToolTipText(Messages.getString("PlotView.PEAK_ACTIVE_USER_TRANSACTIONS_PERCENT.tooltip"));
                            lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                            lt.setBackground(sectionClient.getBackground());
                            this.labels.put(ColumnDefinition.TRAN_PEAK_ACTIVE_PERCENT, lt);
                        } else {
                            lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                            if (!Utilities.hasContent((String)lt.getToolTipText())) {
                                lt.setToolTipText(defns[i].getLabel(null));
                            }
                            lt.setBackground(sectionClient.getBackground());
                            this.labels.put(defns[i], lt);
                            l = new Label((Composite)sliver, 8);
                            l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                            l.setBackground(sectionClient.getBackground());
                        }
                    }
                }
                ++i;
            }
        }
        viewPart.addStandardAdditional(sectionClient, this.detailColumnComposite);
        debug.exit("createDetailSection");
        return this.detailColumnComposite;
    }

    @Override
    public void updateDetailSection(SingleIntervalFigure figure) {
        debug.enter("updateDetailSection");
        super.updateDetailSection(figure);
        if (figure != null) {
            int i = 0;
            while (i < this.headings.length) {
                Map<ColumnDefinition, Control> currentControlMap;
                Object[] values = figure.getElement().getSubMap1().get(this.headings[i].getLabel(null));
                if (values != null && (currentControlMap = this.controls.get(this.headings[i])) != null) {
                    int j = 0;
                    while (j < this.model.getSubColumnValueLabel().size()) {
                        String text = DataTypeUtilities.getAsString(values[j]);
                        ColumnDefinition definition = this.model.getSubColumnValueLabel().get(j);
                        if (currentControlMap.containsKey(definition)) {
                            if (currentControlMap.get(definition) instanceof Label) {
                                ((Label)currentControlMap.get(definition)).setText(text);
                            } else if (currentControlMap.get(definition) instanceof Hyperlink) {
                                ((Hyperlink)currentControlMap.get(definition)).setText(text);
                                ((Hyperlink)currentControlMap.get(definition)).setEnabled(text.length() > 0);
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        debug.exit("updateDetailSection");
    }

    @Override
    protected GridLayout leanLayout(GridLayout noMargin) {
        noMargin.marginBottom = 0;
        noMargin.marginTop = 0;
        noMargin.marginLeft = 0;
        noMargin.marginRight = 0;
        noMargin.marginWidth = 5;
        noMargin.marginHeight = 0;
        noMargin.verticalSpacing = 5;
        noMargin.horizontalSpacing = 10;
        return noMargin;
    }

    private void groupSMT(ColumnDefinition title) {
        ColumnDefinition[] columnDefinitionArray = this.headings;
        int n = this.headings.length;
        int n2 = 0;
        while (n2 < n) {
            final ColumnDefinition head = columnDefinitionArray[n2];
            HashMap<ColumnDefinition, Label> controlset = new HashMap<ColumnDefinition, Label>();
            Composite satisfier = new Composite(this.detailColumnComposite, 0);
            satisfier.setLayout((Layout)this.leanLayout(new GridLayout(4, false)));
            satisfier.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
            satisfier.setBackground(this.detailSection.getBackground());
            Hyperlink hl = new Hyperlink(satisfier, 0);
            hl.setLayoutData((Object)new GridData(16384, 4, true, false, 1, 1));
            hl.setBackground(this.detailSection.getBackground());
            hl.setForeground(Column.getFor(head).getColor());
            this.viewPart.addPaintedLabel((Control)hl, head);
            hl.setText(head.getLabel(null));
            final String tooltip = MessageFormat.format(Messages.getString("Visualisation.SMT.linkto"), this.model.getDSAType().name());
            hl.setToolTipText(tooltip);
            hl.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = tooltip;
                }
            });
            hl.setUnderlined(true);
            hl.addKeyListener(this.viewPart.genericKeyListener);
            hl.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    if (SMTPlotViewVariance.this.model.getDSAType() == PlotModel.DSAType.DSA) {
                        AlertElement nextAlert = SMTPlotViewVariance.this.viewPart.getCurrentElement().createElement(ColumnDefinition.DSA_INDEX, "1,2,3,4", Comparator.IN, null);
                        SMTPlotViewVariance.this.viewPart.activateHyperLink(nextAlert);
                    } else if (SMTPlotViewVariance.this.model.getDSAType() == PlotModel.DSAType.GDSA) {
                        AlertElement nextAlert = SMTPlotViewVariance.this.viewPart.getCurrentElement().createElement(ColumnDefinition.DSA_INDEX, "17, 18, 19", Comparator.IN, null);
                        SMTPlotViewVariance.this.viewPart.activateHyperLink(nextAlert);
                    } else if (SMTPlotViewVariance.this.model.getDSAType() == PlotModel.DSAType.EDSA) {
                        AlertElement nextAlert = SMTPlotViewVariance.this.viewPart.getCurrentElement().createElement(ColumnDefinition.DSA_INDEX, "9, 10, 11, 12, 13", Comparator.IN, null);
                        SMTPlotViewVariance.this.viewPart.activateHyperLink(nextAlert);
                    }
                }
            });
            Label l = new Label(satisfier, 0);
            l.setText(MessageFormat.format(Messages.getString("Current.size"), head.getLabel(null)));
            l.setLayoutData((Object)new GridData(16384, 4, true, false, 1, 1));
            l.setBackground(this.detailSection.getBackground());
            l.setToolTipText(ColumnDefinition.DSA_SIZE_CUR.getLabel(null));
            l = new Label(satisfier, 0);
            l.setLayoutData((Object)new GridData(16384, 4, true, false, 1, 1));
            l.setBackground(this.detailSection.getBackground());
            l.setToolTipText(ColumnDefinition.DSA_SIZE_CUR.getLabel(null));
            controlset.put(ColumnDefinition.DSA_SIZE_CUR, l);
            l = new Label(satisfier, 0);
            l.setLayoutData((Object)new GridData(16384, 4, true, false, 1, 1));
            l.setBackground(this.detailSection.getBackground());
            Group groupBox = new Group(this.detailColumnComposite, 0);
            GridData gbData = new GridData(4, 128, true, false, 4, 1);
            groupBox.setLayoutData((Object)gbData);
            groupBox.setLayout((Layout)this.leanLayout(new GridLayout(4, false)));
            groupBox.setBackground(satisfier.getBackground());
            for (final ColumnDefinition defn : this.model.getSubColumnValueLabel()) {
                if (this.ignoreList.contains(defn)) continue;
                l = new Label((Composite)groupBox, 0);
                l.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                l.setBackground(this.detailSection.getBackground());
                l.setText(defn.getLabel(null));
                Label lt = new Label((Composite)groupBox, 8);
                if (defn == ColumnDefinition.PAGE_STORAGE) {
                    lt.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                        public void getName(AccessibleEvent e) {
                            e.result = MessageFormat.format(Messages.getString("SMT.percentgeofCDSA"), defn.getLabel(null), head.getLabel(null));
                        }
                    });
                    lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                    lt.setToolTipText(MessageFormat.format(Messages.getString("SMT.percentgeofCDSA"), defn.getLabel(null), head.getLabel(null)));
                    lt.setBackground(this.detailSection.getBackground());
                    controlset.put(defn, lt);
                    lt = new Label((Composite)groupBox, 8);
                    lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                    lt.setToolTipText(MessageFormat.format(Messages.getString("SMT.percentgeofCDSA"), defn.getLabel(null), head.getLabel(null)));
                    lt.setBackground(this.detailSection.getBackground());
                    controlset.put(ColumnDefinition.PAGE_STORAGE_PERCENT, lt);
                    continue;
                }
                lt.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                lt.setToolTipText(defn.getLabel(null));
                lt.setBackground(this.detailSection.getBackground());
                controlset.put(defn, lt);
            }
            this.controls.put(head, controlset);
            ++n2;
        }
    }
}

