/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.eclipse.common.ui.Utilities;
import com.ibm.cics.pa.model.AlertElement;
import com.ibm.cics.pa.model.Column;
import com.ibm.cics.pa.model.PlotModel;
import com.ibm.cics.pa.model.PlotPoint;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.IntervalTypes;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.figures.SingleIntervalFigure;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.utilities.ViewLinkingDBFunctions;
import com.ibm.cics.pa.ui.views.PlotView;
import com.ibm.cics.pa.ui.views.internal.IPlotViewVariance;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTableAdapter;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class PlotViewVariance
implements IPlotViewVariance {
    private static final Debug debug = new Debug(PlotViewVariance.class);
    protected PlotModel model;
    protected TableViewer subTableViewer;
    protected Group tableGroup;
    protected ScrolledComposite scrolledComposite;
    protected Composite detailColumnComposite;
    protected Map<ColumnDefinition, Control> labels = new HashMap<ColumnDefinition, Control>();
    protected GridData tableViewer_gd;
    protected static String FONT_NAME = Display.getCurrent().getSystemFont().getFontData()[0].getName();
    protected static int FONT_SIZE = Display.getCurrent().getSystemFont().getFontData()[0].getHeight();
    protected static Font STANDARD_BOLD = new Font((Device)Display.getDefault(), FONT_NAME, FONT_SIZE, 1);
    protected PlotView viewPart;
    protected Composite detailSection;
    protected Composite parent;
    protected static final List<ColumnDefinition> BLANK_PRECEDES = Arrays.asList(ColumnDefinition.DSA_LIMIT, ColumnDefinition.EDSA_LIMIT, ColumnDefinition.MEMLIMIT_SIZE, ColumnDefinition.AVG_TRANS_RESPONSE, ColumnDefinition.TRAN_MXT, ColumnDefinition.X_TCB_SCANS, ColumnDefinition.CICS_TCB_MODES, ColumnDefinition.TASKS, ColumnDefinition.TRANS_QUEUED_CUR, ColumnDefinition.PRTYAGE_TIME, ColumnDefinition.REMOTE_SYSTEM_ID, ColumnDefinition.SMF_RECORDS, ColumnDefinition.LAST_TRANS_ATT_L);
    static final String zeroPercent = "0 " + MessageFormat.format(Messages.getString("PlotView.relative.percentage"), 0);
    private static final Long NOLIMIT = 0xFFFFFFFF000L;
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PlotViewVariance(PlotModel model) {
        this.model = model;
    }

    @Override
    public Composite createDetailSection(final PlotView viewPart, Composite parent, Composite sectionClient) {
        debug.enter("createDetailSection");
        this.viewPart = viewPart;
        this.parent = parent;
        this.detailSection = sectionClient;
        this.scrolledComposite = new ScrolledComposite(sectionClient, 512);
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setAlwaysShowScrollBars(true);
        this.detailColumnComposite = new Composite((Composite)this.scrolledComposite, 0);
        this.scrolledComposite.getVerticalBar().setIncrement(10);
        this.scrolledComposite.getVerticalBar().setPageIncrement(100);
        this.detailColumnComposite.setLayout((Layout)new GridLayout(4, false));
        this.detailColumnComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.detailColumnComposite.setBackground(sectionClient.getBackground());
        this.scrolledComposite.setContent((Control)this.detailColumnComposite);
        this.scrolledComposite.setShowFocusedControl(true);
        GridData span2 = new GridData();
        span2.horizontalSpan = 2;
        this.labels = new HashMap<ColumnDefinition, Control>();
        Label l = new Label(this.detailColumnComposite, 0);
        l.setText(ColumnDefinition.START_DATE.getLabel(null));
        l.setBackground(sectionClient.getBackground());
        Label lt = new Label(this.detailColumnComposite, 0);
        lt.setBackground(sectionClient.getBackground());
        lt.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        lt.setToolTipText(ColumnDefinition.START_DATE.getLabel(null));
        this.labels.put(ColumnDefinition.START_DATE, (Control)lt);
        l = new Label(this.detailColumnComposite, 0);
        l.setBackground(sectionClient.getBackground());
        l.setText(ColumnDefinition.START_TIME.getLabel(null));
        lt = new Label(this.detailColumnComposite, 8);
        lt.setToolTipText(ColumnDefinition.START_TIME.getLabel(null));
        lt.setBackground(sectionClient.getBackground());
        lt.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.labels.put(ColumnDefinition.START_TIME, (Control)lt);
        l = new Label(this.detailColumnComposite, 0);
        l.setBackground(sectionClient.getBackground());
        l.setText(ColumnDefinition.INTERVAL_NUMBER.getLabel(null));
        lt = new Label(this.detailColumnComposite, 8);
        lt.setBackground(sectionClient.getBackground());
        lt.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        lt.setToolTipText(ColumnDefinition.INTERVAL_NUMBER.getLabel(null));
        this.labels.put(ColumnDefinition.INTERVAL_NUMBER, (Control)lt);
        l = new Label(this.detailColumnComposite, 0);
        l.setBackground(sectionClient.getBackground());
        l.setText(ColumnDefinition.APPLID.getLabel(null));
        if (this.model.canLink(ColumnDefinition.APPLID)) {
            lt = new Hyperlink(this.detailColumnComposite, 0);
            ((Hyperlink)lt).setText("");
            ((Hyperlink)lt).addKeyListener(viewPart.genericKeyListener);
            lt.setToolTipText(this.model.getHyperlinkToolTip(ColumnDefinition.APPLID));
            final Hyperlink hlt = (Hyperlink)lt;
            lt.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = String.valueOf(ColumnDefinition.APPLID.getLabel(null)) + ' ' + hlt.getText();
                }
            });
            lt.setForeground(ColorConstants.blue);
            ((Hyperlink)lt).setUnderlined(true);
            ((Hyperlink)lt).addKeyListener(viewPart.genericKeyListener);
            ((Hyperlink)lt).addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    AlertElement nextAlert = viewPart.getCurrentElement().createElement(ColumnDefinition.APPLID, Comparator.EQ, null);
                    viewPart.activateHyperLink(nextAlert);
                }
            });
        } else {
            lt = new Label(this.detailColumnComposite, 8);
            lt.setToolTipText(ColumnDefinition.APPLID.getLabel(null));
        }
        lt.setBackground(sectionClient.getBackground());
        lt.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.labels.put(ColumnDefinition.APPLID, (Control)lt);
        l = new Label(this.detailColumnComposite, 0);
        l.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        l.setBackground(sectionClient.getBackground());
        List<ColumnDefinition> settingsSectionB = this.model.getSettingsDefinitionsB();
        List<ColumnDefinition> settingsSectionA = this.model.getSettingsDefinitionsA();
        ArrayList<ColumnDefinition> expandBarContentA = new ArrayList<ColumnDefinition>();
        ArrayList<ColumnDefinition> expandBarContentB = new ArrayList<ColumnDefinition>();
        if (this.model != null) {
            ColumnDefinition[] defns = this.model.getColumnDefinitions();
            int i = 7;
            while (i < defns.length) {
                if (settingsSectionA.contains(defns[i])) {
                    expandBarContentA.add(defns[i]);
                } else if (settingsSectionB.contains(defns[i])) {
                    expandBarContentB.add(defns[i]);
                }
                if (!(this.labels.containsKey(defns[i]) || defns[i] == this.model.getSubColumnLabel() || this.model.getSubColumnValueLabel().contains(defns[i]) || settingsSectionA.contains(defns[i]) || settingsSectionB.contains(defns[i]))) {
                    if (BLANK_PRECEDES.contains(defns[i])) {
                        l = new Label(this.detailColumnComposite, 0);
                        l.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
                        l.setBackground(sectionClient.getBackground());
                    }
                    if (!this.model.isLDGRecord() || defns[i] != ColumnDefinition.TRAN_MXT) {
                        if (defns[i] == ColumnDefinition.DSA_LIMIT) {
                            this.groupDSAPercents();
                        } else if (defns[i] == ColumnDefinition.CICS_TCB_MODES || defns[i] == ColumnDefinition.CICS_TCB_POOLS) {
                            this.provideDispatcherLink(defns[i]);
                        } else {
                            l = new Label(this.detailColumnComposite, 0);
                            l.setBackground(sectionClient.getBackground());
                            if (defns[i] == this.model.getTextNumber()) {
                                l.setText(MessageFormat.format(Messages.getString("ChartDefinition.Parenthesised"), this.model.getTextNumber().getLabel(this.model.getTable())));
                            } else {
                                l.setText(defns[i].getLabel(this.model.getTable()));
                            }
                            if (this.model.getPlotLines().contains(defns[i]) || defns[i] == this.model.getTextNumber()) {
                                l.setFont(STANDARD_BOLD);
                                l.setForeground(Column.getFor(defns[i]).getColor());
                                viewPart.addPaintedLabel((Control)l, defns[i]);
                                l.setData((Object)defns[i]);
                            } else {
                                for (PlotPoint point : this.model.getPlotPoints()) {
                                    if (point.getPlotReference() != defns[i]) continue;
                                    l.setFont(STANDARD_BOLD);
                                    l.setForeground(Column.getFor(defns[i]).getColor());
                                    viewPart.addPaintedLabel((Control)l, defns[i]);
                                    l.setData((Object)defns[i]);
                                }
                            }
                            if (this.model.canLink(defns[i])) {
                                final ColumnDefinition defn = defns[i];
                                lt = new Hyperlink(this.detailColumnComposite, 0);
                                ((Hyperlink)lt).setText("");
                                ((Hyperlink)lt).addKeyListener(viewPart.genericKeyListener);
                                lt.setToolTipText(this.model.getHyperlinkToolTip(defns[i]));
                                lt.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                                    public void getDescription(AccessibleEvent e) {
                                        e.result = PlotViewVariance.this.model.getHyperlinkToolTip(defn);
                                    }
                                });
                                lt.setForeground(ColorConstants.blue);
                                ((Hyperlink)lt).setUnderlined(true);
                                ((Hyperlink)lt).addKeyListener(viewPart.genericKeyListener);
                                ((Hyperlink)lt).addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                                    public void linkActivated(HyperlinkEvent e) {
                                        PlotModel.PlotModelElement current = viewPart.getCurrentElement();
                                        if (PlotViewVariance.this.model.isXMRRecord() && defn == ColumnDefinition.TRAN_ID) {
                                            ViewLinkingDBFunctions.openSpreadsheetXMR((IViewPart)viewPart, current.getTranAlert(), null);
                                        } else {
                                            viewPart.activateHyperLink(current.createElement(defn, Comparator.EQ, null));
                                        }
                                    }
                                });
                            } else {
                                lt = new Label(this.detailColumnComposite, 8);
                            }
                            lt.setBackground(sectionClient.getBackground());
                            if (defns[i] == ColumnDefinition.ATTACHES_TRANSACTION) {
                                l.setToolTipText(Messages.getString("PlotView.ATTACHES_TRANSACTION.tooltip"));
                                lt.setToolTipText(Messages.getString("PlotView.ATTACHES_TRANSACTION.tooltip"));
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                this.labels.put(defns[i], (Control)lt);
                                lt = new Label(this.detailColumnComposite, 8);
                                lt.setToolTipText(Messages.getString("PlotView.ATTACHES_TRANSACTION.tooltip2"));
                                lt.setForeground(Column.getFor(ColumnDefinition.TRANSACTIONS).getColor());
                                viewPart.addPaintedLabel((Control)lt, ColumnDefinition.TRANSACTIONS);
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setBackground(this.detailSection.getBackground());
                                this.labels.put(ColumnDefinition.ATTACHES_PERCENT_TOTAL_TRANSACTIONS, (Control)lt);
                                lt = new Label(this.detailColumnComposite, 8);
                                lt.setToolTipText(Messages.getString("PlotView.ATTACHES_TRANSACTION.tooltip1"));
                                lt.setForeground(Column.getFor(ColumnDefinition.ATTACHES_TRANSACTION_CLASS).getColor());
                                lt.setBackground(this.detailSection.getBackground());
                                viewPart.addPaintedLabel((Control)lt, ColumnDefinition.ATTACHES_TRANSACTION_CLASS);
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                this.labels.put(ColumnDefinition.ATTACHES_PERCENT_TRANSACTION_CLASS, (Control)lt);
                            } else if (defns[i] == ColumnDefinition.ATTACHES_TRANSACTION_CLASS) {
                                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setToolTipText(Messages.getString("PlotView.ATTACHES_TRANSACTION_CLASS.tooltip"));
                                lt.setBackground(this.detailSection.getBackground());
                                this.labels.put(defns[i], (Control)lt);
                                lt = new Label(this.detailColumnComposite, 8);
                                lt.setToolTipText(Messages.getString("PlotView.ATTACHES_TRANSACTION_CLASS.tooltip1"));
                                if (this.model.isXMGRecord()) {
                                    lt.setForeground(Column.getFor(ColumnDefinition.TRANSACTIONS).getColor());
                                }
                                viewPart.addPaintedLabel((Control)lt, ColumnDefinition.TRANSACTIONS);
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                                lt.setBackground(this.detailSection.getBackground());
                                this.labels.put(ColumnDefinition.ATTACHES_TRANSACTION_CLASS_PERCENT_TOTAL_TRANSACTIONS, (Control)lt);
                            } else if (defns[i] == ColumnDefinition.TRAN_TOTAL_ACTIVE) {
                                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                GridData ltgd = new GridData(4, 4, true, false, 1, 1);
                                lt.setLayoutData((Object)ltgd);
                                lt.setToolTipText(Messages.getString("PlotView.TRAN_TOTAL_ACTIVE.tooltip"));
                                lt.setBackground(this.detailSection.getBackground());
                                this.labels.put(defns[i], (Control)lt);
                                lt = new Label(this.detailColumnComposite, 8);
                                lt.setToolTipText(Messages.getString("PlotView.TRAN_TOTAL_ACTIVE.tooltip"));
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                                lt.setBackground(this.detailSection.getBackground());
                                this.labels.put(ColumnDefinition.TRAN_TOTAL_ACTIVE_PERCENT_TOTAL_TRANSACTIONS, (Control)lt);
                            } else if (defns[i] == ColumnDefinition.TRAN_TOTAL_DELAYED) {
                                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setToolTipText(Messages.getString("PlotView.TRAN_TOTAL_DELAYED.tooltip"));
                                this.labels.put(defns[i], (Control)lt);
                                lt = new Label(this.detailColumnComposite, 8);
                                lt.setToolTipText(Messages.getString("PlotView.TRAN_TOTAL_DELAYED.tooltip"));
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                                lt.setBackground(this.detailSection.getBackground());
                                this.labels.put(ColumnDefinition.TRAN_TOTAL_DELAYED_PERCENT_TOTAL_TRANSACTIONS, (Control)lt);
                            } else if (defns[i] == ColumnDefinition.EDSA_TOTAL_PEAK) {
                                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setToolTipText(Messages.getString("PlotView.EDSA_TOTAL_PEAK_PERCENT.tooltip"));
                                lt.setBackground(this.detailSection.getBackground());
                                this.labels.put(defns[i], (Control)lt);
                                lt = new Label(this.detailColumnComposite, 8);
                                lt.setToolTipText(Messages.getString("PlotView.EDSA_TOTAL_PEAK_PERCENT.tooltip"));
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                                lt.setBackground(this.detailSection.getBackground());
                                this.labels.put(ColumnDefinition.EDSA_TOTAL_PEAK_PERCENT, (Control)lt);
                            } else if (defns[i] == ColumnDefinition.EDSA_CURRENT_TOTAL) {
                                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setToolTipText(Messages.getString("PlotView.EDSA_CURRENT_TOTAL_PERCENT.tooltip"));
                                this.labels.put(defns[i], (Control)lt);
                                lt = new Label(this.detailColumnComposite, 8);
                                lt.setToolTipText(Messages.getString("PlotView.EDSA_CURRENT_TOTAL_PERCENT.tooltip"));
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                                lt.setBackground(this.detailSection.getBackground());
                                this.labels.put(ColumnDefinition.EDSA_CURRENT_TOTAL_PERCENT, (Control)lt);
                            } else if (defns[i] == ColumnDefinition.PEAK_GDSA_ACTIVE) {
                                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setToolTipText(Messages.getString("PlotView.GDSA_TOTAL_PEAK_PERCENT.tooltip"));
                                lt.setBackground(this.detailSection.getBackground());
                                this.labels.put(defns[i], (Control)lt);
                                lt = new Label(this.detailColumnComposite, 8);
                                lt.setToolTipText(Messages.getString("PlotView.GDSA_TOTAL_PEAK_PERCENT.tooltip"));
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                                lt.setBackground(this.detailSection.getBackground());
                                this.labels.put(ColumnDefinition.PEAK_GDSA_ACTIVE_PERCENT, (Control)lt);
                            } else if (defns[i] == ColumnDefinition.CURRENT_ACTIV_GDSA) {
                                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setToolTipText(Messages.getString("PlotView.GDSA_CURRENT_TOTAL_PERCENT.tooltip"));
                                lt.setBackground(this.detailSection.getBackground());
                                this.labels.put(defns[i], (Control)lt);
                                lt = new Label(this.detailColumnComposite, 8);
                                lt.setToolTipText(Messages.getString("PlotView.GDSA_CURRENT_TOTAL_PERCENT.tooltip"));
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                                lt.setBackground(this.detailSection.getBackground());
                                this.labels.put(ColumnDefinition.CURRENT_ACTIV_GDSA_PERCENT, (Control)lt);
                            } else if (defns[i] == ColumnDefinition.TRAN_PEAK_ACTIVE) {
                                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setToolTipText(Messages.getString("PlotView.PEAK_ACTIVE_USER_TRANSACTIONS_PERCENT.tooltip"));
                                lt.setBackground(this.detailSection.getBackground());
                                this.labels.put(defns[i], (Control)lt);
                                lt = new Label(this.detailColumnComposite, 8);
                                lt.setToolTipText(Messages.getString("PlotView.PEAK_ACTIVE_USER_TRANSACTIONS_PERCENT.tooltip"));
                                lt.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
                                lt.setBackground(this.detailSection.getBackground());
                                l = new Label(this.detailColumnComposite, 8);
                                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                l.setBackground(this.detailSection.getBackground());
                                this.labels.put(ColumnDefinition.TRAN_PEAK_ACTIVE_PERCENT, (Control)lt);
                            } else if (defns[i] == ColumnDefinition.TRAN_TOTAL_DELAYED) {
                                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setBackground(this.detailSection.getBackground());
                                lt.setToolTipText(Messages.getString("PlotView.TRAN_TOTAL_DELAYED.tooltip"));
                                this.labels.put(defns[i], (Control)lt);
                                lt = new Label(this.detailColumnComposite, 8);
                                lt.setToolTipText(Messages.getString("PlotView.TRAN_TOTAL_DELAYED.tooltip"));
                                lt.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
                                lt.setBackground(this.detailSection.getBackground());
                                l = new Label(this.detailColumnComposite, 8);
                                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                l.setBackground(this.detailSection.getBackground());
                                this.labels.put(ColumnDefinition.TRAN_TOTAL_DELAYED_PERCENT_TOTAL_TRANSACTIONS, (Control)lt);
                            } else if (defns[i] == ColumnDefinition.PROGRAM_USES) {
                                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setBackground(this.detailSection.getBackground());
                                lt.setToolTipText(defns[i].getLabel(null));
                                this.labels.put(defns[i], (Control)lt);
                                lt = new Label(this.detailColumnComposite, 8);
                                lt.setToolTipText(ColumnDefinition.PROGRAM_USES_AVERAGE.getLabel(null));
                                lt.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
                                lt.setBackground(this.detailSection.getBackground());
                                l = new Label(this.detailColumnComposite, 8);
                                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                l.setBackground(this.detailSection.getBackground());
                                this.labels.put(ColumnDefinition.PROGRAM_USES_AVERAGE, (Control)lt);
                            } else if (defns[i] == ColumnDefinition.ACCEPT_IMMED) {
                                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setBackground(this.detailSection.getBackground());
                                lt.setToolTipText(defns[i].getLabel(null));
                                this.labels.put(defns[i], (Control)lt);
                                lt = new Label(this.detailColumnComposite, 8);
                                lt.setToolTipText(ColumnDefinition.ACCEPT_QUEUED_PERCENT.getLabel(null));
                                lt.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
                                lt.setBackground(this.detailSection.getBackground());
                                l = new Label(this.detailColumnComposite, 8);
                                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                l.setBackground(this.detailSection.getBackground());
                                this.labels.put(ColumnDefinition.ACCEPT_IMMED_PERCENT, (Control)lt);
                            } else if (defns[i] == ColumnDefinition.ACCEPT_QUEUED) {
                                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setBackground(this.detailSection.getBackground());
                                lt.setToolTipText(defns[i].getLabel(null));
                                this.labels.put(defns[i], (Control)lt);
                                lt = new Label(this.detailColumnComposite, 8);
                                lt.setToolTipText(ColumnDefinition.ACCEPT_QUEUED_PERCENT.getLabel(null));
                                lt.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
                                lt.setBackground(this.detailSection.getBackground());
                                l = new Label(this.detailColumnComposite, 8);
                                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                l.setBackground(this.detailSection.getBackground());
                                this.labels.put(ColumnDefinition.ACCEPT_QUEUED_PERCENT, (Control)lt);
                            } else if (defns[i] == ColumnDefinition.DISPATCHER_START_L) {
                                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
                                lt.setToolTipText(defns[i].getLabel(null));
                                lt.setBackground(this.detailSection.getBackground());
                                this.labels.put(defns[i], (Control)lt);
                            } else if (defns[i] == ColumnDefinition.TASKS_PEAK && this.model.isDSGRecord()) {
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
                                lt.setBackground(this.detailSection.getBackground());
                                if (!Utilities.hasContent((String)lt.getToolTipText())) {
                                    lt.setToolTipText(defns[i].getLabel(null));
                                }
                                this.labels.put(defns[i], (Control)lt);
                                l = new Label(this.detailColumnComposite, 0);
                                l.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
                                l.setBackground(sectionClient.getBackground());
                            } else if (defns[i] == ColumnDefinition.LAST_TRANS_ATT_L) {
                                GridData gridData = new GridData(4, 4, true, false, 3, 1);
                                lt.setLayoutData((Object)gridData);
                                lt.setBackground(this.detailSection.getBackground());
                                if (!Utilities.hasContent((String)lt.getToolTipText())) {
                                    lt.setToolTipText(defns[i].getLabel(null));
                                }
                                lt.setText("YYYY-MM-DD hh:mm:ss.zz");
                                gridData.minimumWidth = lt.computeSize((int)-1, (int)-1).x;
                                this.labels.put(defns[i], (Control)lt);
                            } else {
                                lt.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
                                lt.setBackground(this.detailSection.getBackground());
                                if (!Utilities.hasContent((String)lt.getToolTipText())) {
                                    lt.setToolTipText(defns[i].getLabel(null));
                                }
                                this.labels.put(defns[i], (Control)lt);
                            }
                        }
                    }
                }
                ++i;
            }
        }
        if (!expandBarContentA.isEmpty()) {
            l = new Label(this.detailColumnComposite, 0);
            l.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
            l.setBackground(this.detailSection.getBackground());
            this.processExpander(this.model.getSettingsTextA(), expandBarContentA, this.detailColumnComposite);
        }
        if (!expandBarContentB.isEmpty()) {
            this.processExpander(this.model.getSettingsTextB(), expandBarContentB, this.detailColumnComposite);
        }
        l = new Label(this.detailColumnComposite, 0);
        l.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        l.setBackground(sectionClient.getBackground());
        viewPart.addStandardAdditional(sectionClient, this.detailColumnComposite);
        if (this.model.hasSubElements()) {
            this.subTableViewer = this.createTransactionTableViewer(sectionClient);
        }
        debug.exit("createDetailSection");
        return this.detailColumnComposite;
    }

    private void processExpander(String settingsText, List<ColumnDefinition> expandBarContent, Composite detailColumnComposite) {
        Button cb = new Button(detailColumnComposite, 32);
        cb.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        cb.setText(settingsText);
        cb.setBackground(this.detailSection.getBackground());
        cb.addKeyListener(this.viewPart.genericKeyListener);
        Group groupBox = new Group(detailColumnComposite, 2048);
        GridData gbData = new GridData(4, 128, true, true, 4, 1);
        groupBox.setBackground(this.detailSection.getBackground());
        groupBox.setLayoutData((Object)gbData);
        groupBox.setLayout((Layout)this.leanLayout(new GridLayout(2, false)));
        groupBox.setVisible(cb.getSelection());
        for (ColumnDefinition def : expandBarContent) {
            Label l;
            if (BLANK_PRECEDES.contains(def)) {
                l = new Label((Composite)groupBox, 0);
                l.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                l.setBackground(this.detailSection.getBackground());
            }
            l = new Label((Composite)groupBox, 0);
            l.setText(def.getLabel(this.model.getTable()));
            l.setLayoutData((Object)new GridData(16384, 4, true, false));
            l.setBackground(this.detailSection.getBackground());
            Label lt = new Label((Composite)groupBox, 8);
            lt.setLayoutData((Object)new GridData(131072, 4, true, false));
            lt.setBackground(this.detailSection.getBackground());
            this.labels.put(def, (Control)lt);
        }
        gbData.heightHint = 0;
        cb.addSelectionListener((SelectionListener)new SelectionAdapter((Composite)groupBox, cb, gbData){
            private final /* synthetic */ Composite val$groupBox;
            private final /* synthetic */ Button val$cb;
            private final /* synthetic */ GridData val$gbData;
            {
                this.val$groupBox = composite;
                this.val$cb = button;
                this.val$gbData = gridData;
            }

            public void widgetSelected(SelectionEvent e) {
                this.val$groupBox.setVisible(this.val$cb.getSelection());
                this.val$groupBox.setEnabled(this.val$cb.getSelection());
                this.val$gbData.heightHint = this.val$cb.getSelection() ? this.val$groupBox.computeSize((int)-1, (int)-1).y : 0;
                Point origin = PlotViewVariance.this.scrolledComposite.getOrigin();
                PlotViewVariance.this.scrolledComposite.layout();
                PlotViewVariance.this.resize(true);
                this.val$cb.setFocus();
                PlotViewVariance.this.scrolledComposite.setOrigin(origin);
            }
        });
    }

    @Override
    public void updateDetailSection(SingleIntervalFigure figure) {
        debug.enter("updateDetailSection");
        if (figure != null) {
            ColumnDefinition[] defns = this.model.getColumnDefinitions();
            int i = 0;
            while (i < defns.length) {
                if (this.labels.containsKey(defns[i])) {
                    String text = DataTypeUtilities.getAsString(figure.getElement().getValueMap().get(defns[i]));
                    if (this.model.isSMSRecord()) {
                        text = DataTypeUtilities.getAsString(figure.getElement().resolveSMSSubValues(defns[i]));
                    } else if (this.model.isLDGRecord()) {
                        text = DataTypeUtilities.getAsString(figure.getElement().resolveLDGSubValues(defns[i]));
                    }
                    if (defns[i] == ColumnDefinition.INTERVAL_NUMBER) {
                        IntervalTypes e = IntervalTypes.getByName((String)figure.getElement().getValueMap().get(ColumnDefinition.INTERVAL_TYPE));
                        text = String.valueOf(text) + ' ' + MessageFormat.format(Messages.getString("ChartDefinition.Parenthesised"), e.getDescription());
                    } else if (defns[i] == ColumnDefinition.MEMLIMIT_SIZE && figure.getElement().getValueMap().get(defns[i]) == NOLIMIT) {
                        text = Messages.getString("NoLimit");
                    } else if (defns[i] == ColumnDefinition.MEMLIMIT_SIZE || defns[i] == ColumnDefinition.PEAK_GDSA_ACTIVE || defns[i] == ColumnDefinition.CURRENT_ACTIV_GDSA || defns[i] == ColumnDefinition.GDSA_SIZE_USED) {
                        text = String.valueOf(text) + Messages.getString("Megabytes");
                    }
                    if (this.labels.get(defns[i]) instanceof Label) {
                        ((Label)this.labels.get(defns[i])).setText(text);
                        GridData gridData = (GridData)((Label)this.labels.get(defns[i])).getLayoutData();
                        gridData.minimumWidth = Math.max(gridData.minimumWidth, ((Label)this.labels.get((Object)defns[i])).computeSize((int)-1, (int)-1).x);
                    } else if (this.labels.get(defns[i]) instanceof Hyperlink) {
                        ((Hyperlink)this.labels.get(defns[i])).setText(text);
                        ((Hyperlink)this.labels.get(defns[i])).setEnabled(text.length() > 0 && !text.equals(zeroPercent));
                    }
                }
                ++i;
            }
            if (this.subTableViewer != null) {
                this.subTableViewer.setInput(figure.getElement().getSubMap1());
                this.subTableViewer.getTable().layout();
                if (this.model.isDSGRecord()) {
                    this.tableGroup.setText(MessageFormat.format(Messages.getString("PlotView.tcbmodes.details"), figure.getElement().getSubMap1().size()));
                } else {
                    this.tableGroup.setText(MessageFormat.format(this.model.isXMGRecord() ? Messages.getString("PlotView.tranclasses.details") : Messages.getString("PlotView.transaction.details"), figure.getElement().getSubMap1().size()));
                }
            }
        }
        this.detailColumnComposite.layout();
        debug.exit("updateDetailSection");
    }

    @Override
    public void resize(boolean lowerVisible) {
        debug.enter("resize");
        this.scrolledComposite.setMinHeight(this.detailColumnComposite.computeSize((int)-1, (int)-1).y);
        this.scrolledComposite.setAlwaysShowScrollBars(true);
        this.detailSection.layout();
        if (this.tableViewer_gd != null) {
            Point tgSize = this.tableGroup.computeSize(-1, -1);
            this.tableGroup.setSize(tgSize.x, this.parent.getSize().y);
            this.subTableViewer.getTable().setSize(this.subTableViewer.getTable().getSize().x, this.parent.getSize().y - (lowerVisible ? 40 : 25));
        }
        this.scrolledComposite.setSize(this.detailColumnComposite.getSize().x + 20, this.parent.getSize().y - (lowerVisible ? 20 : 5));
        this.scrolledComposite.setAlwaysShowScrollBars(this.scrolledComposite.getSize().y < this.detailSection.getSize().y);
        debug.exit("resize");
    }

    protected GridLayout leanLayout(GridLayout noMargin) {
        noMargin.marginBottom = 0;
        noMargin.marginTop = 0;
        noMargin.marginLeft = 0;
        noMargin.marginRight = 0;
        noMargin.marginWidth = 5;
        noMargin.marginHeight = 0;
        noMargin.verticalSpacing = 5;
        noMargin.horizontalSpacing = 0;
        return noMargin;
    }

    protected GridLayout widerLayout(GridLayout noMargin) {
        noMargin.marginBottom = 10;
        noMargin.marginTop = 10;
        noMargin.marginLeft = 10;
        noMargin.marginRight = 10;
        noMargin.marginWidth = 5;
        noMargin.marginHeight = 5;
        noMargin.verticalSpacing = 5;
        noMargin.horizontalSpacing = 5;
        return noMargin;
    }

    protected GridLayout widerLayoutShort(GridLayout noMargin) {
        noMargin.marginBottom = 0;
        noMargin.marginTop = 0;
        noMargin.marginLeft = 0;
        noMargin.marginRight = 0;
        noMargin.marginWidth = 5;
        noMargin.marginHeight = 5;
        noMargin.verticalSpacing = 5;
        noMargin.horizontalSpacing = 5;
        return noMargin;
    }

    private TableViewer createTransactionTableViewer(Composite parent) {
        debug.enter("createTransactionTableViewer");
        final HashMap links = new HashMap();
        this.tableGroup = new Group(parent, 0);
        if (this.model.isDSGRecord()) {
            this.tableGroup.setText(Messages.getString("PlotView.tcbmodes.details"));
        } else {
            this.tableGroup.setText(this.model.isXMGRecord() ? Messages.getString("PlotView.tranclasses.details") : Messages.getString("PlotView.transaction.details"));
        }
        this.tableGroup.setLayout((Layout)new GridLayout(1, false));
        this.tableGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableGroup.setBackground(this.detailSection.getBackground());
        final TableViewer tableViewer = new TableViewer((Composite)this.tableGroup, 68100);
        this.tableViewer_gd = new GridData(4, 4, true, true);
        tableViewer.getTable().setLayoutData((Object)this.tableViewer_gd);
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private Map<String, Object> input;

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput instanceof Map) {
                    for (Hyperlink link : links.values()) {
                        link.dispose();
                    }
                    links.clear();
                    this.input = (Map)newInput;
                }
            }

            public Object[] getElements(Object inputElement) {
                if (this.input != null && this.input.size() > 0) {
                    Object[][] elements = new Object[this.input.size()][2];
                    int counter = 0;
                    for (String key : this.input.keySet()) {
                        elements[counter] = new Object[]{key, this.input.get(key)};
                        ++counter;
                    }
                    return elements;
                }
                return null;
            }
        });
        ColumnDefinition tranLabel = this.model.getSubColumnLabel();
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer, (int)2);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 16384);
        if (this.model.isDSGRecord()) {
            tableViewerColumn.getColumn().setText(ColumnDefinition.TCB_MODE_NAME.getLabel(null));
        } else {
            tableViewerColumn.getColumn().setText(this.model.isXMGRecord() ? ColumnDefinition.TCLASS_NAME.getLabel(null) : Messages.getString("PlotView.id"));
        }
        tableViewerColumn.getColumn().setToolTipText(tranLabel.getTooltip(null));
        tableViewerColumn.getColumn().setWidth(this.model.isXMGRecord() ? 130 : 80);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public void update(ViewerCell cell) {
                super.update(cell);
                TableItem item = (TableItem)cell.getItem();
                if (((String)((Object[])((Object[])cell.getElement())[1])[0]).length() > 1 && !PlotViewVariance.this.model.isDSGRecord()) {
                    Hyperlink link;
                    if (links.containsKey(cell.getElement())) {
                        link = (Hyperlink)links.get(cell.getElement());
                    } else {
                        link = new Hyperlink((Composite)tableViewer.getTable(), 0);
                        link.setUnderlined(true);
                        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                            public void linkActivated(HyperlinkEvent e) {
                                (this).PlotViewVariance.this.viewPart.activateTransactionIdLink((ISelection)new StructuredSelection(new Object[]{new Object[]{e.getLabel(), ""}}));
                            }
                        });
                        String text = (String)((Object[])cell.getElement())[0];
                        link.setForeground(tableViewer.getTable().getDisplay().getSystemColor(9));
                        if (!PlotViewVariance.this.model.isDSGRecord()) {
                            link.setToolTipText(PlotViewVariance.this.model.isXMGRecord() ? MessageFormat.format(Messages.getString("PlotView.open.tranclass"), text) : MessageFormat.format(Messages.getString("PlotView.open.transaction"), text));
                        }
                        link.setText(text);
                        boolean isZero = zeroPercent.equals(((Object[])((Object[])cell.getElement())[1])[0]);
                        link.setEnabled(!isZero);
                        links.put(cell.getElement(), link);
                    }
                    TableEditor editor = new TableEditor(item.getParent());
                    editor.grabHorizontal = true;
                    editor.grabVertical = true;
                    editor.setEditor((Control)link, item, cell.getColumnIndex());
                    editor.layout();
                }
            }

            public String getToolTipText(Object element) {
                String text = (String)((Object[])element)[0];
                if (PlotViewVariance.this.model.isDSGRecord()) {
                    return null;
                }
                return MessageFormat.format(PlotViewVariance.this.model.isXMGRecord() ? Messages.getString("PlotView.open.tranclass") : Messages.getString("PlotView.open.transaction"), text);
            }

            public String getText(Object element) {
                if (PlotViewVariance.this.model.isDSGRecord()) {
                    return (String)((Object[])element)[0];
                }
                return "";
            }
        });
        tableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (((TableItem)e.item).getData() instanceof Object[] && ((Object[])e.item.getData())[1] != null && !((String)((Object[])((Object[])e.item.getData())[1])[0]).startsWith("0")) {
                    PlotViewVariance.this.viewPart.activateTransactionIdLink(tableViewer.getSelection());
                }
            }

            public void widgetSelected(SelectionEvent e) {
                if (((TableItem)e.item).getData() instanceof Object[] && ((Object[])e.item.getData())[1] != null) {
                    ((String)((Object[])((Object[])e.item.getData())[1])[0]).startsWith("0");
                }
            }
        });
        tableViewer.getTable().getAccessible().addAccessibleTableListener((AccessibleTableListener)new AccessibleTableAdapter(){

            public void getRow(AccessibleTableEvent e) {
            }
        });
        List<ColumnDefinition> valueLabels = this.model.getSubColumnValueLabel();
        int i = 0;
        while (i < valueLabels.size()) {
            TableViewerColumn tableViewerDataColumn = new TableViewerColumn(tableViewer, 16384);
            tableViewerDataColumn.getColumn().setText(this.model.isDSGRecord() ? ColumnDefinition.TCB_ATTACHES_CUR.getLabel(null) : ColumnDefinition.ATTACHES.getLabel(null));
            tableViewerDataColumn.getColumn().setToolTipText(valueLabels.get(i).getTooltip(null));
            tableViewerDataColumn.getColumn().setWidth(100);
            final int index = i++;
            tableViewerDataColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (((Object[])element).length > 0) {
                        return DataTypeUtilities.getAsString(((Object[])((Object[])element)[1])[index]);
                    }
                    return "";
                }
            });
        }
        tableViewer.getTable().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                Object first = ((StructuredSelection)tableViewer.getSelection()).getFirstElement();
                if (first != null && first instanceof Object[]) {
                    e.result = (String)((Object[])first)[0];
                }
            }

            public void getDescription(AccessibleEvent e) {
                Object first = ((StructuredSelection)tableViewer.getSelection()).getFirstElement();
                if (first != null && first instanceof Object[]) {
                    String text = (String)((Object[])first)[0];
                    e.result = MessageFormat.format(Messages.getString("PlotView.open.transaction"), text);
                }
            }
        });
        debug.exit("createTransactionTableViewer");
        return tableViewer;
    }

    private void groupDSAPercents() {
        Link link = new Link(this.detailColumnComposite, 0);
        link.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        link.setBackground(this.detailSection.getBackground());
        link.setText(Messages.getString("DSA.text"));
        link.addKeyListener(this.viewPart.genericKeyListener);
        link.setToolTipText(Messages.getString(this.model.isLDGRecord() ? "LDG.DSA.tooltip" : "DSA.tooltip"));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlertElement nextAlert = PlotViewVariance.this.model.isLDGRecord() ? PlotViewVariance.this.viewPart.getCurrentElement().createElement(ColumnDefinition.DSA_NAME, "'CDSA', 'UDSA', 'SDSA', 'RDSA'", Comparator.IN, "HST030B") : PlotViewVariance.this.viewPart.getCurrentElement().createElement(ColumnDefinition.DSA_INDEX, "1,2,3,4", Comparator.IN, "HST014B");
                PlotViewVariance.this.viewPart.activateHyperLink(nextAlert);
            }
        });
        link.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getDescription(AccessibleEvent e) {
                e.result = Messages.getString(PlotViewVariance.this.model.isLDGRecord() ? "LDG.DSA.tooltip" : "DSA.tooltip");
            }

            public void getName(AccessibleEvent e) {
                e.result = Messages.getString(PlotViewVariance.this.model.isLDGRecord() ? "LDG.DSA.tooltip" : "DSA.tooltip");
            }
        });
        link.setEnabled(true);
        Group groupBox = new Group(this.detailColumnComposite, 0);
        GridData gbData = new GridData(4, 128, true, false, 4, 1);
        groupBox.setLayoutData((Object)gbData);
        groupBox.setLayout((Layout)this.widerLayoutShort(new GridLayout(3, false)));
        groupBox.setBackground(this.detailSection.getBackground());
        Label l = new Label((Composite)groupBox, 0);
        GridData gd0 = new GridData(4, 4, true, false, 1, 1);
        l.setLayoutData((Object)gd0);
        l.setText(ColumnDefinition.DSA_LIMIT.getLabel(null));
        gd0.minimumWidth = l.computeSize((int)-1, (int)-1).x;
        l.setBackground(this.detailSection.getBackground());
        Label lt = new Label((Composite)groupBox, 131080);
        lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lt.setBackground(this.detailSection.getBackground());
        this.labels.put(ColumnDefinition.DSA_LIMIT, (Control)lt);
        l = new Label((Composite)groupBox, 8);
        l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        l.setBackground(this.detailSection.getBackground());
        l = new Label((Composite)groupBox, 0);
        l.setBackground(this.detailSection.getBackground());
        l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        l.setText(ColumnDefinition.DSA_CURRENT_TOTAL.getLabel(null));
        l.setToolTipText(ColumnDefinition.DSA_CURRENT_TOTAL.getTooltip(null));
        l.setFont(STANDARD_BOLD);
        l.setForeground(Column.getFor(ColumnDefinition.DSA_CURRENT_TOTAL).getColor());
        this.viewPart.addPaintedLabel((Control)l, ColumnDefinition.DSA_CURRENT_TOTAL);
        l.setData((Object)ColumnDefinition.DSA_CURRENT_TOTAL);
        l.setBackground(this.detailSection.getBackground());
        lt = new Label((Composite)groupBox, 131080);
        lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lt.setBackground(this.detailSection.getBackground());
        this.labels.put(ColumnDefinition.DSA_CURRENT_TOTAL, (Control)lt);
        lt.setToolTipText(ColumnDefinition.DSA_CURRENT_TOTAL.getTooltip(null));
        lt = new Label((Composite)groupBox, 131080);
        lt.setToolTipText(Messages.getString("PlotView.DSA_CURRENT_TOTAL_PERCENT.tooltip"));
        lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lt.setBackground(this.detailSection.getBackground());
        this.labels.put(ColumnDefinition.DSA_CURRENT_TOTAL_PERCENT, (Control)lt);
        l = new Label((Composite)groupBox, 0);
        l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        l.setText(ColumnDefinition.DSA_TOTAL_PEAK.getLabel(null));
        l.setFont(STANDARD_BOLD);
        l.setBackground(this.detailSection.getBackground());
        l.setForeground(Column.getFor(ColumnDefinition.DSA_TOTAL_PEAK).getColor());
        this.viewPart.addPaintedLabel((Control)l, ColumnDefinition.DSA_TOTAL_PEAK);
        l.setData((Object)ColumnDefinition.DSA_TOTAL_PEAK);
        lt = new Label((Composite)groupBox, 131080);
        lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lt.setBackground(this.detailSection.getBackground());
        this.labels.put(ColumnDefinition.DSA_TOTAL_PEAK, (Control)lt);
        lt.setToolTipText(Messages.getString("PlotView.DSA_TOTAL_PEAK_PERCENT.tooltip"));
        lt = new Label((Composite)groupBox, 131080);
        lt.setBackground(this.detailSection.getBackground());
        lt.setToolTipText(Messages.getString("PlotView.DSA_TOTAL_PEAK_PERCENT.tooltip"));
        lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.labels.put(ColumnDefinition.DSA_TOTAL_PEAK_PERCENT, (Control)lt);
        l = new Label((Composite)groupBox, 0);
        l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        l.setText(ColumnDefinition.DSA_SIZE_USED.getLabel(null));
        l.setFont(STANDARD_BOLD);
        l.setBackground(this.detailSection.getBackground());
        l.setForeground(Column.getFor(ColumnDefinition.DSA_SIZE_USED).getColor());
        this.viewPart.addPaintedLabel((Control)l, ColumnDefinition.DSA_SIZE_USED);
        l.setData((Object)ColumnDefinition.DSA_SIZE_USED);
        l.setToolTipText(ColumnDefinition.DSA_SIZE_USED.getTooltip(null));
        lt = new Label((Composite)groupBox, 131080);
        lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lt.setBackground(this.detailSection.getBackground());
        this.labels.put(ColumnDefinition.DSA_SIZE_USED, (Control)lt);
        lt.setToolTipText(ColumnDefinition.DSA_SIZE_USED.getTooltip(null));
        lt = new Label((Composite)groupBox, 131080);
        lt.setBackground(this.detailSection.getBackground());
        lt.setToolTipText(Messages.getString("PlotView.DSA_SIZE_USED_PERCENT.tooltip"));
        lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.labels.put(ColumnDefinition.DSA_SIZE_USED_PERCENT, (Control)lt);
        if (this.model.isLDGRecord()) {
            l = new Label((Composite)groupBox, 0);
            l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            l.setText(ColumnDefinition.DSA_SIZE_PGMS.getLabel(null));
            l.setFont(STANDARD_BOLD);
            l.setBackground(this.detailSection.getBackground());
            l.setForeground(Column.getFor(ColumnDefinition.DSA_SIZE_PGMS).getColor());
            this.viewPart.addPaintedLabel((Control)l, ColumnDefinition.DSA_SIZE_PGMS);
            l.setData((Object)ColumnDefinition.DSA_SIZE_PGMS);
            l.setToolTipText(ColumnDefinition.DSA_SIZE_PGMS.getTooltip(null));
            lt = new Label((Composite)groupBox, 131080);
            lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            lt.setBackground(this.detailSection.getBackground());
            this.labels.put(ColumnDefinition.DSA_SIZE_PGMS, (Control)lt);
            lt.setToolTipText(ColumnDefinition.DSA_SIZE_PGMS.getTooltip(null));
            lt = new Label((Composite)groupBox, 131080);
            lt.setBackground(this.detailSection.getBackground());
            lt.setToolTipText(Messages.getString("PlotView.DSA_SIZE_PGMS_PERCENT.tooltip"));
            lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            this.labels.put(ColumnDefinition.DSA_SIZE_PGMS_PERCENT, (Control)lt);
        }
        gbData.minimumWidth = groupBox.computeSize((int)-1, (int)-1).x;
        gbData = new GridData(4, 128, true, false, 4, 1);
        link = new Link(this.detailColumnComposite, 0);
        link.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        link.setText(Messages.getString("EDSA.text"));
        link.addKeyListener(this.viewPart.genericKeyListener);
        link.setToolTipText(Messages.getString(this.model.isLDGRecord() ? "LDG.EDSA.tooltip" : "EDSA.tooltip"));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlertElement nextAlert = PlotViewVariance.this.model.isLDGRecord() ? PlotViewVariance.this.viewPart.getCurrentElement().createElement(ColumnDefinition.DSA_NAME, "'ECDSA', 'EUDSA', 'ESDSA', 'ERDSA', 'ETDSA'", Comparator.IN, "HST030B") : PlotViewVariance.this.viewPart.getCurrentElement().createElement(ColumnDefinition.DSA_INDEX, "9, 10, 11, 12, 13", Comparator.IN, "HST014B");
                PlotViewVariance.this.viewPart.activateHyperLink(nextAlert);
            }
        });
        link.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getDescription(AccessibleEvent e) {
                e.result = Messages.getString(PlotViewVariance.this.model.isLDGRecord() ? "LDG.EDSA.tooltip" : "EDSA.tooltip");
            }

            public void getName(AccessibleEvent e) {
                e.result = Messages.getString(PlotViewVariance.this.model.isLDGRecord() ? "LDG.EDSA.tooltip" : "EDSA.tooltip");
            }
        });
        link.setEnabled(true);
        link.setBackground(this.detailSection.getBackground());
        groupBox = new Group(this.detailColumnComposite, 0);
        groupBox.setLayoutData((Object)gbData);
        groupBox.setLayout((Layout)this.widerLayoutShort(new GridLayout(3, false)));
        groupBox.setBackground(this.detailSection.getBackground());
        l = new Label((Composite)groupBox, 0);
        GridData gd1 = new GridData(4, 4, true, false, 1, 1);
        l.setLayoutData((Object)gd1);
        l.setText(ColumnDefinition.EDSA_LIMIT.getLabel(null));
        gd1.minimumWidth = l.computeSize((int)-1, (int)-1).x;
        l.setBackground(this.detailSection.getBackground());
        lt = new Label((Composite)groupBox, 131080);
        gd1 = new GridData(4, 4, true, false, 1, 1);
        lt.setLayoutData((Object)gd1);
        lt.setText("9,999,999,999");
        gd1.minimumWidth = lt.computeSize((int)-1, (int)-1).x;
        lt.setBackground(this.detailSection.getBackground());
        this.labels.put(ColumnDefinition.EDSA_LIMIT, (Control)lt);
        l = new Label((Composite)groupBox, 8);
        l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        l.setBackground(this.detailSection.getBackground());
        l = new Label((Composite)groupBox, 0);
        l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        l.setText(ColumnDefinition.EDSA_CURRENT_TOTAL.getLabel(null));
        l.setFont(STANDARD_BOLD);
        l.setBackground(this.detailSection.getBackground());
        l.setForeground(Column.getFor(ColumnDefinition.EDSA_CURRENT_TOTAL).getColor());
        this.viewPart.addPaintedLabel((Control)l, ColumnDefinition.EDSA_CURRENT_TOTAL);
        l.setData((Object)ColumnDefinition.EDSA_CURRENT_TOTAL);
        lt = new Label((Composite)groupBox, 131080);
        lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lt.setBackground(this.detailSection.getBackground());
        this.labels.put(ColumnDefinition.EDSA_CURRENT_TOTAL, (Control)lt);
        lt.setToolTipText(Messages.getString("PlotView.EDSA_CURRENT_TOTAL_PERCENT.tooltip"));
        lt = new Label((Composite)groupBox, 131080);
        lt.setBackground(this.detailSection.getBackground());
        lt.setToolTipText(Messages.getString("PlotView.EDSA_CURRENT_TOTAL_PERCENT.tooltip"));
        gd1 = new GridData(4, 4, true, false, 1, 1);
        lt.setLayoutData((Object)gd1);
        lt.setText("(99.9)");
        gd1.minimumWidth = lt.computeSize((int)-1, (int)-1).x;
        this.labels.put(ColumnDefinition.EDSA_CURRENT_TOTAL_PERCENT, (Control)lt);
        l = new Label((Composite)groupBox, 0);
        l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        l.setText(ColumnDefinition.EDSA_TOTAL_PEAK.getLabel(null));
        l.setFont(STANDARD_BOLD);
        l.setBackground(this.detailSection.getBackground());
        l.setForeground(Column.getFor(ColumnDefinition.EDSA_TOTAL_PEAK).getColor());
        this.viewPart.addPaintedLabel((Control)l, ColumnDefinition.EDSA_TOTAL_PEAK);
        l.setData((Object)ColumnDefinition.EDSA_TOTAL_PEAK);
        lt = new Label((Composite)groupBox, 131080);
        lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.labels.put(ColumnDefinition.EDSA_TOTAL_PEAK, (Control)lt);
        lt.setToolTipText(Messages.getString("PlotView.EDSA_TOTAL_PEAK_PERCENT.tooltip"));
        lt.setBackground(this.detailSection.getBackground());
        lt = new Label((Composite)groupBox, 131080);
        lt.setToolTipText(Messages.getString("PlotView.EDSA_TOTAL_PEAK_PERCENT.tooltip"));
        lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lt.setBackground(this.detailSection.getBackground());
        this.labels.put(ColumnDefinition.EDSA_TOTAL_PEAK_PERCENT, (Control)lt);
        l = new Label((Composite)groupBox, 0);
        l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        l.setText(ColumnDefinition.EDSA_SIZE_USED.getLabel(null));
        l.setToolTipText(ColumnDefinition.EDSA_SIZE_USED.getTooltip(null));
        l.setFont(STANDARD_BOLD);
        l.setBackground(this.detailSection.getBackground());
        l.setForeground(Column.getFor(ColumnDefinition.EDSA_SIZE_USED).getColor());
        this.viewPart.addPaintedLabel((Control)l, ColumnDefinition.EDSA_SIZE_USED);
        l.setData((Object)ColumnDefinition.EDSA_SIZE_USED);
        lt = new Label((Composite)groupBox, 131080);
        lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lt.setBackground(this.detailSection.getBackground());
        this.labels.put(ColumnDefinition.EDSA_SIZE_USED, (Control)lt);
        lt.setToolTipText(ColumnDefinition.EDSA_SIZE_USED.getTooltip(null));
        lt = new Label((Composite)groupBox, 131080);
        lt.setBackground(this.detailSection.getBackground());
        lt.setToolTipText(Messages.getString("PlotView.EDSA_SIZE_USED_PERCENT.tooltip"));
        lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.labels.put(ColumnDefinition.EDSA_SIZE_USED_PERCENT, (Control)lt);
        if (this.model.isLDGRecord()) {
            l = new Label((Composite)groupBox, 0);
            l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            l.setText(ColumnDefinition.EDSA_SIZE_PGMS.getLabel(null));
            l.setToolTipText(ColumnDefinition.EDSA_SIZE_PGMS.getTooltip(null));
            l.setFont(STANDARD_BOLD);
            l.setBackground(this.detailSection.getBackground());
            l.setForeground(Column.getFor(ColumnDefinition.EDSA_SIZE_PGMS).getColor());
            this.viewPart.addPaintedLabel((Control)l, ColumnDefinition.EDSA_SIZE_PGMS);
            l.setData((Object)ColumnDefinition.EDSA_SIZE_PGMS);
            lt = new Label((Composite)groupBox, 131080);
            lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            lt.setBackground(this.detailSection.getBackground());
            this.labels.put(ColumnDefinition.EDSA_SIZE_PGMS, (Control)lt);
            lt.setToolTipText(ColumnDefinition.EDSA_SIZE_PGMS.getTooltip(null));
            lt = new Label((Composite)groupBox, 131080);
            lt.setBackground(this.detailSection.getBackground());
            lt.setToolTipText(Messages.getString("PlotView.EDSA_SIZE_PGMS_PERCENT.tooltip"));
            lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            this.labels.put(ColumnDefinition.EDSA_SIZE_PGMS_PERCENT, (Control)lt);
        }
        gbData.minimumWidth = groupBox.computeSize((int)-1, (int)-1).x;
        gbData = new GridData(4, 128, true, false, 4, 1);
        if (this.model.isSMSRecord()) {
            link = new Link(this.detailColumnComposite, 0);
            link.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
            link.setText(Messages.getString("GDSA.text"));
            link.addKeyListener(this.viewPart.genericKeyListener);
            link.setToolTipText(Messages.getString(this.model.isLDGRecord() ? "LDG.GDSA.tooltip" : "GDSA.tooltip"));
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AlertElement nextAlert = PlotViewVariance.this.viewPart.getCurrentElement().createElement(ColumnDefinition.DSA_INDEX, "17, 18, 19", Comparator.IN, "HST014B");
                    PlotViewVariance.this.viewPart.activateHyperLink(nextAlert);
                }
            });
            link.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = Messages.getString(PlotViewVariance.this.model.isLDGRecord() ? "LDG.GDSA.tooltip" : "GDSA.tooltip");
                }

                public void getDescription(AccessibleEvent e) {
                    e.result = Messages.getString(PlotViewVariance.this.model.isLDGRecord() ? "LDG.GDSA.tooltip" : "GDSA.tooltip");
                }
            });
            link.setBackground(this.detailSection.getBackground());
            link.setEnabled(true);
            groupBox = new Group(this.detailColumnComposite, 0);
            groupBox.setLayoutData((Object)gbData);
            groupBox.setLayout((Layout)this.widerLayoutShort(new GridLayout(3, false)));
            groupBox.setBackground(this.detailSection.getBackground());
            l = new Label((Composite)groupBox, 0);
            l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            l.setText(Messages.getString("ColumnDefinition.MEMLIMIT_SIZE_SOURCE"));
            l.setBackground(this.detailSection.getBackground());
            GridData gd2 = new GridData(4, 4, true, false, 1, 1);
            l.setLayoutData((Object)gd2);
            gd2.minimumWidth = l.computeSize((int)-1, (int)-1).x;
            l.setBackground(this.detailSection.getBackground());
            lt = new Label((Composite)groupBox, 131080);
            lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            lt.setBackground(this.detailSection.getBackground());
            this.labels.put(ColumnDefinition.MEMLIMIT_SIZE, (Control)lt);
            lt = new Label((Composite)groupBox, 0x1000008);
            lt.setBackground(this.detailSection.getBackground());
            lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            this.labels.put(ColumnDefinition.MEMLIMIT_SOURCE, (Control)lt);
            l = new Label((Composite)groupBox, 0);
            l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            l.setText(ColumnDefinition.CURRENT_ACTIV_GDSA.getLabel(null));
            l.setFont(STANDARD_BOLD);
            l.setBackground(this.detailSection.getBackground());
            l.setForeground(Column.getFor(ColumnDefinition.CURRENT_ACTIV_GDSA).getColor());
            this.viewPart.addPaintedLabel((Control)l, ColumnDefinition.CURRENT_ACTIV_GDSA);
            l.setData((Object)ColumnDefinition.CURRENT_ACTIV_GDSA);
            lt = new Label((Composite)groupBox, 131080);
            lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            lt.setBackground(this.detailSection.getBackground());
            this.labels.put(ColumnDefinition.CURRENT_ACTIV_GDSA, (Control)lt);
            lt.setToolTipText(Messages.getString("PlotView.GDSA_CURRENT_TOTAL_PERCENT.tooltip"));
            lt = new Label((Composite)groupBox, 131080);
            lt.setToolTipText(Messages.getString("PlotView.GDSA_CURRENT_TOTAL_PERCENT.tooltip"));
            lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            lt.setBackground(this.detailSection.getBackground());
            this.labels.put(ColumnDefinition.CURRENT_ACTIV_GDSA_PERCENT, (Control)lt);
            l = new Label((Composite)groupBox, 0);
            l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            l.setText(ColumnDefinition.PEAK_GDSA_ACTIVE.getLabel(null));
            l.setFont(STANDARD_BOLD);
            l.setBackground(this.detailSection.getBackground());
            l.setForeground(Column.getFor(ColumnDefinition.PEAK_GDSA_ACTIVE).getColor());
            this.viewPart.addPaintedLabel((Control)l, ColumnDefinition.PEAK_GDSA_ACTIVE);
            l.setData((Object)ColumnDefinition.PEAK_GDSA_ACTIVE);
            lt = new Label((Composite)groupBox, 131080);
            lt.setBackground(this.detailSection.getBackground());
            lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            this.labels.put(ColumnDefinition.PEAK_GDSA_ACTIVE, (Control)lt);
            lt.setToolTipText(Messages.getString("PlotView.GDSA_TOTAL_PEAK_PERCENT.tooltip"));
            lt = new Label((Composite)groupBox, 131080);
            lt.setToolTipText(Messages.getString("PlotView.GDSA_TOTAL_PEAK_PERCENT.tooltip"));
            lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            lt.setBackground(this.detailSection.getBackground());
            this.labels.put(ColumnDefinition.PEAK_GDSA_ACTIVE_PERCENT, (Control)lt);
            l = new Label((Composite)groupBox, 0);
            l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            l.setText(ColumnDefinition.GDSA_SIZE_USED.getLabel(null));
            l.setToolTipText(ColumnDefinition.GDSA_SIZE_USED.getTooltip(null));
            l.setFont(STANDARD_BOLD);
            l.setBackground(this.detailSection.getBackground());
            l.setForeground(Column.getFor(ColumnDefinition.GDSA_SIZE_USED).getColor());
            this.viewPart.addPaintedLabel((Control)l, ColumnDefinition.GDSA_SIZE_USED);
            l.setData((Object)ColumnDefinition.GDSA_SIZE_USED);
            lt = new Label((Composite)groupBox, 131080);
            lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            lt.setBackground(this.detailSection.getBackground());
            this.labels.put(ColumnDefinition.GDSA_SIZE_USED, (Control)lt);
            lt.setToolTipText(ColumnDefinition.GDSA_SIZE_USED.getTooltip(null));
            lt = new Label((Composite)groupBox, 131080);
            lt.setBackground(this.detailSection.getBackground());
            lt.setToolTipText(Messages.getString("PlotView.GDSA_SIZE_USED_PERCENT.tooltip"));
            lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            this.labels.put(ColumnDefinition.GDSA_SIZE_USED_PERCENT, (Control)lt);
            gbData.minimumWidth = groupBox.computeSize((int)-1, (int)-1).x;
        }
    }

    private void provideDispatcherLink(final ColumnDefinition definition) {
        Hyperlink link = new Hyperlink(this.detailColumnComposite, 0);
        link.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        link.setBackground(this.detailSection.getBackground());
        link.setText(definition.getLabel(null));
        link.addKeyListener(this.viewPart.genericKeyListener);
        link.setForeground(ColorConstants.blue);
        link.setUnderlined(true);
        link.setToolTipText(definition == ColumnDefinition.CICS_TCB_MODES ? Messages.getString("PlotModel.hyperlink.tcbmodes") : Messages.getString("PlotModel.hyperlink.tcbpools"));
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AlertElement nextAlert = PlotViewVariance.this.viewPart.getCurrentElement().createElement(definition == ColumnDefinition.CICS_TCB_MODES ? ColumnDefinition.TCB_MODE_NAME : ColumnDefinition.TCB_POOL, " * ", Comparator.EQ, null);
                if (nextAlert != null) {
                    PlotViewVariance.this.viewPart.activateSheetViewLink(nextAlert);
                }
            }
        });
        link.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getDescription(AccessibleEvent e) {
                e.result = definition == ColumnDefinition.CICS_TCB_MODES ? Messages.getString("PlotModel.hyperlink.tcbmodes") : Messages.getString("PlotModel.hyperlink.tcbpools");
            }
        });
        link.setEnabled(true);
        Label lt = new Label(this.detailColumnComposite, 8);
        lt.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        lt.setToolTipText(definition.getLabel(null));
        lt.setBackground(this.detailSection.getBackground());
        this.labels.put(definition, (Control)lt);
        new Label(this.detailColumnComposite, 8);
    }

    @Override
    public void keyPress(int keyCode) {
        if (keyCode == 0x1000006) {
            Point point = this.scrolledComposite.getOrigin();
            point.y += 100;
            this.scrolledComposite.setOrigin(point);
        } else if (keyCode == 0x1000005) {
            Point point = this.scrolledComposite.getOrigin();
            point.y -= 100;
            this.scrolledComposite.setOrigin(point);
        } else if (keyCode == 0x1000001) {
            Point point = this.scrolledComposite.getOrigin();
            point.y -= 10;
            this.scrolledComposite.setOrigin(point);
        } else if (keyCode == 0x1000002) {
            Point point = this.scrolledComposite.getOrigin();
            point.y += 10;
            this.scrolledComposite.setOrigin(point);
        }
    }

    protected void dsaStyleHeadings(Color background) {
        Composite comp1 = new Composite(this.detailColumnComposite, 0);
        comp1.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        GridLayout lean = this.viewPart.leanLayout(new GridLayout(2, false));
        comp1.setLayout((Layout)lean);
        comp1.setBackground(background);
        Group headingBox = new Group(comp1, 0);
        headingBox.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        headingBox.setLayout((Layout)this.widerLayout(new GridLayout(2, false)));
        headingBox.setBackground(this.detailSection.getBackground());
        Label l = new Label((Composite)headingBox, 0);
        l.setText(ColumnDefinition.START_DATE.getLabel(null));
        l.setBackground(background);
        l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label lt = new Label((Composite)headingBox, 0);
        lt.setBackground(background);
        lt.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        lt.setToolTipText(ColumnDefinition.START_DATE.getLabel(null));
        this.labels.put(ColumnDefinition.START_DATE, (Control)lt);
        l = new Label((Composite)headingBox, 0);
        l.setBackground(background);
        l.setText(ColumnDefinition.START_TIME.getLabel(null));
        l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lt = new Label((Composite)headingBox, 8);
        lt.setToolTipText(ColumnDefinition.START_TIME.getLabel(null));
        lt.setBackground(background);
        lt.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.labels.put(ColumnDefinition.START_TIME, (Control)lt);
        l = new Label((Composite)headingBox, 0);
        l.setBackground(background);
        l.setText(ColumnDefinition.INTERVAL_NUMBER.getLabel(null));
        l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lt = new Label((Composite)headingBox, 8);
        lt.setBackground(background);
        lt.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        lt.setToolTipText(ColumnDefinition.INTERVAL_NUMBER.getLabel(null));
        this.labels.put(ColumnDefinition.INTERVAL_NUMBER, (Control)lt);
        l = new Label((Composite)headingBox, 0);
        l.setBackground(background);
        l.setText(ColumnDefinition.APPLID.getLabel(null));
        l.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        lt = new Hyperlink((Composite)headingBox, 0);
        lt.setToolTipText(ColumnDefinition.APPLID.getLabel(null));
        lt.setBackground(background);
        lt.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        ((Hyperlink)lt).setText("");
        ((Hyperlink)lt).addKeyListener(this.viewPart.genericKeyListener);
        lt.setToolTipText(this.model.getHyperlinkToolTip(ColumnDefinition.APPLID));
        lt.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = PlotViewVariance.this.model.getHyperlinkToolTip(ColumnDefinition.APPLID);
            }
        });
        lt.setForeground(ColorConstants.blue);
        ((Hyperlink)lt).setUnderlined(true);
        ((Hyperlink)lt).addKeyListener(this.viewPart.genericKeyListener);
        ((Hyperlink)lt).addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AlertElement nextAlert = PlotViewVariance.this.model.isLDGDSARecord() ? PlotViewVariance.this.viewPart.getCurrentElement().createElement(ColumnDefinition.APPLID, Comparator.EQ, "HST030A") : PlotViewVariance.this.viewPart.getCurrentElement().createElement(ColumnDefinition.APPLID, Comparator.EQ, "HST014A");
                PlotViewVariance.this.viewPart.activateHyperLink(nextAlert);
            }
        });
        this.labels.put(ColumnDefinition.APPLID, (Control)lt);
        headingBox = new Group(comp1, 0);
        headingBox.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        headingBox.setLayout((Layout)this.widerLayout(new GridLayout(this.model.getDSAType() == PlotModel.DSAType.GDSA ? 4 : 2, false)));
        headingBox.setBackground(this.detailSection.getBackground());
        l = new Label((Composite)headingBox, 0);
        l.setBackground(background);
        l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lt = new Label((Composite)headingBox, 0);
        lt.setBackground(background);
        lt.setLayoutData((Object)new GridData(4, 4, false, false, this.model.getDSAType() == PlotModel.DSAType.GDSA ? 3 : 1, 1));
        switch (this.model.getDSAType()) {
            case GDSA: {
                l.setText(Messages.getString("ChartDefinition.GDSA_TRACE"));
                l.setForeground(Column.getFor(ColumnDefinition.CURRENT_ACTIV_GDSA).getColor());
                break;
            }
            case EDSA: {
                l.setText(Messages.getString("ChartDefinition.EDSA_TRACE"));
                l.setForeground(Column.getFor(ColumnDefinition.EDSA_CURRENT_TOTAL).getColor());
                break;
            }
            default: {
                l.setText(Messages.getString("ChartDefinition.DSA_TRACE"));
                l.setForeground(Column.getFor(ColumnDefinition.DSA_CURRENT_TOTAL).getColor());
            }
        }
        l = new Label((Composite)headingBox, 0);
        l.setBackground(background);
        l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lt = new Label((Composite)headingBox, 0);
        lt.setBackground(background);
        lt.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        switch (this.model.getDSAType()) {
            case GDSA: {
                l.setText(ColumnDefinition.MEMLIMIT_SIZE.getLabel(null));
                lt.setToolTipText(ColumnDefinition.MEMLIMIT_SIZE.getLabel(null));
                this.labels.put(ColumnDefinition.MEMLIMIT_SIZE, (Control)lt);
                l = new Label((Composite)headingBox, 0);
                l.setBackground(background);
                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                lt = new Label((Composite)headingBox, 0);
                lt.setBackground(background);
                lt.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
                l.setText(ColumnDefinition.CUR_GDSA_ALLOCATED.getLabel(null));
                lt.setToolTipText(ColumnDefinition.CUR_GDSA_ALLOCATED.getLabel(null));
                this.labels.put(ColumnDefinition.CUR_GDSA_ALLOCATED, (Control)lt);
                l = new Label((Composite)headingBox, 0);
                l.setBackground(background);
                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                lt = new Label((Composite)headingBox, 0);
                lt.setBackground(background);
                lt.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
                l.setText(ColumnDefinition.MEMLIMIT_SOURCE.getLabel(null));
                lt.setToolTipText(ColumnDefinition.MEMLIMIT_SOURCE.getLabel(null));
                this.labels.put(ColumnDefinition.MEMLIMIT_SOURCE, (Control)lt);
                l = new Label((Composite)headingBox, 0);
                l.setBackground(background);
                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                lt = new Label((Composite)headingBox, 0);
                lt.setBackground(background);
                lt.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
                l.setText(ColumnDefinition.PEAK_GDSA_ALLOCATE.getLabel(null));
                lt.setToolTipText(ColumnDefinition.PEAK_GDSA_ALLOCATE.getLabel(null));
                this.labels.put(ColumnDefinition.PEAK_GDSA_ALLOCATE, (Control)lt);
                break;
            }
            case EDSA: {
                l.setText(ColumnDefinition.EDSA_LIMIT.getLabel(null));
                lt.setToolTipText(ColumnDefinition.EDSA_LIMIT.getLabel(null));
                this.labels.put(ColumnDefinition.EDSA_LIMIT, (Control)lt);
                break;
            }
            default: {
                l.setText(ColumnDefinition.DSA_LIMIT.getLabel(null));
                lt.setToolTipText(ColumnDefinition.DSA_LIMIT.getLabel(null));
                this.labels.put(ColumnDefinition.DSA_LIMIT, (Control)lt);
            }
        }
        l = new Label((Composite)headingBox, 0);
        l.setBackground(background);
        l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lt = new Label((Composite)headingBox, 0);
        lt.setBackground(background);
        lt.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        switch (this.model.getDSAType()) {
            case GDSA: {
                l.setText(ColumnDefinition.CURRENT_ADDR_SPACE.getLabel(null));
                lt.setToolTipText(ColumnDefinition.CURRENT_ADDR_SPACE.getLabel(null));
                this.labels.put(ColumnDefinition.CURRENT_ADDR_SPACE, (Control)lt);
                l = new Label((Composite)headingBox, 0);
                l.setBackground(background);
                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                lt = new Label((Composite)headingBox, 0);
                lt.setBackground(background);
                lt.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
                l.setText(ColumnDefinition.CURRENT_ACTIV_GDSA.getLabel(null));
                lt.setToolTipText(ColumnDefinition.CURRENT_ACTIV_GDSA.getLabel(null));
                this.labels.put(ColumnDefinition.CURRENT_ACTIV_GDSA, (Control)lt);
                break;
            }
            case EDSA: {
                l.setText(ColumnDefinition.EDSA_CURRENT_TOTAL.getLabel(null));
                lt.setToolTipText(ColumnDefinition.EDSA_CURRENT_TOTAL.getLabel(null));
                this.labels.put(ColumnDefinition.EDSA_CURRENT_TOTAL, (Control)lt);
                break;
            }
            default: {
                l.setText(ColumnDefinition.DSA_CURRENT_TOTAL.getLabel(null));
                lt.setToolTipText(ColumnDefinition.DSA_CURRENT_TOTAL.getLabel(null));
                this.labels.put(ColumnDefinition.DSA_CURRENT_TOTAL, (Control)lt);
            }
        }
        l = new Label((Composite)headingBox, 0);
        l.setBackground(background);
        l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lt = new Label((Composite)headingBox, 0);
        lt.setBackground(background);
        lt.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        switch (this.model.getDSAType()) {
            case GDSA: {
                l.setText(ColumnDefinition.PEAK_ADDRESS_SPACE.getLabel(null));
                lt.setToolTipText(ColumnDefinition.PEAK_ADDRESS_SPACE.getLabel(null));
                this.labels.put(ColumnDefinition.PEAK_ADDRESS_SPACE, (Control)lt);
                l = new Label((Composite)headingBox, 0);
                l.setBackground(background);
                l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                lt = new Label((Composite)headingBox, 0);
                lt.setBackground(background);
                lt.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
                l.setText(ColumnDefinition.PEAK_GDSA_ACTIVE.getLabel(null));
                lt.setToolTipText(ColumnDefinition.PEAK_GDSA_ACTIVE.getLabel(null));
                this.labels.put(ColumnDefinition.PEAK_GDSA_ACTIVE, (Control)lt);
                break;
            }
            case EDSA: {
                l.setText(ColumnDefinition.EDSA_TOTAL_PEAK.getLabel(null));
                lt.setToolTipText(ColumnDefinition.EDSA_TOTAL_PEAK.getLabel(null));
                this.labels.put(ColumnDefinition.EDSA_TOTAL_PEAK, (Control)lt);
                break;
            }
            default: {
                l.setText(ColumnDefinition.DSA_TOTAL_PEAK.getLabel(null));
                lt.setToolTipText(ColumnDefinition.DSA_TOTAL_PEAK.getLabel(null));
                this.labels.put(ColumnDefinition.DSA_TOTAL_PEAK, (Control)lt);
            }
        }
    }

    protected Control createPoolsHyperLink(final ColumnDefinition headlabel, Group contentBox) {
        final String labex = headlabel.getLabel(null);
        final Hyperlink lt = new Hyperlink((Composite)contentBox, 0);
        lt.setText("");
        lt.setToolTipText(this.model.getHyperlinkToolTip(labex.endsWith(ColumnDefinition.UDSA.getLabel(null)) ? ColumnDefinition.UDSA : ColumnDefinition.SUBPOOLS_CUR));
        GridData gdHyper = new GridData(4, 4, true, false, 1, 1);
        gdHyper.horizontalAlignment = 131072;
        lt.setLayoutData((Object)gdHyper);
        lt.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = String.valueOf(labex.endsWith(ColumnDefinition.UDSA.getLabel(null)) ? ColumnDefinition.UDSA.getLabel(null) : ColumnDefinition.SUBPOOLS_CUR.getLabel(null)) + ' ' + lt.getText();
            }
        });
        lt.setUnderlined(true);
        lt.addKeyListener(this.viewPart.genericKeyListener);
        lt.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (headlabel == ColumnDefinition.TOTALS) {
                    String values;
                    switch (PlotViewVariance.this.model.getDSAType()) {
                        case GDSA: {
                            values = "GCDSA', 'GSDSA";
                            break;
                        }
                        case EDSA: {
                            values = "ECDSA', 'ESDSA', 'ERDSA', 'ETDSA";
                            break;
                        }
                        default: {
                            values = "CDSA', 'SDSA', 'RDSA";
                        }
                    }
                    AlertElement nextAlert = PlotViewVariance.this.viewPart.getCurrentElement().createElement(ColumnDefinition.DSA_NAME, values, Comparator.IN, ColumnDefinition.DSA_NAME.tableLookup(values));
                    PlotViewVariance.this.viewPart.activateSheetViewLink(nextAlert);
                } else if (labex.endsWith(ColumnDefinition.UDSA.getLabel(null))) {
                    String values;
                    switch (PlotViewVariance.this.model.getDSAType()) {
                        case GDSA: {
                            values = "17, 18, 19";
                            break;
                        }
                        case EDSA: {
                            values = "9, 10, 11, 12, 13";
                            break;
                        }
                        default: {
                            values = "1,2,3,4";
                        }
                    }
                    AlertElement nextAlert = PlotViewVariance.this.viewPart.getCurrentElement().createElement(ColumnDefinition.DSA_INDEX, values, Comparator.IN, "HST006A");
                    PlotViewVariance.this.viewPart.activateHyperLink(nextAlert);
                } else {
                    AlertElement nextAlert = PlotViewVariance.this.viewPart.getCurrentElement().createElement(ColumnDefinition.DSA_NAME, labex, Comparator.IN, ColumnDefinition.DSA_NAME.tableLookup(labex));
                    PlotViewVariance.this.viewPart.activateSheetViewLink(nextAlert);
                }
            }
        });
        return lt;
    }
}

