/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views.internal;

import com.ibm.cics.pa.model.Pie;
import com.ibm.cics.pa.model.TransactionPerformanceListModel;
import com.ibm.cics.pa.model.definitions.ColumnContainment;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.PieChartSpecificDefinitions;
import com.ibm.cics.pa.ui.editors.PieEditorItem;
import com.ibm.cics.pa.ui.figures.BigPie;
import com.ibm.cics.pa.ui.views.PieEditorContentProvider;
import com.ibm.cics.pa.ui.views.PieTreeLabelProvider;
import com.ibm.cics.pa.ui.views.internal.IPerformanceListRecordViewVariance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PerformanceListRecordViewVariance
implements IPerformanceListRecordViewVariance {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private TransactionPerformanceListModel model;
    FocusListener focusListener;
    FormToolkit toolkit;
    private List<IndividualTab> tabContents = new ArrayList<IndividualTab>();
    public static final String RESTRICT = "Restrict";
    public static final String INCLUDE = "Include";

    public PerformanceListRecordViewVariance(TransactionPerformanceListModel transactionPerformanceListModel) {
        this.model = transactionPerformanceListModel;
    }

    @Override
    public TabItem[] populatePieSection(IViewPart part, TabFolder topTabFolder, FormToolkit toolkit, FocusListener focusListener) {
        ArrayList<TabItem> tabItems = new ArrayList<TabItem>();
        List<Pie> dPies = this.model.getDetailPies();
        this.focusListener = focusListener;
        this.toolkit = toolkit;
        int i = 0;
        while (i < dPies.size()) {
            TabItem tabItem = new TabItem(topTabFolder, 0);
            IndividualTab tabContent = new IndividualTab(part, topTabFolder, dPies.get(i));
            tabContent.addFocusListener(focusListener);
            tabItem.setControl((Control)tabContent);
            this.tabContents.add(tabContent);
            if (this.model.getPrimaryPie() == dPies.get(i)) {
                topTabFolder.setSelection(i);
            }
            tabItem.setText(dPies.get(i).getChartReference().getTitle());
            tabItem.setToolTipText(dPies.get(i).getToolTipText());
            tabItems.add(tabItem);
            ++i;
        }
        return tabItems.toArray(new TabItem[tabItems.size()]);
    }

    GridLayout leanLayout(GridLayout noMargin) {
        noMargin.marginBottom = 0;
        noMargin.marginTop = 0;
        noMargin.marginLeft = 0;
        noMargin.marginRight = 0;
        noMargin.marginWidth = 0;
        noMargin.marginHeight = 0;
        noMargin.verticalSpacing = 0;
        noMargin.horizontalSpacing = 0;
        return noMargin;
    }

    public class IndividualTab
    extends Composite {
        private TreeViewer treeViewer;
        private PieEditorContentProvider treeContent;
        private TreeViewer additionalViewer;
        BigPie bigPie;
        private FigureCanvas viewer;
        Tree tree;
        private Map<ColumnDefinition, Object> mapping;
        private Composite treesColumn;
        private GridData treeData;
        private GridData treeColumnData;
        private GridData additionalTreeData;
        private GridData mainCompositeData;

        public IndividualTab(IViewPart part, TabFolder topTabFolder, Pie pie) {
            super((Composite)topTabFolder, 0);
            this.mapping = new HashMap<ColumnDefinition, Object>();
            GridLayout layout = PerformanceListRecordViewVariance.this.leanLayout(new GridLayout());
            layout.numColumns = 2;
            this.setLayout((Layout)layout);
            this.setBackground(ColorConstants.white);
            this.mainCompositeData = new GridData(128, 128, false, false);
            this.mainCompositeData.heightHint = 300;
            this.setLayoutData(this.mainCompositeData);
            Composite pieColumn = PerformanceListRecordViewVariance.this.toolkit.createComposite((Composite)this, 0);
            this.treesColumn = PerformanceListRecordViewVariance.this.toolkit.createComposite((Composite)this, 0);
            pieColumn.setLayout((Layout)new GridLayout());
            pieColumn.setBackground(ColorConstants.white);
            GridLayout layout2 = new GridLayout();
            layout2.marginWidth = 0;
            layout2.marginHeight = 0;
            layout2.verticalSpacing = 0;
            this.treesColumn.setLayout((Layout)layout2);
            this.treeColumnData = new GridData(4, 128, true, false);
            this.treesColumn.setLayoutData((Object)this.treeColumnData);
            GridData gdColumn1 = new GridData(4, 0x1000000, true, false);
            pieColumn.setLayoutData((Object)gdColumn1);
            ScrollingGraphicalViewer graphicalViewer = new ScrollingGraphicalViewer();
            this.viewer = (FigureCanvas)graphicalViewer.createControl(pieColumn);
            this.viewer.getViewport().setPreferredSize(new Dimension(225, 225));
            this.viewer.addListener(15, new Listener(){

                public void handleEvent(Event event) {
                    IndividualTab.this.tree.setFocus();
                }
            });
            this.viewer.setBackground(ColorConstants.white);
            this.viewer.setToolTipText(pie.getToolTipText());
            PerformanceListRecordViewVariance.this.toolkit.adapt((Composite)this.viewer);
            this.bigPie = new BigPie(part, graphicalViewer, pie);
            this.viewer.getViewport().setContents((IFigure)this.bigPie);
            GridData bigPieLayoutData = new GridData(1, 1, true, false);
            bigPieLayoutData.heightHint = 225;
            this.viewer.setLayoutData((Object)bigPieLayoutData);
            this.tree = PerformanceListRecordViewVariance.this.toolkit.createTree(this.treesColumn, 68096);
            this.treeData = new GridData(4, 4, true, true);
            this.tree.setLayoutData((Object)this.treeData);
            this.treeData.heightHint = 300;
            this.tree.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
            this.tree.addFocusListener(PerformanceListRecordViewVariance.this.focusListener);
            this.viewer.addFocusListener(PerformanceListRecordViewVariance.this.focusListener);
            String[] tooltips = ((PieChartSpecificDefinitions)pie.getChartReference().getSpecificType()).getTooltips();
            String[] headers = ((PieChartSpecificDefinitions)pie.getChartReference().getSpecificType()).getHeadings();
            this.treeViewer = new TreeViewer(this.tree);
            this.treeViewer.setColumnProperties(headers);
            this.tree.setLinesVisible(true);
            this.tree.setHeaderVisible(true);
            this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (IndividualTab.this.bigPie != null) {
                        IndividualTab.this.bigPie.setSelection(IndividualTab.this.getInternalSelection());
                    }
                }
            });
            this.treeContent = new PieEditorContentProvider(this.mapping);
            this.treeViewer.setContentProvider((IContentProvider)this.treeContent);
            int i = 0;
            while (i < headers.length) {
                PieTreeLabelProvider tempTreeLabelProvider = new PieTreeLabelProvider(this.mapping, i);
                TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
                treeViewerColumn.setLabelProvider((CellLabelProvider)tempTreeLabelProvider);
                treeViewerColumn.getColumn().setText(headers[i]);
                treeViewerColumn.getColumn().setToolTipText(tooltips[i]);
                if (i == 0) {
                    treeViewerColumn.getColumn().setWidth(350);
                } else if (i == 1) {
                    treeViewerColumn.getColumn().setWidth(160);
                    treeViewerColumn.getColumn().setAlignment(131072);
                } else if (headers[i].length() == 0) {
                    treeViewerColumn.getColumn().setWidth(0);
                } else {
                    treeViewerColumn.getColumn().setWidth(85);
                    treeViewerColumn.getColumn().setAlignment(131072);
                }
                ++i;
            }
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer, (int)2);
            if (pie.twoTree()) {
                Tree additionalTree = PerformanceListRecordViewVariance.this.toolkit.createTree(this.treesColumn, 68096);
                additionalTree.setLinesVisible(true);
                additionalTree.setHeaderVisible(true);
                this.additionalViewer = new TreeViewer(additionalTree);
                this.additionalTreeData = new GridData(4, 1024, true, false);
                this.additionalViewer.getTree().setLayoutData((Object)this.additionalTreeData);
                ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.additionalViewer, (int)2);
            }
            this.initialiseContent(pie);
        }

        private void initialiseContent(Pie model) {
            if (model != null) {
                this.mapping.clear();
                ColumnDefinition[] definitions = model.getDataProvider().getColumnDefinitions();
                int i = 0;
                while (i < definitions.length) {
                    this.mapping.put(definitions[i], model.getRow()[i]);
                    ++i;
                }
                for (ColumnDefinition defn : model.getCompleteValues().keySet()) {
                    if (this.mapping.containsKey(defn)) continue;
                    this.mapping.put(defn, model.getCompleteValues().get(defn));
                }
                if (this.additionalViewer != null) {
                    model.establishVariance().populateTreeViewer(this.additionalViewer, this.mapping, false, true);
                    this.treeData.heightHint = 200;
                    this.treeColumnData.heightHint = 300;
                } else {
                    this.treeData.grabExcessVerticalSpace = true;
                    this.treeColumnData.grabExcessVerticalSpace = true;
                }
                this.treeContent.includeNonZeroValues(true);
                this.treeContent.restrictToCurrentChart(true);
                this.treeViewer.setInput((Object)PieEditorItem.createRootFor(model.getChartReference(), this.mapping, false, true));
                this.treeViewer.expandAll();
                this.bigPie.initialiseSingleComponent(model);
                this.treeViewer.getTree().layout();
                this.treesColumn.layout();
            }
        }

        PieEditorItem getInternalSelection() {
            StructuredSelection sle = (StructuredSelection)this.treeViewer.getSelection();
            return sle.isEmpty() ? null : (PieEditorItem)sle.getFirstElement();
        }

        public void adjustTreeSelection(ColumnContainment containment) {
            PieEditorItem sel = ((PieEditorItem)this.treeViewer.getInput()).findChild(containment);
            if (sel != null) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)sel));
            }
        }

        public void adjustTreeSelection(ColumnDefinition definition) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)((PieEditorItem)this.treeViewer.getInput()).findChild(definition)));
        }
    }
}

