/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.TreeElement;
import com.ibm.cics.pa.model.definitions.CategorisationHelper;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.remote.RemoteUniqueRecord;
import com.ibm.cics.pa.ui.views.SheetView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.IHandlerService;

public class SheetViewSelectionProvider
implements ISelectionProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    SheetView viewPart;
    private Image elementImage = Activator.getDefault().getImage(Activator.IMGD_TRAN);
    private List<TreeElement> mutatedSelection;

    public SheetViewSelectionProvider(SheetView sheetView, final Table table) {
        this.viewPart = sheetView;
        table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (((StructuredSelection)SheetViewSelectionProvider.this.getSelection()).size() == 1 && ((StructuredSelection)SheetViewSelectionProvider.this.getSelection()).getFirstElement() instanceof RemoteUniqueRecord) {
                    IUniqueRecord record = (IUniqueRecord)((StructuredSelection)SheetViewSelectionProvider.this.getSelection()).getFirstElement();
                    if (CategorisationHelper.validateIntervalTrackerTable(SheetViewSelectionProvider.this.viewPart.getManifestRecord().getAlias(), record)) {
                        try {
                            IHandlerService handlerService = (IHandlerService)SheetViewSelectionProvider.this.viewPart.getSite().getService(IHandlerService.class);
                            handlerService.executeCommand("com.ibm.cics.pa.ui.intervaltracker", null);
                            return;
                        }
                        catch (Exception ex) {
                            Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"createPartControl", (Throwable)ex);
                        }
                    }
                }
            }

            public void widgetSelected(SelectionEvent e) {
                SheetViewSelectionProvider.this.setSelection(SheetViewSelectionProvider.this.getSelection());
                ViewHelper.setStatusInformationMessage((IWorkbenchPart)SheetViewSelectionProvider.this.viewPart, (String)("" + table.getSelectionCount() + ' ' + Messages.getString("SheetEditor.ItemsSelected")));
            }
        });
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
        this.setSelection(this.getSelection());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public ISelection getSelection() {
        ArrayList<IUniqueRecord> elements = new ArrayList<IUniqueRecord>();
        GenericDataProvider dataProvider = this.viewPart.getDataProvider();
        if (dataProvider != null && dataProvider.isValid()) {
            Object[][] objectArray = this.viewPart.getSelectedRows();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] row = objectArray[n2];
                IUniqueRecord record = dataProvider.locateUniqueRecordForRow(row);
                if (record != null) {
                    elements.add(record);
                }
                ++n2;
            }
        }
        return new StructuredSelection(elements);
    }

    public synchronized void setSelection(ISelection selection) {
        if (selection == null) {
            new StructuredSelection();
        }
        GenericDataProvider dataProvider = this.viewPart.getDataProvider();
        if (selection != null && !selection.isEmpty() && this.viewPart.getViewer() != null && dataProvider.isValid()) {
            this.mutatedSelection = new ArrayList<TreeElement>();
            if (((StructuredSelection)selection).getFirstElement() instanceof TreeElement) {
                this.mutatedSelection = ((StructuredSelection)selection).toList();
            } else {
                for (Object[] row : ((StructuredSelection)selection).toList()) {
                    IUniqueRecord model = dataProvider.locateUniqueRecordForRow(row);
                    if (model == null) continue;
                    this.mutatedSelection.add(model);
                }
            }
            if (this.mutatedSelection.size() > 1) {
                ViewHelper.setStatusInformationMessage((IWorkbenchPart)this.viewPart, (String)("" + ((StructuredSelection)selection).size() + ' ' + Messages.getString("SheetEditor.RowsSelected")));
            } else if (((StructuredSelection)selection).getFirstElement() instanceof TreeElement) {
                ViewHelper.setStatusInformationMesssage((IWorkbenchPart)this.viewPart, (Image)this.elementImage, (String)((TreeElement)((StructuredSelection)selection).getFirstElement()).getRelativeText());
            }
            this.fireSelectionChanged();
        }
    }

    private void fireSelectionChanged() {
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new StructuredSelection(this.mutatedSelection));
        Iterator<ISelectionChangedListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ISelectionChangedListener listener;
            final ISelectionChangedListener finalListener = listener = iterator.next();
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    Debug.warning((Logger)logger, (String)SheetView.class.getName(), (String)"setSelection", (Object)"Throwable", (Object)exception.getMessage());
                }

                public void run() throws Exception {
                    finalListener.selectionChanged(event);
                }
            });
        }
    }
}

