/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.views.SheetView;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public class SheetViewContentProvider
implements IStructuredContentProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    GenericDataProvider dataStore;
    Object[][] myData = new Object[0][];
    SheetView editor;

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object dataProvider) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"inputChanged");
        if (dataProvider != null) {
            this.dataStore = (GenericDataProvider)dataProvider;
            if (this.dataStore.isRemote() || this.dataStore.isPopulated() && oldInput == dataProvider) {
                this.myData = this.dataStore.getData(null);
                this.editor.adaptPresentation(this.dataStore);
            } else {
                Job job = new Job(Messages.getString("Locating.records")){

                    protected IStatus run(IProgressMonitor monitor) {
                        SheetViewContentProvider.this.myData = SheetViewContentProvider.this.dataStore.getData(monitor);
                        if (monitor != null && monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                (this).SheetViewContentProvider.this.editor.adaptPresentation((this).SheetViewContentProvider.this.dataStore);
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(20);
                job.schedule();
            }
        } else {
            this.myData = new Object[0][0];
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"inputChanged");
    }

    public Object[] getElements(Object inputElement) {
        if (this.myData == null) {
            return new Object[0];
        }
        return this.myData;
    }

    public SheetViewContentProvider(SheetView editor) {
        this.editor = editor;
    }

    public void updateElement(int index) {
        if (this.myData != null && this.myData.length > index) {
            this.editor.getViewer().replace((Object)this.myData[index], index);
        }
    }
}

