/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.ui.UIHelper;
import com.ibm.cics.dbfunc.DBFuncPlugin;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.ui.ScrollLimitManager;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.pa.comm.PASelectionContext;
import com.ibm.cics.pa.model.CSVFile;
import com.ibm.cics.pa.model.ChartingFile;
import com.ibm.cics.pa.model.DataKeyElement;
import com.ibm.cics.pa.model.DateCaveat;
import com.ibm.cics.pa.model.ExplorerViewModel;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.SheetViewDefinition;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.PAContextTracker;
import com.ibm.cics.pa.ui.SheetViewColumnDialog;
import com.ibm.cics.pa.ui.dialogs.ExportLayoutsDialog;
import com.ibm.cics.pa.ui.dialogs.ImportLayoutsDialog;
import com.ibm.cics.pa.ui.dialogs.SaveTemplateDialog;
import com.ibm.cics.pa.ui.dialogs.SelectTemplateDialog;
import com.ibm.cics.pa.ui.editors.PAResourceChangeListener;
import com.ibm.cics.pa.ui.handlers.PAContextListener;
import com.ibm.cics.pa.ui.preferences.PAPreferenceHelper;
import com.ibm.cics.pa.ui.remote.DBQueryFactoryCustomer;
import com.ibm.cics.pa.ui.remote.HierarchicalRemoteElement;
import com.ibm.cics.pa.ui.remote.RemoteEditorInput;
import com.ibm.cics.pa.ui.remote.RemoteUniqueRecord;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.utilities.FilterContributionControl;
import com.ibm.cics.pa.ui.utilities.FilterElement;
import com.ibm.cics.pa.ui.utilities.PredefinedTemplate;
import com.ibm.cics.pa.ui.utilities.SheetViewPersistenceManager;
import com.ibm.cics.pa.ui.views.Overview;
import com.ibm.cics.pa.ui.views.SheetViewContentProvider;
import com.ibm.cics.pa.ui.views.SheetViewSelectionProvider;
import com.ibm.cics.pa.ui.views.internal.IColumnReorderingView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class SheetView
extends ViewPart
implements FilterContributionControl.IFilterContributionAction,
PAContextListener,
DBQueryFactoryCustomer,
IColumnReorderingView {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Debug debug = new Debug(SheetView.class);
    protected static final int COLUMN_WEIGHT = 1;
    protected Table table1;
    protected CSVFile currentCSVFile;
    protected IAction clearSortAction;
    protected ISelection savedSelection;
    TableViewer viewer = null;
    GenericDataProvider dataProvider = null;
    IResourceChangeListener resourceListener = null;
    ScrollLimitManager scrollLimitManager;
    boolean disposed = false;
    LastSelection theLastSelection = null;
    ManifestRecord manifestRecord;
    Composite c;
    ColumnDefinition sortColumnDefinition;
    OverviewListener overviewListener = new OverviewListener();
    ExplorerListener explorerListener = new ExplorerListener();
    List<String> numericInFilter = new ArrayList<String>();
    FilterContributionControl filterControl;
    boolean inConstructionMode = false;
    String reftable;
    List<FilterElement> filters;
    int dir = 0;
    PASelectionContext context;
    IAction linkToSelectionAction;
    boolean isLinkedToSelection;
    boolean awaitingColumnUpdate = false;
    private HashMap<Object[], TableItem> arrItems = new HashMap();
    private boolean beenSorted = false;
    private Command currentEngine;
    private int index;
    private ModeListener preferenceListener = new ModeListener();
    private int sortDirection = 1024;
    private SheetViewSelectionProvider selectionProvider;
    private IAction resetColumnsAction;
    private IAction resetWidthsAction;
    private IAction customizeColumnsActions;
    private IAction saveAsTemplateAction;
    private IAction importLayoutAction;
    private IAction exportLayoutAction;
    private IMenuManager templateMenu;
    private Hyperlink layoutNameHyperlink;
    private String contextDescriptionText;
    private String layoutNameText;
    private SheetViewDefinition viewDefinition;
    private FormText contextDescriptionFormText;
    private Composite hyperlinkComposite;
    private FormText layoutTitleFormText;
    private String layoutTitleText;
    protected boolean alreadyRefreshing;

    public boolean allSelected() {
        return this.getSelectedRows().length == this.table1.getItemCount();
    }

    private void closeMeAgain(final SheetView view) {
        if (this.resourceListener != null) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
        }
        Job job = new Job(Messages.getString("Resource.status.disconnected")){

            protected IStatus run(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SheetView.this.getViewSite().getPage().hideView((IViewPart)view);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
    }

    public void createPartControl(Composite parent) {
        this.c = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        this.c.setLayout((Layout)gridLayout);
        this.hyperlinkComposite = this.makeContextandLayoutDescriptionComposite(this.c);
        this.contextDescriptionFormText = this.makeContextDescriptionFormText(this.hyperlinkComposite);
        this.layoutTitleFormText = this.makeLayoutDescriptionFormText(this.hyperlinkComposite);
        this.layoutNameHyperlink = this.makeLayoutDescriptonHyperlink(this.hyperlinkComposite);
        this.contextDescriptionFormText.setText("", false, false);
        this.layoutTitleFormText.setText("", false, false);
        this.layoutNameHyperlink.setText("");
        this.viewer = new TableViewer(this.c, 268503810);
        this.table1 = this.viewer.getTable();
        this.table1.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.dataProvider instanceof RemoteEditorInput) {
            this.manifestRecord = ((RemoteEditorInput)this.dataProvider).getManifestRecord();
            if (ConnectionsPlugin.getDefault().getConnectionService().getConnectionManager() == null || this.manifestRecord == null) {
                this.closeMeAgain(this);
                return;
            }
            this.viewDefinition = ((RemoteEditorInput)this.dataProvider).getViewDefinition();
            this.reftable = this.manifestRecord.getAlias();
            if (this.viewDefinition != null && this.viewDefinition.getLayout() != null) {
                SheetViewPersistenceManager.getInstance(this.reftable).loadPredefinedTemplate(this.viewDefinition.getLayout(), this.dataProvider.getColumnDefinitions());
                this.setInstanceLayoutLabel(this.reftable, this.viewDefinition.getLayout().getLabel());
            }
        }
        this.viewer.setContentProvider((IContentProvider)new SheetViewContentProvider(this));
        this.makeActions(this.getViewSite().getWorkbenchWindow());
        this.fillMenu(this.getViewSite().getActionBars());
        this.setFocus();
        if (this.dataProvider != null && this.dataProvider.isPopulated()) {
            this.viewer.setInput((Object)this.dataProvider);
        }
        this.table1.addListener(2, new Listener(){

            public void handleEvent(Event arg0) {
                if ((arg0.stateMask & 0x40000) != 0) {
                    switch (arg0.character) {
                        case '\u0001': {
                            SheetView.this.selectAll();
                            break;
                        }
                        case '\u0003': {
                            SheetView.this.doCopy();
                            break;
                        }
                    }
                }
            }
        });
        if (this.getDataProvider() != null && this.csvData()) {
            this.getDataProvider().incrementUseCount();
        } else {
            this.scrollLimitManager = new ScrollLimitManager(this.c, Messages.getString("Records"), this){

                public void scrollLimitReached(Command command) {
                    super.scrollLimitReached(command);
                    SheetView.this.c.layout(new Control[]{SheetView.this.table1, SheetView.this.scrollLimitManager.scrollLimitComposite});
                }

                public void dispose() {
                    if (!SheetView.this.disposed) {
                        super.dispose();
                        SheetView.this.c.layout(new Control[]{SheetView.this.table1});
                    }
                }
            };
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.viewer.getTable(), this.getHelpContextId());
        this.selectionProvider = new SheetViewSelectionProvider(this, this.table1);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        if (this.dataProvider != null && this.currentCSVFile != null) {
            this.resourceListener = new PAResourceChangeListener(this, this.currentCSVFile.getRealPath());
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
        }
        PAContextTracker.getInstance().addPAContextListenerListener(this);
    }

    private Composite makeContextandLayoutDescriptionComposite(Composite parent) {
        Composite contextAndhyperlinkComposite = new Composite(parent, 0);
        GridLayout hyperlinkGridLayout = new GridLayout(3, false);
        hyperlinkGridLayout.marginHeight = 0;
        hyperlinkGridLayout.verticalSpacing = 0;
        contextAndhyperlinkComposite.setLayout((Layout)hyperlinkGridLayout);
        return contextAndhyperlinkComposite;
    }

    private FormText makeContextDescriptionFormText(Composite parent) {
        FormText contextFormText = new FormText(parent, 16384);
        contextFormText.setLayoutData((Object)new GridData(1, 4, false, false));
        return contextFormText;
    }

    private FormText makeLayoutDescriptionFormText(Composite parent) {
        FormText LayoutTitleFormText = new FormText(parent, 16384);
        LayoutTitleFormText.setLayoutData((Object)new GridData(1, 4, false, false));
        return LayoutTitleFormText;
    }

    private Hyperlink makeLayoutDescriptonHyperlink(Composite parent) {
        Hyperlink link = new Hyperlink(parent, 64);
        link.setLayoutData((Object)new GridData(1, 4, true, false));
        link.setToolTipText(Messages.getString("SelectTemplateDialog_description"));
        link.setForeground(link.getDisplay().getSystemColor(9));
        link.setUnderlined(true);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                SelectTemplateDialog dialog = new SelectTemplateDialog(SheetView.this, SheetView.this.reftable);
                if (dialog.open() == 0 && dialog.getTemplateName() != null) {
                    if (dialog.getTemplateName() instanceof PredefinedTemplate) {
                        SheetView.this.applyTemplate(SheetView.this.reftable, (PredefinedTemplate)((Object)dialog.getTemplateName()));
                    } else {
                        SheetView.this.applyTemplate(SheetView.this.reftable, (String)dialog.getTemplateName());
                    }
                }
            }
        });
        link.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getDescription(AccessibleEvent e) {
                e.result = Messages.getString("SelectTemplateDialog_description");
            }
        });
        return link;
    }

    protected void fillMenu(IActionBars actionBars) {
        IMenuManager menu = actionBars.getMenuManager();
        this.fillViewMenuDropdown(menu);
        menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SheetView.this.fillViewMenuDropdown(manager);
            }
        });
        MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)new GroupMarker("find.ext"));
        Menu popUpMenu = menuManager.createContextMenu(this.viewer.getControl());
        MenuItem copyItem = new MenuItem(popUpMenu, 8);
        copyItem.setText(Messages.getString("Copy"));
        copyItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SheetView.this.doCopy();
            }
        });
        this.table1.setMenu(popUpMenu);
        this.getViewSite().registerContextMenu(this.getViewSite().getSecondaryId() == null ? "com.ibm.cics.pa.ui.sheeteditor" : "com.ibm.cics.pa.ui.sheeteditor_multi", menuManager, (ISelectionProvider)this.viewer);
        this.populateToolbar(actionBars);
        actionBars.updateActionBars();
    }

    private void populateToolbar(IActionBars actionBars) {
        if (actionBars.getToolBarManager().getItems().length > 0) {
            actionBars.getToolBarManager().removeAll();
        }
        Separator layoutActionsGroup = new Separator("layoutContributions");
        actionBars.getToolBarManager().add((IContributionItem)layoutActionsGroup);
        Separator sortActionsGroup = new Separator("sortContributions");
        actionBars.getToolBarManager().add((IContributionItem)sortActionsGroup);
        if (this.linkToSelectionAction != null) {
            actionBars.getToolBarManager().appendToGroup("sortContributions", this.linkToSelectionAction);
        }
        actionBars.getToolBarManager().appendToGroup("sortContributions", this.customizeColumnsActions);
        actionBars.getToolBarManager().appendToGroup("sortContributions", this.clearSortAction);
        this.filterControl = new FilterContributionControl(this, actionBars.getToolBarManager());
    }

    void fillViewMenuDropdown(IMenuManager manager) {
        manager.removeAll();
        manager.add(this.clearSortAction);
        manager.add((IContributionItem)new Separator());
        String currentText = this.getInstanceLayoutLabel(this.reftable);
        if (currentText.indexOf(Messages.getString("Custom")) > -1) {
            manager.add(this.resetColumnsAction);
        }
        manager.add(this.resetWidthsAction);
        manager.add(this.customizeColumnsActions);
        manager.add((IContributionItem)new Separator());
        manager.add(this.saveAsTemplateAction);
        manager.add((IContributionItem)this.templateMenu);
        manager.add((IContributionItem)new Separator());
        manager.add(this.importLayoutAction);
        manager.add(this.exportLayoutAction);
        manager.update();
    }

    public void dispose() {
        IWorkbenchPart part;
        this.disposed = true;
        if (this.currentEngine != null) {
            this.currentEngine.cancel();
        }
        if (this.scrollLimitManager != null) {
            this.scrollLimitManager.dispose();
        }
        PAContextTracker.getInstance().removePAContextListenerListener(this);
        if (this.resourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        }
        if (this.getViewSite().getSecondaryId() == null) {
            this.getViewSite().getPage().removePostSelectionListener("com.ibm.cics.pa.ui.overview", (ISelectionListener)this.overviewListener);
            this.getViewSite().getPage().removePostSelectionListener("org.eclipse.ui.navigator.ProjectExplorer", (ISelectionListener)this.explorerListener);
            Activator.getDefault().getPluginInstancePreferences().removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.preferenceListener);
        }
        this.arrItems.clear();
        if (this.table1 != null) {
            this.table1.dispose();
        }
        if (this.getDataProvider() != null) {
            if (this.beenSorted && this.csvData()) {
                this.getDataProvider().resetOrdering();
            }
            this.getDataProvider().decrementUseCount();
        }
        this.dataProvider = null;
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null && (part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart()) != null && part != this) {
            this.getSite().getPage().activate(part);
        }
        super.dispose();
    }

    public void doCopy() {
        Clipboard clipboard = new Clipboard(this.viewer.getTable().getDisplay());
        StringBuffer buffer1 = new StringBuffer();
        StringBuffer buffer2 = new StringBuffer();
        TextTransfer textTransfer = TextTransfer.getInstance();
        FileTransfer fileTransfer = FileTransfer.getInstance();
        this.interpretHeadersForTransfer(',', buffer1, '\t', buffer2);
        Object[][] objectArray = this.getSelectedRows();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] row = objectArray[n2];
            buffer1.append('\n');
            buffer2.append('\n');
            this.interpretRowForTransfer(row, ',', buffer1, '\t', buffer2);
            ++n2;
        }
        try {
            String prefix = this.getManifestRecord() != null ? String.valueOf(this.getManifestRecord().getDescription().replace('/', '-')) + ' ' : Messages.getString("Temporary.name");
            File file = File.createTempFile(prefix, ".csv");
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(buffer1.toString().getBytes());
            fos.close();
            clipboard.setContents(new Object[]{buffer2.toString(), new String[]{file.getAbsolutePath()}}, new Transfer[]{textTransfer, fileTransfer});
            file.deleteOnExit();
            clipboard.dispose();
        }
        catch (IOException e) {
            debug.error("doCopy", (Throwable)e);
        }
    }

    public GenericDataProvider getDataProvider() {
        return this.dataProvider;
    }

    protected String getHelpContextId() {
        return "com.ibm.cics.pa.ui.sheeteditor";
    }

    public Object[][] getSelectedRows() {
        ArrayList<Object[]> aRows = new ArrayList<Object[]>();
        if (this.viewer != null && this.viewer.getTable() != null) {
            Iterator selection = ((StructuredSelection)this.viewer.getSelection()).iterator();
            while (selection.hasNext()) {
                aRows.add((Object[])selection.next());
            }
        }
        if (aRows.size() != this.viewer.getTable().getSelectionCount()) {
            debug.warning("getSelectedRows", (Object)"rows do not match item selection count");
        }
        return (Object[][])aRows.toArray((T[])new Object[aRows.size()][]);
    }

    protected void doTableSort(ColumnDefinition defn, int index, TableColumn currentColumn) {
        if (this.dataProvider != null && this.dataProvider.getData() != null && this.dataProvider.getData().length > 1) {
            Object[][] oldSelect = this.getSelectedRows();
            if (this.scrollLimitManager != null) {
                this.scrollLimitManager.dispose();
            }
            TableColumn sortColumn = this.table1.getSortColumn();
            this.dir = this.table1.getSortDirection();
            this.index = index;
            if (defn == null) {
                this.dir = 0;
            } else if (sortColumn == currentColumn) {
                this.dir = defn.getType().isNumeric() ? (this.dir == 1024 ? 128 : (this.dir == 128 ? 0 : 1024)) : (this.dir == 128 ? 1024 : (this.dir == 1024 ? 0 : 128));
            } else {
                this.table1.setSortColumn(currentColumn);
                this.sortColumnDefinition = defn;
                this.dir = defn.getType().isNumeric() ? 1024 : 128;
            }
            this.beenSorted = true;
            this.savedSelection = this.selectionProvider.getSelection();
            this.clearSortAction.setEnabled(this.dir != 0);
            this.table1.setSortDirection(this.dir);
            if (this.dir == 0) {
                this.table1.setSortColumn(null);
                this.sortColumnDefinition = null;
            }
            if (!this.dataProvider.isRemote()) {
                this.viewer.setInput((Object)this.dataProvider);
                this.table1.setSortDirection(this.dir);
                TableItem[] items = this.getViewer().getTable().getItems();
                int i = 0;
                while (i < items.length) {
                    this.arrItems.put(this.dataProvider.getData()[i], items[i]);
                    ++i;
                }
                TableItem[] originalItems = new TableItem[oldSelect.length];
                int i2 = 0;
                while (i2 < oldSelect.length) {
                    originalItems[i2] = this.arrItems.get(oldSelect[i2]);
                    ++i2;
                }
                this.viewer.getTable().setSelection(originalItems);
            } else {
                this.refresh((RemoteEditorInput)this.dataProvider.sort(this, defn, this.dir, index, this.filters), false);
            }
            this.sortDirection = this.dir;
            this.table1.setRedraw(true);
            this.viewer.refresh();
        }
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        if (this.dataProvider == null && site.getSecondaryId() != null) {
            if (site.getSecondaryId() == "QuickSheet999") {
                return;
            }
            try {
                this.dataProvider = ChartingFile.getReference(site.getSecondaryId());
                if (this.dataProvider == null || this.dataProvider instanceof RemoteEditorInput && ((RemoteEditorInput)this.dataProvider).getManifestRecord() == null) {
                    this.closeMeAgain(this);
                    return;
                }
            }
            catch (Exception exception) {
                debug.error("init", (Throwable)exception);
            }
        } else if (site.getSecondaryId() == null) {
            ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
            selectionService.addPostSelectionListener("com.ibm.cics.pa.ui.overview", (ISelectionListener)this.overviewListener);
            selectionService.addPostSelectionListener("org.eclipse.ui.navigator.ProjectExplorer", (ISelectionListener)this.explorerListener);
            Activator.getDefault().getPluginInstancePreferences().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.preferenceListener);
            this.getSite().getPage().addPartListener(new IPartListener(){

                public void partOpened(IWorkbenchPart part) {
                }

                public void partDeactivated(IWorkbenchPart part) {
                }

                public void partClosed(IWorkbenchPart part) {
                }

                public void partBroughtToTop(IWorkbenchPart part) {
                }

                public void partActivated(IWorkbenchPart part) {
                    ISelection selection;
                    if (part instanceof CommonNavigator) {
                        ISelection selection2 = ((CommonNavigator)part).getCommonViewer().getSelection();
                        if (selection2 != null) {
                            SheetView.this.explorerListener.selectionChanged(part, selection2);
                        }
                    } else if (part instanceof Overview && (selection = ((Overview)part).getSelection()) != null) {
                        SheetView.this.overviewListener.selectionChanged(part, selection);
                    }
                }
            });
        }
    }

    void adaptPresentation(GenericDataProvider dataProvider2) {
        debug.enter("adaptPresentation");
        this.setConstructionMode(true);
        int statementFetchSize = Platform.getPreferencesService().getInt(DBFuncPlugin.getDefault().getBundle().getSymbolicName(), "SIGNAL_THRESHOLD", 0, null);
        this.dataProvider = dataProvider2;
        String string = this.dataProvider.isRemote() ? (this.manifestRecord != null ? this.manifestRecord.getAlias() : ((RemoteEditorInput)this.dataProvider).getInitialTab()) : (this.reftable = this.dataProvider.getRootSource().getName());
        if (this.getViewer().getContentProvider() != null && !this.disposed && this.dataProvider != null) {
            HierarchicalRemoteElement root;
            this.table1.setRedraw(false);
            this.arrItems.clear();
            if (this.adaptationRequired()) {
                this.rebuildTable();
            } else if (this.filterControl != null) {
                this.filterControl.revalidate();
            }
            this.table1.setRedraw(true);
            this.table1.setSortDirection(this.sortDirection);
            if (this.dataProvider != null && this.dataProvider.getData() != null) {
                this.getViewer().setItemCount(this.dataProvider.isRemote() ? Math.min(statementFetchSize, this.dataProvider.getTotalRows()) : this.dataProvider.getData().length);
                this.setPartName(this.dataProvider.getTabName());
                this.setContentDescription(this.dataProvider.getAbridgedReference());
            }
            ColumnDefinition[] defns = this.dataProvider.getColumnDefinitions();
            if (this.sortColumnDefinition != null) {
                int i = 0;
                while (i < defns.length) {
                    if (defns[i] == this.sortColumnDefinition) {
                        this.table1.setSortColumn(this.table1.getColumn(i));
                        this.table1.setSortDirection(this.sortDirection);
                    }
                    ++i;
                }
            }
            if (!this.csvData() && this.savedSelection != null && !this.savedSelection.isEmpty() && (root = ((RemoteEditorInput)this.dataProvider).getRootElement()) != null) {
                Object[] selec = ((StructuredSelection)this.savedSelection).toArray();
                int i = 0;
                while (i < selec.length) {
                    DataKeyElement key = ((RemoteUniqueRecord)selec[i]).getDataKey();
                    selec[i] = root.getSpecificChild(key);
                    if (selec[i] != null) {
                        selec[i] = ((RemoteUniqueRecord)selec[i]).getRow();
                    }
                    ++i;
                }
                this.getViewer().setSelection((ISelection)new StructuredSelection(Arrays.asList(selec)), true);
            }
        }
        this.setConstructionMode(false);
        debug.exit("adaptPresentation");
    }

    void setConstructionMode(boolean underConstruction) {
        if (underConstruction) {
            this.inConstructionMode = true;
        } else {
            Job refreshJob = new Job(this.reftable == null ? Messages.getString("No.table") : this.reftable){

                protected IStatus run(IProgressMonitor monitor) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).SheetView.this.inConstructionMode = false;
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            refreshJob.setPriority(20);
            IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
            siteService.schedule(refreshJob, 250L, true);
        }
    }

    private void rebuildTable() {
        PredefinedTemplate pdt;
        debug.enter("rebuildTable");
        this.removeTableEntries();
        if (this.getManifestRecord() == null) {
            DataKeyElement dk = this.dataProvider.getRootTreeElement().getDataKey();
            this.setTitleImage(dk.isAppPerformanceSummary() ? Activator.getDefault().getImage("anal_history") : (dk.isPerformanceSummary() ? Activator.getDefault().getImage(Activator.IMGD_TRAN) : Activator.getDefault().getImage("table")));
        } else {
            this.setTitleImage(this.getManifestRecord().getImage());
            this.setPartName(this.getManifestRecord().getDescription());
        }
        TableColumn[] tableColumnArray = this.table1.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.dispose();
            ++n2;
        }
        final ColumnDefinition[] defns = this.dataProvider.getColumnDefinitions();
        int[] columnOrder = SheetViewPersistenceManager.getInstance(this.reftable).getColumnOrder(defns);
        PredefinedTemplate predefinedTemplate = pdt = this.viewDefinition != null ? this.viewDefinition.getLayout() : PredefinedTemplate.getByLabel(this.reftable, this.getInstanceLayoutLabel(this.reftable));
        if (pdt != null) {
            SheetViewPersistenceManager.getInstance(this.reftable).loadPredefinedTemplate(pdt, defns);
            columnOrder = SheetViewPersistenceManager.getInstance(this.reftable).getColumnOrder(defns);
        } else if (columnOrder.length != defns.length) {
            String lab = this.getInstanceLayoutLabel(this.reftable);
            if (StringUtil.hasContent((String)lab) && columnOrder.length > 0) {
                SheetViewPersistenceManager.getInstance(this.reftable).loadTemplate(lab, defns);
                columnOrder = SheetViewPersistenceManager.getInstance(this.reftable).getColumnOrder(defns);
            } else {
                columnOrder = this.clearOut(defns);
            }
        }
        this.viewer.setColumnProperties(this.dataProvider.getHeaders());
        int[] widths = SheetViewPersistenceManager.getInstance(this.reftable).getColumnWidths(defns);
        ArrayList<String> inTheFilter = new ArrayList<String>();
        this.numericInFilter = new ArrayList<String>();
        int i = 0;
        while (i < defns.length) {
            final int increment = i;
            final ColumnDefinition defn = defns[i];
            int width = widths.length > i ? widths[i] : -1;
            TableViewerColumn tableViewerColumn = new TableViewerColumn(this.viewer, defns[i].getType().isNumeric() ? 131072 : 16384);
            tableViewerColumn.getColumn().setText(this.dataProvider.getHeaders()[i]);
            tableViewerColumn.getColumn().setToolTipText(defn.getTooltip(this.reftable));
            if (width > -1) {
                inTheFilter.add(defn.getLabel(this.reftable));
                if (defns[i].getType().isNumeric()) {
                    this.numericInFilter.add(defn.getLabel(this.reftable));
                }
                tableViewerColumn.getColumn().setMoveable(true);
                tableViewerColumn.getColumn().setResizable(true);
                tableViewerColumn.getColumn().setWidth(width);
            } else {
                tableViewerColumn.getColumn().setWidth(0);
                tableViewerColumn.getColumn().setMoveable(false);
                tableViewerColumn.getColumn().setResizable(false);
            }
            tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element != null && ((Object[])element).length > increment) {
                        return DataTypeUtilities.getAsString(((Object[])element)[increment], defn);
                    }
                    return "";
                }
            });
            if (defns[i] != ColumnDefinition.UNKNOWN) {
                final int realIndex = i;
                tableViewerColumn.getColumn().addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        SheetView.this.doTableSort(defn, realIndex, (TableColumn)e.widget);
                    }
                });
            }
            tableViewerColumn.getColumn().addControlListener(new ControlListener(){

                public void controlResized(ControlEvent e) {
                    if (!SheetView.this.inConstructionMode && !SheetView.this.awaitingColumnUpdate) {
                        SheetView.this.orderUpdate(SheetView.this.reftable, defns);
                    }
                }

                public void controlMoved(ControlEvent e) {
                    if (!(SheetView.this.inConstructionMode || SheetView.this.awaitingColumnUpdate || Arrays.equals(SheetView.this.viewer.getTable().getColumnOrder(), SheetViewPersistenceManager.getInstance(SheetView.this.reftable).getColumnOrder(defns)))) {
                        SheetView.this.orderUpdate(SheetView.this.reftable, defns);
                    }
                }
            });
            ++i;
        }
        try {
            this.table1.setColumnOrder(columnOrder);
            SheetViewPersistenceManager.getInstance(this.reftable).setColumnOrder(this.viewer.getTable().getColumnOrder(), defns);
            ViewHelper.setStatusErrorMessage((IWorkbenchPart)this, null);
            ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)MessageFormat.format(Messages.getString("Layout.applied"), this.getInstanceLayoutLabel(this.reftable)));
        }
        catch (IllegalArgumentException iaex) {
            ViewHelper.setStatusErrorMessage((IWorkbenchPart)this, (String)Messages.getString("PAX0108E.ColumnSequence.Error"));
            debug.warning("rebuildTable", "name ordering has changed reset to default by doing nothing", (Throwable)iaex);
        }
        this.table1.setHeaderVisible(true);
        this.table1.setLinesVisible(true);
        this.customizeColumnsActions.setEnabled(true);
        this.resetWidthsAction.setEnabled(true);
        this.resetColumnsAction.setEnabled(true);
        this.saveAsTemplateAction.setEnabled(true);
        if (this.filterControl != null) {
            this.filterControl.initialiseColumns(this.reftable, inTheFilter, this.numericInFilter);
        }
        this.importLayoutAction.setEnabled(true);
        this.exportLayoutAction.setEnabled(true);
    }

    void orderUpdate(String table, final ColumnDefinition[] defns) {
        if (!this.awaitingColumnUpdate) {
            this.awaitingColumnUpdate = true;
            Job updateJob = new Job(Messages.getString("Background_job")){

                protected IStatus run(IProgressMonitor monitor) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SheetViewPersistenceManager.getInstance((this).SheetView.this.reftable).setCombinedColumnOrder(SheetView.this.getColumnOrder(), SheetView.this.getColumnWidths(), defns);
                            String currentText = SheetView.this.getInstanceLayoutLabel((this).SheetView.this.reftable);
                            (this).SheetView.this.awaitingColumnUpdate = false;
                            debug.event("orderUpdate", "column ordering updated");
                            if (currentText.indexOf(Messages.getString("Custom")) == -1) {
                                currentText = String.valueOf(Messages.getString("Custom")) + SheetView.this.getInstanceLayoutLabel((this).SheetView.this.reftable);
                                SheetView.this.setInstanceLayoutLabel((this).SheetView.this.reftable, String.valueOf(Messages.getString("Custom")) + SheetView.this.getInstanceLayoutLabel((this).SheetView.this.reftable));
                                ViewHelper.setStatusInformationMessage((IWorkbenchPart)SheetView.this, (String)MessageFormat.format(Messages.getString("Layout.applied"), currentText));
                                SheetView.this.manageTableContextText();
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            updateJob.setPriority(20);
            updateJob.schedule(3500L);
        }
    }

    private boolean adaptationRequired() {
        if (this.getViewSite().getSecondaryId() == null) {
            if (this.theLastSelection == null) {
                return true;
            }
            if (this.theLastSelection.possibleTableColumnChange() || this.theLastSelection.resynchTable) {
                this.theLastSelection.resynchTable = false;
                return true;
            }
        }
        return this.table1.getColumnCount() == 0;
    }

    private boolean csvData() {
        return !this.dataProvider.isRemote();
    }

    public void selectAll() {
        if (this.dataProvider != null && this.dataProvider.getData(null) != null && this.dataProvider.getData(null).length < 1001) {
            this.getViewer().getTable().setRedraw(false);
            this.getViewer().getTable().selectAll();
            this.getViewer().getTable().setRedraw(true);
            this.selectionProvider.setSelection(this.selectionProvider.getSelection());
        } else {
            ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)Messages.getString("TableDialog.unavailable"));
        }
    }

    public void setFocus() {
        if (this.viewer != null && this.viewer.getControl() != null) {
            this.viewer.getControl().setFocus();
        }
    }

    public String getPartProperty(String key) {
        if (IConnectionCategory.class.getName().equals(key)) {
            return "com.ibm.cics.pa.connection";
        }
        return super.getPartProperty(key);
    }

    protected void saveColumns() {
        debug.enter("saveColumns");
        String LAYOUT_DATA = "org.eclipse.jface.LAYOUT_DATA";
        TableColumn[] columns = this.viewer.getTable().getColumns();
        int[] columnOrder = this.viewer.getTable().getColumnOrder();
        StringBuffer namesPrefValue = new StringBuffer();
        StringBuilder widthsPrefValue = new StringBuilder();
        int i = 0;
        while (i < columns.length) {
            String name = (String)columns[columnOrder[i]].getData();
            namesPrefValue.append(name);
            ColumnLayoutData columnLayoutData = (ColumnLayoutData)columns[columnOrder[i]].getData(LAYOUT_DATA);
            if (columnLayoutData instanceof ColumnPixelData) {
                widthsPrefValue.append(columns[columnOrder[i]].getWidth());
            }
            if (i != columns.length - 1) {
                namesPrefValue.append(",");
                widthsPrefValue.append(",");
            }
            ++i;
        }
        debug.exit("saveColumns");
    }

    private void interpretRowForTransfer(Object[] row, char character1, StringBuffer buffer1, char character2, StringBuffer buffer2) {
        debug.enter("interpretRowForTransfer");
        TableColumn[] columns = this.viewer.getTable().getColumns();
        int[] columnOrder = this.viewer.getTable().getColumnOrder();
        boolean started = false;
        int i = 0;
        while (i < columns.length) {
            if (columns[columnOrder[i]].getResizable()) {
                if (started) {
                    buffer1.append(character1);
                    buffer2.append(character2);
                }
                started = true;
                String result = DataTypeUtilities.getAsCSVString(row[columnOrder[i]]);
                buffer1.append(result);
                buffer2.append(result);
            }
            ++i;
        }
        debug.exit("interpretRowForTransfer");
    }

    private void interpretHeadersForTransfer(char character1, StringBuffer buffer1, char character2, StringBuffer buffer2) {
        debug.enter("interpretHeadersForTransfer");
        TableColumn[] columns = this.viewer.getTable().getColumns();
        int[] columnOrder = this.viewer.getTable().getColumnOrder();
        boolean started = false;
        int i = 0;
        while (i < columns.length) {
            if (columns[columnOrder[i]].getResizable()) {
                if (started) {
                    buffer1.append(character1);
                    buffer2.append(character2);
                }
                started = true;
                ColumnDefinition defn = this.dataProvider.getColumnDefinitions()[columnOrder[i]];
                String name = defn.getColumnRef();
                buffer1.append(name);
                buffer2.append(name);
            }
            ++i;
        }
        debug.exit("interpretHeadersForTransfer");
    }

    public void removeAll() {
        if (this.getDataProvider() != null && this.getViewSite().getSecondaryId() != null) {
            this.getDataProvider().decrementUseCount();
        }
        this.dataProvider = null;
        this.getViewer().setInput((Object)this.dataProvider);
        this.theLastSelection = null;
        this.removeTableEntries();
        this.setPartName(Messages.getString("IntervalTracker.noContext"));
        this.setContentDescription(Messages.getString("IntervalTracker.noContext"));
        this.layoutNameHyperlink.setVisible(false);
        this.layoutTitleFormText.setVisible(false);
        this.setTitleImage(Activator.getDefault().getImage("table_d"));
    }

    void removeTableEntries() {
        if (this.viewer != null && !this.viewer.getTable().isDisposed()) {
            this.viewer.getTable().removeAll();
            this.viewer.refresh();
        }
    }

    public DateCaveat getDateRangeCovered() {
        TableItem start = this.table1.getSelection()[0];
        TableItem end = this.table1.getSelection()[this.table1.getSelection().length - 1];
        DataKeyElement element1 = DataKeyElement.createDataKey(this.getDataProvider(), this.allSelected() ? this.getDataProvider().getData()[0] : (Object[])start.getData());
        DataKeyElement element2 = DataKeyElement.createDataKey(this.getDataProvider(), this.allSelected() ? this.getDataProvider().getData()[this.getDataProvider().getData().length - 1] : (Object[])end.getData());
        Date before = element1.getACombinedDateReference();
        Date after = element2.getACombinedDateReference();
        if (after.compareTo(before) < 0) {
            Date temp = after;
            after = before;
            before = temp;
        }
        return DateCaveat.createRangeDateCaveat(before, after);
    }

    @Override
    public void refresh(final RemoteEditorInput newdataProvider, boolean isInterimRefresh) {
        if (this.getDataProvider() != null && this.getViewSite().getSecondaryId() != null && this.getDataProvider() != newdataProvider) {
            this.getDataProvider().decrementUseCount();
        }
        this.dataProvider = newdataProvider;
        if (this.dataProvider != null) {
            if (!isInterimRefresh && !this.alreadyRefreshing) {
                boolean isInitial;
                this.alreadyRefreshing = true;
                boolean bl = isInitial = this.dataProvider.getData(null) == null || this.dataProvider.getData(null).length == 0;
                if (!newdataProvider.isRunning() || newdataProvider.getData(null) != null && newdataProvider.getData(null).length < 1000) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (SheetView.this.getViewer().getContentProvider() != null) {
                                SheetView.this.getViewer().setInput((Object)newdataProvider);
                                if (isInitial) {
                                    SheetView.this.getSite().getPage().activate((IWorkbenchPart)SheetView.this);
                                }
                                SheetView.this.setContentDescription(newdataProvider.getAbridgedReference());
                            }
                        }
                    });
                }
                this.alreadyRefreshing = false;
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ViewHelper.setStatusInformationMessage((IWorkbenchPart)SheetView.this, (String)(String.valueOf(newdataProvider.getInitialTab()) + ' ' + MessageFormat.format(Messages.getString("Results.CollectedOf"), newdataProvider.getData(null) != null ? newdataProvider.getData(null).length : 0, newdataProvider.getTotalRows())));
                    SheetView.this.setPartName(newdataProvider.getTabName());
                }
            });
        }
    }

    @Override
    public void abort() {
        this.filterControl.revalidate();
    }

    @Override
    public void receiveNotification(final int currentTotal) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (SheetView.this.getViewer().getContentProvider() != null) {
                    ViewHelper.setStatusInformationMessage((IWorkbenchPart)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart(), (String)MessageFormat.format(Messages.getString("Results.CollectedOf"), 0, currentTotal));
                    ViewHelper.setStatusInformationMessage((IWorkbenchPart)SheetView.this, (String)MessageFormat.format(Messages.getString("Results.CollectedOf"), 0, currentTotal));
                }
            }
        });
    }

    @Override
    public void upDateCommand(Command engine) {
        this.currentEngine = engine;
    }

    @Override
    public Command getCurrentCommand() {
        return this.currentEngine;
    }

    public void setManifest(ManifestRecord rec) {
        this.manifestRecord = rec;
        if (this.manifestRecord != null) {
            this.reftable = this.manifestRecord.getAlias();
            this.setTitleImage(rec.getImage());
            this.setPartName(this.manifestRecord.getDescription());
        }
    }

    public ManifestRecord getManifestRecord() {
        if (this.manifestRecord == null) {
            this.manifestRecord = PAContextTracker.getInstance().getCurrentManifest();
        }
        return this.manifestRecord;
    }

    @Override
    public void disconnected() {
        if (this.currentEngine != null) {
            this.currentEngine.cancel();
        }
        if (this.getViewSite().getSecondaryId() == null) {
            if (this.getDataProvider() != null && this.getDataProvider().isRemote()) {
                this.removeAll();
                this.setPartName(Messages.getString("Resource.status.disconnected"));
            }
        } else {
            this.closeMeAgain(this);
        }
    }

    @Override
    public void tableSelected(ManifestRecord manifest) {
        if (this.getViewSite().getSecondaryId() == null) {
            if (Messages.getString("Resource.status.disconnected").equals(this.contextDescriptionText)) {
                this.setPartName(Messages.getString("IntervalTracker.noContext"));
            }
            this.setContentDescription("");
        }
    }

    @Override
    public ScrollLimitManager getScrollLimitManager() {
        return this.scrollLimitManager;
    }

    public StructuredSelection getSelection() {
        return (StructuredSelection)this.selectionProvider.getSelection();
    }

    @Override
    public boolean validate(FilterElement element) {
        if (this.dataProvider == null || this.dataProvider.getHeaders() == null) {
            return false;
        }
        if (element.isComplete()) {
            ColumnDefinition defn = null;
            String[] headers = this.dataProvider.getHeaders();
            int i = 0;
            while (i < headers.length) {
                if (((String)element.getColumn()).toUpperCase().startsWith(headers[i].toUpperCase()) && (defn == null || headers[i].length() > defn.getLabel(null).length())) {
                    defn = this.dataProvider.getColumnDefinitions()[i];
                }
                ++i;
            }
            if (defn == null) {
                element.setValid(false);
            } else {
                element.setColumn(defn);
                ColumnReference.DataType type = defn.getType();
                if (type == ColumnReference.DataType.Date) {
                    if (element.getValue().length() == 10 && element.getValue().charAt(4) == '-' && element.getValue().charAt(7) == '-') {
                        Object result = DataTypeUtilities.ensureAppropriateType(type, element.getValue());
                        element.setValueComplete(true);
                        element.setValid(!(result instanceof String));
                    } else {
                        element.setValueComplete(false);
                    }
                } else if (type == ColumnReference.DataType.Time) {
                    if (element.getValue().length() > 7 && (element.getValue().charAt(2) == ':' && element.getValue().charAt(5) == ':' || element.getValue().charAt(2) == '.' && element.getValue().charAt(5) == '.')) {
                        Object result = DataTypeUtilities.ensureAppropriateType(type, element.getValue());
                        element.setValueComplete(true);
                        element.setValid(!(result instanceof String));
                    } else {
                        element.setValueComplete(false);
                    }
                } else {
                    block0 : switch (type) {
                        case Double: 
                        case Integer: 
                        case Float: 
                        case BigDecimal: {
                            if (element.getValue().matches("[-+]?\\d*\\.?\\d+")) {
                                element.setValid(true);
                                element.setValueComplete(true);
                                break;
                            }
                            element.setValid(false);
                            element.setValueComplete(false);
                            for (String filter : this.numericInFilter) {
                                if (filter.equals(element.getValue())) {
                                    defn = null;
                                    int i2 = 0;
                                    while (i2 < headers.length) {
                                        if (element.getValue().toUpperCase().startsWith(headers[i2].toUpperCase()) && (defn == null || headers[i2].length() > defn.getLabel(null).length())) {
                                            defn = this.dataProvider.getColumnDefinitions()[i2];
                                        }
                                        ++i2;
                                    }
                                    if (defn == null) {
                                        element.setValid(false);
                                        element.setValueComplete(false);
                                        continue;
                                    }
                                    element.setValue(defn);
                                    element.setValid(true);
                                    element.setValueComplete(true);
                                    break block0;
                                }
                                if (!filter.startsWith(element.getValue())) continue;
                                element.setValid(true);
                            }
                            break;
                        }
                        case Boolean: {
                            element.setValid(element.getValue().toUpperCase().equals("TRUE") || element.getValue().toUpperCase().equals("FALSE"));
                            break;
                        }
                        default: {
                            element.setValid(UIHelper.hasContent((String)element.getValue()));
                        }
                    }
                }
            }
        }
        return element.isValid();
    }

    @Override
    public void applyFilter(List<FilterElement> elements) {
        ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)Messages.getString("Locating.records"));
        this.filters = elements;
        if (!this.dataProvider.isRemote()) {
            this.dataProvider = this.dataProvider.sort(this, this.sortColumnDefinition, this.dir, this.index, elements);
            this.removeTableEntries();
            if (this.dataProvider.getRootSource() != this.currentCSVFile) {
                if (this.theLastSelection != null) {
                    this.theLastSelection.force();
                }
                this.currentCSVFile = (CSVFile)this.dataProvider.getRootSource();
                this.resourceListener = new PAResourceChangeListener(this, this.currentCSVFile.getRealPath());
                ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
            }
            this.viewer.setInput((Object)this.dataProvider);
        } else {
            this.refresh((RemoteEditorInput)this.dataProvider.sort(this, this.sortColumnDefinition, this.dir, this.index, elements), false);
        }
        this.setPartName(this.dataProvider.getTabName());
        this.setContentDescription(this.dataProvider.getAbridgedReference());
    }

    protected void makeActions(IWorkbenchWindow window) {
        Action action = new Action(){

            public String getActionDefinitionId() {
                return ActionFactory.SELECT_ALL.getId();
            }

            public String getId() {
                return ActionFactory.SELECT_ALL.getId();
            }

            public void run() {
                SheetView.this.selectAll();
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)action);
        action = new Action(){

            public String getActionDefinitionId() {
                return ActionFactory.COPY.getId();
            }

            public void runWithEvent(Event event) {
                if (event.widget instanceof StyledText) {
                    ((StyledText)event.widget).copy();
                } else if (event.widget instanceof Text) {
                    ((Text)event.widget).copy();
                } else {
                    super.runWithEvent(event);
                }
            }

            public String getId() {
                return ActionFactory.COPY.getId();
            }

            public void run() {
                SheetView.this.doCopy();
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)action);
        this.clearSortAction = new Action(Messages.getString("ResourcesView.clearSortAction.text")){

            public void run() {
                SheetView.this.viewer.getTable().setSortDirection(0);
                SheetView.this.viewer.getTable().setSortColumn(null);
                SheetView.this.clearSortAction.setEnabled(false);
                SheetView.this.sortColumnDefinition = null;
                SheetView.this.doTableSort(SheetView.this.sortColumnDefinition, 0, null);
            }
        };
        this.clearSortAction.setToolTipText(Messages.getString("ResourcesView.clearSortAction.tooltip"));
        this.clearSortAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("deletesort"));
        this.clearSortAction.setEnabled(false);
        this.resetColumnsAction = new Action(Messages.getString("ResourcesView.resetColumnsAction.text")){

            public void run() {
                SheetView.this.resetColumns();
            }
        };
        this.resetColumnsAction.setEnabled(this.dataProvider != null);
        this.resetWidthsAction = new Action(Messages.getString("ResourcesView.equalizeColumnWidthsAction.text")){

            public void run() {
                int[] widths = SheetViewPersistenceManager.getInstance(SheetView.this.reftable).resetDisplayedColumnsWidth(SheetView.this.dataProvider.getColumnDefinitions());
                int i = 0;
                while (i < SheetView.this.viewer.getTable().getColumns().length) {
                    if (widths[i] > -1) {
                        SheetView.this.viewer.getTable().getColumns()[i].setWidth(70);
                    }
                    ++i;
                }
            }
        };
        this.resetWidthsAction.setEnabled(this.dataProvider != null);
        this.customizeColumnsActions = new Action(Messages.getString("ResourcesView.customizeColumnsAction.text"), Activator.getDefault().getImageDescriptor("custcols")){

            public void run() {
                if (SheetView.this.dataProvider != null) {
                    SheetViewColumnDialog dialog = new SheetViewColumnDialog(SheetView.this.getSite().getShell(), SheetView.this, SheetView.this.dataProvider.getColumnDefinitions(), SheetView.this.reftable, SheetView.this.manifestRecord, SheetView.this.getInstanceLayoutLabel(SheetView.this.reftable));
                    dialog.open();
                }
            }
        };
        this.customizeColumnsActions.setEnabled(this.dataProvider != null);
        this.saveAsTemplateAction = new Action(Messages.getString("SaveTemplate_text")){

            public void run() {
                SheetView.this.doSaveAsTemplateAction();
            }
        };
        this.saveAsTemplateAction.setEnabled(this.dataProvider != null);
        this.templateMenu = new MenuManager(Messages.getString("Apply_template.text"));
        this.templateMenu.add((IAction)new Action(){});
        this.templateMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.removeAll();
                if (SheetView.this.dataProvider != null) {
                    SheetView.this.fillCategorizedMenu(manager);
                }
                manager.update();
            }
        });
        this.importLayoutAction = new Action(Messages.getString("import.label")){

            public void run() {
                ImportLayoutsDialog dialog = new ImportLayoutsDialog(SheetView.this.getSite().getShell());
                dialog.open();
            }
        };
        this.importLayoutAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("import_layout"));
        this.importLayoutAction.setToolTipText(Messages.getString("import.tooltip"));
        this.importLayoutAction.setEnabled(this.dataProvider != null);
        this.exportLayoutAction = new Action(Messages.getString("export.label")){

            public void run() {
                ExportLayoutsDialog dialog = new ExportLayoutsDialog(SheetView.this.getSite().getShell());
                dialog.open();
            }
        };
        this.exportLayoutAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("export_layout"));
        this.exportLayoutAction.setToolTipText(Messages.getString("export.tooltip"));
        this.exportLayoutAction.setEnabled(this.dataProvider != null && !SheetViewPersistenceManager.getInstance(this.reftable).hasTemplatesForExport());
        if (this.getViewSite().getSecondaryId() == null) {
            this.linkToSelectionAction = new Action(Messages.getString("Button.linkto"), 2){

                public void run() {
                    SheetView.this.isLinkedToSelection = SheetView.this.linkToSelectionAction.isChecked();
                    Activator.getDefault().getPluginInstancePreferences().putBoolean("com.ibm.cics.pa.ui.overviewlinkto.selection", SheetView.this.isLinkedToSelection);
                }

                public ImageDescriptor getImageDescriptor() {
                    return com.ibm.cics.eclipse.common.Activator.IMGD_LINK_TO_SELECTION;
                }
            };
            this.isLinkedToSelection = Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.pa.ui.overviewlinkto.selection", true, null);
            this.linkToSelectionAction.setChecked(this.isLinkedToSelection);
        }
    }

    protected void fillCategorizedMenu(IMenuManager manager) {
        manager.add(this.createTemplateAction(this.reftable, Messages.getString("current.label")));
        manager.add((IContributionItem)new Separator());
        List<PredefinedTemplate> results = PredefinedTemplate.getCollectionFor(this.reftable);
        Collections.sort(results, new Comparator<PredefinedTemplate>(){

            @Override
            public int compare(PredefinedTemplate o1, PredefinedTemplate o2) {
                return o1.getLabel().compareTo(o2.getLabel());
            }
        });
        if (results.size() > 0) {
            for (PredefinedTemplate template : results) {
                manager.add(this.createTemplateAction(this.reftable, template));
            }
            manager.add((IContributionItem)new Separator());
        }
        ArrayList<String> templates = new ArrayList<String>();
        templates.addAll(SheetViewPersistenceManager.getInstance(this.reftable).getTemplates());
        Collections.sort(templates, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        for (String template : templates) {
            manager.add(this.createTemplateAction(this.reftable, template));
        }
        manager.update();
    }

    private IAction createTemplateAction(final String table_reference, final String templateName) {
        Action templateAction = new Action(templateName){

            public void run() {
                SheetView.this.applyTemplate(table_reference, templateName);
            }
        };
        return templateAction;
    }

    protected void applyTemplate(String table_reference, PredefinedTemplate template) {
        debug.enter("applyTemplate", (Object)table_reference, (Object)template);
        if (this.dataProvider != null) {
            SheetViewPersistenceManager.getInstance(this.reftable).loadPredefinedTemplate(template, this.dataProvider.getColumnDefinitions());
            this.applyTemplate(template.getLabel());
        }
        debug.exit("applyTemplate");
    }

    protected void applyTemplate(String table_reference, String templateName) {
        debug.enter("applyTemplate", (Object)table_reference, (Object)templateName);
        if (this.dataProvider != null) {
            this.checkOverwrite();
            if (templateName.equals(Messages.getString("current.label"))) {
                PredefinedTemplate pdt = PredefinedTemplate.findDefaultTemplate(table_reference);
                if (pdt != null) {
                    this.applyTemplate(table_reference, pdt);
                } else {
                    this.defaultLayout(this.dataProvider.getColumnDefinitions());
                }
            } else {
                SheetViewPersistenceManager.getInstance(this.reftable).loadTemplate(templateName, this.dataProvider.getColumnDefinitions());
                String filter = SheetViewPersistenceManager.getInstance(this.reftable).getTemplateFilter(templateName);
                if (StringUtil.hasContent((String)filter)) {
                    this.filterControl.forceText(filter);
                }
                this.applyTemplate(templateName);
            }
        }
        debug.exit("applyTemplate");
    }

    @Override
    public void applyTemplate(String templateName) {
        this.busyApplyTemplate(templateName, SheetViewPersistenceManager.getInstance(this.reftable).getColumnOrder(this.dataProvider.getColumnDefinitions()), SheetViewPersistenceManager.getInstance(this.reftable).getColumnWidths(this.dataProvider.getColumnDefinitions()));
    }

    @Override
    public void applyOrdering(int[] columnOrdering, int[] widths) {
        this.busyApplyTemplate(null, columnOrdering, widths);
        String currentText = this.getInstanceLayoutLabel(this.reftable);
        if (currentText.indexOf(Messages.getString("Custom")) == -1) {
            currentText = String.valueOf(Messages.getString("Custom")) + this.getInstanceLayoutLabel(this.reftable);
            this.setInstanceLayoutLabel(this.reftable, String.valueOf(Messages.getString("Custom")) + this.getInstanceLayoutLabel(this.reftable));
            ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)MessageFormat.format(Messages.getString("Layout.applied"), currentText));
            this.manageTableContextText();
        }
    }

    private void busyApplyTemplate(final String templateName, final int[] columnOrdering, final int[] widths) {
        debug.enter("busyApplyTemplate");
        BusyIndicator.showWhile((Display)this.viewer.getTable().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                SheetView.this.setConstructionMode(true);
                SheetView.this.viewer.getTable().setRedraw(false);
                try {
                    try {
                        SheetView.this.table1.setColumnOrder(columnOrdering);
                        ArrayList<String> inTheFilter = new ArrayList<String>();
                        int i = 0;
                        while (i < columnOrdering.length) {
                            ColumnDefinition defn = SheetView.this.dataProvider.getColumnDefinitions()[i];
                            if (widths[i] > -1) {
                                inTheFilter.add(defn.getLabel(null));
                                if (defn.getType().isNumeric()) {
                                    SheetView.this.numericInFilter.add(defn.getLabel(null));
                                }
                                SheetView.this.viewer.getTable().getColumns()[i].setMoveable(true);
                                SheetView.this.viewer.getTable().getColumns()[i].setResizable(true);
                                SheetView.this.viewer.getTable().getColumns()[i].setWidth(widths[i]);
                            } else {
                                SheetView.this.viewer.getTable().getColumns()[i].setWidth(0);
                                SheetView.this.viewer.getTable().getColumns()[i].setMoveable(false);
                                SheetView.this.viewer.getTable().getColumns()[i].setResizable(false);
                            }
                            ++i;
                        }
                        if (SheetView.this.filterControl != null) {
                            SheetView.this.filterControl.initialiseColumns(SheetView.this.reftable, inTheFilter, SheetView.this.numericInFilter);
                        }
                        if (StringUtil.hasContent((String)templateName)) {
                            SheetView.this.setInstanceLayoutLabel(SheetView.this.reftable, templateName);
                            ViewHelper.setStatusErrorMessage((IWorkbenchPart)SheetView.this, null);
                            ViewHelper.setStatusInformationMessage((IWorkbenchPart)SheetView.this, (String)MessageFormat.format(Messages.getString("Layout.applied"), templateName));
                            SheetView.this.manageTableContextText();
                        }
                    }
                    catch (IllegalArgumentException iaex) {
                        ViewHelper.setStatusErrorMessage((IWorkbenchPart)SheetView.this, (String)Messages.getString("PAX0108E.ColumnSequence.Error"));
                        debug.warning("rebuildTable", "name ordering has changed reset to default by doing nothing", (Throwable)iaex);
                        SheetView.this.viewer.getTable().setRedraw(true);
                        SheetView.this.setConstructionMode(false);
                    }
                }
                finally {
                    SheetView.this.viewer.getTable().setRedraw(true);
                    SheetView.this.setConstructionMode(false);
                }
            }
        });
        debug.exit("busyApplyTemplate");
    }

    private IAction createTemplateAction(String table_reference, final PredefinedTemplate template) {
        Action templateAction = new Action(template.getLabel()){

            public void run() {
                SheetView.this.applyTemplate(SheetView.this.reftable, template);
            }
        };
        return templateAction;
    }

    @Override
    public int[] getColumnOrder() {
        return this.table1.getColumnOrder();
    }

    public void setColumnOrder(int[] order) {
        this.table1.setColumnOrder(order);
    }

    @Override
    public int[] getColumnWidths() {
        if (this.table1 != null) {
            int[] widths = new int[this.table1.getColumnCount()];
            int i = 0;
            while (i < widths.length) {
                widths[i] = this.table1.getColumn(i).getWidth();
                if (widths[i] == 0) {
                    widths[i] = -1;
                }
                ++i;
            }
            return widths;
        }
        return SheetViewPersistenceManager.getInstance(this.reftable).getColumnWidths(this.dataProvider.getColumnDefinitions());
    }

    public void setColumnWidths(int[] widths) {
        this.setConstructionMode(true);
        if (this.table1 != null) {
            int i = 0;
            while (i < widths.length) {
                this.table1.getColumn(i).setWidth(widths[i]);
                ++i;
            }
        }
        this.setConstructionMode(false);
    }

    public PASelectionContext getContext() {
        return this.context;
    }

    void manageTableContextText() {
        debug.enter("manageTableContextText");
        if (StringUtil.hasContent((String)this.contextDescriptionText)) {
            String text = this.getInstanceLayoutLabel(this.reftable);
            this.layoutTitleText = Messages.getString("SheetView.applied.layout3");
            String string = this.layoutNameText = text == null || text.equals(this.reftable) ? Messages.getString("current.label") : text;
            if (this.getDataProvider() != null) {
                this.contextDescriptionFormText.setText(this.contextDescriptionText, false, false);
                this.layoutTitleFormText.setText(this.layoutTitleText, false, false);
                this.layoutNameHyperlink.setText(this.layoutNameText);
                this.layoutTitleFormText.setVisible(true);
                this.layoutNameHyperlink.setVisible(true);
            } else {
                this.contextDescriptionFormText.setText(this.contextDescriptionText, false, false);
                this.layoutTitleFormText.setVisible(false);
                this.layoutNameHyperlink.setVisible(false);
            }
        } else {
            this.contextDescriptionFormText.setText("", false, false);
            this.layoutTitleFormText.setVisible(false);
            this.layoutNameHyperlink.setVisible(false);
        }
        Control[] changed = new Control[]{this.contextDescriptionFormText, this.layoutTitleFormText, this.layoutNameHyperlink};
        this.c.changed(changed);
        this.c.layout();
        debug.exit("manageTableContextText");
    }

    public void setContentDescription(String desc) {
        debug.enter("setContentDescription", (Object)desc);
        this.contextDescriptionText = desc;
        this.manageTableContextText();
        debug.exit("setContentDescription");
    }

    private int[] defaultLayout(ColumnDefinition[] defns) {
        debug.enter("defaultLayout");
        int[] defArray = this.clearOut(defns);
        this.resetColumns();
        debug.exit("defaultLayout", (Object)defArray);
        return defArray;
    }

    private int[] clearOut(ColumnDefinition[] defns) {
        debug.enter("clearOut");
        int[] defArray = new int[defns.length];
        int[] widthsArray = new int[defns.length];
        int i = 0;
        while (i < defns.length) {
            defArray[i] = i;
            widthsArray[i] = 70;
            ++i;
        }
        this.setInstanceLayoutLabel(this.reftable, null);
        SheetViewPersistenceManager.getInstance(this.reftable).setColumnOrder(defArray, this.dataProvider.getColumnDefinitions());
        SheetViewPersistenceManager.getInstance(this.reftable).setColumnWidths(widthsArray, this.dataProvider.getColumnDefinitions());
        debug.exit("clearOut", (Object)defArray);
        return defArray;
    }

    @Override
    public void resetColumns() {
        debug.enter("resetColumns");
        String label = this.getInstanceLayoutLabel(this.reftable).replace(Messages.getString("Custom"), "");
        this.setInstanceLayoutLabel(this.reftable, null);
        PredefinedTemplate pdt = PredefinedTemplate.getByLabel(this.reftable, label);
        if (label.equals(Messages.getString("current.label"))) {
            pdt = PredefinedTemplate.findDefaultTemplate(this.reftable);
        }
        if (pdt != null) {
            SheetViewPersistenceManager.getInstance(this.reftable).loadPredefinedTemplate(pdt, this.dataProvider.getColumnDefinitions());
        } else if (label.equals(Messages.getString("current.label"))) {
            this.clearOut(this.dataProvider.getColumnDefinitions());
        } else {
            SheetViewPersistenceManager.getInstance(this.reftable).loadTemplate(label, this.dataProvider.getColumnDefinitions());
        }
        this.applyTemplate(label);
        debug.exit("resetColumns");
    }

    String getInstanceLayoutLabel(String reftable) {
        return SheetViewPersistenceManager.getInstance(reftable).getLayoutLabel();
    }

    void setInstanceLayoutLabel(String reftable, String layoutName) {
        SheetViewPersistenceManager.getInstance(reftable).setLayoutLabel(layoutName);
    }

    @Override
    public boolean swapColumns(ColumnDefinition sourceItemDefinition, ColumnDefinition targetItemDefinition) {
        boolean beenSorted = false;
        int sourcePointer = this.getDataProvider().getColumnPosition(sourceItemDefinition);
        int targetPointer = this.getDataProvider().getColumnPosition(targetItemDefinition);
        int sourcePosition = -1;
        int targetPosition = -1;
        int[] ordering = this.table1.getColumnOrder();
        int i = 0;
        while (i < ordering.length) {
            if (sourcePointer == ordering[i]) {
                sourcePosition = i;
            }
            if (targetPointer == ordering[i]) {
                targetPosition = i;
            }
            ++i;
        }
        if (sourcePosition > -1 && targetPosition > -1 && sourcePosition < ordering.length && targetPosition < ordering.length) {
            int tempPos = ordering[sourcePosition];
            ordering[sourcePosition] = ordering[targetPosition];
            ordering[targetPosition] = tempPos;
            this.table1.setRedraw(false);
            this.table1.setColumnOrder(ordering);
            this.table1.setRedraw(true);
            beenSorted = true;
        }
        return beenSorted;
    }

    protected void checkOverwrite() {
        debug.enter("checkOverwrite");
        if (this.getInstanceLayoutLabel(this.reftable).indexOf(Messages.getString("Custom")) > -1) {
            MessageBox dialog1 = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 200);
            dialog1.setText(Messages.getString("Overwrite_layout_title"));
            dialog1.setMessage(Messages.getString("Overwrite_layout_message"));
            if (dialog1.open() == 64) {
                this.doSaveAsTemplateAction();
            }
        }
        debug.exit("checkOverwrite");
    }

    void doSaveAsTemplateAction() {
        SheetViewPersistenceManager.getInstance(this.reftable).setCombinedColumnOrder(this.getColumnOrder(), this.getColumnWidths(), this.dataProvider.getColumnDefinitions());
        SaveTemplateDialog dialog = new SaveTemplateDialog(this, this.reftable, this.filterControl.getContent(), this.getManifestRecord() == null ? this.reftable : this.getManifestRecord().getDescription());
        if (dialog.open() == 0) {
            this.setInstanceLayoutLabel(this.reftable, dialog.getTemplateName());
            ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)MessageFormat.format(Messages.getString("Layout.applied"), dialog.getTemplateName()));
            this.manageTableContextText();
        }
    }

    class ExplorerListener
    implements ISelectionListener {
        ExplorerListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection.isEmpty() || SheetView.this.table1.isDisposed() || part instanceof ProjectExplorer && !SheetView.this.isLinkedToSelection) {
                return;
            }
            if (SheetView.this.getScrollLimitManager() != null) {
                SheetView.this.getScrollLimitManager().dispose();
            }
            SheetView.this.filters = null;
            if (SheetView.this.filterControl != null) {
                SheetView.this.filterControl.resetFilter();
            }
            SheetView.this.sortColumnDefinition = null;
            SheetView.this.dir = 0;
            SheetView.this.table1.setSortColumn(null);
            final Object first = ((StructuredSelection)selection).getFirstElement();
            if (first instanceof ExplorerViewModel) {
                if (!new LastSelection(part, selection).aNewSelection()) {
                    return;
                }
                SheetView.this.removeTableEntries();
                SheetView.this.dataProvider = ChartingFile.adaptFor(((ExplorerViewModel)first).getSourceProvider(), (StructuredSelection)selection, null);
                if (SheetView.this.dataProvider.getRootSource() != SheetView.this.currentCSVFile) {
                    SheetView.this.reftable = SheetView.this.dataProvider.getRootSource().getName();
                    SheetView.this.theLastSelection.force();
                    SheetView.this.currentCSVFile = (CSVFile)SheetView.this.dataProvider.getRootSource();
                    SheetView.this.resourceListener = new PAResourceChangeListener(SheetView.this, SheetView.this.currentCSVFile.getRealPath());
                    ResourcesPlugin.getWorkspace().addResourceChangeListener(SheetView.this.resourceListener);
                }
                SheetView.this.viewer.setInput((Object)SheetView.this.dataProvider);
            } else if (first instanceof IFile && "csv".equalsIgnoreCase(((IFile)first).getFileExtension()) && new LastSelection(part, selection).aNewSelection()) {
                Job job = new Job(Messages.getString("Locating.records")){

                    protected IStatus run(IProgressMonitor monitor) {
                        ((ExplorerListener)ExplorerListener.this).SheetView.this.dataProvider = ChartingFile.getReference((IFile)first);
                        if (((ExplorerListener)ExplorerListener.this).SheetView.this.dataProvider.getRootSource() != ((ExplorerListener)ExplorerListener.this).SheetView.this.currentCSVFile) {
                            ((ExplorerListener)ExplorerListener.this).SheetView.this.reftable = ((ExplorerListener)ExplorerListener.this).SheetView.this.dataProvider.getRootSource().getName();
                            ((ExplorerListener)ExplorerListener.this).SheetView.this.theLastSelection.force();
                            ((ExplorerListener)ExplorerListener.this).SheetView.this.currentCSVFile = (CSVFile)((ExplorerListener)ExplorerListener.this).SheetView.this.dataProvider.getRootSource();
                            ((ExplorerListener)ExplorerListener.this).SheetView.this.resourceListener = new PAResourceChangeListener(SheetView.this, ((ExplorerListener)ExplorerListener.this).SheetView.this.currentCSVFile.getRealPath());
                            ResourcesPlugin.getWorkspace().addResourceChangeListener(((ExplorerListener)ExplorerListener.this).SheetView.this.resourceListener);
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ((ExplorerListener)(this).ExplorerListener.this).SheetView.this.viewer.setInput((Object)((ExplorerListener)(this).ExplorerListener.this).SheetView.this.dataProvider);
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(20);
                job.schedule();
            }
        }
    }

    private class LastSelection {
        private IWorkbenchPart part;
        private int reference;
        boolean resynchTable = true;
        private ManifestRecord lastRecord = null;

        public LastSelection(IWorkbenchPart part, Object reference) {
            this.part = part;
            this.reference = reference.hashCode();
            this.lastRecord = PAContextTracker.getInstance().getCurrentManifest();
        }

        public boolean aNewSelection() {
            if (this.isSame()) {
                return false;
            }
            this.resynchTable = SheetView.this.theLastSelection == null || this.part != SheetView.this.theLastSelection.part || this.lastRecord != SheetView.this.theLastSelection.lastRecord;
            SheetView.this.theLastSelection = this;
            return true;
        }

        public boolean possibleTableColumnChange() {
            return this.resynchTable;
        }

        public void force() {
            this.resynchTable = true;
        }

        private boolean isSame() {
            return SheetView.this.theLastSelection != null && SheetView.this.theLastSelection.part == this.part && SheetView.this.theLastSelection.reference == this.reference;
        }
    }

    class ModeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        ModeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().equals("MODE_OVERVIEW") && PAContextTracker.inOverviewMode()) {
                SheetView.this.getViewSite().getPage().hideView((IViewPart)SheetView.this);
            }
        }
    }

    class OverviewListener
    implements ISelectionListener {
        OverviewListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (SheetView.this.resourceListener != null) {
                SheetView.this.currentCSVFile = null;
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(SheetView.this.resourceListener);
            }
            if (!SheetView.this.isLinkedToSelection || SheetView.this.table1.isDisposed()) {
                return;
            }
            if (selection.isEmpty()) {
                SheetView.this.removeAll();
                return;
            }
            if (SheetView.this.getCurrentCommand() != null && SheetView.this.getCurrentCommand().status() == -1) {
                SheetView.this.getCurrentCommand().cancel();
                ViewHelper.setStatusInformationMessage((IWorkbenchPart)SheetView.this, (String)Messages.getString("RemoteEditorInput.SearchHalted1"));
                debug.event("Overview Listener selectionChanged", "Cancelled already waiting command");
            } else if (SheetView.this.getCurrentCommand() != null && SheetView.this.getCurrentCommand().status() == 0) {
                ViewHelper.setStatusInformationMessage((IWorkbenchPart)SheetView.this, (String)Messages.getString("RemoteEditorInput.SearchHalted2"));
                debug.event("Overview Listener selectionChanged", "Ignored, command already in progress");
            }
            SheetView.this.context = (PASelectionContext)((Overview)part).getCurrentContext();
            if (!SheetView.this.context.isPopulated() || !new LastSelection(part, SheetView.this.context).aNewSelection()) {
                return;
            }
            if (SheetView.this.getScrollLimitManager() != null) {
                SheetView.this.getScrollLimitManager().dispose();
            }
            SheetView.this.setManifest(PAContextTracker.getInstance().getCurrentManifest());
            SheetView.this.setContentDescription(Messages.getString("SheetProxy.Initializing"));
            SheetView.this.removeTableEntries();
            String tableau = PAContextTracker.getInstance().getShortTableReference();
            Selection baseQuery = SheetView.this.context.getSummarySelection(PAContextTracker.getInstance().getShortTableReference());
            SheetView.this.sortColumnDefinition = PAPreferenceHelper.getSortColumn(tableau);
            SheetView.this.dir = 0;
            SheetView.this.table1.setSortColumn(null);
            SheetView.this.refresh(RemoteEditorInput.runQuery(SheetView.this, baseQuery, new HashMap<String, Object>(), null, SheetView.this.context.toString(), PAContextTracker.getInstance().getCurrentManifest(), 0), false);
            SheetView.this.filters = null;
            if (SheetView.this.filterControl != null) {
                SheetView.this.filterControl.resetFilter();
            }
            SheetView.this.getViewSite().getPage().bringToTop((IWorkbenchPart)SheetView.this);
            ViewHelper.setStatusInformationMessage((IWorkbenchPart)part, (String)Messages.getString("SheetProxy.Initializing"));
        }
    }
}

