/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ModelUtilities;
import com.ibm.cics.core.model.RegionsModel;
import com.ibm.cics.core.ui.editors.actions.EditCICSObjectHelper;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.eclipse.common.jobs.CancellableRunnable;
import com.ibm.cics.eclipse.common.ui.Utilities;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.model.IRegion;
import com.ibm.cics.pa.model.AlertElement;
import com.ibm.cics.pa.model.Chart;
import com.ibm.cics.pa.model.Column;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.IModelChangeListener;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.PlotModel;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.PAContextTracker;
import com.ibm.cics.pa.ui.figures.IIntervalColumnFigure;
import com.ibm.cics.pa.ui.figures.IntervalPlotFigure;
import com.ibm.cics.pa.ui.figures.SingleIntervalFigure;
import com.ibm.cics.pa.ui.handlers.PAContextListener;
import com.ibm.cics.pa.ui.views.IChartColorPreferenceDependent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class PlotView
extends ViewPart
implements PAContextListener,
IChartColorPreferenceDependent,
IModelChangeListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Debug debug = new Debug(PlotView.class);
    static Map<String, String> regionMap = new HashMap<String, String>();
    public KeyListener genericKeyListener = new PlotViewKeyListener();
    protected boolean isDisposed = false;
    FigureCanvas figureCanvas;
    Composite detailSection;
    PlotModel model = null;
    Composite outerComposite;
    Hyperlink defnLink;
    String region = "";
    boolean lowerVisible;
    Menu menu;
    private ScrolledComposite outerSC;
    private Composite plotSection;
    private Composite detailColumnComposite;
    private LightweightSystem lws = null;
    private IntervalPlotFigure figure;
    private Map<Control, ColumnDefinition> paintedLabels = new HashMap<Control, ColumnDefinition>();
    private Composite parent;
    private IPerspectiveListener perspectiveListener;
    private Color formColour;
    private boolean pendingClosure = false;
    private boolean wasPAPerspective = true;
    private boolean isInitialised = false;
    private ScrollingGraphicalViewer graphicalViewer;
    private static final String PLOTS_GROUP = "com.ibm.cics.pa.ui.plots";
    private ConnectionServiceListener connectionListener = new ConnectionServiceListener(){

        public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
            if ("com.ibm.cics.sm.connection".equals(event.getConnectionCategoryId())) {
                if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                    if (!PlotView.this.isDisposed) {
                        PlotView.this.findExtraInformation(PlotView.this.getModel().getApplid(), true);
                    }
                } else if (event instanceof ConnectionServiceListener.DisconnectedEvent && !PlotView.this.isDisposed) {
                    PlotView.this.findExtraInformation(PlotView.this.getModel().getApplid(), false);
                }
            }
        }
    };

    public void init(IViewSite site) throws PartInitException {
        debug.enter("init");
        super.init(site);
        this.model = (PlotModel)Chart.getReference(site.getSecondaryId());
        if (this.figure != null && this.model != null) {
            this.figure.setModel(this.model);
        } else if (this.model == null && site.getSecondaryId() != null) {
            this.closeMeAgain((IViewPart)this);
        }
        this.isInitialised = true;
        this.model.addModelChangeListener(this);
        debug.exit("init", (Object)this.model);
    }

    public void createPartControl(Composite parent) {
        debug.enter("createPartControl");
        if (!this.pendingClosure) {
            if (this.isDisposed || this.model == null) {
                this.setContentDescription(Messages.getString("SheetView.noContext"));
                this.closeMeAgain((IViewPart)this);
            } else {
                this.parent = parent;
                Composite container = new Composite(parent, 0);
                container.setLayout((Layout)new FillLayout());
                this.outerSC = new ScrolledComposite(container, 2304);
                this.outerSC.setAlwaysShowScrollBars(false);
                this.outerSC.setLayout((Layout)new FillLayout());
                this.outerSC.setExpandHorizontal(true);
                this.outerSC.setExpandVertical(true);
                this.outerSC.setShowFocusedControl(true);
                this.outerSC.getHorizontalBar().setIncrement(10);
                this.outerSC.getHorizontalBar().setPageIncrement(100);
                if (this.getModel() != null && this.getModel().getElements().length > 0) {
                    this.setPartName(this.getModel().getTitle());
                    this.setContentDescription(this.getModel().getContentDescription());
                    this.outerComposite = new Composite((Composite)this.outerSC, 0);
                    this.outerSC.setContent((Control)this.outerComposite);
                    this.outerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
                    this.outerComposite.setLayout((Layout)new GridLayout(2, false));
                    this.outerComposite.setBackground(ColorConstants.listBackground);
                    this.outerSC.setBackground(ColorConstants.listBackground);
                    this.plotSection = new Composite(this.outerComposite, 0);
                    this.plotSection.setLayoutData((Object)new GridData(4, 4, false, true));
                    this.plotSection.setBackground(ColorConstants.listBackground);
                    this.createPlotSection(this.plotSection);
                    this.figureCanvas.addMouseWheelListener(new MouseWheelListener(){

                        public void mouseScrolled(org.eclipse.swt.events.MouseEvent e) {
                            PlotView.this.getFigure().repaint();
                        }
                    });
                    this.detailSection = new Composite(this.outerComposite, 0);
                    this.detailSection.setBackground(ColorConstants.listBackground);
                    this.detailSection.setLayoutData((Object)new GridData(4, 4, false, false));
                    GridLayout lean = this.leanLayout(new GridLayout(this.getModel().hasSubElements() ? 2 : 1, false));
                    lean.marginWidth = 5;
                    this.detailSection.setLayout((Layout)lean);
                    this.createDetailSection(this.detailSection);
                    parent.addControlListener((ControlListener)new ControlAdapter(){

                        public void controlResized(ControlEvent e) {
                            PlotView.this.outerComposite.layout();
                            PlotView.this.resize();
                        }
                    });
                    this.outerSC.getHorizontalBar().addListener(22, new Listener(){

                        public void handleEvent(Event event) {
                            PlotView.this.lowerVisible = true;
                            PlotView.this.resize();
                        }
                    });
                    this.outerSC.getHorizontalBar().addListener(23, new Listener(){

                        public void handleEvent(Event event) {
                            PlotView.this.lowerVisible = false;
                            PlotView.this.resize();
                        }
                    });
                    ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionListener);
                    this.wasPAPerspective = "com.ibm.cics.pa.ui.perspective".equals(this.getSite().getWorkbenchWindow().getActivePage().getPerspective().getId());
                    this.getSite().setSelectionProvider((ISelectionProvider)this.getFigure());
                    this.resize();
                    this.updateDetailSection(this.getFigure().setInitialSelected());
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.model.getCheatSheetReference());
                } else {
                    this.setContentDescription(Messages.getString("SheetView.noContext"));
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cics.pa.ui.plotview");
                }
                PAContextTracker.getInstance().addPAContextListenerListener(this);
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener(this.getPerspectiveListener());
                this.addToolbar(this.getViewSite().getActionBars().getToolBarManager());
                this.createMenu(this.getViewSite().getActionBars());
            }
        }
        debug.exit("createPartControl");
    }

    private void createPlotSection(Composite parent) {
        debug.enter("createPlotSection");
        this.formColour = new FormColors(Display.getCurrent()).getColor("org.eclipse.ui.forms.TB_BG");
        parent.setLayout((Layout)new GridLayout());
        this.graphicalViewer = new ScrollingGraphicalViewer();
        this.figureCanvas = (FigureCanvas)this.graphicalViewer.createControl(parent);
        this.lws = this.figureCanvas.getLightweightSystem();
        this.figureCanvas.getViewport().setLayoutManager((LayoutManager)new XYLayout());
        this.figureCanvas.getViewport().setContentsTracksWidth(true);
        this.figureCanvas.setLayoutData((Object)new GridData(4, 4, true, true));
        this.figureCanvas.setVerticalScrollBarVisibility(FigureCanvas.NEVER);
        this.figureCanvas.setHorizontalScrollBarVisibility(FigureCanvas.NEVER);
        this.figureCanvas.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(org.eclipse.swt.events.MouseEvent e) {
                PlotView.this.model.getApplicableImplementation().keyPress(e.count > 0 ? 0x1000001 : 0x1000002);
            }
        });
        this.figureCanvas.addKeyListener(this.genericKeyListener);
        this.getFigure().addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent me) {
                Point point = new Point(me.x, me.y);
                PlotView.this.getFigure().translateToRelative((Translatable)point);
                IFigure figure = PlotView.this.getFigure().findFigureAt(point.x, point.y);
                if (figure instanceof SingleIntervalFigure) {
                    PlotView.this.updateDetailSection(PlotView.this.getFigure().setSelected(figure));
                } else if (figure instanceof IIntervalColumnFigure) {
                    PlotView.this.updateDetailSection(PlotView.this.getFigure().setSelected(figure.getParent()));
                }
            }

            public void mouseReleased(MouseEvent me) {
            }

            public void mouseDoubleClicked(MouseEvent me) {
            }
        });
        Action action = new Action(){

            public String getId() {
                return ActionFactory.COPY.getId();
            }

            public String getActionDefinitionId() {
                return ActionFactory.COPY.getId();
            }

            public void run() {
                Clipboard clipboard = new Clipboard(PlotView.this.figureCanvas.getDisplay());
                Image image = new Image((Device)PlotView.this.figureCanvas.getDisplay(), PlotView.this.detailSection.getParent().getClientArea());
                GC gc = new GC((Drawable)PlotView.this.figureCanvas);
                gc.copyArea(image, 0, 0);
                gc.dispose();
                ImageTransfer transfer = ImageTransfer.getInstance();
                clipboard.setContents(new Object[]{image.getImageData()}, new Transfer[]{transfer});
                image.dispose();
                clipboard.dispose();
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)action);
        this.getViewSite().getActionBars().updateActionBars();
        this.figureCanvas.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                event.doit = true;
            }
        });
        this.figureCanvas.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                if (PlotView.this.getFigure() != null) {
                    PlotView.this.getFigure().showFocusColumn(true);
                }
            }
        });
        this.figureCanvas.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (PlotView.this.getFigure() != null) {
                    PlotView.this.getFigure().showFocusColumn(false);
                }
            }
        });
        this.figureCanvas.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode != 13) {
                    switch (e.keyCode) {
                        case 0x1000008: {
                            PlotView.this.getFigure().setSelectLast();
                            break;
                        }
                        case 0x1000007: {
                            PlotView.this.getFigure().setSelectFirst();
                            break;
                        }
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        if (this.getDataProvider() != null && this.getDataProvider() != null) {
            this.getDataProvider().incrementUseCount();
        }
        this.figureCanvas.getViewport().setContents((IFigure)this.getFigure());
        this.lws.setContents((IFigure)this.getFigure());
        this.getFigure().repaint();
        debug.exit("createPlotSection");
    }

    private void createDetailSection(Composite sectionClient) {
        debug.enter("createDetailSection");
        this.detailColumnComposite = this.model.getApplicableImplementation().createDetailSection(this, this.parent, sectionClient);
        debug.exit("createDetailSection");
    }

    public void addStandardAdditional(Composite sectionClient, Composite detailColumnComposite) {
        this.defnLink = new Hyperlink(detailColumnComposite, 0);
        this.defnLink.setText(MessageFormat.format("", "NNNNNNNN"));
        this.defnLink.setBackground(sectionClient.getBackground());
        this.defnLink.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        this.defnLink.setForeground(ColorConstants.blue);
        this.defnLink.setToolTipText(Messages.getString("PlotView.CICS.region"));
        this.defnLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Job smeditorJob = PlotView.this.openEditorForRegion(PlotView.this.region);
                Utilities.scheduleJob((IWorkbenchPart)PlotView.this, (Job)smeditorJob);
            }
        });
        this.defnLink.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getDescription(AccessibleEvent e) {
                e.result = Messages.getString("PlotView.CICS.region");
            }

            public void getName(AccessibleEvent e) {
                e.result = Messages.getString("PlotView.CICS.region");
            }
        });
        this.defnLink.addKeyListener(this.genericKeyListener);
        this.defnLink.setUnderlined(true);
        this.defnLink.setEnabled(false);
        this.defnLink.setText(MessageFormat.format(Messages.getString("PlotView.open.editor1"), this.getModel().getApplid()));
        final Link link = new Link(detailColumnComposite, 0);
        link.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        String target = "com.ibm.cics.pa.ui.preferences.colors2";
        link.setText(Messages.getString("ChartColorPrefs.7"));
        link.addKeyListener(this.genericKeyListener);
        link.setToolTipText(Messages.getString("ChartColorPrefs.5"));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)"com.ibm.cics.pa.ui.preferences.colors2", (String[])new String[]{"com.ibm.cics.pa.ui.preferences.colors2"}, null).open();
            }
        });
        link.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getDescription(AccessibleEvent e) {
                e.result = Messages.getString("ChartColorPrefs.5");
            }

            public void getName(AccessibleEvent e) {
                e.result = Messages.getString("ChartColorPrefs.5");
            }
        });
        link.setEnabled(true);
        link.setBackground(sectionClient.getBackground());
        Label l = new Label(detailColumnComposite, 0);
        l.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        l.setBackground(this.detailSection.getBackground());
        this.findExtraInformation(this.getModel().getApplid(), this.cpsmIsConnected());
    }

    public void setFocus() {
        if (this.figureCanvas != null) {
            this.figureCanvas.setFocus();
        }
        this.getFigure().showFocusColumn(true);
    }

    public void dispose() {
        debug.enter("dispose");
        this.isDisposed = true;
        if (this.connectionListener != null) {
            this.connectionListener.makeStale();
        }
        this.model.removeModelChangeListener(this);
        PAContextTracker.getInstance().removePAContextListenerListener(this);
        this.getSite().setSelectionProvider(null);
        if (this.wasPAPerspective || !this.wasPAPerspective && this.isInitialised && "com.ibm.cics.pa.ui.perspective".equals(this.getSite().getWorkbenchWindow().getActivePage().getPerspective().getId())) {
            if (this.getDataProvider() != null) {
                this.getDataProvider().decrementUseCount();
            }
            if (this.model != null) {
                this.model.remove();
            }
        }
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().removePerspectiveListener(this.getPerspectiveListener());
        super.dispose();
        debug.exit("dispose");
    }

    private GenericDataProvider getDataProvider() {
        if (this.model != null) {
            return this.model.getDataProvider();
        }
        return null;
    }

    PlotModel getModel() {
        return this.model;
    }

    IntervalPlotFigure getFigure() {
        if (this.figure == null && this.model != null) {
            this.figure = new IntervalPlotFigure(this.formColour, this.figureCanvas, this.getModel());
        }
        return this.figure;
    }

    public String getPartProperty(String key) {
        if (IConnectionCategory.class.getName().equals(key)) {
            return "com.ibm.cics.pa.connection";
        }
        return super.getPartProperty(key);
    }

    @Override
    public void disconnected() {
        this.closeMeAgain((IViewPart)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findExtraInformation(final String applid, boolean isConnected) {
        debug.enter("findExtraInformation", (Object)applid);
        Map<String, String> map = regionMap;
        synchronized (map) {
            if (regionMap.containsKey(applid)) {
                this.region = regionMap.get(applid);
                this.waitForResponse(applid);
                return;
            }
        }
        if (isConnected && this.cpsmIsConnected() && !this.isDisposed) {
            map = regionMap;
            synchronized (map) {
                regionMap.put(applid, null);
            }
            Job smeditorJob = new Job(Messages.getString("PlotView.job.locating")){

                protected IStatus run(IProgressMonitor aMonitor) {
                    CancellableRunnable runnable = new CancellableRunnable(){

                        protected Object performLongWork() throws Exception {
                            return PlotView.this.findRegionName(applid);
                        }
                    };
                    try {
                        PlotView.this.region = (String)runnable.run(aMonitor);
                        regionMap.put(applid, PlotView.this.region);
                        PlotView.this.fillInRegion();
                    }
                    catch (Exception e) {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            smeditorJob.setPriority(50);
            IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
            siteService.schedule(smeditorJob, 0L, false);
        } else if (this.defnLink != null && !this.defnLink.isDisposed()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    PlotView.this.defnLink.setEnabled(false);
                }
            });
        }
        debug.exit("findExtraInformation");
    }

    private void waitForResponse(final String applid) {
        debug.enter("waitForResponse", (Object)applid);
        Job waitJob = new Job(Messages.getString("PlotView.job.waiting")){

            protected IStatus run(IProgressMonitor aMonitor) {
                PlotView.this.region = regionMap.get(applid);
                while (PlotView.this.region == null && !aMonitor.isCanceled()) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        debug.error("doOne", (Throwable)e);
                        return Status.CANCEL_STATUS;
                    }
                    if (!regionMap.containsKey(applid)) continue;
                    PlotView.this.region = regionMap.get(applid);
                }
                PlotView.this.fillInRegion();
                return Status.OK_STATUS;
            }
        };
        waitJob.setPriority(50);
        Utilities.scheduleJob((IWorkbenchPart)this, (Job)waitJob);
        debug.exit("waitForResponse");
    }

    void fillInRegion() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!PlotView.this.defnLink.isDisposed()) {
                    if (StringUtil.hasContent((String)PlotView.this.region)) {
                        PlotView.this.defnLink.setEnabled(true);
                        PlotView.this.defnLink.setText(MessageFormat.format(Messages.getString("PlotView.open.editor2"), PlotView.this.getModel().getApplid(), PlotView.this.region));
                        PlotView.this.defnLink.getParent().layout();
                    } else {
                        PlotView.this.defnLink.setEnabled(false);
                    }
                }
            }
        });
    }

    void updateDetailSection(SingleIntervalFigure figure) {
        debug.enter("updateDetailSection");
        this.model.getApplicableImplementation().updateDetailSection(figure);
        debug.exit("updateDetailSection");
    }

    public void activateTransactionIdLink(ISelection selection) {
        if (!selection.isEmpty()) {
            Object first = ((StructuredSelection)selection).getFirstElement();
            String transaction = (String)((Object[])first)[0];
            PlotModel.PlotModelElement current = this.getFigure().getCurrentElement();
            AlertElement nextAlert = current.createElement(this.getModel().getSubColumnLabel(), transaction, Comparator.EQ, this.getModel().getSubColumnLabel().tableLookup(transaction));
            this.activateHyperLink(nextAlert);
        }
    }

    public void activateHyperLink(AlertElement nextAlert) {
        debug.enter("activateHyperLink", (Object)nextAlert);
        if (nextAlert != null) {
            this.getCurrentElement().setNextAlert(nextAlert);
            ICommandService commandService = (ICommandService)this.getSite().getService(ICommandService.class);
            Command command = commandService.getCommand("com.ibm.cics.pa.ui.intervaltracker");
            if (command.isEnabled()) {
                try {
                    IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
                    handlerService.executeCommand("com.ibm.cics.pa.ui.intervaltracker", null);
                }
                catch (NotDefinedException e) {
                    debug.error("activateLink", "Could not find open command: com.ibm.cics.pa.ui.intervaltracker", (Throwable)e);
                }
                catch (ExecutionException e) {
                    debug.error("activateLink", "Failed to execute comand: com.ibm.cics.pa.ui.intervaltracker", (Throwable)e);
                }
                catch (NotEnabledException e) {
                    debug.error("activateLink", "Command not enabled: com.ibm.cics.pa.ui.intervaltracker", (Throwable)e);
                }
                catch (NotHandledException e) {
                    debug.error("activateLink", "Command not handled: com.ibm.cics.pa.ui.intervaltracker", (Throwable)e);
                }
            }
        }
        debug.exit("activateHyperLink");
    }

    public void activateSheetViewLink(AlertElement nextAlert) {
        debug.enter("activateHyperLink", (Object)nextAlert);
        if (nextAlert != null) {
            this.getCurrentElement().setNextAlert(nextAlert);
            ICommandService commandService = (ICommandService)this.getSite().getService(ICommandService.class);
            Command command = commandService.getCommand("com.ibm.cics.pa.ui.commands.run_report1");
            if (command.isEnabled()) {
                try {
                    IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
                    handlerService.executeCommand("com.ibm.cics.pa.ui.commands.run_report1", null);
                }
                catch (NotDefinedException e) {
                    debug.error("activateLink", "Could not find open command: com.ibm.cics.pa.ui.commands.run_report1", (Throwable)e);
                }
                catch (ExecutionException e) {
                    debug.error("activateLink", "Failed to execute comand: com.ibm.cics.pa.ui.commands.run_report1", (Throwable)e);
                }
                catch (NotEnabledException e) {
                    debug.error("activateLink", "Command not enabled: com.ibm.cics.pa.ui.commands.run_report1", (Throwable)e);
                }
                catch (NotHandledException e) {
                    debug.error("activateLink", "Command not handled: com.ibm.cics.pa.ui.commands.run_report1", (Throwable)e);
                }
            }
        }
        debug.exit("activateHyperLink");
    }

    private void closeMeAgain(final IViewPart view) {
        debug.enter("closeMeAgain");
        this.pendingClosure = true;
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PlotView.this.getViewSite().getPage().hideView(view);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
        debug.exit("closeMeAgain");
    }

    @Override
    public void forceRepaint() {
        debug.enter("forceRepaint");
        Control[] controlArray = this.detailColumnComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            Object data = control.getData();
            if (data instanceof ColumnDefinition) {
                control.setForeground(Column.getFor((ColumnDefinition)data).getColor());
                control.redraw();
            }
            ++n2;
        }
        this.getFigure().forceRepaint();
        for (Control label : this.paintedLabels.keySet()) {
            label.setForeground(Column.getFor(this.paintedLabels.get(label)).getColor());
        }
        debug.exit("forceRepaint");
    }

    void resize() {
        debug.enter("resize");
        this.parent.getParent().layout();
        this.outerSC.setMinSize(this.outerComposite.computeSize(-1, -1));
        this.outerSC.layout();
        this.model.getApplicableImplementation().resize(this.lowerVisible);
        this.parent.layout();
        int length1 = this.getModel().getElements().length;
        this.getFigure().setPreferredSize(length1 * 64, this.parent.getSize().y - (this.lowerVisible ? 35 : 20));
        this.figureCanvas.setSize(length1 * 64, this.parent.getSize().y);
        this.parent.layout();
        debug.exit("resize");
    }

    String findRegionName(String applid) {
        ICPSM cpsm;
        debug.enter("findRegionName", (Object)applid);
        String regionLabel = "";
        if (applid != null && (cpsm = (ICPSM)ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.sm.connection")).isConnected()) {
            ICICSplex[] iCICSplexArray = cpsm.getCICSplexes();
            int n = iCICSplexArray.length;
            int n2 = 0;
            while (n2 < n) {
                IManagedRegion[] regions;
                ICICSplex cicsplex = iCICSplexArray[n2];
                IRegion region = ModelUtilities.findRegion((ICICSplex)cicsplex, (String)applid);
                if (region != null && applid.equals(region.getApplID())) {
                    regionLabel = region.getName();
                    debug.exit("findRegionName", (Object)regionLabel);
                    return regionLabel;
                }
                IManagedRegion[] iManagedRegionArray = regions = cpsm.getManagedRegions(cicsplex);
                int n3 = regions.length;
                int n4 = 0;
                while (n4 < n3) {
                    IManagedRegion iManagedRegion = iManagedRegionArray[n4];
                    region = ModelUtilities.findRegion((ICICSplex)cicsplex, (String)iManagedRegion.getName());
                    if (region != null && applid.equals(region.getApplID())) {
                        regionLabel = region.getName();
                        debug.exit("findRegionName", (Object)regionLabel);
                        return regionLabel;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        debug.exit("findRegionName", (Object)regionLabel);
        return "";
    }

    Job openEditorForRegion(final String region) {
        debug.enter("openEditorFor(IHistoricalApplid)", (Object)region);
        if (region == null) {
            return null;
        }
        Job smeditorJob = new Job(Messages.getString("PlotView.job.locating")){

            protected IStatus run(final IProgressMonitor aMonitor) {
                CancellableRunnable runnable = new CancellableRunnable(){

                    protected Object performLongWork() throws Exception {
                        return PlotView.this.findRegion(region, aMonitor);
                    }
                };
                try {
                    final ArrayList regions = (ArrayList)runnable.run(aMonitor);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            for (ICICSObject aRegion : regions) {
                                try {
                                    EditCICSObjectHelper.openEditor((ICICSObject)aRegion, (boolean)true);
                                    aMonitor.done();
                                }
                                catch (Exception ex) {
                                    debug.error("openEditorFor(IHistoricalApplid)", (Throwable)ex);
                                }
                            }
                        }
                    });
                }
                catch (Exception e) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        smeditorJob.setPriority(30);
        debug.exit("openEditorForRegion");
        return smeditorJob;
    }

    ArrayList<ICICSObject> findRegion(String region, IProgressMonitor aMonitor) {
        debug.enter("findRegion", (Object)region);
        ArrayList<ICICSObject> regions = new ArrayList<ICICSObject>();
        ICPSM cpsm = (ICPSM)ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.sm.connection");
        if (cpsm.isConnected()) {
            ICICSplex[] cicsplexes;
            ICICSplex[] iCICSplexArray = cicsplexes = cpsm.getCICSplexes();
            int n = cicsplexes.length;
            int n2 = 0;
            while (n2 < n) {
                ICICSplex cicsplex = iCICSplexArray[n2];
                RegionsModel regModel = cpsm.getRegions(cicsplex.getName());
                ICICSObject reg = regModel.find(region);
                if (reg != null) {
                    regions.add(reg);
                }
                if (aMonitor.isCanceled()) {
                    aMonitor.done();
                    return null;
                }
                aMonitor.internalWorked(1.0);
                ++n2;
            }
        }
        debug.exit("findRegion", regions);
        return regions;
    }

    public GridLayout leanLayout(GridLayout noMargin) {
        noMargin.marginBottom = 0;
        noMargin.marginTop = 0;
        noMargin.marginLeft = 0;
        noMargin.marginRight = 0;
        noMargin.marginWidth = 0;
        noMargin.marginHeight = 0;
        noMargin.verticalSpacing = 0;
        noMargin.horizontalSpacing = 0;
        return noMargin;
    }

    private boolean cpsmIsConnected() {
        IConnectable smConnection = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.sm.connection");
        return smConnection != null && smConnection.isConnected();
    }

    private IPerspectiveListener getPerspectiveListener() {
        if (this.perspectiveListener == null) {
            this.perspectiveListener = new IPerspectiveListener(){

                public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
                }

                public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                    if (page.equals(PlotView.this.getSite().getPage())) {
                        Job job = new Job(""){

                            protected IStatus run(IProgressMonitor monitor) {
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        PlotView.this.resize();
                                    }
                                });
                                return Status.OK_STATUS;
                            }
                        };
                        job.setPriority(20);
                        job.schedule();
                    }
                }
            };
        }
        return this.perspectiveListener;
    }

    public PlotModel.PlotModelElement getCurrentElement() {
        return this.getFigure().getCurrentElement();
    }

    public void openEditorForRegion() {
        Job smeditorJob = this.openEditorForRegion(this.region);
        Utilities.scheduleJob((IWorkbenchPart)this, (Job)smeditorJob);
    }

    public void setPartName(String title) {
        super.setPartName(title);
    }

    @Override
    public void tableSelected(ManifestRecord manifest) {
    }

    private void addToolbar(IToolBarManager toolBarManager) {
        String nextTable = "HST014A";
        String actionText = "PlotModel.hyperlink.DSAApplid";
        if (this.model.isSMSRecord() || this.model.isSMTRecord() || this.model.isDSARecord() || this.model.isLDGRecord()) {
            nextTable = "HST060A";
            actionText = "ChartDefinition.DISPATCHER_OVERVIEW";
        } else if (this.model.isDSGRecord()) {
            nextTable = "HST010A";
            actionText = "ChartDefinition.TRAN_MAN_TRACE";
        }
        final String table = nextTable;
        Action alternativePlotAction = new Action(Messages.getString(actionText), 4){

            public void run() {
                AlertElement nextAlert = PlotView.this.getCurrentElement().createElement(ColumnDefinition.APPLID, Comparator.EQ, null);
                nextAlert.setAlias(table);
                PlotView.this.activateHyperLink(nextAlert);
            }
        };
        alternativePlotAction.setToolTipText(Messages.getString("Visualisation.cycle"));
        alternativePlotAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("interval"));
        alternativePlotAction.setEnabled(true);
        alternativePlotAction.setMenuCreator(new IMenuCreator(){

            public void dispose() {
                if (PlotView.this.menu != null) {
                    PlotView.this.menu.dispose();
                }
            }

            public Menu getMenu(Control parent) {
                if (PlotView.this.menu != null) {
                    return PlotView.this.menu;
                }
                MenuManager manager = new MenuManager();
                manager.add((IContributionItem)new Separator(PlotView.PLOTS_GROUP));
                IAction[] iActionArray = PlotView.this.createPlotActions();
                int n = iActionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAction action = iActionArray[n2];
                    manager.appendToGroup(PlotView.PLOTS_GROUP, action);
                    ++n2;
                }
                PlotView.this.menu = manager.createContextMenu(parent);
                return PlotView.this.menu;
            }

            public Menu getMenu(Menu parent) {
                return null;
            }
        });
        toolBarManager.add((IAction)alternativePlotAction);
    }

    private void createMenu(IActionBars actionbars) {
        this.graphicalViewer.setContextMenu((MenuManager)actionbars.getMenuManager());
        actionbars.getMenuManager().setRemoveAllWhenShown(true);
        actionbars.getMenuManager().addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IAction[] iActionArray = PlotView.this.createPlotActions();
                int n = iActionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAction action = iActionArray[n2];
                    manager.add(action);
                    ++n2;
                }
            }
        });
    }

    public Object getAdapter(Class type) {
        if (type == GraphicalViewer.class) {
            return this.graphicalViewer;
        }
        return super.getAdapter(type);
    }

    protected IAction[] createPlotActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        Action xmgAlertAction = new Action(Messages.getString("ChartDefinition.TRAN_MAN_TRACE")){

            public void run() {
                AlertElement xmgAlert = PlotView.this.getCurrentElement().createElement(ColumnDefinition.APPLID, Comparator.EQ, null);
                xmgAlert.setAlias("HST010A");
                PlotView.this.activateHyperLink(xmgAlert);
            }
        };
        xmgAlertAction.setToolTipText(Messages.getString("PlotModel.hyperlink.applid"));
        actions.add(xmgAlertAction);
        Action smsAlertAction = new Action(Messages.getString("ChartDefinition.STORAGE_OVERVIEW")){

            public void run() {
                AlertElement smsAlert = PlotView.this.getCurrentElement().createElement(ColumnDefinition.APPLID, Comparator.EQ, null);
                smsAlert.setAlias("HST014A");
                PlotView.this.activateHyperLink(smsAlert);
            }
        };
        smsAlertAction.setToolTipText(Messages.getString("PlotModel.hyperlink.DSAApplid"));
        actions.add(smsAlertAction);
        Action dispAlertAction = new Action(Messages.getString("ChartDefinition.DISPATCHER_OVERVIEW")){

            public void run() {
                AlertElement dispAlert = PlotView.this.getCurrentElement().createElement(ColumnDefinition.APPLID, Comparator.EQ, null);
                dispAlert.setAlias("HST060A");
                PlotView.this.activateHyperLink(dispAlert);
            }
        };
        dispAlertAction.setToolTipText(Messages.getString("ChartDefinition.DISPATCHER_OVERVIEW"));
        actions.add(dispAlertAction);
        Action monitoringAlertAction = new Action(Messages.getString("ChartDefinition.MONITORING_TRACE")){

            public void run() {
                AlertElement monAlert = PlotView.this.getCurrentElement().createElement(ColumnDefinition.APPLID, Comparator.EQ, null);
                monAlert.setAlias("HST081A");
                PlotView.this.activateHyperLink(monAlert);
            }
        };
        monitoringAlertAction.setToolTipText(Messages.getString("ChartDefinition.LOADER_TRACE"));
        actions.add(monitoringAlertAction);
        Action loaderAlertAction = new Action(Messages.getString("ChartDefinition.LOADER_TRACE")){

            public void run() {
                AlertElement loadAlert = PlotView.this.getCurrentElement().createElement(ColumnDefinition.APPLID, Comparator.EQ, null);
                loadAlert.setAlias("HST030A");
                PlotView.this.activateHyperLink(loadAlert);
            }
        };
        loaderAlertAction.setToolTipText(Messages.getString("ChartDefinition.MONITORING_TRACE"));
        actions.add(loaderAlertAction);
        if (this.model.isXMGRecord() || this.model.isXMCRecord() || this.model.isXMRRecord()) {
            actions.remove(xmgAlertAction);
        } else if (this.model.isSMSRecord() || this.model.isSMTRecord() || this.model.isDSARecord()) {
            actions.remove(smsAlertAction);
        } else if (this.model.isDSGRecord()) {
            actions.remove(dispAlertAction);
        } else if (this.model.isMNGRecord()) {
            actions.remove(monitoringAlertAction);
        } else if (this.model.isLDGRecord() || this.model.isLDGDSARecord()) {
            actions.remove(loaderAlertAction);
        }
        return actions.toArray(new IAction[actions.size()]);
    }

    public void addPaintedLabel(Control lt, ColumnDefinition headlabel) {
        this.paintedLabels.put(lt, headlabel);
    }

    @Override
    public void modelStateChanged() {
        this.getFigure().initialise(this.getModel());
        this.updateDetailSection(this.getFigure().setInitialSelected());
        this.outerComposite.layout();
        this.resize();
    }

    class PlotViewKeyListener
    implements KeyListener {
        PlotViewKeyListener() {
        }

        public void keyReleased(KeyEvent e) {
            if (e.keyCode == 0x1000003) {
                PlotView.this.updateDetailSection(PlotView.this.getFigure().moveSelection(false));
            } else if (e.keyCode == 0x1000004) {
                PlotView.this.updateDetailSection(PlotView.this.getFigure().moveSelection(true));
            }
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 0x1000005 || e.keyCode == 0x1000006 || e.keyCode == 0x1000001 || e.keyCode == 0x1000002) {
                PlotView.this.model.getApplicableImplementation().keyPress(e.keyCode);
            }
        }
    }
}

