/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.pa.model.Chart;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.Pie;
import com.ibm.cics.pa.model.WaitAnalysis;
import com.ibm.cics.pa.model.definitions.AbstractChartDefinition;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.ColumnContainment;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.model.definitions.PieChartSpecificDefinitions;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.ChartManager;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.editors.PAResourceChangeListener;
import com.ibm.cics.pa.ui.editors.PieEditorItem;
import com.ibm.cics.pa.ui.figures.BigPie;
import com.ibm.cics.pa.ui.figures.PieLine;
import com.ibm.cics.pa.ui.figures.WaitAnalysisFigure;
import com.ibm.cics.pa.ui.remote.PAConnectionListener;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.cics.pa.ui.views.IChartColorPreferenceDependent;
import com.ibm.cics.pa.ui.views.PieEditorContentProvider;
import com.ibm.cics.pa.ui.views.PieTreeLabelProvider;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.ColumnLayoutData;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.ViewPart;

public class PieView
extends ViewPart
implements ISelectionProvider,
IChartColorPreferenceDependent,
PAConnectionListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(PieView.class);
    private FormToolkit toolkit;
    public static final String RESTRICT = "Restrict";
    public static final String INCLUDE = "Include";
    private Collection<ISelectionChangedListener> listeners = new HashSet<ISelectionChangedListener>();
    private Pie startModel = null;
    IManagedForm managedForm;
    private IResourceChangeListener resourceListener = null;
    protected ScrollingGraphicalViewer graphicalViewer;
    protected ScrollingGraphicalViewer graphicalViewerLine;
    private WaitAnalysisFigure waitFigure;
    private Section waitSection;
    private PieLine headerSection;
    private Section treeSection;
    BigPie bigPie;
    Tree tree;
    private TreeViewer treeViewer;
    private Tree additionalTree;
    private TreeViewer additionalViewer;
    private Image elementImage = Activator.getDefault().getImage("pie");
    private FigureCanvas viewer;
    private FigureCanvas viewerHeader;
    PieView editorPart = this;
    private Map<ColumnDefinition, Object> mapping = new HashMap<ColumnDefinition, Object>();
    Button includeButton;
    private ChartSpecification currentDefinition;
    Button restrictButton;
    private PieEditorContentProvider treeContent;
    private Font smallerFont;
    IAction linkToSelectionAction;
    boolean isLinkedToSelection = true;
    private ISelectionListener selectionListener;
    protected IUniqueRecord existingInput;
    private IPartListener2 partListener;
    private Composite treesColumn;
    private GridData treeGridDataTop;
    private GridData treeGridDataLower;
    FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
        }
    };

    public void createPartControl(Composite parent) {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(false);
        Menu popUpMenu = menuManager.createContextMenu((Control)parent);
        parent.setMenu(popUpMenu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this);
        this.makeActions(this.getViewSite().getWorkbenchWindow());
        this.fillActionBar(this.getViewSite().getActionBars());
        this.addPartListener();
        this.addSelectionListener();
        this.managedForm = new ManagedForm(parent);
        parent.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                PieView.this.managedForm.getForm().getVerticalBar();
            }
        });
        if (this.getModel() != null) {
            this.createFormContent();
            this.setInput(this.getModel());
        }
        PAConnectionTracker.getInstance().addPAConnectionTrackerListener(this);
        this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpContextId());
    }

    public void setFocus() {
        if (this.waitSection != null) {
            this.waitSection.setFocus();
        } else if (this.headerSection != null) {
            this.headerSection.setFocus();
        } else if (this.treeSection != null) {
            this.treeSection.setFocus();
        }
    }

    public void dispose() {
        PAConnectionTracker.getInstance().removePAConnectionTrackerListener(this);
        if (this.getDataProvider() != null && this.getDataProvider() != null) {
            this.getDataProvider().decrementUseCount();
        }
        if (this.smallerFont != null) {
            this.smallerFont.dispose();
        }
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
        super.dispose();
    }

    private PieLine createHeaderSection(IManagedForm managedForm, int expanded) {
        final ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        Section section = toolkit.createSection(form.getBody(), 0x100 | expanded);
        section.setText(Messages.getString("PiePage.Overview"));
        section.setDescription(Messages.getString("PiePage.NO_RECORDED_DATA"));
        section.marginWidth = 5;
        section.marginHeight = 0;
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(false);
            }
        });
        this.graphicalViewerLine = new ScrollingGraphicalViewer();
        this.viewerHeader = (FigureCanvas)this.graphicalViewerLine.createControl((Composite)section);
        this.viewerHeader.getViewport().setPreferredSize(new Dimension(800, 105));
        LightweightSystem lws = new LightweightSystem((Canvas)this.viewerHeader);
        toolkit.adapt((Composite)this.viewerHeader);
        section.setClient((Control)this.viewerHeader);
        PieLine fig1 = new PieLine(this, (GraphicalViewer)this.graphicalViewerLine, this.startModel);
        this.viewerHeader.getViewport().setContents((IFigure)fig1);
        lws.setContents((IFigure)fig1);
        this.viewerHeader.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                Point origin = form.getOrigin();
                origin.y -= 3 * e.count;
                form.setOrigin(origin);
            }
        });
        return fig1;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.startModel = (Pie)Chart.getReference(site.getSecondaryId());
        if (this.startModel == null) {
            this.closeMeAgain(this);
            return;
        }
    }

    public void closeMeAgain(final ViewPart view) {
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PieView.this.getViewSite().getPage().hideView((IViewPart)view);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
    }

    private Section createMainSection(IManagedForm managedForm, int expanded) {
        this.toolkit = managedForm.getToolkit();
        Section section = this.toolkit.createSection(managedForm.getForm().getBody(), 0x80 | expanded);
        section.setDescription(Messages.getString("PiePage.description"));
        Composite client = this.toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 10;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        ColumnLayoutData sectionData = new ColumnLayoutData();
        sectionData.heightHint = -1;
        section.setLayoutData((Object)sectionData);
        section.setClient((Control)client);
        Composite pieColumn = this.toolkit.createComposite(client);
        this.treesColumn = this.toolkit.createComposite(client);
        pieColumn.setLayout((Layout)new GridLayout());
        GridLayout layout2 = new GridLayout();
        layout2.marginWidth = 0;
        layout2.makeColumnsEqualWidth = true;
        layout2.marginHeight = 0;
        layout2.verticalSpacing = 0;
        this.treesColumn.setLayout((Layout)layout2);
        GridData treeData = new GridData(1, 1, false, false);
        this.treesColumn.setLayoutData((Object)treeData);
        GridData gdColumn1 = new GridData(1, 1, false, false);
        pieColumn.setLayoutData((Object)gdColumn1);
        this.graphicalViewer = new ScrollingGraphicalViewer();
        this.viewer = (FigureCanvas)this.graphicalViewer.createControl(pieColumn);
        this.viewer.getViewport().setPreferredSize(new Dimension(275, 275));
        this.viewer.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                PieView.this.tree.setFocus();
            }
        });
        LightweightSystem lws = new LightweightSystem((Canvas)this.viewer);
        this.toolkit.paintBordersFor((Composite)this.viewer);
        this.toolkit.adapt((Composite)this.viewer);
        this.bigPie = new BigPie((IViewPart)this, this.graphicalViewer, this.startModel);
        this.viewer.getViewport().setContents((IFigure)this.bigPie);
        GridData bigPieLayoutData = new GridData(1, 1, true, false);
        bigPieLayoutData.heightHint = -1;
        this.viewer.setLayoutData((Object)bigPieLayoutData);
        lws.setContents((IFigure)this.bigPie);
        this.restrictButton = this.toolkit.createButton(pieColumn, Messages.getString("PiePage.RestrictNodes"), 32);
        this.restrictButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PieView.this.setSelectedChart(PieView.this.getModel());
                Activator.getDefault().getPluginInstancePreferences().putBoolean(PieView.RESTRICT, PieView.this.restrictButton.getSelection());
            }

            public void widgetSelected(SelectionEvent e) {
                PieView.this.setSelectedChart(PieView.this.getModel());
                Activator.getDefault().getPluginInstancePreferences().putBoolean(PieView.RESTRICT, PieView.this.restrictButton.getSelection());
            }
        });
        this.restrictButton.setSelection(Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), RESTRICT, false, null));
        this.restrictButton.setLayoutData((Object)new GridData(1, 1, false, false));
        this.includeButton = this.toolkit.createButton(pieColumn, Messages.getString("PiePage.IncludeZeros"), 32);
        this.includeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PieView.this.setSelectedChart(PieView.this.getModel());
                Activator.getDefault().getPluginInstancePreferences().putBoolean(PieView.INCLUDE, PieView.this.includeButton.getSelection());
            }

            public void widgetSelected(SelectionEvent e) {
                PieView.this.setSelectedChart(PieView.this.getModel());
                Activator.getDefault().getPluginInstancePreferences().putBoolean(PieView.INCLUDE, PieView.this.includeButton.getSelection());
            }
        });
        this.includeButton.setSelection(Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), INCLUDE, true, null));
        this.includeButton.setLayoutData((Object)new GridData(1, 1, false, false));
        this.tree = this.toolkit.createTree(this.treesColumn, 68096);
        this.treeGridDataTop = new GridData(1, 128, true, false);
        this.treeGridDataTop.heightHint = -1;
        this.treeGridDataTop.widthHint = -1;
        this.tree.setLayoutData((Object)this.treeGridDataTop);
        this.tree.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        this.treeViewer = new TreeViewer(this.tree);
        this.tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    PieView.this.editorPart.doubleClicked(PieView.this.getModel().getElementName(), PieView.this.getModel().getRow());
                }
            }

            public void keyReleased(KeyEvent e) {
                char key = e.character;
                if ((e.stateMask & 0x40000) != 0) {
                    switch (key) {
                        case '\u0003': {
                            PieView.this.editorPart.copyToClipboard();
                            break;
                        }
                    }
                }
            }
        });
        String[] tooltips = ((PieChartSpecificDefinitions)this.startModel.getChartReference().getSpecificType()).getTooltips();
        String[] headers = ((PieChartSpecificDefinitions)this.startModel.getChartReference().getSpecificType()).getHeadings();
        this.treeViewer.setColumnProperties(headers);
        this.tree.setLinesVisible(true);
        this.tree.setHeaderVisible(true);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (PieView.this.bigPie != null) {
                    PieView.this.bigPie.setSelection(PieView.this.getInternalSelection());
                }
            }
        });
        this.treeContent = new PieEditorContentProvider(this.mapping);
        this.treeViewer.setContentProvider((IContentProvider)this.treeContent);
        int i = 0;
        while (i < headers.length) {
            PieTreeLabelProvider tempTreeLabelProvider = new PieTreeLabelProvider(this.mapping, i);
            TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
            treeViewerColumn.setLabelProvider((CellLabelProvider)tempTreeLabelProvider);
            treeViewerColumn.getColumn().setText(headers[i]);
            treeViewerColumn.getColumn().setToolTipText(tooltips[i]);
            if (i == 0) {
                treeViewerColumn.getColumn().setWidth(350);
            } else if (i == 1) {
                treeViewerColumn.getColumn().setWidth(160);
            } else {
                treeViewerColumn.getColumn().setWidth(85);
                treeViewerColumn.getColumn().setAlignment(131072);
            }
            ++i;
        }
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer, (int)2);
        this.additionalTree = this.toolkit.createTree(this.treesColumn, 68096);
        this.treeGridDataLower = new GridData(1, 128, true, false);
        this.treeGridDataLower.heightHint = -1;
        this.treeGridDataLower.widthHint = -1;
        this.additionalTree.setLayoutData((Object)this.treeGridDataLower);
        this.additionalTree.setLinesVisible(true);
        this.additionalTree.setHeaderVisible(true);
        this.additionalViewer = new TreeViewer(this.additionalTree);
        return section;
    }

    public Pie getModel() {
        return this.startModel;
    }

    public void doubleClicked(String elementName, Object[] row) {
    }

    @Override
    public void forceRepaint() {
        this.setSelectedChart(this.getModel());
    }

    public void copyToClipboard() {
        Clipboard clipboard = new Clipboard(this.managedForm.getForm().getDisplay());
        Image image = null;
        image = new Image((Device)this.managedForm.getForm().getDisplay(), this.managedForm.getForm().getBounds());
        GC gc = new GC((Drawable)this.managedForm.getForm());
        gc.copyArea(image, 0, 0);
        gc.dispose();
        clipboard.setContents(new Object[]{image.getImageData()}, (Transfer[])new ImageTransfer[]{ImageTransfer.getInstance()});
        image.dispose();
        clipboard.dispose();
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this.startModel.getUniqueRecord());
    }

    public PieEditorItem getInternalSelection() {
        StructuredSelection sle = (StructuredSelection)this.treeViewer.getSelection();
        return sle.isEmpty() ? null : (PieEditorItem)sle.getFirstElement();
    }

    public void setSelectedChart(Pie model) {
        this.startModel = model;
        model.establishVariance();
        if (this.startModel != null) {
            this.treeSection.setRedraw(false);
            for (ColumnDefinition defn : this.startModel.getCompleteValues().keySet()) {
                if (this.mapping.containsKey(defn)) continue;
                this.mapping.put(defn, this.startModel.getCompleteValues().get(defn));
            }
            model.establishVariance().populateTreeViewer(this.additionalViewer, this.mapping, this.includeButton.getSelection(), this.restrictButton.getSelection());
            this.currentDefinition = this.startModel.getChartReference();
            this.resetTreeColumns(this.currentDefinition);
            this.treeContent.includeNonZeroValues(this.includeButton.getSelection());
            this.treeContent.restrictToCurrentChart(this.restrictButton.getSelection());
            this.treeViewer.setInput((Object)PieEditorItem.createRootFor(this.currentDefinition, this.mapping, this.includeButton.getSelection(), this.restrictButton.getSelection()));
            this.treeViewer.expandAll();
            this.setSelection(this.getSelection());
            this.treeSection.setDescription(this.startModel.isNoHeader() ? this.startModel.getPrimaryLabel() : this.bigPie.getDescription());
            this.treeSection.setText(this.currentDefinition.getTitle());
            this.treeGridDataTop.heightHint = -1;
            this.managedForm.reflow(true);
            this.treesColumn.layout();
            this.treeSection.setRedraw(true);
        }
    }

    public void setSelection(ISelection selection) {
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Iterator<ISelectionChangedListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ISelectionChangedListener listener;
            final ISelectionChangedListener finalListener = listener = iterator.next();
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    finalListener.selectionChanged(event);
                }
            });
        }
    }

    protected String getHelpContextId() {
        return "com.ibm.cics.pa.ui.pie_editor";
    }

    protected void createFormContent() {
        ScrolledForm form = this.managedForm.getForm();
        ColumnLayout layout = new ColumnLayout();
        layout.topMargin = 0;
        layout.bottomMargin = 5;
        layout.leftMargin = 10;
        layout.rightMargin = 10;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        layout.maxNumColumns = 1;
        layout.minNumColumns = 1;
        form.getBody().setLayout((Layout)layout);
        this.setTitleToolTip(this.startModel.getUniqueRecord().getDataKey().getColumnDescriptiveFullReference());
        form.setImage(this.elementImage);
        String description = MessageFormat.format(Messages.getString("PieEditor.TRAN_DETAIL_FOR"), this.startModel.getUniqueRecord().getDataKey().getFullDescriptiveReference());
        form.setText(description);
        form.setToolTipText(this.startModel.getUniqueRecord().getDataKey().getColumnDescriptiveFullReference());
        if (this.getDataProvider() != null) {
            if (this.getDataProvider() != null) {
                this.getDataProvider().incrementUseCount();
            }
            this.resourceListener = new PAResourceChangeListener((IViewPart)this, (IPath)new Path(this.getDataProvider().getFileReference()));
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
        }
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new Action(){

            public String getId() {
                return ActionFactory.COPY.getId();
            }

            public String getActionDefinitionId() {
                return ActionFactory.COPY.getId();
            }

            public void run() {
                PieView.this.copyToClipboard();
            }
        });
        this.getViewSite().getActionBars().updateActionBars();
        if (!this.startModel.isNoHeader()) {
            this.waitSection = this.createWaitAnalysisSection(this.managedForm, 66);
            this.headerSection = this.createHeaderSection(this.managedForm, 66);
            this.treeSection = this.createMainSection(this.managedForm, 64);
            this.viewerHeader.addFocusListener(this.focusListener);
        } else {
            this.treeSection = this.createMainSection(this.managedForm, 64);
            this.currentDefinition = this.startModel.getChartReference();
        }
        this.treeSection.addFocusListener(this.focusListener);
        this.viewer.addFocusListener(this.focusListener);
        this.managedForm.reflow(true);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this);
    }

    private GenericDataProvider getDataProvider() {
        if (this.getModel() != null) {
            return this.getModel().getDataProvider();
        }
        return null;
    }

    private void resetTreeColumns(ChartSpecification definition) {
        String[] tooltips = ((PieChartSpecificDefinitions)definition.getSpecificType()).getTooltips();
        String[] headers = ((PieChartSpecificDefinitions)definition.getSpecificType()).getHeadings();
        TreeColumn[] baseColumns = this.treeViewer.getTree().getColumns();
        int defaultWidth = 125;
        int i = 0;
        while (i < headers.length) {
            if (headers[i].length() == 0) {
                defaultWidth += 62;
            }
            ++i;
        }
        i = headers.length;
        while (i < baseColumns.length) {
            baseColumns[i].setWidth(0);
            ++i;
        }
        i = 0;
        while (i < headers.length) {
            baseColumns[i].setText(headers[i]);
            baseColumns[i].setToolTipText(tooltips[i]);
            if (headers[i].length() == 0) {
                baseColumns[i].setWidth(0);
            } else if (i != 0) {
                baseColumns[i].setWidth(defaultWidth);
                baseColumns[i].setAlignment(131072);
            }
            ++i;
        }
    }

    private void createColumnReference() {
        this.mapping.clear();
        if (this.getModel() != null) {
            ColumnDefinition[] definitions = this.getModel().getDataProvider().getColumnDefinitions();
            int i = 0;
            while (i < definitions.length) {
                this.mapping.put(definitions[i], this.getModel().getRow()[i]);
                ++i;
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void adjustTreeSelection(ColumnContainment containment) {
        PieEditorItem sel = ((PieEditorItem)this.treeViewer.getInput()).findChild(containment);
        if (sel != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)sel));
        }
    }

    public void adjustTreeSelection(ColumnDefinition definition) {
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)((PieEditorItem)this.treeViewer.getInput()).findChild(definition)));
    }

    public String getPartProperty(String key) {
        if (IConnectionCategory.class.getName().equals(key)) {
            return "com.ibm.cics.pa.connection";
        }
        return super.getPartProperty(key);
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.linkToSelectionAction = new Action(Messages.getString("Button.linkto"), 2){

            public void run() {
                PieView.this.isLinkedToSelection = PieView.this.linkToSelectionAction.isChecked();
            }

            public ImageDescriptor getImageDescriptor() {
                return com.ibm.cics.eclipse.common.Activator.IMGD_LINK_TO_SELECTION;
            }
        };
        this.linkToSelectionAction.setChecked(true);
    }

    protected void fillActionBar(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        this.fillToolBar(toolBar);
    }

    protected void fillToolBar(IToolBarManager toolBar) {
        if (this.linkToSelectionAction != null) {
            toolBar.add(this.linkToSelectionAction);
        }
    }

    protected void addSelectionListener() {
        debug.enter("addSelectionListener");
        if (this.selectionListener == null) {
            this.selectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    Object inputObject;
                    if (PieView.this.isLinkedToSelection && selection instanceof StructuredSelection && (inputObject = ((StructuredSelection)selection).getFirstElement()) != PieView.this.existingInput) {
                        PieView.this.setInput(inputObject);
                    }
                }
            };
            IWorkbenchWindow workbenchWindow = this.getSite().getWorkbenchWindow();
            workbenchWindow.getSelectionService().addSelectionListener("com.ibm.cics.pa.ui.sheeteditor", this.selectionListener);
            workbenchWindow.getSelectionService().addSelectionListener("com.ibm.cics.pa.ui.sheeteditor_multi", this.selectionListener);
        }
        debug.exit("addSelectionListener");
    }

    protected void setInput(Object nextModel) {
        if (!this.managedForm.getForm().isDisposed() && nextModel != null) {
            String id;
            ChartSpecification defn;
            if (nextModel instanceof Pie) {
                this.existingInput = ((Pie)nextModel).getUniqueRecord();
                this.startModel = (Pie)nextModel;
            } else if (nextModel instanceof IUniqueRecord && ((IUniqueRecord)nextModel).getSourceProvider().getDataProviderKey() == DataProviderKey.STARTTIME_APPLID_TRAN) {
                this.existingInput = (IUniqueRecord)nextModel;
                defn = this.startModel != null ? this.startModel.getChartReference() : AbstractChartDefinition.getByName("HST_RMI_pie");
                id = ChartManager.getInstance().createChart(defn, ((IUniqueRecord)nextModel).getSourceProvider(), null, (IUniqueRecord)nextModel, null);
                this.startModel = (Pie)Chart.getReference(id);
            } else if (nextModel instanceof IUniqueRecord && ((IUniqueRecord)nextModel).getSourceProvider().getDataProviderKey() == DataProviderKey.STARTTIME_APPLICATION) {
                this.existingInput = (IUniqueRecord)nextModel;
                defn = this.startModel != null ? this.startModel.getChartReference() : AbstractChartDefinition.getByName("HST_APP_Threadsafe_pie");
                id = ChartManager.getInstance().createChart(defn, ((IUniqueRecord)nextModel).getSourceProvider(), null, (IUniqueRecord)nextModel, null);
                this.startModel = (Pie)Chart.getReference(id);
            } else {
                return;
            }
            String description = this.startModel.getUniqueRecord().getDataKey().getColumnDescriptiveFullReference();
            this.setContentDescription(description);
            String label = this.startModel.getUniqueRecord().getLabel().toString();
            if (StringUtil.hasContent((String)label)) {
                this.setPartName(label);
            }
            this.setTitleToolTip(description);
            if (this.managedForm != null) {
                if (description.length() > 100) {
                    FontData[] fd = this.managedForm.getForm().getFont().getFontData();
                    fd[0].setHeight(10);
                    this.smallerFont = new Font((Device)Display.getDefault(), fd);
                    this.managedForm.getForm().setFont(this.smallerFont);
                }
                this.managedForm.getForm().setText(description);
            }
            this.createColumnReference();
            if (this.bigPie != null) {
                if (this.headerSection != null && this.waitFigure != null) {
                    WaitAnalysis wModel = new WaitAnalysis(this.startModel);
                    if (wModel.isReliable()) {
                        this.bigPie.initialiseComponents(this.startModel);
                    }
                    this.headerSection.initialiseFigures(this, this.startModel, this.bigPie);
                    this.waitFigure.setModel(wModel);
                } else {
                    this.bigPie.initialiseSingleComponent(this.startModel);
                }
            }
        }
    }

    protected void removeSelectionListener() {
        debug.enter("removeSelectionListener");
        if (this.selectionListener != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener("com.ibm.cics.pa.ui.sheeteditor_multi", this.selectionListener);
            this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener("com.ibm.cics.pa.ui.sheeteditor", this.selectionListener);
            this.selectionListener = null;
        }
        debug.exit("removeSelectionListener");
    }

    protected void addPartListener() {
        debug.enter("addPartListener");
        IWorkbenchWindow workbenchWindow = this.getSite().getWorkbenchWindow();
        this.partListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference part) {
                IWorkbenchPart workbenchPart = part.getPart(false);
            }

            public void partBroughtToTop(IWorkbenchPartReference part) {
                IWorkbenchPart workbenchPart = part.getPart(false);
            }

            public void partClosed(IWorkbenchPartReference part) {
                IWorkbenchPart workbenchPart = part.getPart(false);
                if (workbenchPart == PieView.this) {
                    PieView.this.removePartListener();
                    PieView.this.removeSelectionListener();
                }
            }

            public void partDeactivated(IWorkbenchPartReference part) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
                IWorkbenchPart workbenchPart = partRef.getPart(false);
                if (workbenchPart == PieView.this) {
                    PieView.this.removeSelectionListener();
                }
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference part) {
                IWorkbenchPart workbenchPart = part.getPart(false);
            }

            public void partVisible(IWorkbenchPartReference partRef) {
                IWorkbenchPart workbenchPart = partRef.getPart(false);
                if (workbenchPart == PieView.this) {
                    PieView.this.addSelectionListener();
                }
            }
        };
        workbenchWindow.getPartService().addPartListener(this.partListener);
        debug.exit("addPartListener");
    }

    protected void removePartListener() {
        debug.enter("removePartListener");
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
        debug.exit("removePartListener");
    }

    private Section createWaitAnalysisSection(IManagedForm managedForm, int expanded) {
        Section section = null;
        final WaitAnalysis model = new WaitAnalysis(this.startModel);
        if (model.isReliable()) {
            final ScrolledForm form = managedForm.getForm();
            FormToolkit toolkit = managedForm.getToolkit();
            section = toolkit.createSection(form.getBody(), 0x100 | expanded);
            section.setText(Messages.getString("PiePage.wait.Overview"));
            section.setDescription(Messages.getString("PiePage.NO_RECORDED_DATA"));
            section.marginWidth = 5;
            section.marginHeight = 0;
            section.setLayout((Layout)new GridLayout());
            section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    form.reflow(false);
                }
            });
            this.graphicalViewerLine = new ScrollingGraphicalViewer();
            this.viewerHeader = (FigureCanvas)this.graphicalViewerLine.createControl((Composite)section);
            this.viewerHeader.getViewport().setPreferredSize(new Dimension(800, 125));
            LightweightSystem lws = new LightweightSystem((Canvas)this.viewerHeader);
            toolkit.adapt((Composite)this.viewerHeader);
            section.setClient((Control)this.viewerHeader);
            section.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = Messages.getString("PiePage.wait.Overview");
                }
            });
            this.waitFigure = new WaitAnalysisFigure((GraphicalViewer)this.graphicalViewerLine, model);
            section.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = model.getAccessibleMessage();
                }
            });
            this.viewerHeader.getViewport().setContents((IFigure)this.waitFigure);
            lws.setContents((IFigure)this.waitFigure);
        } else {
            ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)Messages.getString("PlotView.insufficient.data"));
            this.closeMeAgain(this);
        }
        return section;
    }

    @Override
    public void disconnected() {
        Job job = new Job(Messages.getString("Resource.status.disconnected")){

            protected IStatus run(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PieView.this.getViewSite().getPage().hideView((IViewPart)PieView.this);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
    }

    @Override
    public void connected(PAConnectionListener.Era era) {
    }

    @Override
    public void disconnecting() {
    }
}

