/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views;

import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.ColumnContainment;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.PieChartSpecificDefinitions;
import com.ibm.cics.pa.ui.editors.PieEditorItem;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class PieEditorContentProvider
implements ITreeContentProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean restrictToCurrentChart;
    private boolean includeNonZeroValues;
    private Map<ColumnDefinition, Object> mapping;

    public PieEditorContentProvider(Map<ColumnDefinition, Object> mapping) {
        this.mapping = mapping;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ChartSpecification) {
            PieChartSpecificDefinitions specifics = (PieChartSpecificDefinitions)((ChartSpecification)parentElement).getSpecificType();
            if (specifics.getContainments().length > 0) {
                return specifics.getContainments();
            }
            return this.purgeZeros(specifics.getPrimaryColumns());
        }
        if (parentElement instanceof ColumnDefinition && !this.restrictToCurrentChart) {
            ColumnContainment containment = ColumnContainment.getByColumnDefinition((ColumnDefinition)parentElement);
            if (containment != null) {
                return this.purgeZeros(containment.getColumnRef());
            }
        } else {
            if (parentElement instanceof PieEditorItem) {
                return ((PieEditorItem)parentElement).getChildren();
            }
            if (parentElement instanceof ColumnContainment) {
                if (((ColumnContainment)parentElement).getColumnRef().length > 0) {
                    return this.purgeZeros(((ColumnContainment)parentElement).getColumnRef());
                }
                return this.purgeZeros(new ColumnDefinition[]{((ColumnContainment)parentElement).getPrimary()});
            }
        }
        return null;
    }

    private Object[] purgeZeros(ColumnDefinition[] columns) {
        if (this.includeNonZeroValues) {
            return columns;
        }
        ArrayList<ColumnDefinition> revisedList = new ArrayList<ColumnDefinition>();
        ColumnDefinition[] columnDefinitionArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition column = columnDefinitionArray[n2];
            Object value = this.mapping.get(column);
            if (value != null && value instanceof Number && ((Number)value).doubleValue() != 0.0) {
                revisedList.add(column);
            }
            ++n2;
        }
        return revisedList.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        Object[] kids = this.getChildren(element);
        return kids != null && kids.length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void restrictToCurrentChart(boolean selection) {
        this.restrictToCurrentChart = selection;
    }

    public void includeNonZeroValues(boolean selection) {
        this.includeNonZeroValues = selection;
    }
}

