/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.dbfunc.command.Engine;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.command.RowProcessor;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.ConstraintElement;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.eclipse.common.ui.Utilities;
import com.ibm.cics.pa.comm.PASelectionContext;
import com.ibm.cics.pa.model.DateCaveat;
import com.ibm.cics.pa.model.IntervalsCaveat;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.NullRangeDateCaveat;
import com.ibm.cics.pa.model.OverviewApplidElement;
import com.ibm.cics.pa.model.OverviewCountedApplicationElement;
import com.ibm.cics.pa.model.OverviewCountedElement;
import com.ibm.cics.pa.model.RangeDateCaveat;
import com.ibm.cics.pa.model.SimpleTreeElement;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.TableCategorisationEnum;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.PAContextTracker;
import com.ibm.cics.pa.ui.dialogs.PATreeColumnViewerLabelProvider;
import com.ibm.cics.pa.ui.dialogs.TableSelectorContentProvider;
import com.ibm.cics.pa.ui.dialogs.TimelineAssistDialog;
import com.ibm.cics.pa.ui.handlers.PAContextListener;
import com.ibm.cics.pa.ui.remote.PAConnectionListener;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.sm.comm.IContext;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.services.IEvaluationService;

public class Overview
extends ViewPart
implements PAContextListener,
PAConnectionListener,
TimelineAssistDialog.DateChangeListener,
ISelectionProvider,
ISelectionListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    TableViewer applidTableViewer;
    TableViewer transactionTableViewer;
    TableViewer platformTableViewer;
    TableViewer applicationTableViewer;
    TableViewer versionTableViewer;
    TableViewer operationTableViewer;
    TreeViewer navigatorTreeViewer;
    private SashForm performanceSash;
    private Composite topComposite;
    private Composite bottomComposite;
    private Composite middleComposite;
    Composite quickWrapper;
    Collection<ISelectionChangedListener> selectionListeners = new HashSet<ISelectionChangedListener>();
    private Text transactionText = null;
    private Text applidText = null;
    private Text platformText = null;
    private Text applicationText = null;
    private Text versionText = null;
    private Text operationText = null;
    Label treeText = null;
    private Image image1 = Activator.getDefault().getImage("table");
    private Image image2 = Activator.getDefault().getImage("smfcategory");
    ISelection currentSelection = StructuredSelection.EMPTY;
    private ColumnDefinition resourceColumn = ColumnDefinition.TRAN;
    ActiveViewer activeViewer = null;
    TreeViewer treeViewer;
    DeferredTreeContentManager manager;
    Composite dateDetail;
    private Hyperlink dateDetailLabel1;
    private Hyperlink dateDetailLabel2;
    int charWidth;
    private Composite performanceParent;
    private Composite platformParent;
    private GridData dataPriority;
    GridData dataLesser;
    private SashForm applicationSash;
    private Composite topCompositeApp;
    private Composite middleCompositeApp;
    private Composite bottomCompositeApp;
    private Composite subCompositeApp;
    TabFolder doubleParent;
    private Composite mainParent;
    private Composite tableParent;
    Composite gridParent;
    private Job job;
    boolean pendingTreeQuery = false;
    boolean currentMode;
    Boolean disconnecting = false;
    Engine applidEngine;
    Engine tranEngine;
    Engine platformEngine;
    Engine appEngine;
    Engine versionEngine;
    Engine operationEngine;
    ManifestRecord navigatorSelectedrecord;
    ManifestRecord oldrecord;
    private TabItem tablesTab;
    private TabItem recordsTab;
    StyledText tableLabel1;
    private Composite dateParent;
    private Action resetColumnsAction;
    private StyledText recordsFeedback;
    FilteredTree filteredTree;

    public void createPartControl(Composite singleParent) {
        GridLayout background = new GridLayout();
        background.marginHeight = 0;
        background.horizontalSpacing = 0;
        background.verticalSpacing = 0;
        background.marginWidth = 0;
        GridLayout background2 = new GridLayout();
        background2.numColumns = 2;
        singleParent.setLayout((Layout)background);
        this.gridParent = new Composite(singleParent, 0);
        this.gridParent.setLayout((Layout)background);
        this.gridParent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.doubleParent = new TabFolder(this.gridParent, 0);
        GridData span2 = new GridData(4, 4, true, true);
        span2.horizontalSpan = 2;
        this.doubleParent.setLayoutData((Object)span2);
        this.tablesTab = new TabItem(this.doubleParent, 0);
        this.tablesTab.setText(Messages.getString("CICS.SMF.Tables"));
        this.tablesTab.setImage(this.image2);
        this.recordsTab = new TabItem(this.doubleParent, 0);
        this.recordsTab.setText(Messages.getString("Selected.Records"));
        this.recordsTab.setImage(this.image1);
        this.tableParent = new Composite((Composite)this.doubleParent, 0);
        this.tableParent.setLayout((Layout)background);
        this.tableParent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tablesTab.setControl((Control)this.tableParent);
        this.createNavigatorComposite(this.tableParent);
        this.dateParent = new Composite((Composite)this.doubleParent, 0);
        this.dateParent.setLayout((Layout)background);
        this.dateParent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mainParent = new Composite((Composite)this.doubleParent, 0);
        this.mainParent.setLayout((Layout)background);
        this.mainParent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.recordsTab.setControl((Control)this.mainParent);
        this.dataPriority = new GridData();
        this.dataPriority.grabExcessHorizontalSpace = true;
        this.dataPriority.grabExcessVerticalSpace = true;
        this.dataPriority.verticalAlignment = 4;
        this.dataPriority.horizontalAlignment = 4;
        this.dataPriority.exclude = false;
        this.dataLesser = new GridData();
        this.dataLesser.grabExcessHorizontalSpace = false;
        this.dataLesser.grabExcessVerticalSpace = false;
        this.dataLesser.verticalAlignment = 1;
        this.dataLesser.horizontalAlignment = 1;
        this.dataLesser.exclude = true;
        this.dataLesser.heightHint = 0;
        this.dataLesser.widthHint = 0;
        this.createHeaderDetail(this.mainParent);
        this.doubleParent.setSelection(this.tablesTab);
        this.doubleParent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Overview.this.doubleParent.getSelectionIndex() == 0) {
                    TableCategorisationEnum[] container;
                    Overview.this.updateFeedback(true);
                    if (Overview.this.filteredTree.getFilterControl().isEnabled() && (container = TableCategorisationEnum.findlevel2Parent(Overview.this.oldrecord.getAlias())) != null) {
                        TableCategorisationEnum[] tableCategorisationEnumArray = container;
                        int n = container.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableCategorisationEnum enumeration = tableCategorisationEnumArray[n2];
                            Overview.this.navigatorTreeViewer.setExpandedState((Object)enumeration, true);
                            ++n2;
                        }
                        Overview.this.navigatorTreeViewer.setSelection((ISelection)new StructuredSelection((Object)Overview.this.oldrecord), true);
                    }
                } else {
                    Overview.this.applyTable(Overview.this.navigatorSelectedrecord);
                }
            }
        });
        this.performanceParent = this.createPerformanceComposite(this.mainParent);
        this.platformParent = this.createApplicationComposite(this.mainParent);
        if (PAContextTracker.getInstance().isInitialised()) {
            this.tableSelected(PAContextTracker.getInstance().getCurrentManifest());
        }
        this.setOldStyle(true);
        this.currentMode = Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "MODE_OVERVIEW", false, null);
        TimelineAssistDialog.getInstance().addDateChangeListener(this);
        this.makeActions(this.getViewSite().getWorkbenchWindow());
        this.fillActionBar(this.getViewSite().getActionBars());
        this.fillViewMenuDropdown(this.getViewSite().getActionBars().getMenuManager());
    }

    public void doCompositeSwitch(int page) {
        this.doubleParent.setSelection(page == 0 ? this.tablesTab : this.recordsTab);
        if (page == 1) {
            this.applyTable(this.navigatorSelectedrecord);
        } else {
            this.updateFeedback(false);
        }
    }

    private Composite createApplicationComposite(Composite mainParent) {
        Composite pp = new Composite(mainParent, 0);
        GridData data1 = new GridData();
        data1.grabExcessHorizontalSpace = true;
        data1.grabExcessVerticalSpace = true;
        data1.verticalAlignment = 4;
        data1.horizontalAlignment = 4;
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pp.setLayout((Layout)layout);
        this.applicationSash = new SashForm(pp, 512);
        this.applicationSash.setVisible(true);
        this.applicationSash.setLayoutData((Object)data1);
        this.applicationSash.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
            }
        });
        this.topCompositeApp = new Composite((Composite)this.applicationSash, 0);
        this.topCompositeApp.setLayout((Layout)layout);
        this.middleCompositeApp = new Composite((Composite)this.applicationSash, 0);
        this.middleCompositeApp.setLayout((Layout)layout);
        this.bottomCompositeApp = new Composite((Composite)this.applicationSash, 0);
        this.bottomCompositeApp.setLayout((Layout)layout);
        this.subCompositeApp = new Composite((Composite)this.applicationSash, 0);
        this.subCompositeApp.setLayout((Layout)layout);
        this.applicationSash.setWeights(new int[]{25, 25, 25, 25});
        this.createPlatformControl(this.topCompositeApp);
        this.createApplicationControl(this.middleCompositeApp);
        this.createApplicationVersionControl(this.bottomCompositeApp);
        this.createApplicationOperationControl(this.subCompositeApp);
        GridData data3 = new GridData();
        data3.grabExcessHorizontalSpace = true;
        data3.grabExcessVerticalSpace = false;
        data3.verticalAlignment = 3;
        data3.horizontalAlignment = 4;
        Label separator = new Label(this.bottomCompositeApp, 258);
        separator.setLayoutData((Object)data3);
        separator = new Label(this.subCompositeApp, 258);
        separator.setLayoutData((Object)data3);
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        Menu popUpMenu = menuManager.createContextMenu((Control)this.platformTableViewer.getTable());
        this.platformTableViewer.getTable().setMenu(popUpMenu);
        this.getSite().registerContextMenu("com.ibm.cics.pa.ui.overview.platform", menuManager, (ISelectionProvider)this.platformTableViewer);
        MenuManager menuManager1 = new MenuManager();
        menuManager1.setRemoveAllWhenShown(true);
        Menu popUpMenu1 = menuManager1.createContextMenu((Control)this.applicationTableViewer.getTable());
        this.applicationTableViewer.getTable().setMenu(popUpMenu1);
        this.getSite().registerContextMenu("com.ibm.cics.pa.ui.overview.application", menuManager1, (ISelectionProvider)this.applicationTableViewer);
        MenuManager menuManager2 = new MenuManager();
        menuManager2.setRemoveAllWhenShown(true);
        Menu popUpMenu2 = menuManager2.createContextMenu((Control)this.versionTableViewer.getTable());
        this.versionTableViewer.getTable().setMenu(popUpMenu2);
        this.getSite().registerContextMenu("com.ibm.cics.pa.ui.overview.version", menuManager2, (ISelectionProvider)this.versionTableViewer);
        MenuManager menuManager3 = new MenuManager();
        menuManager3.setRemoveAllWhenShown(true);
        Menu popUpMenu3 = menuManager3.createContextMenu((Control)this.operationTableViewer.getTable());
        this.operationTableViewer.getTable().setMenu(popUpMenu3);
        this.getSite().registerContextMenu("com.ibm.cics.pa.ui.overview.operation", menuManager3, (ISelectionProvider)this.operationTableViewer);
        ICommandService cs = (ICommandService)this.getSite().getService(ICommandService.class);
        cs.refreshElements("com.ibm.cics.pa.ui.commands.interval", null);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pp, this.getHelpContextId());
        this.getViewSite().setSelectionProvider((ISelectionProvider)this);
        PAContextTracker.getInstance().addPAContextListenerListener(this);
        PAConnectionTracker.getInstance().addPAConnectionTrackerListener(this);
        this.platformTableViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (Overview.this.activeViewer != ActiveViewer.platform) {
                    Overview.this.activeViewer = ActiveViewer.platform;
                    Overview.this.setSelection(Overview.this.platformTableViewer.getSelection());
                }
            }
        });
        this.applicationTableViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (Overview.this.activeViewer != ActiveViewer.application) {
                    Overview.this.activeViewer = ActiveViewer.application;
                    Overview.this.setSelection(Overview.this.applicationTableViewer.getSelection());
                }
            }
        });
        this.versionTableViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (Overview.this.activeViewer != ActiveViewer.version) {
                    Overview.this.activeViewer = ActiveViewer.version;
                    Overview.this.setSelection(Overview.this.versionTableViewer.getSelection());
                }
            }
        });
        this.operationTableViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (Overview.this.activeViewer != ActiveViewer.operation) {
                    Overview.this.activeViewer = ActiveViewer.operation;
                    Overview.this.setSelection(Overview.this.operationTableViewer.getSelection());
                }
            }
        });
        return pp;
    }

    private Composite createPerformanceComposite(Composite mainParent) {
        Composite performanceP = new Composite(mainParent, 0);
        GridData data1 = new GridData();
        data1.grabExcessHorizontalSpace = true;
        data1.grabExcessVerticalSpace = true;
        data1.verticalAlignment = 4;
        data1.horizontalAlignment = 4;
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        performanceP.setLayout((Layout)layout);
        this.performanceSash = new SashForm(performanceP, 512);
        this.performanceSash.setVisible(true);
        this.performanceSash.setLayoutData((Object)data1);
        this.topComposite = new Composite((Composite)this.performanceSash, 0);
        this.topComposite.setLayout((Layout)layout);
        this.middleComposite = new Composite((Composite)this.performanceSash, 0);
        this.middleComposite.setLayout((Layout)layout);
        this.bottomComposite = new Composite((Composite)this.performanceSash, 0);
        this.bottomComposite.setLayout((Layout)layout);
        this.bottomComposite.setLayoutData((Object)data1);
        this.performanceSash.setWeights(this.getSashWeight(null));
        this.createApplidControl(this.topComposite);
        this.createTransactionControl(this.middleComposite);
        this.createTreeControl(this.bottomComposite);
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        Menu popUpMenu = menuManager.createContextMenu((Control)this.applidTableViewer.getTable());
        this.applidTableViewer.getTable().setMenu(popUpMenu);
        this.getSite().registerContextMenu("com.ibm.cics.pa.ui.overview.applid", menuManager, (ISelectionProvider)this.applidTableViewer);
        MenuManager menuManager1 = new MenuManager();
        menuManager1.setRemoveAllWhenShown(true);
        Menu popUpMenu1 = menuManager1.createContextMenu((Control)this.transactionTableViewer.getTable());
        this.transactionTableViewer.getTable().setMenu(popUpMenu1);
        this.getSite().registerContextMenu("com.ibm.cics.pa.ui.overview.resource", menuManager1, (ISelectionProvider)this.transactionTableViewer);
        ICommandService cs = (ICommandService)this.getSite().getService(ICommandService.class);
        cs.refreshElements("com.ibm.cics.pa.ui.commands.interval", null);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)performanceP, this.getHelpContextId());
        this.getViewSite().setSelectionProvider((ISelectionProvider)this);
        PAContextTracker.getInstance().addPAContextListenerListener(this);
        PAConnectionTracker.getInstance().addPAConnectionTrackerListener(this);
        this.transactionTableViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (Overview.this.activeViewer != ActiveViewer.transaction) {
                    Overview.this.activeViewer = ActiveViewer.transaction;
                    Overview.this.setSelection(Overview.this.transactionTableViewer.getSelection());
                }
            }
        });
        this.applidTableViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (Overview.this.activeViewer != ActiveViewer.applid) {
                    Overview.this.activeViewer = ActiveViewer.applid;
                    Overview.this.setSelection(Overview.this.applidTableViewer.getSelection());
                    Overview.this.applidTableViewer.getSelection().isEmpty();
                }
            }
        });
        this.treeViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (Overview.this.activeViewer != ActiveViewer.tree) {
                    Overview.this.activeViewer = ActiveViewer.tree;
                    Overview.this.setSelection(Overview.this.treeViewer.getSelection());
                }
            }
        });
        return performanceP;
    }

    public void dispose() {
        if (this.job != null) {
            this.job.cancel();
        }
        TimelineAssistDialog.getInstance().removeDateChangeListener(this);
        PAContextTracker.getInstance().removePAContextListenerListener(this);
        PAConnectionTracker.getInstance().removePAConnectionTrackerListener(this);
        super.dispose();
    }

    private String getHelpContextId() {
        return "com.ibm.cics.pa.ui.overview";
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void setFocus() {
        if (this.doubleParent.getSelectionIndex() == 0) {
            this.navigatorTreeViewer.getTree().setFocus();
        } else if (this.activeViewer == ActiveViewer.applid) {
            this.applidTableViewer.getTable().setFocus();
        } else if (this.activeViewer == ActiveViewer.transaction) {
            this.transactionTableViewer.getTable().setFocus();
        } else if (this.activeViewer == ActiveViewer.application) {
            this.applicationTableViewer.getTable().setFocus();
        } else if (this.activeViewer == ActiveViewer.platform) {
            this.platformTableViewer.getTable().setFocus();
        } else if (this.activeViewer == ActiveViewer.version) {
            this.versionTableViewer.getTable().setFocus();
        } else if (this.activeViewer == ActiveViewer.operation) {
            this.operationTableViewer.getTable().setFocus();
        } else if (this.activeViewer == ActiveViewer.tree) {
            this.treeViewer.getTree().setFocus();
        } else {
            this.applidText.setFocus();
        }
    }

    private void createHeaderDetail(Composite parent) {
        this.tableLabel1 = new StyledText(parent, 72);
        this.recordsFeedback.setBackground(parent.getBackground());
        this.tableLabel1.setBackground(parent.getBackground());
        this.tableLabel1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.tableLabel1.setText(Messages.getString("No.table"));
        this.tableLabel1.setToolTipText(Messages.getString("No.table"));
        this.tableLabel1.setEditable(false);
        this.tableLabel1.setEnabled(false);
        StyleRange range = new StyleRange(0, 0, null, null);
        this.tableLabel1.setStyleRange(range);
        this.dateDetail = new Composite(parent, 0);
        GridLayout background2 = new GridLayout();
        background2.numColumns = 2;
        this.dateDetail.setLayout((Layout)background2);
        this.dateDetail.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout background = new GridLayout();
        background.marginHeight = 0;
        background.horizontalSpacing = 0;
        background.verticalSpacing = 0;
        background.marginWidth = 0;
        Button contextLabel = new Button(this.dateDetail, 0x800008);
        contextLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        contextLabel.setImage(Activator.getDefault().getImage(Activator.IMGD_DATE));
        contextLabel.setToolTipText(Messages.getString("command.dates"));
        contextLabel.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.getString("command.dates");
            }
        });
        Composite tableComposite = new Composite(this.dateDetail, 0);
        tableComposite.setLayout((Layout)background);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        contextLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimelineAssistDialog.getInstance().openDialog();
            }
        });
        this.dateDetailLabel1 = new Hyperlink(tableComposite, 0);
        this.dateDetailLabel1.setLayoutData((Object)new GridData(4, 4, true, false));
        this.dateDetailLabel1.setForeground(this.dateDetailLabel1.getDisplay().getSystemColor(9));
        this.dateDetailLabel1.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TimelineAssistDialog.getInstance().openDialog();
            }
        });
        this.dateDetailLabel2 = new Hyperlink(tableComposite, 0);
        this.dateDetailLabel2.setLayoutData((Object)new GridData(4, 4, true, false));
        this.dateDetailLabel2.setForeground(this.dateDetailLabel2.getDisplay().getSystemColor(9));
        this.dateDetailLabel2.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TimelineAssistDialog.getInstance().openDialog();
            }
        });
        this.dateDetailLabel1.setText("");
        this.dateDetailLabel1.setToolTipText("");
        this.dateDetailLabel2.setText("");
        this.dateDetailLabel2.setToolTipText("");
        this.dateDetail.setVisible(true);
        this.datesUpdated(TimelineAssistDialog.getInstance().getDateCaveat());
    }

    private void createApplidControl(Composite parent) {
        this.applidText = this.createToolbar(parent, ColumnDefinition.APPLID);
        GridData data1 = new GridData();
        data1.grabExcessHorizontalSpace = true;
        data1.grabExcessVerticalSpace = true;
        data1.verticalAlignment = 4;
        data1.horizontalAlignment = 4;
        this.applidTableViewer = new TableViewer(parent, 268437506);
        this.applidTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            OverviewApplidElement[] applids = new OverviewApplidElement[0];

            public Object[] getElements(Object inputElement) {
                return this.applids;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput != null) {
                    this.applids = (OverviewApplidElement[])newInput;
                    Overview.this.applidTableViewer.getTable().redraw();
                    Overview.this.applidTableViewer.refresh();
                }
            }
        });
        this.applidTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return Activator.getDefault().getImage("table");
            }

            public String getText(Object element) {
                return element == null ? "" : ((OverviewApplidElement)element).toString();
            }
        });
        this.applidTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().equals(Overview.this.currentSelection)) {
                    Overview.this.runTranQuery(((StructuredSelection)event.getSelection()).toArray());
                    Overview.this.setSelection(event.getSelection());
                    event.getSelection().isEmpty();
                }
            }
        });
        this.applidTableViewer.getTable().setLayoutData((Object)data1);
        Label separator = new Label(parent, 258);
        GridData data2 = new GridData();
        data2.grabExcessHorizontalSpace = true;
        data2.grabExcessVerticalSpace = false;
        data2.verticalAlignment = 3;
        data2.horizontalAlignment = 4;
        separator.setLayoutData((Object)data2);
        parent.layout();
    }

    private void createTransactionControl(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData data2 = new GridData();
        data2.grabExcessHorizontalSpace = true;
        data2.grabExcessVerticalSpace = false;
        data2.verticalAlignment = 1;
        data2.horizontalAlignment = 4;
        separator.setLayoutData((Object)data2);
        this.transactionText = this.createToolbar(parent, ColumnDefinition.TRAN);
        GridData data1 = new GridData();
        data1.grabExcessHorizontalSpace = true;
        data1.grabExcessVerticalSpace = true;
        data1.verticalAlignment = 4;
        data1.horizontalAlignment = 4;
        this.transactionTableViewer = new TableViewer(parent, 268437506);
        this.transactionTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            OverviewApplidElement[] trans = new OverviewApplidElement[0];

            public Object[] getElements(Object inputElement) {
                return this.trans;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.trans = (OverviewApplidElement[])newInput;
                if (newInput != null) {
                    Overview.this.transactionTableViewer.getTable().redraw();
                    Overview.this.transactionTableViewer.refresh();
                }
            }
        });
        this.transactionTableViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                ColumnDefinition[] defns;
                ManifestRecord record = PAContextTracker.getInstance().getCurrentManifest();
                if (record != null && (defns = record.getKey().getColumnDefinitions()).length == 4) {
                    return Activator.getDefault().getImage(defns[3].getDBColumnRef());
                }
                return null;
            }

            public String getText(Object element) {
                return element == null ? "" : String.valueOf(((OverviewApplidElement)element).toString()) + " (" + ' ' + ((OverviewApplidElement)element).getApplid() + ' ' + ((OverviewApplidElement)element).getCount() + ')';
            }
        });
        this.transactionTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().equals(Overview.this.currentSelection)) {
                    Overview.this.setSelection(event.getSelection());
                }
            }
        });
        this.transactionTableViewer.getTable().setLayoutData((Object)data1);
        separator = new Label(parent, 258);
        GridData data3 = new GridData();
        data3.grabExcessHorizontalSpace = true;
        data3.grabExcessVerticalSpace = false;
        data3.verticalAlignment = 3;
        data3.horizontalAlignment = 4;
        separator.setLayoutData((Object)data3);
        parent.layout();
    }

    private void createTreeControl(Composite parent) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"createTreeControl");
        GridData data2 = new GridData();
        data2.grabExcessHorizontalSpace = true;
        data2.grabExcessVerticalSpace = false;
        data2.verticalAlignment = 1;
        data2.horizontalAlignment = 4;
        data2.widthHint = 250;
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)data2);
        data2 = new GridData();
        data2.grabExcessHorizontalSpace = true;
        data2.grabExcessVerticalSpace = false;
        data2.verticalAlignment = 1;
        data2.horizontalAlignment = 4;
        data2.widthHint = 350;
        Composite bounder = new Composite(parent, 0);
        bounder.setLayout((Layout)new GridLayout(2, false));
        this.treeText = new Label(bounder, 0);
        this.treeText.setImage(Activator.getDefault().getImage("ntree"));
        this.treeText = new Label(bounder, 0);
        this.treeText.setLayoutData((Object)data2);
        this.treeText.setText("");
        this.treeViewer = new TreeViewer(parent, 2052);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object sec = ((TreeSelection)event.getSelection()).getFirstElement();
                if (sec != null && sec instanceof SimpleTreeElement) {
                    Overview.this.setSelection((ISelection)new StructuredSelection(sec));
                }
            }
        });
        this.manager = new DeferredTreeContentManager((AbstractTreeViewer)this.treeViewer, this.getSite()){

            protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                if (element instanceof SimpleTreeElement) {
                    return (IDeferredWorkbenchAdapter)element;
                }
                return super.getAdapter(element);
            }
        };
        this.treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return Overview.this.manager.getChildren(parentElement);
            }

            public Object getParent(Object element) {
                if (element instanceof SimpleTreeElement) {
                    return ((SimpleTreeElement)element).getParent();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return Overview.this.manager.mayHaveChildren(element);
            }

            public Object[] getElements(Object inputElement) {
                return Overview.this.manager.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (Overview.this.manager != null) {
                    Overview.this.manager.cancel(oldInput);
                }
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof SimpleTreeElement) {
                    return ((SimpleTreeElement)element).getImage();
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof SimpleTreeElement) {
                    return ((SimpleTreeElement)element).getLabel(element);
                }
                return super.getText(element);
            }
        });
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.update();
            }
        });
        Menu popUpMenu = menuManager.createContextMenu((Control)this.treeViewer.getTree());
        this.treeViewer.getTree().setMenu(popUpMenu);
        this.getViewSite().registerContextMenu("com.ibm.cics.pa.ui.overview.tree", menuManager, (ISelectionProvider)this.treeViewer);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"createTreeControl");
    }

    private Text createToolbar(final Composite parent, final ColumnDefinition defn) {
        GridData data = new GridData(4, 4, true, false);
        GridLayout layout1 = new GridLayout(1, false);
        layout1.marginWidth = 0;
        layout1.marginHeight = 0;
        if (defn == ColumnDefinition.APPLID || defn == ColumnDefinition.ACPLATNM) {
            layout1.marginTop = 5;
        }
        parent.setLayout((Layout)layout1);
        this.quickWrapper = new Composite(parent, 0);
        GridLayout layout4 = new GridLayout(4, false);
        layout4.marginWidth = 2;
        layout4.marginHeight = 2;
        this.quickWrapper.setLayout((Layout)layout4);
        this.quickWrapper.setLayoutData((Object)data);
        Composite b = new Composite(this.quickWrapper, 0){

            public Point computeSize(int hint, int hint2, boolean changed) {
                GC gc = new GC((Drawable)parent);
                int charextent = Math.max(gc.textExtent((String)defn.getLabel(null)).x, 80);
                return super.computeSize(charextent, hint2, changed);
            }
        };
        b.setLayout((Layout)new FillLayout());
        Label transactionLabel = new Label(b, 0);
        transactionLabel.setText(defn.getLabel(null));
        Composite c = new Composite(this.quickWrapper, 0){

            public Point computeSize(int hint, int hint2, boolean changed) {
                Point p = super.computeSize(hint, hint2, changed);
                int factor = 20;
                if (defn == ColumnDefinition.TRAN) {
                    factor = 4;
                } else if (defn == ColumnDefinition.APPLID) {
                    factor = 8;
                }
                return new Point(Math.max(factor * Overview.this.charWidth, 64), p.y);
            }
        };
        c.setLayout((Layout)new FillLayout());
        final Text text = new Text(c, 2048);
        if (defn == ColumnDefinition.TRAN) {
            text.setTextLimit(4);
        } else if (defn == ColumnDefinition.APPLID) {
            text.setTextLimit(8);
        }
        text.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                Overview.this.runFilter(defn);
            }
        });
        text.setToolTipText(String.valueOf(defn.getLabel(null)) + ' ' + Messages.getString("Filter"));
        text.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = String.valueOf(defn.getLabel(null)) + ' ' + Messages.getString("Filter") + ' ' + text.getText();
            }
        });
        ToolBar toolBar1 = new ToolBar(this.quickWrapper, 0x800000);
        ToolBar toolBar2 = new ToolBar(this.quickWrapper, 0x800000);
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        toolBar1.setLayout((Layout)layout2);
        ToolItem typeToolItem1 = new ToolItem(toolBar1, 0x800008);
        typeToolItem1.setImage(Activator.getDefault().getImage("run"));
        typeToolItem1.setToolTipText(Messages.getString("ResourcesView.runFilterAction.tooltip"));
        toolBar1.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.getString("ResourcesView.runFilterAction.tooltip");
            }
        });
        typeToolItem1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"widgetSelected");
                Overview.this.runFilter(defn);
                Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"widgetSelected");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ToolItem typeToolItem2 = new ToolItem(toolBar2, 0x800008);
        typeToolItem2.setToolTipText(Messages.getString("ResourcesView.clearFilterAction.tooltip"));
        typeToolItem2.setImage(Activator.getDefault().getImage("clear"));
        toolBar2.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.getString("ResourcesView.clearFilterAction.tooltip");
            }
        });
        typeToolItem2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                text.setText("");
                Overview.this.runFilter(defn);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                text.setText("");
            }
        });
        this.quickWrapper.setTabList(new Control[]{c, toolBar1, toolBar2});
        return text;
    }

    void runFilter(ColumnDefinition defn) {
        if (PAContextTracker.getInstance().getCurrentManifest() != null && PAConnectionTracker.getInstance().isConnected()) {
            if (defn == ColumnDefinition.APPLID) {
                this.runApplidQuery();
            } else if (defn == ColumnDefinition.TRAN) {
                this.runTranQuery(((StructuredSelection)this.applidTableViewer.getSelection()).toArray());
            } else if (defn == ColumnDefinition.ACPLATNM) {
                this.runPlatformQuery();
            } else if (defn == ColumnDefinition.ACAPPLNM) {
                this.runPlatformApplicationQuery(((StructuredSelection)this.platformTableViewer.getSelection()).toArray());
            } else if (defn == ColumnDefinition.ACAPPLVR) {
                this.runPlatformApplicationVersionQuery(((StructuredSelection)this.versionTableViewer.getSelection()).toArray());
            } else if (defn == ColumnDefinition.ACOPERNM) {
                this.runPlatformApplicationOperationQuery(((StructuredSelection)this.operationTableViewer.getSelection()).toArray());
            }
        }
    }

    private synchronized void runApplidQuery() {
        final StructuredSelection lastSelection = (StructuredSelection)this.applidTableViewer.getSelection();
        final DateCaveat dateToken = TimelineAssistDialog.getInstance().getDateCaveat();
        this.applidTableViewer.setInput((Object)new OverviewApplidElement[0]);
        this.transactionTableViewer.setInput((Object)new OverviewApplidElement[0]);
        this.applidTableViewer.setSelection((ISelection)new StructuredSelection());
        this.applidTableViewer.getTable().clearAll();
        ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)Messages.getString("Retrieving_applids"));
        final String applid = this.applidText.getText();
        this.job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                final Selection selection = PresentationFactory.getInstance().createSelectForTable(new String[]{PAContextTracker.getInstance().getShortTableReference()}, new String[]{":schema"});
                selection.getSelect().addSelectionColumn(ColumnDefinition.APPLID.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.APPLID.getType(), ColumnReference.Function.NONE);
                if (!PAContextTracker.getInstance().getCurrentManifest().isPerformanceSummaryRecord() && !PAContextTracker.getInstance().getCurrentManifest().isPerformanceList()) {
                    selection.getSelect().addSelectionColumn(ColumnDefinition.MVSID.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.MVSID.getType(), ColumnReference.Function.NONE);
                }
                if (PAContextTracker.getInstance().getCurrentManifest().isPerformanceList()) {
                    selection.getSelect().addSelectionColumn(ColumnDefinition.START.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.START.getType(), ColumnReference.Function.MAX);
                } else {
                    selection.getSelect().addSelectionColumn(ColumnDefinition.START_DATE.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.START_DATE.getType(), ColumnReference.Function.MAX);
                }
                if (Utilities.hasContent((String)applid)) {
                    selection.appendCondition(ColumnDefinition.APPLID.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.APPLID.getType(), Comparator.LI, new Object[]{String.valueOf(applid.toUpperCase()) + "%"}, QueryElement.Predicate.AND, false);
                }
                selection.addOrderByCondition(ColumnDefinition.APPLID.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), Direction.GROUP);
                if (!PAContextTracker.getInstance().getCurrentManifest().isPerformanceSummaryRecord() && !PAContextTracker.getInstance().getCurrentManifest().isPerformanceList()) {
                    selection.addOrderByCondition(ColumnDefinition.MVSID.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), Direction.GROUP);
                }
                if (dateToken != null && !(dateToken instanceof NullRangeDateCaveat)) {
                    selection.appendCondition(dateToken.getConstraint(null, PAContextTracker.getInstance().getCurrentManifest().isPerformanceList()), QueryElement.Predicate.AND);
                }
                if (!PAContextTracker.getInstance().getCurrentManifest().isPerformanceList() && !PAContextTracker.getInstance().getCurrentManifest().isPerformanceSummaryRecord() && IntervalsCaveat.getInstance().getClause() != null) {
                    selection.appendCondition((ConstraintElement)IntervalsCaveat.getInstance().getClause(), QueryElement.Predicate.AND);
                }
                Overview.this.applidEngine = new Engine("com.ibm.cics.pa.connection", new RowProcessor(){

                    public Map<String, Object> getParameterMap() {
                        return new HashMap<String, Object>();
                    }

                    public SelectionObject getSelectionObject() {
                        return selection;
                    }

                    public Object processRow(ResultSet resultSet) {
                        try {
                            if (PAContextTracker.getInstance().getCurrentManifest().isPerformanceSummaryRecord()) {
                                return new OverviewApplidElement(resultSet.getString(1), "", resultSet.getDate(2));
                            }
                            if (PAContextTracker.getInstance().getCurrentManifest().isPerformanceList()) {
                                return new OverviewApplidElement(resultSet.getString(1), "", resultSet.getDate(2));
                            }
                            return new OverviewApplidElement(resultSet.getString(1).trim(), resultSet.getString(2).trim(), resultSet.getDate(3));
                        }
                        catch (SQLException e) {
                            Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"runApplidQuery ", (Throwable)e);
                            return null;
                        }
                    }
                });
                Overview.this.applidEngine.setPageSize(90000);
                Overview.this.applidEngine.addListener(new EngineShell.EngineListener(){
                    private List<Object> res = new ArrayList<Object>();

                    public void dataAvailable(Collection<Object> items) {
                        this.getRes().addAll(items);
                    }

                    public void notifyResultCount(int count) {
                    }

                    public void statusUpdate(EngineShell.EngineStatus es) {
                        switch (es) {
                            case Cancelled: 
                            case Error: {
                                (this).Overview.this.applidEngine.removeListener((EngineShell.EngineListener)this);
                                break;
                            }
                            case Complete: {
                                (this).Overview.this.applidEngine.removeListener((EngineShell.EngineListener)this);
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (this.getRes().size() > 0) {
                                            ((this).this).Overview.this.applidTableViewer.setInput((Object)this.getRes().toArray(new OverviewApplidElement[this.getRes().size()]));
                                            ((this).this).Overview.this.applidTableViewer.refresh();
                                            ArrayList<Object> bucket = new ArrayList<Object>();
                                            block0: for (Object el : this.getRes()) {
                                                Object[] objectArray = lastSelection.toArray();
                                                int n = objectArray.length;
                                                int n2 = 0;
                                                while (n2 < n) {
                                                    Object el1 = objectArray[n2];
                                                    if (el.toString().equals(el1.toString())) {
                                                        bucket.add(el);
                                                        continue block0;
                                                    }
                                                    ++n2;
                                                }
                                            }
                                            if (!bucket.isEmpty()) {
                                                ((this).this).Overview.this.applidTableViewer.setSelection((ISelection)new StructuredSelection(bucket), true);
                                                ViewHelper.setStatusInformationMessage((IWorkbenchPart)Overview.this, (String)MessageFormat.format(Messages.getString("CSVDataExtract.Rows"), this.getRes().size()));
                                            } else if (lastSelection.isEmpty()) {
                                                ViewHelper.setStatusInformationMessage((IWorkbenchPart)Overview.this, (String)Messages.getString("IntervalTracker.noContext"));
                                            } else {
                                                ViewHelper.setStatusInformationMessage((IWorkbenchPart)Overview.this, (String)MessageFormat.format(Messages.getString("CSVDataExtract.Rows"), this.getRes().size()));
                                            }
                                            Overview.this.updateFeedback(false);
                                        } else {
                                            ViewHelper.setStatusInformationMessage((IWorkbenchPart)Overview.this, (String)MessageFormat.format(Messages.getString("PAX0109I.Results.NoData.view"), Overview.this.getPartName()));
                                        }
                                    }
                                });
                                if ((this).Overview.this.oldrecord != null && !(this).Overview.this.currentMode && (this).Overview.this.pendingTreeQuery && this.getRes().size() > 0) {
                                    Overview.this.runTreeQuery();
                                }
                                (this).Overview.this.pendingTreeQuery = false;
                                break;
                            }
                        }
                    }

                    public List<Object> getRes() {
                        return this.res;
                    }
                });
                if (Overview.this.applidEngine.getStatus() == EngineShell.EngineStatus.Initial) {
                    Overview.this.applidEngine.start();
                }
                return Status.OK_STATUS;
            }
        };
        this.job.setPriority(20);
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(this.job, 0L, true);
    }

    synchronized void runTranQuery(final Object[] selection) {
        this.resourceColumn = ColumnDefinition.TRAN;
        ManifestRecord record = PAContextTracker.getInstance().getCurrentManifest();
        if (selection.length > 0 && record != null && !record.isStatTable()) {
            ColumnDefinition[] defns = record.getKey().getColumnDefinitions();
            if (defns.length < 4) {
                return;
            }
            final ColumnDefinition resourceColumnfinal = this.resourceColumn = defns[3];
            final DateCaveat dateToken = TimelineAssistDialog.getInstance().getDateCaveat();
            final String resource = this.transactionText.getText();
            final List<String> applids = ((PASelectionContext)this.getCurrentContext()).getApplids();
            final List<String> oldSelection = ((PASelectionContext)this.getCurrentContext()).getResources();
            if (applids.size() == 0) {
                Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"runTranQuery", (Object)"Applids cannot be empty");
            }
            this.job = new Job(""){

                protected IStatus run(IProgressMonitor monitor) {
                    final Selection selectionObj = PresentationFactory.getInstance().createSelectForTable(new String[]{PAContextTracker.getInstance().getShortTableReference()}, new String[]{":schema"});
                    selectionObj.getSelect().addSelectionColumn(ColumnDefinition.APPLID.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnReference.DataType.String, ColumnReference.Function.NONE);
                    selectionObj.getSelect().addSelectionColumn(resourceColumnfinal.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), resourceColumnfinal.getType(), null);
                    selectionObj.getSelect().addSelectionColumn(resourceColumnfinal.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), resourceColumnfinal.getType(), ColumnReference.Function.COUNT);
                    selectionObj.addOrderByCondition(ColumnDefinition.APPLID.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), Direction.GROUP);
                    selectionObj.addOrderByCondition(resourceColumnfinal.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), Direction.GROUP);
                    ArrayList<String> inList = new ArrayList<String>();
                    Object[] objectArray = selection;
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object selected = objectArray[n2];
                        inList.add(((OverviewApplidElement)selected).toString());
                        ++n2;
                    }
                    if (Utilities.hasContent((String)resource)) {
                        selectionObj.appendCondition(resourceColumnfinal.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), resourceColumnfinal.getType(), Comparator.LI, new Object[]{String.valueOf(resource) + "%"}, QueryElement.Predicate.AND, false);
                    }
                    selectionObj.appendCondition(ColumnDefinition.APPLID.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.APPLID.getType(), Comparator.IN, applids.toArray(), QueryElement.Predicate.AND, false);
                    if (dateToken != null && !(dateToken instanceof NullRangeDateCaveat) && PAContextTracker.getInstance().getCurrentManifest() != null) {
                        selectionObj.appendCondition(dateToken.getConstraint(null, PAContextTracker.getInstance().getCurrentManifest().isPerformanceList()), QueryElement.Predicate.AND);
                    }
                    Overview.this.tranEngine = new Engine("com.ibm.cics.pa.connection", new RowProcessor(){

                        public Map<String, Object> getParameterMap() {
                            return new HashMap<String, Object>();
                        }

                        public SelectionObject getSelectionObject() {
                            return selectionObj;
                        }

                        public Object processRow(ResultSet resultSet) {
                            try {
                                return new OverviewCountedElement(resultSet.getString(1).trim(), resultSet.getString(2).trim(), resultSet.getInt(3));
                            }
                            catch (SQLException e) {
                                Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"runApplidQuery ", (Throwable)e);
                                return null;
                            }
                        }
                    });
                    Overview.this.tranEngine.setPageSize(90000);
                    Overview.this.tranEngine.addListener(new EngineShell.EngineListener(){
                        private List<Object> res = new ArrayList<Object>();

                        public void dataAvailable(Collection<Object> items) {
                            this.getRes().addAll(items);
                        }

                        public void notifyResultCount(int count) {
                        }

                        public void statusUpdate(EngineShell.EngineStatus es) {
                            switch (es) {
                                case Cancelled: 
                                case Error: {
                                    (this).Overview.this.tranEngine.removeListener((EngineShell.EngineListener)this);
                                    break;
                                }
                                case Complete: {
                                    (this).Overview.this.tranEngine.removeListener((EngineShell.EngineListener)this);
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            OverviewCountedElement[] nextinput = this.getRes().toArray(new OverviewCountedElement[this.getRes().size()]);
                                            ((this).this).Overview.this.transactionTableViewer.setInput((Object)nextinput);
                                            ((this).this).Overview.this.transactionTableViewer.refresh();
                                            ((this).this).Overview.this.quickWrapper.layout();
                                            if (!oldSelection.isEmpty()) {
                                                ArrayList<OverviewCountedElement> newSelection = new ArrayList<OverviewCountedElement>();
                                                OverviewCountedElement[] overviewCountedElementArray = nextinput;
                                                int n = nextinput.length;
                                                int n2 = 0;
                                                while (n2 < n) {
                                                    OverviewCountedElement element = overviewCountedElementArray[n2];
                                                    if (oldSelection.contains(element.getTransactionName())) {
                                                        newSelection.add(element);
                                                    }
                                                    ++n2;
                                                }
                                                ((this).this).Overview.this.transactionTableViewer.setSelection((ISelection)new StructuredSelection(newSelection));
                                            }
                                        }
                                    });
                                    break;
                                }
                            }
                        }

                        public List<Object> getRes() {
                            return this.res;
                        }
                    });
                    Overview.this.tranEngine.setNotifyOnCount(false);
                    Overview.this.tranEngine.start();
                    return Status.OK_STATUS;
                }
            };
            this.job.setPriority(20);
            IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
            siteService.schedule(this.job, 0L, true);
        }
    }

    synchronized void runTreeQuery() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"treeQuery");
        this.job = new Job(Messages.getString("TreeView.empty")){

            protected IStatus run(IProgressMonitor monitor) {
                final DateCaveat dateToken = TimelineAssistDialog.getInstance().getDateCaveat();
                if (dateToken != null) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).Overview.this.treeText.setText(MessageFormat.format(Messages.getString("TreeView"), PAContextTracker.getInstance().getCurrentManifest().getDescription()));
                            (this).Overview.this.treeText.getParent().layout();
                            (this).Overview.this.treeViewer.setInput((Object)SimpleTreeElement.createRoot(dateToken));
                        }
                    });
                }
                if (monitor != null) {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        this.job.setPriority(30);
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(this.job, 2500L, true);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"treeQuery");
    }

    @Override
    public void datesUpdated(DateCaveat dateToken) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"datesUpdated");
        ISelectionChangedListener[] iSelectionChangedListenerArray = this.selectionListeners.toArray(new ISelectionChangedListener[this.selectionListeners.size()]);
        int n = iSelectionChangedListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISelectionChangedListener listener = iSelectionChangedListenerArray[n2];
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new StructuredSelection()));
            ++n2;
        }
        this.descriptionUpdate(dateToken);
        if (PAContextTracker.getInstance().getCurrentManifest() != null && PAConnectionTracker.getInstance().isConnected()) {
            if (PAContextTracker.getInstance().getCurrentManifest().isApplicationSummaryRecord()) {
                this.runPlatformQuery();
            } else if (this.treeViewer != null) {
                this.treeViewer.setInput(null);
                this.pendingTreeQuery = true;
                this.runApplidQuery();
            }
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"datesUpdated");
    }

    private void descriptionUpdate(DateCaveat dateToken) {
        if (dateToken instanceof RangeDateCaveat) {
            String[] labels = ((RangeDateCaveat)dateToken).getLabelAsArray();
            this.dateDetailLabel1.setText(labels[0]);
            this.dateDetailLabel1.setToolTipText(labels[0]);
            this.dateDetailLabel2.setText(labels[1]);
            this.dateDetailLabel2.setVisible(true);
        } else {
            this.dateDetailLabel1.setText(dateToken instanceof NullRangeDateCaveat ? Messages.getString("ParameterDialog.noCurrentDate") : dateToken.getLabel());
            this.dateDetailLabel1.setToolTipText(dateToken instanceof NullRangeDateCaveat ? Messages.getString("ParameterDialog.noCurrentDate.tooltip") : dateToken.getLabel());
            this.dateDetailLabel2.setText("");
            this.dateDetailLabel2.setToolTipText("");
            this.dateDetailLabel2.setVisible(false);
        }
        int dateChoice = Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.pa.ui.overview", 0, null);
        if (dateChoice == 1) {
            this.dateDetailLabel2.setText(Messages.getString("Overview.LastYear"));
            this.dateDetailLabel2.setToolTipText(Messages.getString("Overview.LastYear"));
            this.dateDetailLabel2.setVisible(true);
        } else if (dateChoice == 3) {
            this.dateDetailLabel2.setText(Messages.getString("Overview.LastQuarter"));
            this.dateDetailLabel2.setToolTipText(Messages.getString("Overview.LastQuarter"));
            this.dateDetailLabel2.setVisible(true);
        } else if (dateChoice == 2) {
            this.dateDetailLabel2.setText(Messages.getString("Overview.LastMonth"));
            this.dateDetailLabel2.setToolTipText(Messages.getString("Overview.LastMonth"));
            this.dateDetailLabel2.setVisible(true);
        } else if (dateChoice == 4) {
            this.dateDetailLabel2.setText(Messages.getString("Overview.LastWeek"));
            this.dateDetailLabel2.setToolTipText(Messages.getString("Overview.LastWeek"));
            this.dateDetailLabel2.setVisible(true);
        } else if (dateChoice == 6) {
            this.dateDetailLabel2.setText(Messages.getString("Overview.LastDay"));
            this.dateDetailLabel2.setToolTipText(Messages.getString("Overview.LastDay"));
            this.dateDetailLabel2.setVisible(true);
        }
        this.dateDetail.setVisible(true);
        this.dateDetail.layout();
        this.dateDetail.getParent().layout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnected() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"disconnected");
        Boolean bl = this.disconnecting;
        synchronized (bl) {
            this.disconnecting = true;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Overview.this.applidTableViewer.setInput((Object)new OverviewApplidElement[0]);
                    Overview.this.transactionTableViewer.setInput((Object)new OverviewApplidElement[0]);
                    Overview.this.platformTableViewer.setInput((Object)new String[0]);
                    Overview.this.applicationTableViewer.setInput((Object)new String[0]);
                    Overview.this.versionTableViewer.setInput((Object)new String[0]);
                    Overview.this.operationTableViewer.setInput((Object)new OverviewCountedApplicationElement[0]);
                    Overview.this.treeViewer.setInput(null);
                    ISelectionChangedListener[] iSelectionChangedListenerArray = Overview.this.selectionListeners.toArray(new ISelectionChangedListener[Overview.this.selectionListeners.size()]);
                    int n = iSelectionChangedListenerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ISelectionChangedListener listener = iSelectionChangedListenerArray[n2];
                        listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)Overview.this, (ISelection)new StructuredSelection()));
                        ++n2;
                    }
                    Overview.this.treeText.setText("");
                    Overview.this.dateDetail.setVisible(false);
                    Overview.this.dateDetail.layout();
                    Overview.this.dateDetail.getParent().layout();
                    Overview.this.dateDetail.setLayoutData((Object)Overview.this.dataLesser);
                    Overview.this.dateDetail.getParent().layout();
                    Overview.this.disconnecting = false;
                    Overview.this.navigatorTreeViewer.setInput(null);
                    Overview.this.tableLabel1.setText(Messages.getString("Resource.status.disconnected"));
                    StyleRange range = new StyleRange(0, 0, null, null);
                    Overview.this.tableLabel1.setStyleRange(range);
                    Overview.this.tableLabel1.setToolTipText(Messages.getString("Resource.status.disconnected"));
                    Overview.this.gridParent.layout();
                }
            });
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"disconnected");
    }

    @Override
    public void disconnecting() {
        Engine[] engineArray = new Engine[]{this.applidEngine, this.tranEngine, this.platformEngine, this.appEngine, this.versionEngine, this.operationEngine};
        int n = engineArray.length;
        int n2 = 0;
        while (n2 < n) {
            Engine engine = engineArray[n2];
            if (engine != null) {
                engine.cancel();
            }
            ++n2;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Overview.this.filteredTree.getFilterControl().setEnabled(false);
            }
        });
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        if (this.doubleParent.getSelectionIndex() == 0) {
            return this.navigatorTreeViewer.getSelection();
        }
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        this.currentSelection = selection;
        Iterator<ISelectionChangedListener> iterator = this.selectionListeners.iterator();
        while (iterator.hasNext()) {
            ISelectionChangedListener listener;
            ISelectionChangedListener finalListener = listener = iterator.next();
            finalListener.selectionChanged(event);
        }
        if (this.doubleParent.getSelectionIndex() == 0) {
            this.updateFeedback(true);
        }
    }

    public IContext getCurrentContext() {
        PASelectionContext ctx = null;
        DateCaveat dateToken = TimelineAssistDialog.getInstance().getDateCaveat();
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"getCurrentContext");
        if (this.activeViewer == ActiveViewer.tree) {
            ctx = PASelectionContext.getPASelectionContext(this.treeViewer.getSelection());
        } else if (this.activeViewer == ActiveViewer.applid || this.activeViewer == ActiveViewer.transaction) {
            ArrayList<String> applids = new ArrayList<String>();
            ArrayList<String> resources = new ArrayList<String>();
            for (Object row : ((StructuredSelection)this.applidTableViewer.getSelection()).toList()) {
                applids.add(((OverviewApplidElement)row).toString());
            }
            if (this.activeViewer == ActiveViewer.transaction) {
                for (Object row : ((StructuredSelection)this.transactionTableViewer.getSelection()).toList()) {
                    resources.add(((OverviewApplidElement)row).toString());
                }
            }
            ctx = new PASelectionContext(dateToken, applids, resources, this.resourceColumn);
        } else {
            ArrayList<String> platforms = new ArrayList<String>();
            ArrayList<String> applications = new ArrayList<String>();
            ArrayList<String> versions = new ArrayList<String>();
            ArrayList<String> operations = new ArrayList<String>();
            for (Object row : ((StructuredSelection)this.platformTableViewer.getSelection()).toList()) {
                platforms.add((String)row);
            }
            if (this.activeViewer == ActiveViewer.application || this.activeViewer == ActiveViewer.version || this.activeViewer == ActiveViewer.operation) {
                for (Object row : ((StructuredSelection)this.applicationTableViewer.getSelection()).toList()) {
                    applications.add((String)row);
                }
            }
            if (this.activeViewer == ActiveViewer.version || this.activeViewer == ActiveViewer.operation) {
                for (Object row : ((StructuredSelection)this.versionTableViewer.getSelection()).toList()) {
                    versions.add((String)row);
                }
            }
            if (this.activeViewer == ActiveViewer.operation) {
                for (Object row : ((StructuredSelection)this.operationTableViewer.getSelection()).toList()) {
                    operations.add(((OverviewCountedApplicationElement)row).getLabel());
                }
            }
            ctx = new PASelectionContext(dateToken, platforms, applications, versions, operations);
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getCurrentContext", (Object)ctx);
        return ctx;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public String getPartProperty(String key) {
        if (IConnectionCategory.class.getName().equals(key)) {
            return "com.ibm.cics.pa.connection";
        }
        return super.getPartProperty(key);
    }

    private int[] getSashWeight(ManifestRecord record) {
        int[] tripleSash = new int[]{40, 30, 30};
        if (this.currentMode) {
            tripleSash[1] = 0;
            tripleSash[2] = 0;
            tripleSash[0] = 100;
        } else if (record != null && record.isApplicationSummaryRecord()) {
            tripleSash = new int[]{Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "FourSash0", 20, null), Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "FourSash1", 30, null), Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "FourSash2", 20, null), Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "FourSash3", 30, null)};
        } else if (record == null || record.isPerformanceSummaryRecord()) {
            tripleSash[0] = Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "ThreeSash0", 40, null);
            tripleSash[1] = Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "ThreeSash1", 20, null);
            tripleSash[2] = Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "ThreeSash2", 40, null);
        } else if (record.isPerformanceList()) {
            tripleSash[2] = 0;
            tripleSash[0] = Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "TwoSash0", 60, null);
            tripleSash[1] = Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "TwoSash1", 40, null);
        } else {
            tripleSash[1] = 0;
            tripleSash[0] = Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "TwoSash0", 60, null);
            tripleSash[2] = Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "TwoSash1", 40, null);
        }
        return tripleSash;
    }

    private void saveSashWeight(int[] weights, ManifestRecord record) {
        if (!this.currentMode) {
            if (record != null && record.isApplicationSummaryRecord()) {
                Activator.getDefault().getPluginInstancePreferences().putInt("FourSash0", this.applicationSash.getWeights()[0]);
                Activator.getDefault().getPluginInstancePreferences().putInt("FourSash1", this.applicationSash.getWeights()[1]);
                Activator.getDefault().getPluginInstancePreferences().putInt("FourSash2", this.applicationSash.getWeights()[2]);
                Activator.getDefault().getPluginInstancePreferences().putInt("FourSash3", this.applicationSash.getWeights()[3]);
            } else if (record != null && record.isPerformanceSummaryRecord()) {
                Activator.getDefault().getPluginInstancePreferences().putInt("ThreeSash0", this.performanceSash.getWeights()[0]);
                Activator.getDefault().getPluginInstancePreferences().putInt("ThreeSash1", this.performanceSash.getWeights()[1]);
                Activator.getDefault().getPluginInstancePreferences().putInt("ThreeSash2", this.performanceSash.getWeights()[2]);
            } else {
                Activator.getDefault().getPluginInstancePreferences().putInt("TwoSash0", this.performanceSash.getWeights()[0]);
                Activator.getDefault().getPluginInstancePreferences().putInt("TwoSash1", this.performanceSash.getWeights()[1] > 0 ? this.performanceSash.getWeights()[1] : this.performanceSash.getWeights()[2]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connected(PAConnectionListener.Era era) {
        Boolean bl = this.disconnecting;
        synchronized (bl) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (PAConnectionTracker.getInstance().isConnected()) {
                        Overview.this.tableLabel1.setText(Messages.getString("No.table"));
                        Overview.this.tableLabel1.setToolTipText(Messages.getString("No.table"));
                        Overview.this.dateDetail.setLayoutData((Object)new GridData(32, 128, true, false));
                        Overview.this.dateDetail.setVisible(true);
                        Overview.this.dateDetail.layout();
                        Overview.this.dateDetail.getParent().layout();
                        Overview.this.navigatorTreeViewer.setInput((Object)TableCategorisationEnum.Root);
                        Overview.this.navigatorTreeViewer.expandToLevel(2);
                    }
                }
            });
        }
    }

    @Override
    public void tableSelected(final ManifestRecord record) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"tableSelected", (Object)record);
        if (record != null && this.oldrecord != record) {
            Job job = new Job(Messages.getString("PAOutlinePage.ExpandingJob")){

                protected IStatus run(IProgressMonitor monitor) {
                    while (!record.isDateChecked()) {
                        try {
                            Thread.yield();
                            Thread.sleep(150L);
                        }
                        catch (InterruptedException e) {
                            Debug.error((Logger)logger, (String)ManifestRecord.class.getName(), (String)"isPresent", (Throwable)e);
                        }
                    }
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Overview.this.tableSelectedInner(record);
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"tableSelected");
    }

    void tableSelectedInner(ManifestRecord record) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"tableSelected1", (Object)record);
        if (record != null && this.oldrecord != record) {
            this.fillViewMenuDropdown(this.getViewSite().getActionBars().getMenuManager());
            this.getViewSite().getActionBars().updateActionBars();
            if (this.oldrecord != null) {
                if (this.activeViewer == ActiveViewer.platform || this.activeViewer == ActiveViewer.application || this.activeViewer == ActiveViewer.operation || this.activeViewer == ActiveViewer.version) {
                    this.saveSashWeight(this.applicationSash.getWeights(), this.oldrecord);
                } else {
                    this.saveSashWeight(this.performanceSash.getWeights(), this.oldrecord);
                }
            }
            this.oldrecord = record;
            DateCaveat dateToken = TimelineAssistDialog.getInstance().getDateCaveat();
            if (record.getDescription().length() > 0) {
                String txt1 = record.isPresent() ? MessageFormat.format(Messages.getString("Date.fromto.long"), record.getDescription(), DataTypeUtilities.getAsString(record.getEarliestRecord()), record.isRecent() ? ">" + DataTypeUtilities.getAsString(record.getLatestRecord()) + "<" : DataTypeUtilities.getAsString(record.getLatestRecord())) : String.valueOf(record.getDescription()) + ' ' + Messages.getString("TableDialog.unavailable");
                this.tableLabel1.setText(txt1);
                this.tableLabel1.setToolTipText(txt1);
                StyleRange range = new StyleRange(0, record.getDescription().length(), null, null, 1);
                this.tableLabel1.setStyleRange(range);
            }
            this.gridParent.layout();
            if (record.isPresent()) {
                int[] tripleSash;
                if (this.currentMode) {
                    this.activeViewer = ActiveViewer.applid;
                    this.setOldStyle(true);
                    this.pendingTreeQuery = false;
                    this.runApplidQuery();
                    tripleSash = new int[3];
                    tripleSash[1] = 0;
                    tripleSash[0] = 100;
                    tripleSash[2] = 0;
                    this.performanceSash.setWeights(tripleSash);
                    this.performanceParent.layout();
                } else if (record.isPerformanceSummaryRecord()) {
                    this.activeViewer = ActiveViewer.applid;
                    this.setOldStyle(true);
                    this.pendingTreeQuery = true;
                    this.runApplidQuery();
                    tripleSash = new int[]{Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "ThreeSash0", 40, null), Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "ThreeSash1", 20, null), Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "ThreeSash2", 40, null)};
                    this.performanceSash.setWeights(tripleSash);
                    this.performanceParent.layout();
                    this.performanceParent.getParent().layout();
                    this.performanceSash.layout();
                } else if (record.isPerformanceList()) {
                    this.activeViewer = ActiveViewer.applid;
                    this.setOldStyle(true);
                    this.pendingTreeQuery = false;
                    this.runApplidQuery();
                    int[] twinSash = new int[]{Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "TwoSash0", 50, null), Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "TwoSash1", 50, null), 0};
                    this.performanceSash.setWeights(twinSash);
                    this.performanceParent.layout();
                    this.performanceParent.getParent().layout();
                    this.performanceSash.layout();
                } else if (record.isApplicationSummaryRecord()) {
                    this.activeViewer = ActiveViewer.platform;
                    this.setOldStyle(false);
                    this.runPlatformQuery();
                    int[] bigSlash = new int[]{Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "FourSash0", 20, null), Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "FourSash1", 30, null), Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "FourSash2", 20, null), Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "FourSash3", 30, null)};
                    this.applicationSash.setWeights(bigSlash);
                    this.platformParent.layout();
                    this.platformParent.getParent().layout();
                    this.applicationSash.layout();
                } else {
                    this.activeViewer = ActiveViewer.applid;
                    this.setOldStyle(true);
                    this.pendingTreeQuery = true;
                    this.runApplidQuery();
                    tripleSash = new int[3];
                    tripleSash[1] = 0;
                    tripleSash[0] = Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "TwoSash0", 50, null);
                    tripleSash[2] = Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "TwoSash1", 50, null);
                    this.performanceSash.setWeights(tripleSash);
                    this.performanceParent.layout();
                }
            }
            this.quickWrapper.layout();
            this.setFocus();
            this.descriptionUpdate(dateToken);
            this.performanceParent.getParent().layout();
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"tableSelected1");
    }

    private void setOldStyle(boolean oldStyle) {
        this.activeViewer = oldStyle ? ActiveViewer.applid : ActiveViewer.platform;
        this.performanceParent.setEnabled(oldStyle);
        this.platformParent.setEnabled(!oldStyle);
        this.performanceParent.setVisible(oldStyle);
        this.platformParent.setVisible(!oldStyle);
        this.performanceParent.setLayoutData((Object)(oldStyle ? this.dataPriority : this.dataLesser));
        this.platformParent.setLayoutData((Object)(oldStyle ? this.dataLesser : this.dataPriority));
        this.performanceParent.getParent().layout();
    }

    private synchronized void runPlatformQuery() {
        ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)Messages.getString("Retrieving_platforms"));
        final DateCaveat dateToken = TimelineAssistDialog.getInstance().getDateCaveat();
        this.platformTableViewer.setInput((Object)new String[0]);
        this.platformTableViewer.setSelection((ISelection)new StructuredSelection());
        this.platformTableViewer.getTable().clearAll();
        ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)ColumnDefinition.ACPLATNM.getDBColumnRef());
        final String platform = this.platformText.getText();
        this.job = new Job(ColumnDefinition.ACPLATNM.getDBColumnRef()){

            protected IStatus run(IProgressMonitor monitor) {
                final Selection selection = PresentationFactory.getInstance().createSelectForTable(new String[]{PAContextTracker.getInstance().getShortTableReference()}, new String[]{":schema"});
                selection.getSelect().addSelectionColumn(ColumnDefinition.ACPLATNM.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.ACPLATNM.getType(), ColumnReference.Function.DISTINCT);
                if (Utilities.hasContent((String)platform)) {
                    selection.appendCondition(ColumnDefinition.ACPLATNM.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.ACPLATNM.getType(), Comparator.LI, new Object[]{String.valueOf(platform) + "%"}, QueryElement.Predicate.AND, false);
                }
                if (dateToken != null && !(dateToken instanceof NullRangeDateCaveat)) {
                    selection.appendCondition(dateToken.getConstraint(null, false), QueryElement.Predicate.AND);
                }
                if (!PAContextTracker.getInstance().getCurrentManifest().isApplicationSummaryRecord() && !PAContextTracker.getInstance().getCurrentManifest().isPerformanceList() && IntervalsCaveat.getInstance().getClause() != null) {
                    selection.appendCondition((ConstraintElement)IntervalsCaveat.getInstance().getClause(), QueryElement.Predicate.AND);
                }
                Overview.this.platformEngine = new Engine("com.ibm.cics.pa.connection", new RowProcessor(){

                    public Map<String, Object> getParameterMap() {
                        return new HashMap<String, Object>();
                    }

                    public SelectionObject getSelectionObject() {
                        return selection;
                    }

                    public Object processRow(ResultSet resultSet) {
                        try {
                            return new String(resultSet.getString(1));
                        }
                        catch (SQLException e) {
                            Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"runPlatformQuery ", (Throwable)e);
                            return null;
                        }
                    }
                });
                Overview.this.platformEngine.setPageSize(90000);
                Overview.this.platformEngine.addListener(new EngineShell.EngineListener(){
                    private List<Object> res = new ArrayList<Object>();

                    public void dataAvailable(Collection<Object> items) {
                        this.getRes().addAll(items);
                    }

                    public void notifyResultCount(int count) {
                    }

                    public void statusUpdate(EngineShell.EngineStatus es) {
                        switch (es) {
                            case Cancelled: 
                            case Error: {
                                (this).Overview.this.platformEngine.removeListener((EngineShell.EngineListener)this);
                                break;
                            }
                            case Complete: {
                                (this).Overview.this.platformEngine.removeListener((EngineShell.EngineListener)this);
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (this.getRes().size() > 0) {
                                            ((this).this).Overview.this.platformTableViewer.setInput((Object)this.getRes().toArray(new String[this.getRes().size()]));
                                            ((this).this).Overview.this.platformTableViewer.refresh();
                                            ViewHelper.setStatusInformationMessage((IWorkbenchPart)Overview.this, (String)MessageFormat.format("", this.getRes().size()));
                                        } else {
                                            ViewHelper.setStatusInformationMessage((IWorkbenchPart)Overview.this, (String)"");
                                        }
                                    }
                                });
                                break;
                            }
                        }
                    }

                    public List<Object> getRes() {
                        return this.res;
                    }
                });
                Overview.this.platformEngine.start();
                return Status.OK_STATUS;
            }
        };
        this.job.setPriority(20);
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(this.job, 0L, true);
    }

    void runPlatformApplicationQuery(Object[] array) {
        ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)Messages.getString("Retrieving_applications"));
        final StructuredSelection lastSelection = (StructuredSelection)this.applicationTableViewer.getSelection();
        final DateCaveat dateToken = TimelineAssistDialog.getInstance().getDateCaveat();
        this.applicationTableViewer.setInput((Object)new String[0]);
        this.applicationTableViewer.getTable().clearAll();
        ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)ColumnDefinition.ACAPPLNM.getDBColumnRef());
        final List<String> platforms = ((PASelectionContext)this.getCurrentContext()).getPlatforms();
        final String text = this.applicationText.getText();
        this.job = new Job(ColumnDefinition.ACAPPLNM.getDBColumnRef()){

            protected IStatus run(IProgressMonitor monitor) {
                final Selection selection = PresentationFactory.getInstance().createSelectForTable(new String[]{PAContextTracker.getInstance().getShortTableReference()}, new String[]{":schema"});
                selection.getSelect().addSelectionColumn(ColumnDefinition.ACAPPLNM.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.ACAPPLNM.getType(), ColumnReference.Function.DISTINCT);
                selection.appendCondition(ColumnDefinition.ACPLATNM.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.ACPLATNM.getType(), Comparator.IN, platforms.toArray(), QueryElement.Predicate.AND, false);
                if (Utilities.hasContent((String)text)) {
                    selection.appendCondition(ColumnDefinition.ACAPPLNM.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.ACAPPLNM.getType(), Comparator.LI, new Object[]{String.valueOf(text) + "%"}, QueryElement.Predicate.AND, false);
                }
                if (dateToken != null && !(dateToken instanceof NullRangeDateCaveat)) {
                    selection.appendCondition(dateToken.getConstraint(null, false), QueryElement.Predicate.AND);
                }
                selection.addOrderByCondition(ColumnDefinition.ACAPPLNM.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), Direction.ASC);
                Overview.this.appEngine = new Engine("com.ibm.cics.pa.connection", new RowProcessor(){

                    public Map<String, Object> getParameterMap() {
                        return new HashMap<String, Object>();
                    }

                    public SelectionObject getSelectionObject() {
                        return selection;
                    }

                    public Object processRow(ResultSet resultSet) {
                        try {
                            return new String(resultSet.getString(1));
                        }
                        catch (SQLException e) {
                            Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"runPlatformApplicationQuery ", (Throwable)e);
                            return null;
                        }
                    }
                });
                Overview.this.appEngine.setPageSize(90000);
                Overview.this.appEngine.addListener(new EngineShell.EngineListener(){
                    private List<Object> res = new ArrayList<Object>();

                    public void dataAvailable(Collection<Object> items) {
                        this.getRes().addAll(items);
                    }

                    public void notifyResultCount(int count) {
                    }

                    public void statusUpdate(EngineShell.EngineStatus es) {
                        switch (es) {
                            case Cancelled: 
                            case Error: {
                                (this).Overview.this.appEngine.removeListener((EngineShell.EngineListener)this);
                                break;
                            }
                            case Complete: {
                                (this).Overview.this.appEngine.removeListener((EngineShell.EngineListener)this);
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (this.getRes().size() > 0) {
                                            ((this).this).Overview.this.applicationTableViewer.setInput((Object)this.getRes().toArray(new String[this.getRes().size()]));
                                            ((this).this).Overview.this.applicationTableViewer.refresh();
                                            ArrayList<Object> bucket = new ArrayList<Object>();
                                            block0: for (Object el : this.getRes()) {
                                                Object[] objectArray = lastSelection.toArray();
                                                int n = objectArray.length;
                                                int n2 = 0;
                                                while (n2 < n) {
                                                    Object el1 = objectArray[n2];
                                                    if (el.toString().equals(el1.toString())) {
                                                        bucket.add(el);
                                                        continue block0;
                                                    }
                                                    ++n2;
                                                }
                                            }
                                            if (!bucket.isEmpty()) {
                                                ((this).this).Overview.this.applicationTableViewer.setSelection((ISelection)new StructuredSelection(bucket), true);
                                                ViewHelper.setStatusInformationMessage((IWorkbenchPart)Overview.this, (String)MessageFormat.format(Messages.getString("CSVDataExtract.Rows"), this.getRes().size()));
                                            } else if (lastSelection.isEmpty()) {
                                                ViewHelper.setStatusInformationMessage((IWorkbenchPart)Overview.this, (String)Messages.getString("IntervalTracker.noContext"));
                                            } else {
                                                ViewHelper.setStatusInformationMessage((IWorkbenchPart)Overview.this, (String)MessageFormat.format(Messages.getString("CSVDataExtract.Rows"), this.getRes().size()));
                                            }
                                            Overview.this.updateFeedback(false);
                                        } else {
                                            ViewHelper.setStatusInformationMessage((IWorkbenchPart)Overview.this, (String)"");
                                        }
                                    }
                                });
                                break;
                            }
                        }
                    }

                    public List<Object> getRes() {
                        return this.res;
                    }
                });
                Overview.this.appEngine.start();
                return Status.OK_STATUS;
            }
        };
        this.job.setPriority(20);
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(this.job, 0L, true);
    }

    void runPlatformApplicationVersionQuery(Object[] array) {
        ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)Messages.getString("Retrieving_versions"));
        final DateCaveat dateToken = TimelineAssistDialog.getInstance().getDateCaveat();
        this.versionTableViewer.setInput((Object)new String[0]);
        this.versionTableViewer.getTable().clearAll();
        ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)ColumnDefinition.ACAPPLVR.getDBColumnRef());
        final List<String> platforms = ((PASelectionContext)this.getCurrentContext()).getPlatforms();
        final List<String> applications = ((PASelectionContext)this.getCurrentContext()).getApplications();
        final String text = this.versionText.getText();
        this.job = new Job(ColumnDefinition.ACAPPLVR.getDBColumnRef()){

            protected IStatus run(IProgressMonitor monitor) {
                final Selection selection = PresentationFactory.getInstance().createSelectForTable(new String[]{PAContextTracker.getInstance().getShortTableReference()}, new String[]{":schema"});
                selection.getSelect().addSelectionColumn(ColumnDefinition.ACAPPLVR.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.ACAPPLVR.getType(), ColumnReference.Function.DISTINCT);
                selection.getSelect().addSelectionColumn(ColumnDefinition.ACMAJVER.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.ACMAJVER.getType(), null);
                selection.getSelect().addSelectionColumn(ColumnDefinition.ACMINVER.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.ACMINVER.getType(), null);
                selection.getSelect().addSelectionColumn(ColumnDefinition.ACMICVER.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.ACMICVER.getType(), null);
                selection.appendCondition(ColumnDefinition.ACPLATNM.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.ACPLATNM.getType(), Comparator.IN, platforms.toArray(), QueryElement.Predicate.AND, false);
                selection.appendCondition(ColumnDefinition.ACAPPLNM.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.ACAPPLNM.getType(), Comparator.IN, applications.toArray(), QueryElement.Predicate.AND, false);
                if (Utilities.hasContent((String)text)) {
                    selection.appendCondition(ColumnDefinition.ACAPPLVR.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.ACAPPLVR.getType(), Comparator.LI, new Object[]{String.valueOf(text) + "%"}, QueryElement.Predicate.AND, false);
                }
                if (dateToken != null && !(dateToken instanceof NullRangeDateCaveat)) {
                    selection.appendCondition(dateToken.getConstraint(null, false), QueryElement.Predicate.AND);
                }
                selection.addOrderByCondition(ColumnDefinition.ACMAJVER.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), Direction.ASC);
                selection.addOrderByCondition(ColumnDefinition.ACMINVER.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), Direction.ASC);
                selection.addOrderByCondition(ColumnDefinition.ACMICVER.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), Direction.ASC);
                Overview.this.versionEngine = new Engine("com.ibm.cics.pa.connection", new RowProcessor(){

                    public Map<String, Object> getParameterMap() {
                        return new HashMap<String, Object>();
                    }

                    public SelectionObject getSelectionObject() {
                        return selection;
                    }

                    public Object processRow(ResultSet resultSet) {
                        try {
                            return new String(resultSet.getString(1));
                        }
                        catch (SQLException e) {
                            Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"runPlatformApplicationVersionQuery ", (Throwable)e);
                            return null;
                        }
                    }
                });
                Overview.this.versionEngine.setPageSize(90000);
                Overview.this.versionEngine.addListener(new EngineShell.EngineListener(){
                    private List<Object> res = new ArrayList<Object>();

                    public void dataAvailable(Collection<Object> items) {
                        this.getRes().addAll(items);
                    }

                    public void notifyResultCount(int count) {
                    }

                    public void statusUpdate(EngineShell.EngineStatus es) {
                        switch (es) {
                            case Cancelled: 
                            case Error: {
                                (this).Overview.this.versionEngine.removeListener((EngineShell.EngineListener)this);
                                break;
                            }
                            case Complete: {
                                (this).Overview.this.versionEngine.removeListener((EngineShell.EngineListener)this);
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (this.getRes().size() > 0) {
                                            ((this).this).Overview.this.versionTableViewer.setInput((Object)this.getRes().toArray(new String[this.getRes().size()]));
                                            ((this).this).Overview.this.versionTableViewer.refresh();
                                            ViewHelper.setStatusInformationMessage((IWorkbenchPart)Overview.this, (String)MessageFormat.format("", this.getRes().size()));
                                        } else {
                                            ViewHelper.setStatusInformationMessage((IWorkbenchPart)Overview.this, (String)"");
                                        }
                                    }
                                });
                                break;
                            }
                        }
                    }

                    public List<Object> getRes() {
                        return this.res;
                    }
                });
                Overview.this.versionEngine.start();
                return Status.OK_STATUS;
            }
        };
        this.job.setPriority(20);
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(this.job, 0L, true);
    }

    void runPlatformApplicationOperationQuery(Object[] array) {
        final DateCaveat dateToken = TimelineAssistDialog.getInstance().getDateCaveat();
        this.operationTableViewer.setInput((Object)new OverviewCountedApplicationElement[0]);
        this.operationTableViewer.getTable().clearAll();
        ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)ColumnDefinition.ACAPPLVR.getDBColumnRef());
        final List<String> platforms = ((PASelectionContext)this.getCurrentContext()).getPlatforms();
        final List<String> applications = ((PASelectionContext)this.getCurrentContext()).getApplications();
        final List<String> versions = ((PASelectionContext)this.getCurrentContext()).getVersions();
        final String text = this.operationText.getText();
        this.job = new Job(ColumnDefinition.ACAPPLVR.getDBColumnRef()){

            protected IStatus run(IProgressMonitor monitor) {
                final Selection selection = PresentationFactory.getInstance().createSelectForTable(new String[]{PAContextTracker.getInstance().getShortTableReference()}, new String[]{":schema"});
                selection.getSelect().addSelectionColumn(ColumnDefinition.ACOPERNM.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.ACOPERNM.getType(), null);
                selection.getSelect().addSelectionColumn(ColumnDefinition.ACOPERNM.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.ACOPERNM.getType(), ColumnReference.Function.COUNT);
                selection.appendCondition(ColumnDefinition.ACPLATNM.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.ACPLATNM.getType(), Comparator.IN, platforms.toArray(), QueryElement.Predicate.AND, false);
                selection.appendCondition(ColumnDefinition.ACAPPLNM.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.ACAPPLNM.getType(), Comparator.IN, applications.toArray(), QueryElement.Predicate.AND, false);
                selection.appendCondition(ColumnDefinition.ACAPPLVR.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.ACAPPLVR.getType(), Comparator.IN, versions.toArray(), QueryElement.Predicate.AND, false);
                if (Utilities.hasContent((String)text)) {
                    selection.appendCondition(ColumnDefinition.ACOPERNM.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnDefinition.ACOPERNM.getType(), Comparator.LI, new Object[]{String.valueOf(text) + "%"}, QueryElement.Predicate.AND, false);
                }
                if (dateToken != null && !(dateToken instanceof NullRangeDateCaveat)) {
                    selection.appendCondition(dateToken.getConstraint(null, false), QueryElement.Predicate.AND);
                }
                selection.addOrderByCondition(ColumnDefinition.ACOPERNM.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), Direction.GROUP);
                Overview.this.operationEngine = new Engine("com.ibm.cics.pa.connection", new RowProcessor(){

                    public Map<String, Object> getParameterMap() {
                        return new HashMap<String, Object>();
                    }

                    public SelectionObject getSelectionObject() {
                        return selection;
                    }

                    public Object processRow(ResultSet resultSet) {
                        try {
                            return new OverviewCountedApplicationElement(resultSet.getString(1), resultSet.getInt(2));
                        }
                        catch (SQLException e) {
                            Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"runPlatformApplicationVersionQuery ", (Throwable)e);
                            return null;
                        }
                    }
                });
                Overview.this.operationEngine.setPageSize(90000);
                Overview.this.operationEngine.addListener(new EngineShell.EngineListener(){
                    private List<Object> res = new ArrayList<Object>();

                    public void dataAvailable(Collection<Object> items) {
                        this.getRes().addAll(items);
                    }

                    public void notifyResultCount(int count) {
                    }

                    public void statusUpdate(EngineShell.EngineStatus es) {
                        switch (es) {
                            case Cancelled: 
                            case Error: {
                                (this).Overview.this.operationEngine.removeListener((EngineShell.EngineListener)this);
                                break;
                            }
                            case Complete: {
                                (this).Overview.this.operationEngine.removeListener((EngineShell.EngineListener)this);
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (this.getRes().size() > 0) {
                                            ((this).this).Overview.this.operationTableViewer.setInput((Object)this.getRes().toArray(new OverviewCountedApplicationElement[this.getRes().size()]));
                                            ((this).this).Overview.this.operationTableViewer.refresh();
                                            ViewHelper.setStatusInformationMessage((IWorkbenchPart)Overview.this, (String)MessageFormat.format("", this.getRes().size()));
                                        } else {
                                            ViewHelper.setStatusInformationMessage((IWorkbenchPart)Overview.this, (String)"");
                                        }
                                    }
                                });
                                break;
                            }
                        }
                    }

                    public List<Object> getRes() {
                        return this.res;
                    }
                });
                Overview.this.operationEngine.start();
                return Status.OK_STATUS;
            }
        };
        this.job.setPriority(20);
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(this.job, 0L, true);
    }

    private void createPlatformControl(Composite parent) {
        this.platformText = this.createToolbar(parent, ColumnDefinition.ACPLATNM);
        GridData data1 = new GridData();
        data1.grabExcessHorizontalSpace = true;
        data1.grabExcessVerticalSpace = true;
        data1.verticalAlignment = 4;
        data1.horizontalAlignment = 4;
        this.platformTableViewer = new TableViewer(parent, 268437506);
        this.platformTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            String[] platforms = new String[0];

            public Object[] getElements(Object inputElement) {
                return this.platforms;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput != null) {
                    this.platforms = (String[])newInput;
                    Overview.this.platformTableViewer.getTable().redraw();
                    Overview.this.platformTableViewer.refresh();
                }
            }
        });
        this.platformTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return Activator.getDefault().getImage(ColumnDefinition.ACPLATNM.getDBColumnRef());
            }

            public String getText(Object element) {
                return element == null ? "" : (String)element;
            }
        });
        this.platformTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().equals(Overview.this.currentSelection)) {
                    if (event.getSelection().isEmpty()) {
                        Overview.this.applicationTableViewer.setInput((Object)new String[0]);
                        Overview.this.applicationTableViewer.getTable().clearAll();
                    } else {
                        Overview.this.runPlatformApplicationQuery(((StructuredSelection)event.getSelection()).toArray());
                    }
                    Overview.this.setSelection(event.getSelection());
                }
            }
        });
        this.platformTableViewer.getTable().setLayoutData((Object)data1);
        Label separator = new Label(parent, 258);
        GridData data2 = new GridData();
        data2.grabExcessHorizontalSpace = true;
        data2.grabExcessVerticalSpace = false;
        data2.verticalAlignment = 3;
        data2.horizontalAlignment = 4;
        separator.setLayoutData((Object)data2);
        parent.layout();
    }

    private void createApplicationControl(Composite parent) {
        this.applicationText = this.createToolbar(parent, ColumnDefinition.ACAPPLNM);
        GridData data1 = new GridData();
        data1.grabExcessHorizontalSpace = true;
        data1.grabExcessVerticalSpace = true;
        data1.verticalAlignment = 4;
        data1.horizontalAlignment = 4;
        this.applicationTableViewer = new TableViewer(parent, 268437506);
        this.applicationTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            String[] applications = new String[0];

            public Object[] getElements(Object inputElement) {
                return this.applications;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput != null) {
                    this.applications = (String[])newInput;
                    Overview.this.applicationTableViewer.getTable().redraw();
                    Overview.this.applicationTableViewer.refresh();
                }
            }
        });
        this.applicationTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return Activator.getDefault().getImage(ColumnDefinition.ACAPPLNM.getDBColumnRef());
            }

            public String getText(Object element) {
                return element == null ? "" : (String)element;
            }
        });
        this.applicationTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().equals(Overview.this.currentSelection)) {
                    Overview.this.operationTableViewer.setInput((Object)new OverviewCountedApplicationElement[0]);
                    Overview.this.operationTableViewer.getTable().clearAll();
                    if (event.getSelection().isEmpty()) {
                        Overview.this.versionTableViewer.setInput((Object)new String[0]);
                        Overview.this.versionTableViewer.getTable().clearAll();
                    } else {
                        Overview.this.runPlatformApplicationVersionQuery(((StructuredSelection)event.getSelection()).toArray());
                    }
                    Overview.this.setSelection(event.getSelection());
                }
            }
        });
        this.applicationTableViewer.getTable().setLayoutData((Object)data1);
        Label separator = new Label(parent, 258);
        GridData data2 = new GridData();
        data2.grabExcessHorizontalSpace = true;
        data2.grabExcessVerticalSpace = false;
        data2.verticalAlignment = 3;
        data2.horizontalAlignment = 4;
        separator.setLayoutData((Object)data2);
        parent.layout();
    }

    private void createApplicationVersionControl(Composite parent) {
        this.versionText = this.createToolbar(parent, ColumnDefinition.ACAPPLVR);
        GridData data1 = new GridData();
        data1.grabExcessHorizontalSpace = true;
        data1.grabExcessVerticalSpace = true;
        data1.verticalAlignment = 4;
        data1.horizontalAlignment = 4;
        this.versionTableViewer = new TableViewer(parent, 268437506);
        this.versionTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            String[] applications = new String[0];

            public Object[] getElements(Object inputElement) {
                return this.applications;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput != null) {
                    this.applications = (String[])newInput;
                    Overview.this.versionTableViewer.getTable().redraw();
                    Overview.this.versionTableViewer.refresh();
                }
            }
        });
        this.versionTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return Activator.getDefault().getImage(ColumnDefinition.ACAPPLVR.getDBColumnRef());
            }

            public String getText(Object element) {
                return (String)(element == null ? "" : element);
            }
        });
        this.versionTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().equals(Overview.this.currentSelection)) {
                    if (event.getSelection().isEmpty()) {
                        Overview.this.operationTableViewer.setInput((Object)new OverviewCountedApplicationElement[0]);
                        Overview.this.operationTableViewer.getTable().clearAll();
                    } else {
                        Overview.this.runPlatformApplicationOperationQuery(((StructuredSelection)event.getSelection()).toArray());
                    }
                    Overview.this.setSelection(event.getSelection());
                }
            }
        });
        this.versionTableViewer.getTable().setLayoutData((Object)data1);
        Label separator = new Label(parent, 258);
        GridData data2 = new GridData();
        data2.grabExcessHorizontalSpace = true;
        data2.grabExcessVerticalSpace = false;
        data2.verticalAlignment = 3;
        data2.horizontalAlignment = 4;
        separator.setLayoutData((Object)data2);
        parent.layout();
    }

    private void fillViewMenuDropdown(IMenuManager menuManager) {
        IEvaluationService srv = (IEvaluationService)this.getViewSite().getService(IEvaluationService.class);
        srv.requestEvaluation("com.ibm.cics.pa.ui.stats");
        menuManager.update(true);
    }

    private void fillActionBar(IActionBars actionBars) {
        this.fillToolBar(actionBars.getToolBarManager());
        actionBars.updateActionBars();
    }

    private void fillToolBar(IToolBarManager toolBar) {
        if (this.resetColumnsAction != null) {
            toolBar.add((IAction)this.resetColumnsAction);
        }
    }

    private void makeActions(IWorkbenchWindow workbenchWindow) {
    }

    private void createApplicationOperationControl(Composite parent) {
        this.operationText = this.createToolbar(parent, ColumnDefinition.ACOPERNM);
        GridData data1 = new GridData();
        data1.grabExcessHorizontalSpace = true;
        data1.grabExcessVerticalSpace = true;
        data1.verticalAlignment = 4;
        data1.horizontalAlignment = 4;
        this.operationTableViewer = new TableViewer(parent, 268437506);
        this.operationTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            OverviewCountedApplicationElement[] applications = new OverviewCountedApplicationElement[0];

            public Object[] getElements(Object inputElement) {
                return this.applications;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput != null) {
                    this.applications = (OverviewCountedApplicationElement[])newInput;
                    Overview.this.operationTableViewer.getTable().redraw();
                    Overview.this.operationTableViewer.refresh();
                }
            }
        });
        this.operationTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return Activator.getDefault().getImage(ColumnDefinition.ACOPERNM.getDBColumnRef());
            }

            public String getText(Object element) {
                return element == null ? "" : String.valueOf(((OverviewCountedApplicationElement)element).getLabel()) + " (" + ((OverviewCountedApplicationElement)element).getCount() + ")";
            }
        });
        this.operationTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().equals(Overview.this.currentSelection)) {
                    Overview.this.setSelection(event.getSelection());
                }
            }
        });
        this.operationTableViewer.getTable().setLayoutData((Object)data1);
        Label separator = new Label(parent, 258);
        GridData data2 = new GridData();
        data2.grabExcessHorizontalSpace = true;
        data2.grabExcessVerticalSpace = false;
        data2.verticalAlignment = 3;
        data2.horizontalAlignment = 4;
        separator.setLayoutData((Object)data2);
        parent.layout();
    }

    protected void modeCheck() {
        ICommandService commandService = (ICommandService)this.getSite().getService(ICommandService.class);
        if (commandService != null) {
            commandService.refreshElements("com.ibm.cics.pa.ui.commands.tabledialog1", null);
        }
        this.currentMode = PAContextTracker.inOverviewMode();
        if (this.currentMode) {
            try {
                this.getViewSite().getPage().showView("com.ibm.cics.pa.ui.linked.plotview");
                this.setSelection(this.getSelection());
            }
            catch (PartInitException e) {
                Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"preferenceChange", (Throwable)e);
            }
        } else {
            try {
                this.getViewSite().getPage().showView("com.ibm.cics.pa.ui.sheeteditor");
                this.getViewSite().getPage().showView("com.ibm.cics.pa.ui.overview");
                this.setSelection(this.getSelection());
            }
            catch (PartInitException e) {
                Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"preferenceChange", (Throwable)e);
            }
        }
    }

    public void createNavigatorComposite(Composite parent) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"createNavigatorComposite");
        TableSelectorContentProvider contentProvider = new TableSelectorContentProvider((Object)TableCategorisationEnum.Root){

            @Override
            public boolean hasChildren(Object element) {
                return !(element instanceof String) && !(element instanceof ManifestRecord);
            }
        };
        PATreeColumnViewerLabelProvider labelProvider = new PATreeColumnViewerLabelProvider(false);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.filteredTree = new FilteredTree(parent, 2820, new PatternFilter(){

            protected boolean isParentMatch(Viewer viewer, Object element) {
                Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element);
                if (element instanceof ManifestRecord || element instanceof TableCategorisationEnum) {
                    return this.filter(viewer, element, children).length > 0;
                }
                return false;
            }
        }, true);
        this.filteredTree.getFilterControl().setEnabled(false);
        this.navigatorTreeViewer = this.filteredTree.getViewer();
        this.navigatorTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.navigatorTreeViewer, (int)2);
        this.navigatorTreeViewer.setContentProvider((IContentProvider)contentProvider);
        this.navigatorTreeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.navigatorTreeViewer.getTree().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!Overview.this.navigatorTreeViewer.getSelection().isEmpty()) {
                    String msg = "";
                    Object selected_element = ((StructuredSelection)Overview.this.navigatorTreeViewer.getSelection()).getFirstElement();
                    if (selected_element instanceof ManifestRecord) {
                        Overview.this.navigatorSelectedrecord = (ManifestRecord)((StructuredSelection)Overview.this.navigatorTreeViewer.getSelection()).getFirstElement();
                        msg = MessageFormat.format(Messages.getString("TableDialog.TableSelected"), Overview.this.navigatorSelectedrecord.getDescription(), Overview.this.navigatorSelectedrecord.getAlias());
                        Overview.this.gridParent.layout();
                    } else if (selected_element instanceof String) {
                        msg = MessageFormat.format(Messages.getString("Overview.missing"), selected_element);
                    }
                    ViewHelper.setStatusInformationMessage((IWorkbenchPart)Overview.this, (String)msg);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (!Overview.this.navigatorTreeViewer.getSelection().isEmpty() && ((StructuredSelection)Overview.this.navigatorTreeViewer.getSelection()).getFirstElement() instanceof ManifestRecord && ((ManifestRecord)((StructuredSelection)Overview.this.navigatorTreeViewer.getSelection()).getFirstElement()).isPresent()) {
                    Overview.this.setSelection((ISelection)new StructuredSelection((Object)Overview.this.navigatorTreeViewer.getSelection()));
                    Overview.this.navigatorSelectedrecord = (ManifestRecord)((StructuredSelection)Overview.this.navigatorTreeViewer.getSelection()).getFirstElement();
                    Overview.this.applyTable(Overview.this.navigatorSelectedrecord);
                }
            }
        });
        this.navigatorTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().equals(Overview.this.currentSelection)) {
                    Overview.this.setSelection(event.getSelection());
                }
            }
        });
        this.recordsFeedback = new StyledText(parent, 72);
        this.recordsFeedback.setBackground(parent.getBackground());
        GridData data = new GridData(4, 4, true, false);
        this.recordsFeedback.setLayoutData((Object)data);
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.update();
            }
        });
        Menu popUpMenu = menuManager.createContextMenu((Control)this.navigatorTreeViewer.getTree());
        this.navigatorTreeViewer.getTree().setMenu(popUpMenu);
        this.getSite().registerContextMenu("com.ibm.cics.pa.ui.overview.navigator", menuManager, (ISelectionProvider)this.navigatorTreeViewer);
        PAConnectionTracker.getInstance().addPAConnectionTrackerListener(this);
        ManifestRecord.registerNavigator(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpContextId());
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"createNavigatorComposite");
    }

    void updateFeedback(boolean noPageSwap) {
        String standard = Messages.getString("InUse.records");
        String feedback = ((PASelectionContext)this.getCurrentContext()).getLabelWithoutDates();
        String text = MessageFormat.format(Messages.getString("ChartDefinition.FormattedLabelString"), standard, feedback);
        if (feedback.length() > 0) {
            StyleRange range = new StyleRange(standard.length(), feedback.length() + 3, ColorConstants.blue, this.recordsFeedback.getParent().getBackground());
            this.recordsFeedback.setText(text);
            this.recordsFeedback.setStyleRange(range);
        } else {
            this.recordsFeedback.setText("");
            if (this.doubleParent.getSelectionIndex() == 0 && !noPageSwap && !((PASelectionContext)this.getCurrentContext()).isPopulated()) {
                this.doCompositeSwitch(1);
            }
        }
        this.recordsFeedback.getParent().layout();
    }

    public void refresh(final ManifestRecord manifestRecord) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"refresh");
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Overview.this.navigatorTreeViewer.refresh((Object)manifestRecord);
                Overview.this.filteredTree.getFilterControl().setEnabled(ManifestRecord.tablesInitialised());
                if (StringUtil.hasContent((String)Overview.this.filteredTree.getFilterControl().getText())) {
                    Overview.this.filteredTree.getFilterControl().setText(Overview.this.filteredTree.getFilterControl().getText());
                }
            }
        });
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"refresh");
    }

    void applyTable(ManifestRecord record) {
        if (record != null && record.isPresent() && record.isDateChecked()) {
            Activator.getDefault().getPluginInstancePreferences().put("LAST_TABLE", record.getAlias());
            PAContextTracker.getInstance().readRecordFromManifest(record);
            if (!((PASelectionContext)this.getCurrentContext()).isRelevant(record)) {
                this.doubleParent.setSelection(1);
            }
        }
    }

    public void applyTable() {
        this.navigatorSelectedrecord = (ManifestRecord)((StructuredSelection)this.navigatorTreeViewer.getSelection()).getFirstElement();
        this.applyTable(this.navigatorSelectedrecord);
    }

    private static enum ActiveViewer {
        transaction,
        applid,
        tree,
        platform,
        application,
        version,
        operation;

    }

    class ModeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        ModeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().equals("MODE_OVERVIEW")) {
                Overview.this.modeCheck();
            }
        }
    }
}

