/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.pa.model.CSVFile;
import com.ibm.cics.pa.model.ChartingFile;
import com.ibm.cics.pa.model.TreeElement;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.ui.Messages;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.progress.DeferredTreeContentManager;

public class ExplorerViewContentProvider
implements ITreeContentProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    private static final Object[] NO_CHILDREN = new Object[0];
    private DeferredTreeContentManager manager = null;
    TreeViewer view = null;

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        this.view = (TreeViewer)v;
        this.manager = new DeferredTreeContentManager((AbstractTreeViewer)v);
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = NO_CHILDREN;
        try {
            if (parentElement instanceof TreeElement) {
                return ((TreeElement)parentElement).getChildren();
            }
            if (parentElement instanceof IContainer) {
                if (((IContainer)parentElement).isAccessible()) {
                    children = ((IContainer)parentElement).members();
                }
            } else if (parentElement instanceof IFile && "csv".equalsIgnoreCase(((IFile)parentElement).getFileExtension())) {
                IFile file = (IFile)parentElement;
                if (ChartingFile.referenceExists(file)) {
                    MessageBox messageBox;
                    CSVFile data = CSVFile.get((IFile)parentElement);
                    TreeElement model = data.getRootTreeElement();
                    if (!data.isValid() && Display.getCurrent() != null) {
                        messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 33);
                        messageBox.setMessage(String.valueOf(Messages.getString("ExplorerViewContentProvider.InvalidCSV")) + data.getTabName() + Messages.getString("ExplorerViewContentProvider.Consult"));
                        messageBox.setText(Messages.getString("ExplorerViewContentProvider.InvalidFile"));
                        messageBox.open();
                    }
                    if (data.isCorrupted() && Display.getCurrent() != null) {
                        messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 40);
                        messageBox.setMessage(MessageFormat.format(Messages.getString("ExplorerViewContentProvider.TheCSVFile"), data.getTabName()));
                        messageBox.setText(Messages.getString("ExplorerViewContentProvider.CorruptedTitle"));
                        messageBox.open();
                    }
                    if (model != null && model.getSourceProvider().isValid()) {
                        children = model.getChildren();
                    }
                } else {
                    this.runJob(file);
                }
            }
        }
        catch (CoreException e) {
            logger.logp(Level.SEVERE, ExplorerViewContentProvider.class.getName(), "getChildren", "Core", e);
        }
        return children;
    }

    public Object getParent(Object element) {
        if (element instanceof TreeElement) {
            return ((TreeElement)element).getParent();
        }
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        boolean result = false;
        if (element instanceof TreeElement) {
            if (((TreeElement)element).getSourceProvider().getDataProviderKey() == DataProviderKey.STARTTIME_APPLID_TRAN || ((TreeElement)element).getSourceProvider().getDataProviderKey() == DataProviderKey.STARTTIME_APPLICATION || ((TreeElement)element).getColumn() == ColumnDefinition.START_DATE || ((TreeElement)element).getColumn() == ColumnDefinition.START_TIME) {
                result = ((TreeElement)element).hasChildren();
            }
        } else if (element instanceof IFile && ((IFile)element).getFileExtension() != null) {
            if (((IFile)element).getFileExtension().equalsIgnoreCase("csv")) {
                IFile file = (IFile)element;
                if (ChartingFile.referenceExists(file)) {
                    result = !CSVFile.get((IFile)element).getDataProviderKey().equals((Object)DataProviderKey.NONE);
                } else {
                    this.runJob(file);
                    result = false;
                }
            } else if (((IFile)element).getFileExtension().equalsIgnoreCase("cpa")) {
                return this.manager.mayHaveChildren(element);
            }
        } else {
            result = element instanceof IConnectable ? true : this.manager.mayHaveChildren(element);
        }
        return result;
    }

    private void runJob(final IFile file) {
        Job job = new Job(String.valueOf(file.getName()) + ' ' + Messages.getString("ExplorerViewContentProvider.initialization")){

            protected IStatus run(IProgressMonitor monitor) {
                Debug.enter((Logger)logger, (String)ExplorerViewContentProvider.class.getName(), (String)"run");
                CSVFile dataStore = CSVFile.get(file);
                dataStore.getData(monitor);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).ExplorerViewContentProvider.this.view != null && (this).ExplorerViewContentProvider.this.view instanceof CommonViewer && !(this).ExplorerViewContentProvider.this.view.getTree().isDisposed()) {
                            (this).ExplorerViewContentProvider.this.view.refresh((Object)file);
                        }
                    }
                });
                Debug.exit((Logger)logger, (String)ExplorerViewContentProvider.class.getName(), (String)"run", (Object)Status.OK_STATUS);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.schedule();
    }

    public void clear(IFile file) {
        this.view.remove((Object)file);
    }
}

