/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.ui.ScrollLimitManager;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.pa.model.Chart;
import com.ibm.cics.pa.model.ChartType;
import com.ibm.cics.pa.model.Column;
import com.ibm.cics.pa.model.DataKeyElement;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.GraphModel;
import com.ibm.cics.pa.model.Histogram;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.TreeElement;
import com.ibm.cics.pa.model.definitions.CategorisationHelper;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.HistogramChartSpecificDefinitions;
import com.ibm.cics.pa.model.definitions.PersistedChartDefinition;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.ChartManager;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.editors.PAResourceChangeListener;
import com.ibm.cics.pa.ui.figures.ChartSelectable;
import com.ibm.cics.pa.ui.figures.CombinedLineHistogram;
import com.ibm.cics.pa.ui.figures.CommonHistogram;
import com.ibm.cics.pa.ui.remote.DBQueryFactoryCustomer;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.cics.pa.ui.remote.RemoteEditorInput;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.views.IChartColorPreferenceDependent;
import com.ibm.cics.pa.ui.views.SheetView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.MouseWheelHelper;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class ChartView
extends ViewPart
implements MouseWheelHelper,
ISelectionProvider,
ISelectionChangedListener,
DBQueryFactoryCustomer,
IChartColorPreferenceDependent {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2022 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    private static final int TEXT_SECTION_WIDTH = 275;
    public static final String ID = "com.ibm.cics.pa.ui.charteditor";
    public static final boolean isLinux = System.getProperty("os.name").equals("Linux");
    protected FigureCanvas viewer;
    protected GraphicalViewer graphicalViewer;
    private Command currentEngine;
    protected GraphModel model = null;
    public Image legendImage = Activator.getDefault().getImage("legend");
    public Image counterIcon = Activator.getDefault().getImage("count");
    public Image upArrow = Activator.getDefault().getImage("upArrow");
    private CommonHistogram figure;
    protected ScrollLimitManager scrollLimitManager;
    protected Scale scale;
    public final int iconSize = isLinux ? 32 : 20;
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    protected Canvas basicSWT = null;
    protected Button legendButton = null;
    private IResourceChangeListener resourceListener = null;
    private Image elementImage = Activator.getDefault().getImage(Activator.IMGD_TRAN);
    private boolean duplicate = false;
    protected Composite originalParent;
    protected Composite parent1;
    protected Composite parent2;
    private int lastCount = 0;
    private Label dateText;
    private Label timeText;
    private Label tranText;
    private Label applidText;
    private StyledText[] valueText = new StyledText[0];
    private int widthHint;
    protected Menu menu;
    protected boolean iRefreshing;

    public ChartView() {
        this.widthHint = FigureUtilities.getTextWidth((String)"999,999.00000009", (Font)Activator.getDefault().fontArialLarge);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void barNodeDoubleClicked(IUniqueRecord uniqueRecord) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"barNodeDoubleClicked");
        ChartSpecification chart = CategorisationHelper.getNextChartFor(this.getModel().getChartReference());
        String shortRef = DataKeyElement.createDataKey(this.getDataProvider(), uniqueRecord.getRow()).getFullDescriptiveReference();
        if (chart != null) {
            String id = ChartManager.getInstance().createChart(chart, this.getDataProvider(), shortRef, uniqueRecord, null);
            if (id.length() > 0) {
                try {
                    switch (chart.getType()) {
                        case PIE: {
                            this.getSite().getPage().showView("com.ibm.cics.pa.ui.pie_editor", id, 1);
                            break;
                        }
                    }
                }
                catch (PartInitException e) {
                    logger.logp(Level.SEVERE, ChartView.class.getName(), "barNodeDoubleClicked", "unable to open editor", e);
                }
            } else {
                logger.logp(Level.SEVERE, ChartView.class.getName(), "barNodeDoubleClicked", Messages.getString("ChartEditor.message.incompatible"));
            }
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"barNodeDoubleClicked");
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.model = (GraphModel)Chart.getReference(site.getSecondaryId());
        if (this.model != null) {
            String title = "";
            title = this.model.getDataProvider() instanceof RemoteEditorInput ? String.valueOf(title) + ((RemoteEditorInput)this.model.getDataProvider()).getRemoteConnectionProvider().getConnectionName() + " " : String.valueOf(title) + this.model.getDataProvider().getRootSource().getName() + " ";
            title = String.valueOf(title) + this.model.getChartReference().getTitle();
            this.setPartName(title);
            if (this.isCompact()) {
                this.setTitleImage(Activator.getDefault().getImage("line"));
            }
        }
    }

    public void createPartControl(final Composite parent) {
        this.originalParent = parent;
        if (this.getModel() != null) {
            parent.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout gridLayout = this.leanLayout(new GridLayout(2, false));
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 0;
            parent.setLayout((Layout)gridLayout);
            parent.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    parent.layout();
                    ChartView.this.resize(parent);
                }
            });
            this.parent1 = new Composite(parent, 0);
            this.parent1.setLayoutData((Object)new GridData(16384, 4, true, true));
            this.parent1.setLayout((Layout)this.leanLayout(new GridLayout(2, false)));
            this.parent1.setBackground(parent.getBackground());
            ScrolledComposite c2 = new ScrolledComposite(parent, 512);
            c2.setBackground(parent.getBackground());
            c2.setMinWidth(275);
            c2.setExpandHorizontal(true);
            c2.setExpandVertical(true);
            c2.setLayoutData((Object)new GridData(4, 4, false, true));
            c2.setLayout((Layout)new GridLayout());
            this.parent2 = new Composite((Composite)c2, 0);
            this.parent2.setBackground(parent.getBackground());
            this.parent2.setLayoutData((Object)new GridData(4, 4, false, true));
            this.parent2.setBackground(ColorConstants.white);
            c2.setContent((Control)this.parent2);
            GridLayout p2Layout = new GridLayout(2, false);
            p2Layout.marginLeft = 20;
            this.parent2.setLayout((Layout)p2Layout);
            Label tempText = new Label(this.parent2, 0);
            tempText.setFont(Activator.getDefault().fontArialLarge);
            tempText.setText(ColumnDefinition.START_DATE.getLabel(null));
            tempText.setLayoutData((Object)new GridData(16384, 4, false, false));
            tempText.setBackground(this.parent2.getBackground());
            this.dateText = new Label(this.parent2, 0x1000000);
            GridData textLayout = new GridData(0x1000000, 4, false, false);
            textLayout.widthHint = this.widthHint;
            this.dateText.setLayoutData((Object)textLayout);
            this.dateText.setBackground(this.parent2.getBackground());
            tempText = new Label(this.parent2, 0);
            tempText.setFont(Activator.getDefault().fontArialLarge);
            tempText.setText(ColumnDefinition.START_TIME.getLabel(null));
            tempText.setLayoutData((Object)new GridData(16384, 4, false, false));
            tempText.setBackground(this.parent2.getBackground());
            this.timeText = new Label(this.parent2, 0x1000000);
            textLayout = new GridData(0x1000000, 4, false, false);
            textLayout.widthHint = this.widthHint;
            this.timeText.setLayoutData((Object)textLayout);
            this.timeText.setBackground(this.parent2.getBackground());
            tempText = new Label(this.parent2, 0);
            tempText.setFont(Activator.getDefault().fontArialLarge);
            tempText.setText(ColumnDefinition.APPLID.getLabel(null));
            tempText.setLayoutData((Object)new GridData(16384, 4, false, false));
            tempText.setBackground(this.parent2.getBackground());
            this.applidText = new Label(this.parent2, 0x1000000);
            textLayout = new GridData(0x1000000, 4, false, false);
            textLayout.widthHint = this.widthHint;
            this.applidText.setLayoutData((Object)textLayout);
            this.applidText.setBackground(this.parent2.getBackground());
            tempText = new Label(this.parent2, 0);
            tempText.setFont(Activator.getDefault().fontArialLarge);
            tempText.setText(ColumnDefinition.TRAN.getLabel(null));
            tempText.setLayoutData((Object)new GridData(16384, 4, false, false));
            tempText.setBackground(this.parent2.getBackground());
            this.tranText = new Label(this.parent2, 0x1000000);
            textLayout = new GridData(0x1000000, 4, false, false);
            textLayout.widthHint = this.widthHint;
            this.tranText.setLayoutData((Object)textLayout);
            this.tranText.setBackground(this.parent2.getBackground());
            this.valueText = new StyledText[((PersistedChartDefinition)this.getModel().getChartReference()).getAllColumnDefinitions().size()];
            int i = 0;
            while (i < this.valueText.length) {
                tempText = new Label(this.parent2, 0);
                tempText.setFont(Activator.getDefault().fontArialLarge);
                tempText.setText(((PersistedChartDefinition)this.getModel().getChartReference()).getAllColumnDefinitions().get(i).getLabel(null));
                tempText.setLayoutData((Object)new GridData(16384, 4, false, false));
                tempText.setBackground(this.parent2.getBackground());
                this.valueText[i] = new StyledText(this.parent2, 0);
                this.valueText[i].setEditable(false);
                this.valueText[i].setBackground(this.parent2.getBackground());
                textLayout = new GridData(0x1000000, 4, true, false);
                textLayout.widthHint = this.widthHint;
                this.valueText[i].setLayoutData((Object)textLayout);
                ++i;
            }
            String title = "";
            title = this.getModel().getDataProvider() instanceof RemoteEditorInput ? String.valueOf(title) + ((RemoteEditorInput)this.getModel().getDataProvider()).getRemoteConnectionProvider().getConnectionName() + " " : String.valueOf(title) + this.getModel().getDataProvider().getRootSource().getName() + " ";
            title = String.valueOf(title) + this.getModel().getChartReference().getTitle();
            this.setPartName(title);
            this.setContentDescription(this.getDataProvider().getAbridgedReference());
            Composite sliderGroup = new Composite(this.parent1, 0);
            sliderGroup.setLayout((Layout)new GridLayout());
            sliderGroup.setLayoutData((Object)new GridData(4, 4, false, true));
            this.basicSWT = new Decorations(sliderGroup, 0x20000000);
            this.basicSWT.setLayoutData((Object)new GridData(4, 128, false, false));
            this.legendButton = new Button((Composite)this.basicSWT, 8);
            this.legendButton.setImage(this.legendImage);
            this.legendButton.setBounds(0, 0, this.iconSize, this.iconSize);
            this.legendButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = Messages.getString("ChartEditor.Legend");
                }
            });
            this.legendButton.setToolTipText(Messages.getString("ChartEditor.Legend"));
            this.menu = new Menu((Decorations)this.basicSWT, 8);
            if (this.getModel().getChartReference().getSpecificType() instanceof HistogramChartSpecificDefinitions) {
                MenuItem menuItem;
                ColumnDefinition column;
                ColumnDefinition[] columnDefinitionArray = ((HistogramChartSpecificDefinitions)this.getModel().getChartReference().getSpecificType()).getPrimaryReqts();
                int n = columnDefinitionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    column = columnDefinitionArray[n2];
                    menuItem = new MenuItem(this.menu, 8);
                    menuItem.setData((Object)column);
                    menuItem.setText(column.getLabel(null));
                    menuItem.setImage(Column.getFor((ColumnDefinition)menuItem.getData()).getImage());
                    ++n2;
                }
                columnDefinitionArray = ((HistogramChartSpecificDefinitions)this.getModel().getChartReference().getSpecificType()).getSecondaryReqts();
                n = columnDefinitionArray.length;
                n2 = 0;
                while (n2 < n) {
                    column = columnDefinitionArray[n2];
                    menuItem = new MenuItem(this.menu, 8);
                    menuItem.setData((Object)column);
                    menuItem.setText(column.getLabel(null));
                    menuItem.setImage(Column.getFor((ColumnDefinition)menuItem.getData()).getImage());
                    ++n2;
                }
            }
            this.legendButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem[] menuItemArray = ChartView.this.menu.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem menuItem = menuItemArray[n2];
                        menuItem.setImage(Column.getFor((ColumnDefinition)menuItem.getData()).getImage());
                        ++n2;
                    }
                    Rectangle rect = ChartView.this.legendButton.getBounds();
                    Point pt = new Point(rect.x, rect.y + rect.height);
                    pt = ChartView.this.basicSWT.toDisplay(pt);
                    ChartView.this.menu.setLocation(pt.x, pt.y);
                    ChartView.this.menu.setVisible(true);
                }
            });
            this.graphicalViewer = new ScrollingGraphicalViewer();
            this.viewer = (FigureCanvas)this.graphicalViewer.createControl(this.parent1);
            this.viewer.setLayoutData((Object)new GridData(16384, 4, true, true));
            this.viewer.getViewport().setContentsTracksWidth(true);
            this.viewer.setVerticalScrollBarVisibility(FigureCanvas.NEVER);
            Button[] buttons = this.getFigure().getAdditionalButtons(this.basicSWT);
            if (buttons != null && buttons.length > 0) {
                int i2 = 0;
                while (i2 < buttons.length) {
                    int n = this.iconSize * i2;
                    buttons[i2].setBounds(50 + n, 0, this.iconSize, this.iconSize);
                    ++i2;
                }
            }
            this.scale = new Scale(sliderGroup, 512);
            this.scale.setMaximum(50);
            this.scale.setMinimum(0);
            this.scale.setIncrement(1);
            this.scale.setPageIncrement(5);
            this.scale.setSelection(50);
            this.scale.setLayoutData((Object)new GridData(16384, 4, false, true));
            this.scale.setSize(25, this.getSite().getShell().getBounds().height / 2);
            this.scale.setBackground(ColorConstants.white);
            this.scale.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ChartView.this.handleMouseWheelScrolled(null);
                }

                public void widgetSelected(SelectionEvent e) {
                    ChartView.this.handleMouseWheelScrolled(null);
                }
            });
            this.scale.addMouseWheelListener(new MouseWheelListener(){

                public void mouseScrolled(MouseEvent e) {
                    ChartView.this.handleMouseWheelScrolled(null);
                }
            });
            this.scale.setToolTipText(Messages.getString("ChartEditor.Resize"));
            this.scale.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    event.doit = true;
                }
            });
            this.parent1.setTabList(new Control[]{sliderGroup, this.viewer});
            this.viewer.addMouseWheelListener(new MouseWheelListener(){

                public void mouseScrolled(MouseEvent e) {
                    ChartView.this.scale.setSelection(ChartView.this.scale.getSelection() - e.count);
                    ChartView.this.handleMouseWheelScrolled(null);
                    ChartView.this.scale.redraw();
                }
            });
            MenuManager menuManager = new MenuManager();
            Menu popUpMenu = menuManager.createContextMenu(this.graphicalViewer.getControl());
            this.viewer.setMenu(popUpMenu);
            this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.graphicalViewer);
            Action action = new Action(){

                public String getId() {
                    return ActionFactory.SELECT_ALL.getId();
                }

                public String getActionDefinitionId() {
                    return ActionFactory.SELECT_ALL.getId();
                }

                public void run() {
                    ChartView.this.selectAll();
                }
            };
            this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)action);
            action = new Action(){

                public String getId() {
                    return ActionFactory.COPY.getId();
                }

                public String getActionDefinitionId() {
                    return ActionFactory.COPY.getId();
                }

                public void run() {
                    ChartView.this.copyToClipboard();
                }
            };
            this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)action);
            this.getViewSite().getActionBars().updateActionBars();
            this.viewer.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    event.doit = true;
                }
            });
            this.viewer.addListener(15, new Listener(){

                public void handleEvent(Event event) {
                    if (ChartView.this.getFigure() != null) {
                        ChartView.this.getFigure().showFocusColumn(true);
                    }
                }
            });
            this.viewer.addListener(16, new Listener(){

                public void handleEvent(Event event) {
                    if (ChartView.this.getFigure() != null) {
                        ChartView.this.getFigure().showFocusColumn(false);
                    }
                }
            });
            this.viewer.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    if ((e.stateMask & 0x40000) != 0) {
                        switch (e.character) {
                            case '\u0001': {
                                ChartView.this.selectAll();
                                break;
                            }
                            case '\u0003': {
                                ChartView.this.copyToClipboard();
                                break;
                            }
                        }
                    } else if (e.keyCode == 13) {
                        ChartSelectable column = ChartView.this.getFigure().getFocusColumn();
                        if (column != null) {
                            ChartView.this.barNodeDoubleClicked(column.getUniqueRecord());
                        }
                    } else if ((e.stateMask & 0x20000) == 0) {
                        switch (e.keyCode) {
                            case 0x1000002: 
                            case 0x1000006: {
                                int newSetting = ChartView.this.scale.getSelection();
                                if (ChartView.this.scale.getSelection() < ChartView.this.scale.getMaximum()) {
                                    ++newSetting;
                                }
                                ChartView.this.scale.setSelection(newSetting);
                                ChartView.this.getFigure().setZoom(ChartView.this.scale.getMaximum() + 1 - newSetting);
                                break;
                            }
                            case 0x1000001: 
                            case 0x1000005: {
                                int newSetting = ChartView.this.scale.getSelection();
                                if (ChartView.this.scale.getSelection() > ChartView.this.scale.getMinimum()) {
                                    --newSetting;
                                }
                                ChartView.this.scale.setSelection(newSetting);
                                ChartView.this.getFigure().setZoom(ChartView.this.scale.getMaximum() + 1 - newSetting);
                                break;
                            }
                            default: {
                                ChartView.this.getFigure().noModifierMode(e.keyCode);
                            }
                        }
                    }
                }

                public void keyReleased(KeyEvent e) {
                    if ((e.stateMask & 0x40000) != 0) {
                        switch (e.character) {
                            case '\u0001': {
                                break;
                            }
                            case '\u0003': {
                                break;
                            }
                            default: {
                                ChartView.this.getFigure().ctrlMode(e.keyCode);
                                break;
                            }
                        }
                    } else if ((e.stateMask & 0x20000) != 0) {
                        char cfr_ignored_0 = e.character;
                        ChartView.this.getFigure().shiftMode(e.keyCode);
                    }
                }
            });
            parent.layout(true);
            if (this.getDataProvider() != null) {
                this.getDataProvider().incrementUseCount();
            }
            if (PAConnectionTracker.getInstance().isConnected()) {
                this.scrollLimitManager = new ScrollLimitManager(parent, Messages.getString("Records"), (IViewPart)this){

                    public void scrollLimitReached(Command command) {
                        super.scrollLimitReached(command);
                        parent.layout(new Control[]{ChartView.this.parent1, ChartView.this.scrollLimitManager.scrollLimitComposite});
                    }

                    public void dispose() {
                        if (!parent.isDisposed()) {
                            super.dispose();
                            parent.layout(new Control[]{ChartView.this.parent1});
                        }
                    }
                };
            }
            if (this.getDataProvider().getFileReference() != null) {
                this.resourceListener = new PAResourceChangeListener((IViewPart)this, (IPath)new Path(this.getDataProvider().getRootSource().getFileReference()));
                ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
            }
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpContextId());
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        Object sel = this.getSite().getWorkbenchWindow().getSelectionService().getSelection();
        if (sel == null) {
            IEclipseContext eclipseContext = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
            ESelectionService selectionService = (ESelectionService)eclipseContext.get(ESelectionService.class);
            sel = selectionService.getSelection();
        }
        if (sel != null && sel instanceof IStructuredSelection) {
            this.setSelection((ISelection)((IStructuredSelection)sel));
        }
    }

    protected String getHelpContextId() {
        return ID;
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.setFocus();
        }
    }

    public void dispose() {
        if (this.resourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        }
        this.getSite().setSelectionProvider(null);
        if (this.getDataProvider() != null && !this.duplicate) {
            this.getDataProvider().decrementUseCount();
        }
        if (this.getModel() != null && !this.duplicate) {
            this.getModel().remove();
        }
        super.dispose();
    }

    public Object getAdapter(Class type) {
        if (type == GraphicalViewer.class) {
            return this.graphicalViewer;
        }
        if (type == ZoomManager.class) {
            return ((ScalableRootEditPart)this.graphicalViewer.getRootEditPart()).getZoomManager();
        }
        return super.getAdapter(type);
    }

    public int getSelectionCount() {
        if (this.getFigure() != null) {
            return ((StructuredSelection)this.getFigure().getSelection()).size();
        }
        return 0;
    }

    public boolean allSelected() {
        return this.getSelectionCount() == this.getModel().getPrimaryColumns().size();
    }

    public ISelection getSelection() {
        if (this.figure == null) {
            return new StructuredSelection();
        }
        return this.getFigure().getSelection();
    }

    public void copyToClipboard() {
        Clipboard clipboard = new Clipboard(this.viewer.getDisplay());
        StringBuffer buffer1 = new StringBuffer();
        StringBuffer buffer2 = new StringBuffer();
        TextTransfer textTransfer = TextTransfer.getInstance();
        FileTransfer fileTransfer = FileTransfer.getInstance();
        DataTypeUtilities.interpretHeadersForTransfer(this.getDataProvider().getHeaders(), this.getDataProvider().getColumnDefinitions(), ',', buffer1, '\t', buffer2);
        for (ChartSelectable selectable : this.figure.getCurrentSelections()) {
            selectable.getDataRow();
            buffer1.append('\n');
            buffer2.append('\n');
            DataTypeUtilities.interpretForTransfer(selectable.getDataRow(), ',', buffer1, '\t', buffer2);
        }
        try {
            File file = File.createTempFile(Messages.getString("Temporary.name"), ".csv");
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(buffer1.toString().getBytes());
            fos.close();
            Image image = new Image((Device)this.viewer.getDisplay(), this.viewer.getClientArea());
            GC gc = new GC((Drawable)this.viewer);
            gc.copyArea(image, 0, 0);
            gc.dispose();
            ImageTransfer transfer = ImageTransfer.getInstance();
            clipboard.setContents(new Object[]{buffer2.toString(), new String[]{file.getAbsolutePath()}, image.getImageData()}, new Transfer[]{textTransfer, fileTransfer, transfer});
            image.dispose();
            file.deleteOnExit();
            clipboard.dispose();
        }
        catch (IOException e) {
            Debug.error((Logger)logger, (String)SheetView.class.getName(), (String)"doCopy", (Throwable)e);
        }
    }

    public GraphModel getModel() {
        return this.model;
    }

    public GenericDataProvider getDataProvider() {
        if (this.getModel() != null) {
            return this.getModel().getDataProvider();
        }
        return null;
    }

    public CommonHistogram getFigure() {
        if (this.figure == null && this.getModel() != null) {
            Control[] controlArray = this.viewer.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                ++n2;
            }
            switch (this.getModel().getChartReference().getType()) {
                case HISTOGRAM: 
                case COMPACT_HISTOGRAM: {
                    this.figure = new CommonHistogram(this, (Histogram)this.getModel(), this.viewer);
                    break;
                }
                case COMBINEDHISTOGRAMLINE: {
                    this.figure = new CombinedLineHistogram(this, (Histogram)this.getModel(), this.viewer);
                    break;
                }
            }
        }
        return this.figure;
    }

    public void handleMouseWheelScrolled(Event event) {
        int factor = 51 - this.scale.getSelection();
        this.getFigure().setZoom(factor);
    }

    void resize(Composite parent) {
        if (this.getModel() != null && !parent.isDisposed() && this.getDataProvider() != null && !this.duplicate) {
            this.viewer.setContents((IFigure)this.getFigure());
            Rectangle area = parent.getClientArea();
            if (area.width > 0) {
                this.getFigure().setPreferredSize(new Dimension(this.getModel().getPreferrerdPixelWidth() + this.getModel().getLeftMargin() + this.getModel().getRightMargin() + 50, area.height));
            } else {
                this.getFigure().setPreferredSize(new Dimension(Math.min(this.getModel().getPreferrerdPixelWidth() + this.getModel().getLeftMargin() + this.getModel().getRightMargin(), 1000), parent.getClientArea().height));
            }
            parent.layout();
            this.lastCount = this.getDataProvider().getData().length;
        }
    }

    public void setSelection(ISelection selection) {
        IUniqueRecord record;
        int size;
        if (!((StructuredSelection)selection).isEmpty() && ((StructuredSelection)selection).getFirstElement() instanceof ChartSelectable) {
            this.getFigure().setSelection(selection);
            size = ((StructuredSelection)selection).size();
            if (size == 1) {
                record = ((ChartSelectable)((Object)((StructuredSelection)selection).getFirstElement())).getUniqueRecord();
                this.setStatusMessage(this.elementImage, record.getRelativeText());
                this.setvalues(record);
            } else if (size > 1) {
                this.setStatusMessage("" + size + ' ' + Messages.getString("SheetEditor.ItemsSelected"));
                this.setvalues((IUniqueRecord)((StructuredSelection)selection).getFirstElement());
            }
        } else if (!((StructuredSelection)selection).isEmpty() && ((StructuredSelection)selection).getFirstElement() instanceof IUniqueRecord) {
            this.getFigure().setSelection(selection);
            size = ((StructuredSelection)selection).size();
            if (size == 1) {
                record = (IUniqueRecord)((StructuredSelection)selection).getFirstElement();
                this.setStatusMessage(this.elementImage, record.getRelativeText());
                this.setvalues(record);
            } else if (size > 1) {
                this.setStatusMessage("" + size + ' ' + Messages.getString("SheetEditor.ItemsSelected"));
                this.setvalues((IUniqueRecord)((StructuredSelection)selection).getFirstElement());
            }
        } else if (!((StructuredSelection)selection).isEmpty() && ((StructuredSelection)selection).getFirstElement() instanceof TreeElement) {
            this.getFigure().setSelection(selection);
        }
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Iterator<ISelectionChangedListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ISelectionChangedListener listener;
            final ISelectionChangedListener finalListener = listener = iterator.next();
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    finalListener.selectionChanged(event);
                }
            });
        }
    }

    private void setvalues(IUniqueRecord record) {
        this.applidText.setText(DataTypeUtilities.getAsString(record.getReferenceMapping().get(ColumnDefinition.APPLID)));
        this.tranText.setText(DataTypeUtilities.getAsString(record.getReferenceMapping().get(ColumnDefinition.TRAN)));
        this.dateText.setText(DataTypeUtilities.getAsString(record.getReferenceMapping().get(ColumnDefinition.START_DATE)));
        this.timeText.setText(DataTypeUtilities.getAsString(record.getReferenceMapping().get(ColumnDefinition.START_TIME)));
        int i = 0;
        while (i < this.valueText.length) {
            ColumnDefinition column = ((PersistedChartDefinition)this.getModel().getChartReference()).getAllColumnDefinitions().get(i);
            Number value = (Number)record.getCompleteMapping(false).get(column);
            String text = value.floatValue() == 0.0f ? "" : DataTypeUtilities.getAsString(value);
            this.valueText[i].setText(text);
            StyleRange range1 = new StyleRange();
            range1.start = 0;
            range1.length = this.valueText[i].getText().length();
            range1.underline = value.floatValue() != 0.0f;
            range1.background = this.valueText[i].getParent().getBackground();
            range1.underlineColor = Column.getFor(column).getColor();
            range1.underlineStyle = 0;
            this.valueText[i].setStyleRange(range1);
            GC gc = new GC((Drawable)this.valueText[i]);
            ((GridData)this.valueText[i].getLayoutData()).widthHint = gc.textExtent((String)text).x;
            gc.dispose();
            ++i;
        }
    }

    public void selectAll() {
        this.figure.selectAll();
        this.setStatusMessage("" + this.figure.getItemCount() + ' ' + Messages.getString("SheetEditor.ItemsSelected"));
    }

    public void setStatusMessage(String message) {
        ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)message);
    }

    protected void setStatusMessage(Image image, String message) {
        ViewHelper.setStatusInformationMesssage((IWorkbenchPart)this, (Image)image, (String)message);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
    }

    @Override
    public void forceRepaint() {
        if (this.viewer != null) {
            this.figure.repaint();
            Debug.event((Logger)logger, (String)ChartView.class.getName(), (String)"forceRepaint");
        }
    }

    public boolean isCompact() {
        return this.getModel().getChartReference().getType().equals((Object)ChartType.COMPACT_HISTOGRAM);
    }

    public String getPartProperty(String key) {
        if (IConnectionCategory.class.getName().equals(key)) {
            return "com.ibm.cics.pa.connection";
        }
        return super.getPartProperty(key);
    }

    @Override
    public void upDateCommand(Command engine) {
        this.currentEngine = engine;
    }

    @Override
    public Command getCurrentCommand() {
        return this.currentEngine;
    }

    public void disconnected() {
        if (this.currentEngine != null) {
            this.currentEngine.cancel();
        }
    }

    public void tableSelected(ManifestRecord manifest) {
    }

    @Override
    public ScrollLimitManager getScrollLimitManager() {
        return this.scrollLimitManager;
    }

    @Override
    public void receiveNotification(final int currentTotal) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ViewHelper.setStatusInformationMessage((IWorkbenchPart)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart(), (String)MessageFormat.format(Messages.getString("Results.CollectedOf"), 0, currentTotal));
                ViewHelper.setStatusInformationMessage((IWorkbenchPart)ChartView.this, (String)MessageFormat.format(Messages.getString("Results.CollectedOf"), 0, currentTotal));
            }
        });
    }

    @Override
    public void abort() {
    }

    @Override
    public void refresh(RemoteEditorInput dataProvider, boolean isInterimRefresh) {
        StructuredSelection selection;
        int lastCount1 = this.lastCount;
        Object object = selection = this.figure != null ? this.figure.getSelection() : new StructuredSelection();
        if (dataProvider.getData().length > this.lastCount) {
            ChartSelectable focus;
            this.iRefreshing = true;
            final List<ChartSelectable> revisedPrimaryColumns = dataProvider.getSelectableColumns(this.getModel().getChartReference(), null);
            ChartSelectable chartSelectable = focus = this.figure != null ? this.figure.getFocusColumn() : revisedPrimaryColumns.get(lastCount1);
            if (this.figure != null) {
                this.figure = null;
            }
            Display.getDefault().syncExec(new Runnable((ISelection)selection, focus){
                private final /* synthetic */ ISelection val$selection;
                private final /* synthetic */ ChartSelectable val$focus;
                {
                    this.val$selection = iSelection;
                    this.val$focus = chartSelectable;
                }

                @Override
                public void run() {
                    ChartView.this.originalParent.setRedraw(false);
                    ChartView.this.getModel().initialise(revisedPrimaryColumns);
                    ChartView.this.resize(ChartView.this.originalParent);
                    ChartView.this.originalParent.setRedraw(true);
                    ChartView.this.originalParent.layout();
                    Job job = new Job(""){

                        protected IStatus run(IProgressMonitor monitor) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ChartView.this.getFigure().setSelection(val$selection);
                                    ChartView.this.getFigure().setFocusColumn(val$focus);
                                }
                            });
                            return Status.OK_STATUS;
                        }
                    };
                    job.setPriority(20);
                    job.schedule();
                    ChartView.this.iRefreshing = false;
                }
            });
        }
    }

    public GridLayout leanLayout(GridLayout noMargin) {
        noMargin.marginBottom = 0;
        noMargin.marginTop = 0;
        noMargin.marginLeft = 0;
        noMargin.marginRight = 0;
        noMargin.marginWidth = 0;
        noMargin.marginHeight = 0;
        noMargin.verticalSpacing = 0;
        noMargin.horizontalSpacing = 0;
        return noMargin;
    }
}

