/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.ui.ScrollLimitManager;
import com.ibm.cics.eclipse.common.Utilities;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.eclipse.common.historical.IHistoricalApplid;
import com.ibm.cics.pa.model.AlertBucket;
import com.ibm.cics.pa.model.AlertElement;
import com.ibm.cics.pa.model.DateCaveat;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.SheetViewColumnDialog;
import com.ibm.cics.pa.ui.dialogs.ExportLayoutsDialog;
import com.ibm.cics.pa.ui.dialogs.ImportLayoutsDialog;
import com.ibm.cics.pa.ui.dialogs.SaveTemplateDialog;
import com.ibm.cics.pa.ui.dialogs.TimelineAssistDialog;
import com.ibm.cics.pa.ui.handlers.PAContextListener;
import com.ibm.cics.pa.ui.remote.AlertsCommand;
import com.ibm.cics.pa.ui.remote.PAConnectionListener;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.utilities.FilterContributionControl;
import com.ibm.cics.pa.ui.utilities.FilterElement;
import com.ibm.cics.pa.ui.utilities.SheetViewPersistenceManager;
import com.ibm.cics.pa.ui.views.internal.IColumnReorderingView;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.ViewPart;

public abstract class AlertsView
extends ViewPart
implements PAContextListener,
PAConnectionListener,
ISelectionListener,
TimelineAssistDialog.DateChangeListener,
FilterContributionControl.IFilterContributionAction,
IColumnReorderingView {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    private static final String COLUMN_WIDTHS = "column_widths";
    protected final AlertBucket severe = new AlertBucket(AlertBucket.SEVERITY.CRITICAL);
    protected final AlertBucket warning = new AlertBucket(AlertBucket.SEVERITY.WARNING);
    protected final AlertBucket information = new AlertBucket(AlertBucket.SEVERITY.INFORMATION);
    protected List<ColumnDefinition> defns = new ArrayList<ColumnDefinition>();
    protected static final String RELATIVE_PLACEMENT = "Relative";
    protected static final String COLUMN = "Column";
    protected static final String POSITION = "Position";
    protected boolean connected = false;
    protected TreeViewer viewer;
    protected IMemento memento;
    protected ManifestRecord currentManifest = null;
    protected DateCaveat currentDateToken = null;
    protected Command currentEngine;
    protected ScrollLimitManager scrollLimitManager = null;
    protected boolean disposed = false;
    protected Composite c;
    protected Selection selection;
    protected AlertsCommand command;
    protected IAction linkToSelectionAction;
    protected List<String> linkToSelection = new ArrayList<String>();
    List<String> numericInFilter = new ArrayList<String>();
    protected boolean isLinkedToSelection = false;
    protected IAction clearSortAction;
    private IAction resetColumnsAction;
    private IAction resetWidthsAction;
    private IAction customizeColumnsActions;
    private IAction saveAsTemplateAction;
    private IAction importLayoutAction;
    IAction exportLayoutAction;
    private IMenuManager templateMenu;
    private Action refreshAction;
    protected ColumnDefinition sortColumnDefinition = null;
    protected int sortDirection = 1024;
    FilterContributionControl filterControl;
    protected boolean initialised = false;
    protected List<FilterElement> filters = null;
    List<TreeColumn> awaitingUpdate = new ArrayList<TreeColumn>();
    protected final List<AlertBucket> buckets = new ArrayList<AlertBucket>();

    protected abstract String getHelpContextId();

    public void createPartControl(Composite parent) {
        block30: {
            Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"createPartControl");
            this.c = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(1, true);
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 0;
            this.c.setLayout((Layout)gridLayout);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.c.setLayout((Layout)layout);
            int[] widths = SheetViewPersistenceManager.getInstance(this.getPersistenceLabel()).getColumnWidths(this.getFields());
            this.viewer = new TreeViewer(this.c, 268501762);
            this.viewer.getTree().setLinesVisible(true);
            this.viewer.getTree().setHeaderVisible(true);
            this.viewer.expandAll();
            this.viewer.setUseHashlookup(true);
            this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
            this.viewer.addTreeListener(new ITreeViewerListener(){

                public void treeCollapsed(TreeExpansionEvent event) {
                }

                public void treeExpanded(TreeExpansionEvent event) {
                }
            });
            this.viewer.setContentProvider((IContentProvider)new ILazyTreeContentProvider(){

                public Object getParent(Object element) {
                    if (element instanceof AlertElement) {
                        return ((AlertElement)element).getParent();
                    }
                    if (element instanceof AlertBucket) {
                        return AlertsView.this.buckets;
                    }
                    return null;
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer1, Object oldInput, Object inputElement) {
                }

                public void updateElement(Object parent, int index) {
                    if (parent instanceof List) {
                        AlertBucket bucket = (AlertBucket)((List)parent).get(index);
                        AlertsView.this.viewer.setChildCount((Object)bucket, bucket.getBucket().length);
                        AlertsView.this.viewer.replace(parent, index, (Object)bucket);
                    } else if (parent instanceof AlertBucket) {
                        AlertsView.this.viewer.replace(parent, index, ((AlertBucket)parent).getBucket()[index]);
                    }
                }

                public void updateChildCount(Object element, int currentChildCount) {
                    int count = 0;
                    if (element instanceof AlertBucket) {
                        count = ((AlertBucket)element).getBucket().length;
                    }
                    if (element instanceof List) {
                        count = ((List)element).size();
                    }
                    AlertsView.this.viewer.setChildCount(element, count);
                }
            });
            MenuManager menuManager = new MenuManager("popup");
            menuManager.setRemoveAllWhenShown(true);
            Menu popUpMenu = menuManager.createContextMenu((Control)this.viewer.getTree());
            this.viewer.getTree().setMenu(popUpMenu);
            this.getViewSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
            this.makeActions(this.getViewSite().getWorkbenchWindow());
            this.fillMenu(this.getViewSite().getActionBars());
            this.fillActionBar(this.getViewSite().getActionBars());
            ArrayList<String> inTheFilter = new ArrayList<String>();
            int i = 0;
            while (i < this.getFields().length) {
                int width = widths.length > i ? widths[i] : -1;
                final int position = i;
                final ColumnDefinition definition = this.getFields()[position];
                final TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.viewer, 0);
                treeViewerColumn.getColumn().setText(definition.getLabel(null));
                treeViewerColumn.getColumn().setData((Object)definition);
                if (width > -1) {
                    inTheFilter.add(definition.getLabel(null));
                    if (definition.getType().isNumeric()) {
                        this.numericInFilter.add(definition.getLabel(null));
                    }
                    treeViewerColumn.getColumn().setMoveable(true);
                    treeViewerColumn.getColumn().setResizable(true);
                    treeViewerColumn.getColumn().setWidth(width);
                } else if (definition == ColumnDefinition.ALERT) {
                    treeViewerColumn.getColumn().setWidth(150);
                } else if (definition.getType() == ColumnReference.DataType.Timestamp) {
                    treeViewerColumn.getColumn().setWidth(150);
                    treeViewerColumn.getColumn().setAlignment(16384);
                } else if (definition.getType() == ColumnReference.DataType.String) {
                    treeViewerColumn.getColumn().setWidth(75);
                    treeViewerColumn.getColumn().setAlignment(16384);
                } else if (definition.getType().isNumeric()) {
                    treeViewerColumn.getColumn().setWidth(65);
                    treeViewerColumn.getColumn().setAlignment(131072);
                } else {
                    treeViewerColumn.getColumn().setWidth(65);
                    treeViewerColumn.getColumn().setAlignment(0x1000000);
                }
                if (definition != ColumnDefinition.ALERT) {
                    treeViewerColumn.getColumn().setMoveable(true);
                }
                treeViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        String text = "";
                        if (element instanceof AlertElement) {
                            text = ((AlertElement)element).getLabel(definition);
                        } else if (element instanceof AlertBucket && AlertsView.this.viewer.getTree().getColumnOrder()[0] == position) {
                            text = ((AlertBucket)element).getLabel();
                        }
                        return text;
                    }

                    public Image getImage(Object element) {
                        Image image = null;
                        if (AlertsView.this.viewer.getTree().getColumnOrder()[0] == position) {
                            if (element instanceof AlertElement) {
                                image = ((AlertElement)element).getImage();
                            } else if (element instanceof AlertBucket) {
                                image = ((AlertBucket)element).getImage();
                            }
                        }
                        return image;
                    }
                });
                treeViewerColumn.getColumn().addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        AlertsView.this.doTableSort(definition, (TreeColumn)e.widget);
                    }
                });
                treeViewerColumn.getColumn().addControlListener(new ControlListener(){

                    public void controlResized(ControlEvent e) {
                        AlertsView.this.orderUpdate(position, treeViewerColumn.getColumn(), AlertsView.this.getFields());
                    }

                    public void controlMoved(ControlEvent e) {
                        SheetViewPersistenceManager.getInstance(AlertsView.this.getPersistenceLabel()).setColumnOrder(AlertsView.this.viewer.getTree().getColumnOrder(), AlertsView.this.getFields());
                    }
                });
                treeViewerColumn.getColumn().setText(definition.getLabel(null));
                treeViewerColumn.getColumn().setToolTipText(definition.getTooltip(null));
                int[] columnOrder = SheetViewPersistenceManager.getInstance(this.getPersistenceLabel()).getColumnOrder(this.getFields());
                if (this.viewer.getTree().getColumnCount() == columnOrder.length) {
                    try {
                        this.viewer.getTree().setColumnOrder(columnOrder);
                    }
                    catch (IllegalArgumentException iaex) {
                        Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"rebuildTable", (String)"name ordering has changed rest to default by doing nothing", (Throwable)iaex);
                    }
                }
                this.viewer.getTree().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                    public void getName(AccessibleEvent e) {
                        if (e.childID == -1) {
                            e.result = AlertsView.this.viewer.getTree().getToolTipText();
                        } else {
                            TreeItem[] selection = AlertsView.this.viewer.getTree().getSelection();
                            if (selection.length == 1) {
                                TreeItem item = selection[0];
                                Object content = item.getData();
                                if (content instanceof AlertBucket) {
                                    e.result = ((AlertBucket)content).getLabel();
                                } else if (content instanceof AlertElement) {
                                    e.result = ((AlertElement)content).getAccessibleLabel(AlertsView.this.getFields());
                                }
                            }
                        }
                    }
                });
                ++i;
            }
            if (this.filterControl != null) {
                this.filterControl.initialiseColumns(this.getPersistenceLabel(), inTheFilter, this.numericInFilter);
            }
            this.viewer.setInput(null);
            try {
                IMemento columnEntry;
                if (this.memento == null || this.memento.getChildren(RELATIVE_PLACEMENT).length <= 0) break block30;
                IMemento[] relatives = this.memento.getChildren(RELATIVE_PLACEMENT);
                int[] positions = new int[relatives.length];
                int j = 0;
                while (j < this.viewer.getTree().getColumnCount()) {
                    positions[j] = j;
                    ++j;
                }
                int i2 = 0;
                while (i2 < relatives.length) {
                    String aColumn = relatives[i2].getString(COLUMN);
                    ColumnDefinition defn = ColumnDefinition.getByDBColumnRef(aColumn);
                    if (defn != null) {
                        int j2 = 0;
                        while (j2 < this.viewer.getTree().getColumnCount()) {
                            if ((ColumnDefinition)this.viewer.getTree().getColumn(j2).getData() == defn) {
                                positions[j2] = relatives[i2].getInteger(POSITION);
                            }
                            ++j2;
                        }
                    }
                    ++i2;
                }
                if (relatives.length > 0) {
                    try {
                        this.viewer.getTree().setColumnOrder(positions);
                    }
                    catch (IllegalArgumentException iaex) {
                        Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"rebuildTable", (String)"name ordering has changed rest to default by doing nothing", (Throwable)iaex);
                    }
                }
                if ((columnEntry = this.memento.getChild(COLUMN_WIDTHS)) != null) {
                    int i3 = 0;
                    while (i3 < this.getFields().length) {
                        Integer width = columnEntry.getInteger(this.getFields()[i3].getDBColumnRef());
                        if (width != null) {
                            this.viewer.getTree().getColumn(i3).setWidth(width.intValue());
                        }
                        ++i3;
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                Debug.error((Logger)logger, (String)AlertsView.class.getName(), (String)"createPartControl", (Throwable)iae);
            }
        }
        this.scrollLimitManager = new ScrollLimitManager(this.c, Messages.getString("Alerts"), this){

            public void scrollLimitReached(Command command) {
                super.scrollLimitReached(command);
                AlertsView.this.c.layout(new Control[]{AlertsView.this.viewer.getTree(), AlertsView.this.scrollLimitManager.scrollLimitComposite});
            }

            public void dispose() {
                if (!AlertsView.this.disposed) {
                    super.dispose();
                    AlertsView.this.c.layout(new Control[]{AlertsView.this.viewer.getTree()});
                }
            }
        };
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        PAConnectionTracker.getInstance().addPAContextListener(this);
        PAConnectionTracker.getInstance().addPAConnectionTrackerListener(this);
        this.setContentDescription("");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpContextId());
        ICommandService cs = (ICommandService)this.getSite().getService(ICommandService.class);
        cs.refreshElements("com.ibm.cics.pa.ui.commands.alerts.tools", null);
        TimelineAssistDialog.getInstance().addDateChangeListener(this);
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
    }

    void orderUpdate(final int position, final TreeColumn column, final ColumnDefinition[] fields) {
        if (!this.awaitingUpdate.contains(column)) {
            this.awaitingUpdate.add(column);
            Job updateJob = new Job(Messages.getString("Background_job")){

                protected IStatus run(IProgressMonitor monitor) {
                    AlertsView.this.awaitingUpdate.remove(column);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SheetViewPersistenceManager.getInstance(AlertsView.this.getPersistenceLabel()).setColumnWidth(position, column.getWidth(), fields);
                            Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"column ordering updated", (Object)column);
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            updateJob.setPriority(20);
            updateJob.schedule(2500L);
        }
    }

    private void fillMenu(IActionBars actionBars) {
        IMenuManager menu = actionBars.getMenuManager();
        this.fillViewMenuDropdown(menu);
        menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AlertsView.this.fillViewMenuDropdown(manager);
            }
        });
    }

    protected void fillViewMenuDropdown(IMenuManager manager) {
        if (manager.find(this.clearSortAction.getId()) == null) {
            manager.add(this.clearSortAction);
            manager.add((IContributionItem)new Separator());
        }
        if (manager.find(this.resetColumnsAction.getId()) == null) {
            manager.add(this.resetColumnsAction);
        }
        if (manager.find(this.resetWidthsAction.getId()) == null) {
            manager.add(this.resetWidthsAction);
        }
        if (manager.find(this.customizeColumnsActions.getId()) == null) {
            manager.add(this.customizeColumnsActions);
            manager.add((IContributionItem)new Separator());
        }
        if (manager.find(this.saveAsTemplateAction.getId()) == null) {
            manager.add(this.saveAsTemplateAction);
            manager.add((IContributionItem)new Separator());
        }
        if (SheetViewPersistenceManager.getInstance(this.getPersistenceLabel()).getTemplates().size() > 0 && manager.find(this.templateMenu.getId()) == null && manager.find(this.saveAsTemplateAction.getId()) != null) {
            manager.insertAfter(this.saveAsTemplateAction.getId(), (IContributionItem)this.templateMenu);
            manager.add((IContributionItem)new Separator());
        }
        if (manager.find(this.importLayoutAction.getId()) == null) {
            manager.add(this.importLayoutAction);
        }
        if (manager.find(this.exportLayoutAction.getId()) == null) {
            manager.add(this.exportLayoutAction);
            manager.add((IContributionItem)new Separator());
            manager.update();
            manager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    AlertsView.this.fillViewMenuDropdown(manager);
                }
            });
        }
    }

    public void dispose() {
        this.disposed = true;
        TimelineAssistDialog.getInstance().removeDateChangeListener(this);
        if (this.scrollLimitManager != null) {
            this.scrollLimitManager.dispose();
        }
        PAConnectionTracker.getInstance().removePAContextListener(this);
        PAConnectionTracker.getInstance().removePAConnectionTrackerListener(this);
    }

    public void setFocus() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"setFocus");
        if (!this.initialised && PAConnectionTracker.getInstance().isPost32()) {
            this.connected(PAConnectionListener.Era.POST);
            this.connected = true;
            this.initialise();
            this.initialised = true;
        }
        this.viewer.getTree().setFocus();
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"setFocus");
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
        this.currentDateToken = TimelineAssistDialog.getInstance().getDateCaveat();
        this.memento = memento;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        IMemento columnEntry = memento.createChild(COLUMN_WIDTHS);
        int[] positions = this.viewer.getTree().getColumnOrder();
        int i = 0;
        while (i < this.viewer.getTree().getColumnCount()) {
            IMemento child = memento.createChild(RELATIVE_PLACEMENT);
            child.putString(COLUMN, ((ColumnDefinition)this.viewer.getTree().getColumn(i).getData()).getDBColumnRef());
            child.putInteger(POSITION, positions[i]);
            ++i;
        }
        i = 0;
        while (i < this.getFields().length) {
            TreeColumn column = this.viewer.getTree().getColumn(i);
            columnEntry.putInteger(((ColumnDefinition)this.viewer.getTree().getColumn(i).getData()).getDBColumnRef(), column.getWidth());
            ++i;
        }
    }

    public void hide() {
        Object[] objectArray = ((StructuredSelection)this.viewer.getSelection()).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            AlertElement element = (AlertElement)obj;
            this.severe.remove(element);
            this.warning.remove(element);
            this.information.remove(element);
            ++n2;
        }
        this.viewer.remove(((StructuredSelection)this.viewer.getSelection()).toArray());
    }

    public ScrollLimitManager getScrollLimitManager() {
        return this.scrollLimitManager;
    }

    public void upDateEngine(Command engine) {
        if (this.currentEngine != null) {
            this.currentEngine.cancel();
        }
        this.currentEngine = engine;
    }

    public Command getCurrentEngine() {
        return this.currentEngine;
    }

    @Override
    public void datesUpdated(DateCaveat dateToken) {
        this.currentDateToken = dateToken;
        this.tableSelected(this.currentManifest);
        if (PAConnectionTracker.getInstance().isConnected()) {
            this.setContentDescription(String.valueOf(dateToken.getLabel()) + this.relativeDateText());
        }
    }

    protected String relativeDateText() {
        String text = "";
        int dateChoice = Platform.getPreferencesService().getInt(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.pa.ui.overview", 0, null);
        if (dateChoice == 1) {
            text = String.valueOf(text) + ' ' + Messages.getString("Overview.LastYear");
        } else if (dateChoice == 3) {
            text = String.valueOf(text) + ' ' + Messages.getString("Overview.LastQuarter");
        } else if (dateChoice == 2) {
            text = String.valueOf(text) + ' ' + Messages.getString("Overview.LastMonth");
        } else if (dateChoice == 4) {
            text = String.valueOf(text) + ' ' + Messages.getString("Overview.LastWeek");
        } else if (dateChoice == 6) {
            text = String.valueOf(text) + ' ' + Messages.getString("Overview.LastDay");
        }
        return text;
    }

    @Override
    public void disconnecting() {
        this.upDateEngine(null);
        if (this.command != null) {
            this.command.cancel();
        }
    }

    @Override
    public void disconnected() {
        this.connected = false;
        this.currentManifest = null;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AlertsView.this.setContentDescription("");
                AlertsView.this.viewer.setInput(null);
                if (AlertsView.this.scrollLimitManager != null) {
                    AlertsView.this.scrollLimitManager.dispose();
                }
            }
        });
    }

    public String getPartProperty(String key) {
        if (IConnectionCategory.class.getName().equals(key)) {
            return "com.ibm.cics.pa.connection";
        }
        return super.getPartProperty(key);
    }

    @Override
    public void connected(final PAConnectionListener.Era post32) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean bl = AlertsView.this.connected = post32 == PAConnectionListener.Era.POST;
                if (PAConnectionTracker.getInstance().isConnected()) {
                    AlertsView.this.setContentDescription(String.valueOf(AlertsView.this.currentDateToken.getLabel()) + AlertsView.this.relativeDateText());
                }
            }
        });
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof StructuredSelection) {
            ArrayList<String> latestSelection = new ArrayList<String>();
            for (Object item : ((StructuredSelection)selection).toList()) {
                IHistoricalApplid applid = (IHistoricalApplid)Platform.getAdapterManager().getAdapter(item, IHistoricalApplid.class);
                if (applid == null) continue;
                latestSelection.add(applid.getApplid());
            }
            if (!latestSelection.isEmpty() && !latestSelection.equals(this.linkToSelection)) {
                this.linkToSelection = latestSelection;
                if (this.isLinkedToSelection) {
                    this.tableSelected(this.currentManifest);
                }
            }
        }
    }

    private void makeActions(IWorkbenchWindow iWorkbenchWindow) {
        this.linkToSelectionAction = new Action(Messages.getString("Button.linkto"), 2){

            public void run() {
                AlertsView.this.isLinkedToSelection = AlertsView.this.linkToSelectionAction.isChecked();
                Activator.getDefault().getPluginInstancePreferences().putBoolean("com.ibm.cics.pa.ui.alertsviewlinkto.selection", AlertsView.this.isLinkedToSelection);
                AlertsView.this.tableSelected(AlertsView.this.currentManifest);
            }

            public ImageDescriptor getImageDescriptor() {
                return com.ibm.cics.eclipse.common.Activator.IMGD_LINK_TO_SELECTION;
            }
        };
        this.isLinkedToSelection = Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.pa.ui.alertsviewlinkto.selection", true, null);
        this.linkToSelectionAction.setChecked(this.isLinkedToSelection);
        this.linkToSelectionAction.setId(String.valueOf(AlertsView.class.getName()) + '.' + "linkToSelectionAction");
        this.refreshAction = new Action(Messages.getString("ResourcesView.refreshAction.text"), 8){

            public void run() {
                AlertsView.this.tableSelected(AlertsView.this.currentManifest);
            }

            public ImageDescriptor getImageDescriptor() {
                return Activator.getDefault().getImageDescriptor("refresh");
            }
        };
        this.refreshAction.setId(String.valueOf(AlertsView.class.getName()) + '.' + "refreshAction");
        this.clearSortAction = new Action(Messages.getString("ResourcesView.clearSortAction.text")){

            public void run() {
                AlertsView.this.viewer.getTree().setSortDirection(0);
                AlertsView.this.viewer.getTree().setSortColumn(null);
                AlertsView.this.clearSortAction.setEnabled(false);
                AlertsView.this.sortColumnDefinition = null;
                AlertsView.this.tableSelected(AlertsView.this.currentManifest);
            }
        };
        this.clearSortAction.setToolTipText(Messages.getString("ResourcesView.clearSortAction.tooltip"));
        this.clearSortAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("deletesort"));
        this.clearSortAction.setEnabled(false);
        this.clearSortAction.setId(String.valueOf(AlertsView.class.getName()) + '.' + "clearSortAction");
        this.resetColumnsAction = new Action(Messages.getString("ResourcesView.resetColumnsAction.text")){

            public void run() {
                AlertsView.this.resetColumns();
            }
        };
        this.resetColumnsAction.setEnabled(this.viewer != null);
        this.resetColumnsAction.setId(String.valueOf(AlertsView.class.getName()) + '.' + "resetColumnsAction");
        this.resetWidthsAction = new Action(Messages.getString("ResourcesView.equalizeColumnWidthsAction.text")){

            public void run() {
                int[] widths = SheetViewPersistenceManager.getInstance(AlertsView.this.getPersistenceLabel()).resetDisplayedColumnsWidth(AlertsView.this.getFields());
                int i = 0;
                while (i < AlertsView.this.viewer.getTree().getColumns().length) {
                    if (widths[i] > -1) {
                        AlertsView.this.viewer.getTree().getColumns()[i].setWidth(70);
                    }
                    ++i;
                }
            }
        };
        this.resetWidthsAction.setEnabled(this.viewer != null);
        this.resetWidthsAction.setId(String.valueOf(AlertsView.class.getName()) + '.' + "resetWidthsAction");
        this.customizeColumnsActions = new Action(Messages.getString("ResourcesView.customizeColumnsAction.text")){

            public void run() {
                SheetViewColumnDialog dialog = new SheetViewColumnDialog(AlertsView.this.getSite().getShell(), AlertsView.this, AlertsView.this.getFields(), AlertsView.this.getPersistenceLabel(), AlertsView.this.currentManifest, null);
                dialog.open();
            }
        };
        this.customizeColumnsActions.setEnabled(this.viewer != null);
        this.customizeColumnsActions.setId(String.valueOf(AlertsView.class.getName()) + '.' + "customizeColumnsActions");
        this.saveAsTemplateAction = new Action(Messages.getString("SaveTemplate_text")){

            public void run() {
                SaveTemplateDialog dialog = new SaveTemplateDialog(AlertsView.this, AlertsView.this.getPersistenceLabel(), AlertsView.this.filterControl.getContent(), AlertsView.this.getPersistenceLabel());
                dialog.open();
                AlertsView.this.exportLayoutAction.setEnabled(AlertsView.this.viewer != null && !SheetViewPersistenceManager.getInstance(AlertsView.this.getPersistenceLabel()).hasTemplatesForExport());
            }
        };
        this.saveAsTemplateAction.setEnabled(this.viewer != null);
        this.saveAsTemplateAction.setId(String.valueOf(AlertsView.class.getName()) + '.' + "saveAsTemplateAction");
        this.templateMenu = new MenuManager(Messages.getString("Apply_template.text"), String.valueOf(AlertsView.class.getName()) + '.' + "templateMenu");
        this.templateMenu.add((IAction)new Action(){});
        this.templateMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AlertsView.this.fillCategorizedMenu(manager);
            }
        });
        this.importLayoutAction = new Action(Messages.getString("import.label")){

            public void run() {
                ImportLayoutsDialog dialog = new ImportLayoutsDialog(AlertsView.this.getSite().getShell());
                dialog.open();
                AlertsView.this.exportLayoutAction.setEnabled(AlertsView.this.viewer != null && !SheetViewPersistenceManager.getInstance(AlertsView.this.getPersistenceLabel()).hasTemplatesForExport());
            }
        };
        this.importLayoutAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("import_layout"));
        this.importLayoutAction.setToolTipText(Messages.getString("import.tooltip"));
        this.importLayoutAction.setEnabled(this.viewer != null);
        this.importLayoutAction.setId(String.valueOf(AlertsView.class.getName()) + '.' + "importLayoutAction");
        this.exportLayoutAction = new Action(Messages.getString("export.label")){

            public void run() {
                ExportLayoutsDialog dialog = new ExportLayoutsDialog(AlertsView.this.getSite().getShell());
                dialog.open();
            }
        };
        this.exportLayoutAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("export_layout"));
        this.exportLayoutAction.setToolTipText(Messages.getString("export.tooltip"));
        this.exportLayoutAction.setEnabled(this.viewer != null && !SheetViewPersistenceManager.getInstance(this.getPersistenceLabel()).hasTemplatesForExport());
        this.exportLayoutAction.setId(String.valueOf(AlertsView.class.getName()) + '.' + "exportLayoutAction");
    }

    protected void fillCategorizedMenu(IMenuManager manager) {
        manager.removeAll();
        for (String template : SheetViewPersistenceManager.getInstance(this.getPersistenceLabel()).getTemplates()) {
            manager.add(this.createTemplateAction(this.getPersistenceLabel(), template));
        }
        manager.update();
    }

    private IAction createTemplateAction(final String table_reference, final String templateName) {
        Action templateAction = new Action(templateName){

            public void run() {
                SheetViewPersistenceManager.getInstance(table_reference).loadTemplate(templateName, AlertsView.this.getFields());
                String filter = SheetViewPersistenceManager.getInstance(table_reference).getTemplateFilter(templateName);
                if (StringUtil.hasContent((String)filter)) {
                    AlertsView.this.filterControl.forceText(filter);
                }
                AlertsView.this.applyTemplate(templateName);
                AlertsView.this.viewer.getTree().setFocus();
            }
        };
        return templateAction;
    }

    protected void fillActionBar(IActionBars actionBars) {
        this.fillToolBar(actionBars.getToolBarManager());
    }

    protected void fillToolBar(IToolBarManager toolBar) {
        if (this.linkToSelectionAction != null) {
            toolBar.add(this.linkToSelectionAction);
        }
        if (this.refreshAction != null) {
            toolBar.add((IAction)this.refreshAction);
        }
        if (this.clearSortAction != null) {
            toolBar.add(this.clearSortAction);
        }
        this.filterControl = new FilterContributionControl(this, toolBar);
    }

    public AlertBucket getBucket(AlertBucket.SEVERITY severity) {
        switch (severity) {
            case CRITICAL: {
                return this.severe;
            }
            case WARNING: {
                return this.warning;
            }
        }
        return this.information;
    }

    @Override
    public int[] getColumnOrder() {
        if (this.viewer != null) {
            return this.viewer.getTree().getColumnOrder();
        }
        return SheetViewPersistenceManager.getInstance(this.getPersistenceLabel()).getColumnOrder(this.getFields());
    }

    @Override
    public int[] getColumnWidths() {
        if (this.viewer != null) {
            int[] widths = new int[this.viewer.getTree().getColumnCount()];
            int i = 0;
            while (i < widths.length) {
                widths[i] = this.viewer.getTree().getColumn(i).getWidth();
                ++i;
            }
            return widths;
        }
        return SheetViewPersistenceManager.getInstance(this.getPersistenceLabel()).getColumnWidths(this.getFields());
    }

    public synchronized void relocateColumnUp(boolean moveUp, int index) {
        int[] order = this.viewer.getTree().getColumnOrder();
        if (moveUp && index > 0) {
            int preceed = order[index - 1];
            order[index - 1] = order[index];
            order[index] = preceed;
            this.viewer.getTree().setColumnOrder(order);
            SheetViewPersistenceManager.getInstance(this.getPersistenceLabel()).setColumnOrder(order, this.getFields());
        } else if (!moveUp && index + 1 < order.length) {
            int post = order[index + 1];
            order[index + 1] = order[index];
            order[index] = post;
            this.viewer.getTree().setColumnOrder(order);
            SheetViewPersistenceManager.getInstance(this.getPersistenceLabel()).setColumnOrder(order, this.getFields());
        }
    }

    @Override
    public boolean swapColumns(ColumnDefinition sourceItemDefinition, ColumnDefinition targetItemDefinition) {
        boolean beenSorted = false;
        int sourcePointer = -1;
        int targetPointer = -1;
        int sourcePosition = -1;
        int targetPosition = -1;
        int i = 0;
        while (i < this.getFields().length) {
            if (sourceItemDefinition == this.getFields()[i]) {
                sourcePointer = i;
            }
            if (targetItemDefinition == this.getFields()[i]) {
                targetPointer = i;
            }
            ++i;
        }
        int[] ordering = this.viewer.getTree().getColumnOrder();
        int i2 = 0;
        while (i2 < ordering.length) {
            if (sourcePointer == ordering[i2]) {
                sourcePosition = i2;
            }
            if (targetPointer == ordering[i2]) {
                targetPosition = i2;
            }
            ++i2;
        }
        if (sourcePosition > -1 && targetPosition > -1 && sourcePosition < ordering.length && targetPosition < ordering.length) {
            int tempPos = ordering[sourcePosition];
            ordering[sourcePosition] = ordering[targetPosition];
            ordering[targetPosition] = tempPos;
            this.viewer.getTree().setColumnOrder(ordering);
            beenSorted = true;
        }
        return beenSorted;
    }

    @Override
    public boolean validate(FilterElement element) {
        if (element.isComplete()) {
            ColumnDefinition defn = null;
            int i = 0;
            while (i < this.getFields().length) {
                if (((String)element.getColumn()).toUpperCase().startsWith(this.getFields()[i].getLabel(null).toUpperCase()) && (defn == null || this.getFields().length > defn.getLabel(null).length())) {
                    defn = this.getFields()[i];
                }
                ++i;
            }
            if (defn == null) {
                element.setValid(false);
            } else {
                element.setColumn(defn);
                ColumnReference.DataType type = defn.getType();
                if (type == ColumnReference.DataType.Date) {
                    if (element.getValue().length() == 10 && element.getValue().charAt(4) == '-' && element.getValue().charAt(7) == '-') {
                        Object result = DataTypeUtilities.ensureAppropriateType(type, element.getValue());
                        element.setValueComplete(true);
                        element.setValid(!(result instanceof String));
                    } else {
                        element.setValueComplete(false);
                    }
                } else if (type == ColumnReference.DataType.Time) {
                    if (element.getValue().length() > 7 && (element.getValue().charAt(2) == ':' && element.getValue().charAt(5) == ':' || element.getValue().charAt(2) == '.' && element.getValue().charAt(5) == '.')) {
                        Object result = DataTypeUtilities.ensureAppropriateType(type, element.getValue());
                        element.setValueComplete(true);
                        element.setValid(!(result instanceof String));
                    } else {
                        element.setValueComplete(false);
                    }
                } else {
                    block0 : switch (type) {
                        case Double: 
                        case Integer: 
                        case Float: 
                        case BigDecimal: {
                            if (element.getValue().matches("[-+]?\\d*\\.?\\d+")) {
                                element.setValid(true);
                                element.setValueComplete(true);
                                break;
                            }
                            element.setValid(false);
                            element.setValueComplete(false);
                            for (String filter : this.numericInFilter) {
                                if (filter.equals(element.getValue())) {
                                    defn = null;
                                    int i2 = 0;
                                    while (i2 < this.getFields().length) {
                                        if (element.getValue().toUpperCase().startsWith(this.getFields()[i2].getLabel(null).toUpperCase()) && (defn == null || this.getFields().length > defn.getLabel(null).length())) {
                                            defn = this.getFields()[i2];
                                        }
                                        ++i2;
                                    }
                                    if (defn == null) {
                                        element.setValid(false);
                                        element.setValueComplete(false);
                                        continue;
                                    }
                                    element.setValue(defn);
                                    element.setValid(true);
                                    element.setValueComplete(true);
                                    break block0;
                                }
                                if (!filter.startsWith(element.getValue())) continue;
                                element.setValid(true);
                            }
                            break;
                        }
                        case Boolean: {
                            element.setValid(element.getValue().toUpperCase().equals("TRUE") || element.getValue().toUpperCase().equals("FALSE"));
                            break;
                        }
                        default: {
                            element.setValid(Utilities.hasContent((String)element.getValue()));
                        }
                    }
                }
            }
        }
        return element.isValid();
    }

    @Override
    public void applyFilter(List<FilterElement> filters) {
        this.filters = filters;
        this.tableSelected(this.currentManifest);
    }

    protected void doTableSort(ColumnDefinition defn, TreeColumn currentColumn) {
        if (this.viewer != null) {
            if (this.scrollLimitManager != null) {
                this.scrollLimitManager.dispose();
            }
            TreeColumn sortColumn = this.viewer.getTree().getSortColumn();
            int dir = this.viewer.getTree().getSortDirection();
            if (sortColumn == currentColumn) {
                dir = defn.getType().isNumeric() ? (dir == 1024 ? 128 : (dir == 128 ? 0 : 1024)) : (dir == 128 ? 1024 : (dir == 1024 ? 0 : 128));
            } else {
                this.viewer.getTree().setSortColumn(currentColumn);
                this.sortColumnDefinition = defn;
                dir = defn.getType().isNumeric() ? 1024 : 128;
            }
            this.clearSortAction.setEnabled(dir != 0);
            this.viewer.getTree().setSortDirection(dir);
            if (dir == 0) {
                this.viewer.getTree().setSortColumn(null);
                this.sortColumnDefinition = null;
            }
            this.sortDirection = dir;
            this.tableSelected(this.currentManifest);
        }
    }

    @Override
    public void applyTemplate(String templateName) {
        SheetViewPersistenceManager.getInstance(this.getPersistenceLabel()).loadTemplate(templateName, this.getFields());
        SheetViewPersistenceManager.getInstance(this.getPersistenceLabel()).setLayoutLabel(templateName);
        String filter = SheetViewPersistenceManager.getInstance(this.getPersistenceLabel()).getTemplateFilter(templateName);
        if (StringUtil.hasContent((String)filter)) {
            this.filterControl.forceText(filter);
        }
        ViewHelper.setStatusErrorMessage((IWorkbenchPart)this, null);
        ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)MessageFormat.format(Messages.getString("Layout.applying"), templateName));
        this.applyOrdering(SheetViewPersistenceManager.getInstance(this.getPersistenceLabel()).getColumnOrder(this.getFields()), SheetViewPersistenceManager.getInstance(this.getPersistenceLabel()).getColumnWidths(this.getFields()));
    }

    @Override
    public void applyOrdering(final int[] columnOrdering, final int[] widths) {
        SheetViewPersistenceManager.getInstance(this.getPersistenceLabel()).setColumnOrder(columnOrdering, this.getFields());
        SheetViewPersistenceManager.getInstance(this.getPersistenceLabel()).setColumnWidths(widths, this.getFields());
        BusyIndicator.showWhile((Display)this.viewer.getTree().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                AlertsView.this.viewer.getTree().setRedraw(false);
                try {
                    try {
                        ArrayList<String> inTheFilter = new ArrayList<String>();
                        int i = 0;
                        while (i < AlertsView.this.getFields().length) {
                            ColumnDefinition defn = AlertsView.this.getFields()[i];
                            if (widths[i] > -1) {
                                inTheFilter.add(defn.getLabel(null));
                                if (defn.getType().isNumeric()) {
                                    AlertsView.this.numericInFilter.add(defn.getLabel(null));
                                }
                                AlertsView.this.viewer.getTree().getColumns()[i].setMoveable(true);
                                AlertsView.this.viewer.getTree().getColumns()[i].setResizable(true);
                                AlertsView.this.viewer.getTree().getColumns()[i].setWidth(widths[i]);
                            } else {
                                AlertsView.this.viewer.getTree().getColumns()[i].setWidth(0);
                                AlertsView.this.viewer.getTree().getColumns()[i].setMoveable(false);
                                AlertsView.this.viewer.getTree().getColumns()[i].setResizable(false);
                            }
                            ++i;
                        }
                        if (AlertsView.this.filterControl != null) {
                            AlertsView.this.filterControl.initialiseColumns(AlertsView.this.getPersistenceLabel(), inTheFilter, AlertsView.this.numericInFilter);
                        }
                        AlertsView.this.viewer.getTree().setColumnOrder(columnOrdering);
                        String templateName = SheetViewPersistenceManager.getInstance(AlertsView.this.getPersistenceLabel()).getLayoutLabel();
                        ViewHelper.setStatusInformationMessage((IWorkbenchPart)AlertsView.this, (String)MessageFormat.format(Messages.getString("Layout.applied"), templateName));
                    }
                    catch (IllegalArgumentException iaex) {
                        ViewHelper.setStatusErrorMessage((IWorkbenchPart)AlertsView.this, (String)Messages.getString("PAX0108E.ColumnSequence.Error"));
                        AlertsView.this.viewer.getTree().setRedraw(true);
                    }
                }
                finally {
                    AlertsView.this.viewer.getTree().setRedraw(true);
                }
            }
        });
    }

    protected void initialiseBuckets() {
        if (this.buckets != null && !this.buckets.isEmpty()) {
            int i = 0;
            while (i < this.buckets.size()) {
                this.buckets.get(i).clear();
                ++i;
            }
        }
        if (Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.pa.ui.alert.critical", true, null)) {
            if (!this.buckets.contains(this.severe)) {
                this.buckets.add(this.severe);
            }
        } else {
            this.buckets.remove(this.severe);
        }
        if (Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.pa.ui.alert.warning", true, null)) {
            if (!this.buckets.contains(this.warning)) {
                this.buckets.add(this.warning);
            }
        } else {
            this.buckets.remove(this.warning);
        }
        if (Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.pa.ui.alert.information", true, null)) {
            if (!this.buckets.contains(this.information)) {
                this.buckets.add(this.information);
            }
        } else {
            this.buckets.remove(this.information);
        }
        this.viewer.setInput(this.buckets);
    }

    protected void updateResults(final TreeViewer viewer, Collection<Object> res) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                boolean expansion_state;
                boolean bl = expansion_state = viewer.getExpandedState((Object)AlertsView.this.severe) || viewer.getExpandedState((Object)AlertsView.this.warning) || viewer.getExpandedState((Object)AlertsView.this.information);
                if (AlertsView.this.buckets != null && !AlertsView.this.buckets.isEmpty()) {
                    int i = 0;
                    while (i < AlertsView.this.buckets.size()) {
                        viewer.setChildCount((Object)AlertsView.this.buckets.get(i), AlertsView.this.buckets.get(i).getBucket().length);
                        if (!expansion_state) {
                            viewer.expandAll();
                        }
                        ++i;
                    }
                }
            }
        });
    }

    public abstract void initialise();

    public abstract ColumnDefinition[] getFields();

    public abstract String getPersistenceLabel();

    @Override
    public abstract void resetColumns();
}

