/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.utilities;

import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.utilities.FilterContributionControl;
import com.ibm.cics.pa.ui.utilities.FilterElement;
import com.ibm.cics.pa.ui.utilities.StyledTextContentAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class FilterContributionItem
extends ControlContribution {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    String[] input = new String[0];
    private List<String> numericHeadings;
    String[] operators = FilterElement.operators;
    private List<FilterElement> elements = new ArrayList<FilterElement>();
    private Image column_image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage();
    private Image error_image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
    private Image warn_image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage();
    private ControlDecoration controldecoration1;
    private ControlDecoration controldecoration2;
    protected boolean lastState;
    Mode currentMode;
    private ITextListener textListener;
    TextViewer textViewr;
    private KeyListener keyListener;
    private IContentProposalListener contentProposalListener;
    private ContentProposalAdapter adapter;
    SimpleContentProposalProvider provider;
    protected String dataFilter = Messages.getString("FilterContributionItem.0");
    StyleRange titleStyleRange = new StyleRange();
    IFilterContributionHost parent;
    private VerifyListener verifyListener;
    boolean enterPressedInStyledtext = false;

    public FilterContributionItem(IFilterContributionHost filterContributionControl) {
        super(null);
        this.parent = filterContributionControl;
    }

    protected Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.textViewr = new TextViewer(composite, 2052);
        try {
            Document document = new Document();
            this.textViewr.setDocument((IDocument)document);
            char[] autoActivationCharacters = new char[]{};
            KeyStroke keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
            this.provider = new SimpleContentProposalProvider(this.input){

                public IContentProposal[] getProposals(String contents, int position) {
                    int n;
                    String methodContents = contents;
                    int methodPosition = position;
                    if (methodContents.length() > 0) {
                        StringBuffer muff = new StringBuffer(methodContents);
                        int comma = muff.substring(0, methodPosition).lastIndexOf(",");
                        if (comma > -1) {
                            muff = new StringBuffer(muff.substring(comma + 1));
                            methodPosition -= comma + 1;
                        }
                        while (muff.length() > 0 && muff.charAt(muff.length() - 1) == ' ') {
                            muff.setLength(muff.length() - 1);
                            if (methodPosition <= 0) continue;
                            --methodPosition;
                        }
                        methodContents = muff.toString();
                    }
                    if (FilterContributionItem.this.currentMode == Mode.FIELD) {
                        String[] stringArray = FilterContributionItem.this.input;
                        int n2 = FilterContributionItem.this.input.length;
                        n = 0;
                        while (n < n2) {
                            String column = stringArray[n];
                            int loc = methodContents.lastIndexOf(column);
                            if (loc > -1 && loc + column.length() == methodPosition) {
                                return super.getProposals("", methodPosition);
                            }
                            ++n;
                        }
                    } else {
                        if (FilterContributionItem.this.currentMode == Mode.OPERATOR) {
                            return super.getProposals("", methodPosition);
                        }
                        if (FilterContributionItem.this.currentMode == Mode.VALUE) {
                            String[] stringArray = FilterContributionItem.this.operators;
                            int n3 = FilterContributionItem.this.operators.length;
                            n = 0;
                            while (n < n3) {
                                String operator = stringArray[n];
                                String trimOperator = operator.trim();
                                int start = methodContents.lastIndexOf(trimOperator);
                                if (start > -1 && start < methodPosition) {
                                    String substr = methodContents.substring(start + 1);
                                    while (substr.length() > 0 && substr.charAt(0) == ' ') {
                                        substr = substr.substring(1);
                                    }
                                    return super.getProposals(substr, methodPosition + substr.length() - methodContents.length());
                                }
                                ++n;
                            }
                            return super.getProposals("", methodPosition);
                        }
                    }
                    return super.getProposals(methodContents.substring(0, methodPosition), methodPosition);
                }
            };
            this.provider.setFiltering(true);
            this.adapter = new ContentProposalAdapter((Control)this.getTextWidget(), (IControlContentAdapter)new StyledTextContentAdapter(), (IContentProposalProvider)this.provider, keyStroke, autoActivationCharacters);
            this.adapter.setProposalAcceptanceStyle(3);
            this.adapter.setPropagateKeys(true);
            this.adapter.setFilterStyle(1);
            GridData data = new GridData(768);
            data.minimumWidth = 250;
            this.textViewr.getControl().setLayoutData((Object)data);
            this.controldecoration1 = new ControlDecoration(this.textViewr.getControl(), 16512);
            this.controldecoration2 = new ControlDecoration(this.textViewr.getControl(), 131200);
            this.controldecoration1.setShowOnlyOnFocus(true);
            this.controldecoration2.setShowOnlyOnFocus(true);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.addListeners();
        this.titleStyleRange.start = 0;
        this.titleStyleRange.length = this.dataFilter.length();
        this.titleStyleRange.foreground = Display.getDefault().getSystemColor(15);
        this.titleStyleRange.fontStyle = 2;
        this.getTextWidget().setText(this.dataFilter);
        this.getTextWidget().setStyleRange(this.titleStyleRange);
        this.parent.enableFilter(false);
        return composite;
    }

    private void addListeners() {
        this.getTextWidget().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                String tex = FilterContributionItem.this.getText();
                if (tex.length() == 0 || tex.equals(FilterContributionItem.this.dataFilter)) {
                    FilterContributionItem.this.getTextWidget().setText(FilterContributionItem.this.dataFilter);
                    FilterContributionItem.this.getTextWidget().setStyleRange(FilterContributionItem.this.titleStyleRange);
                }
            }

            public void focusGained(FocusEvent e) {
                String tex = FilterContributionItem.this.getText();
                if (tex.equals(FilterContributionItem.this.dataFilter)) {
                    FilterContributionItem.this.getTextWidget().setText("");
                }
            }
        });
        this.contentProposalListener = new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                FilterContributionItem.this.enterPressedInStyledtext = true;
                StringBuffer buffer = new StringBuffer();
                String remnant = "";
                String existingTagsText = FilterContributionItem.this.getText();
                int position = FilterContributionItem.this.getTextWidget().getCaretOffset();
                if (position < existingTagsText.length()) {
                    remnant = existingTagsText.substring(position);
                    existingTagsText = existingTagsText.substring(0, position);
                }
                buffer.append(existingTagsText);
                if (existingTagsText.length() > 0) {
                    int startPoint = existingTagsText.length() - proposal.getContent().length();
                    if (startPoint < 0) {
                        startPoint = 0;
                    }
                    int pos = startPoint;
                    while (pos < existingTagsText.length()) {
                        if (proposal.getContent().toUpperCase().startsWith(existingTagsText.substring(pos).toUpperCase())) {
                            buffer.setLength(pos);
                            break;
                        }
                        ++pos;
                    }
                }
                buffer.append(proposal.getContent());
                position = buffer.length();
                buffer.append(remnant);
                String newTagTextContents = buffer.toString().trim();
                FilterContributionItem.this.getTextWidget().setText(newTagTextContents);
                FilterContributionItem.this.getTextWidget().setCaretOffset(position);
                FilterContributionItem.this.textViewr.revealRange(position, position);
            }
        };
        this.textListener = new ITextListener(){

            public void textChanged(TextEvent event) {
                FilterContributionItem.this.presentContents(FilterContributionItem.this.getText());
                FilterContributionItem.this.validateContents(FilterContributionItem.this.getText());
            }
        };
        this.verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (Messages.getString("FilterContributionItem.1").equals(e.text) && (e.start == 0 || e.start > 0 && FilterContributionItem.this.getText().charAt(e.end - 1) == ',')) {
                    e.doit = false;
                }
            }
        };
        this.keyListener = new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (FilterContributionItem.this.enterPressedInStyledtext) {
                    FilterContributionItem.this.enterPressedInStyledtext = false;
                } else {
                    StyledText text = (StyledText)e.getSource();
                    FilterContributionItem.this.provider.setProposals(FilterContributionItem.this.allocateCurrentProposals(text.getText(), text.getCaretOffset()));
                    if (e.keyCode == 13 && FilterContributionItem.this.validateContents(text.getText()) == 0) {
                        ((FilterContributionControl)FilterContributionItem.this.parent).doRun();
                    }
                }
            }
        };
        this.adapter.addContentProposalListener(this.contentProposalListener);
        this.getTextWidget().addKeyListener(this.keyListener);
        this.getTextWidget().addVerifyListener(this.verifyListener);
        this.textViewr.addTextListener(this.textListener);
    }

    String[] allocateCurrentProposals(String text, int position) {
        this.currentMode = this.whereAmI(text, position);
        switch (this.currentMode) {
            case FIELD: {
                this.controldecoration1.show();
                this.controldecoration1.setImage(this.column_image);
                this.controldecoration1.setDescriptionText(Messages.getString("ResourcesView.column.prompt"));
                return this.input;
            }
            case OPERATOR: {
                this.controldecoration1.show();
                this.controldecoration1.setImage(this.column_image);
                this.controldecoration1.setDescriptionText(Messages.getString("ResourcesView.prompt"));
                return this.operators;
            }
        }
        this.controldecoration1.setImage(this.column_image);
        this.controldecoration1.setDescriptionText(Messages.getString("ResourcesView.compareprompt"));
        String currentColumn = this.getApplicableField(text, position);
        if (currentColumn != null) {
            this.controldecoration1.show();
            ArrayList destination = (ArrayList)((ArrayList)this.numericHeadings).clone();
            destination.remove(currentColumn);
            return destination.toArray(new String[destination.size()]);
        }
        this.controldecoration1.hide();
        return new String[0];
    }

    private Mode whereAmI(String subString, int position) {
        int methodPosition;
        String methodSubString = subString;
        int start = methodPosition = position;
        int x = methodPosition - 1;
        while (x > -1 && methodSubString.charAt(x) != ',') {
            --start;
            --x;
        }
        int end = methodPosition;
        int x2 = methodPosition;
        while (x2 < methodSubString.length() && methodSubString.charAt(x2) != ',') {
            ++end;
            ++x2;
        }
        if ((methodSubString = methodSubString.substring(start, end)).indexOf(61) > -1 && methodSubString.indexOf(61) < (methodPosition -= start)) {
            return Mode.VALUE;
        }
        if (methodSubString.indexOf(62) > -1 && methodSubString.indexOf(62) < methodPosition) {
            return Mode.VALUE;
        }
        if (methodSubString.indexOf(60) > -1 && methodSubString.indexOf(60) < methodPosition) {
            return Mode.VALUE;
        }
        String[] stringArray = this.input;
        int n = this.input.length;
        int n2 = 0;
        while (n2 < n) {
            String prompt = stringArray[n2];
            if (methodSubString.trim().equalsIgnoreCase(prompt) && methodPosition == methodSubString.length()) {
                return Mode.OPERATOR;
            }
            ++n2;
        }
        return Mode.FIELD;
    }

    public void dispose() {
        this.textViewr.removeTextListener(this.textListener);
        if (this.getTextWidget() != null) {
            this.getTextWidget().removeKeyListener(this.keyListener);
            this.getTextWidget().removeVerifyListener(this.verifyListener);
        }
        this.adapter.removeContentProposalListener(this.contentProposalListener);
    }

    void presentContents(String text) {
        String tex = this.getText();
        this.parent.enableResetButton(tex.length() > 0 && !text.equals(this.dataFilter));
        String[] stringArray = this.input;
        int n = this.input.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            int start = tex.indexOf(column);
            while (start > -1) {
                StyleRange styleRange = new StyleRange();
                styleRange.start = start;
                styleRange.length = column.length();
                styleRange.foreground = Display.getDefault().getSystemColor(9);
                this.getTextWidget().setStyleRange(styleRange);
                start = tex.indexOf(column, start + column.length());
            }
            ++n2;
        }
        stringArray = this.operators;
        n = this.operators.length;
        n2 = 0;
        while (n2 < n) {
            String operator = stringArray[n2];
            String trimOperator = operator.trim();
            int start = tex.indexOf(trimOperator);
            while (start > -1) {
                StyleRange styleRange = new StyleRange();
                styleRange.start = start;
                styleRange.length = trimOperator.trim().length();
                styleRange.fontStyle = 1;
                this.getTextWidget().setStyleRange(styleRange);
                start = tex.indexOf(trimOperator, start + trimOperator.length());
            }
            ++n2;
        }
    }

    protected int validateContents(String text) {
        this.elements.clear();
        this.controldecoration2.hide();
        int error_level = 0;
        StringTokenizer currentTagsTokenizer = new StringTokenizer(this.textViewr.getDocument().get(), ",");
        while (currentTagsTokenizer.hasMoreElements()) {
            FilterElement element = new FilterElement(this.input, (String)currentTagsTokenizer.nextElement());
            if (element.isComplete()) {
                if (this.parent == null) continue;
                this.parent.validate(element);
                if (element.isValid()) {
                    if (element.containsInvalidCharacters()) {
                        error_level = 3;
                        continue;
                    }
                    this.elements.add(element);
                    continue;
                }
                error_level = element.getValue().length() == 0 ? 1 : 2;
                continue;
            }
            if (error_level != 0) continue;
            error_level = 1;
        }
        this.parent.enableRunButton(false);
        this.parent.enableResetButton(text.length() > 0 && !text.equals(Messages.getString("FilterContributionItem.0")));
        switch (error_level) {
            case 1: {
                this.controldecoration2.show();
                this.controldecoration2.setImage(this.warn_image);
                this.controldecoration2.setDescriptionText(Messages.getString("Filter.FilterIncomplete"));
                break;
            }
            case 2: {
                this.controldecoration2.show();
                this.controldecoration2.setImage(this.error_image);
                this.controldecoration2.setDescriptionText(Messages.getString("Filter.FilterInvalid"));
                break;
            }
            case 3: {
                this.controldecoration2.show();
                this.controldecoration2.setImage(this.error_image);
                this.controldecoration2.setDescriptionText(Messages.getString("Filter.InvalidCharacters"));
                break;
            }
            default: {
                this.controldecoration2.hide();
                if (this.elements.isEmpty()) break;
                this.parent.enableRunButton(true);
            }
        }
        return error_level;
    }

    public void initialiseColumns(List<String> inTheFilter, List<String> numericInFilter) {
        this.input = inTheFilter.toArray(new String[inTheFilter.size()]);
        this.numericHeadings = numericInFilter;
        if (this.textViewr != null) {
            this.parent.enableFilter(this.input.length > 0);
            this.presentContents(this.getText().trim());
        }
        this.provider.setProposals(this.allocateCurrentProposals("", 0));
    }

    StyledText getTextWidget() {
        return this.textViewr.getTextWidget();
    }

    String getText() {
        return this.getTextWidget().getText();
    }

    List<FilterElement> getElements() {
        return this.elements;
    }

    private String getApplicableField(String subString, int position) {
        int methodPosition;
        int start = methodPosition = position;
        int x = methodPosition - 1;
        while (x > -1 && subString.charAt(x) != ',') {
            --start;
            --x;
        }
        FilterElement currentElement = new FilterElement(this.numericHeadings.toArray(new String[this.numericHeadings.size()]), subString.substring(start, position));
        return (String)currentElement.getColumn();
    }

    public static interface IFilterContributionHost {
        public void enableFilter(boolean var1);

        public void enableRunButton(boolean var1);

        public void enableResetButton(boolean var1);

        public boolean validate(FilterElement var1);
    }

    private static enum Mode {
        FIELD,
        OPERATOR,
        VALUE;

    }
}

