/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.utilities;

import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.utilities.FilterContributionItem;
import com.ibm.cics.pa.ui.utilities.FilterElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;

public class FilterContributionControl
implements FilterContributionItem.IFilterContributionHost {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IFilterContributionAction host;
    private FilterContributionItem contributionItem = null;
    protected Action runFilterAction;
    protected Action resetFilterAction;
    private boolean filterApplied = false;
    private Map<String, String> heldFilters = new HashMap<String, String>();
    private String currentReference = null;

    public FilterContributionControl(IFilterContributionAction host, IToolBarManager toolBarMgr) {
        this.host = host;
        this.contributionItem = new FilterContributionItem(this);
        Separator filterActionsGroup = new Separator("filterContributions");
        toolBarMgr.add((IContributionItem)filterActionsGroup);
        toolBarMgr.appendToGroup("filterContributions", (IContributionItem)this.contributionItem);
        toolBarMgr.appendToGroup("filterContributions", this.getRunFilterAction());
        toolBarMgr.appendToGroup("filterContributions", this.getResetFilterAction());
        toolBarMgr.update(true);
    }

    private IAction getRunFilterAction() {
        this.runFilterAction = new Action(){

            public void run() {
                FilterContributionControl.this.doRun();
            }

            public String toString() {
                return "IAction[runFilterAction]";
            }
        };
        this.runFilterAction.setEnabled(false);
        this.runFilterAction.setToolTipText(Messages.getString("ResourcesView.runFilterAction.tooltip"));
        this.runFilterAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("run"));
        return this.runFilterAction;
    }

    void doRun() {
        if (this.runFilterAction.isEnabled()) {
            this.enableFilter(false);
            this.filterApplied = true;
            this.host.applyFilter(this.contributionItem.getElements());
        }
    }

    private IAction getResetFilterAction() {
        this.resetFilterAction = new Action(){

            public void run() {
                FilterContributionControl.this.doReset();
            }

            public String toString() {
                return "IAction[resetFilterAction]";
            }
        };
        this.enableResetButton(false);
        this.resetFilterAction.setToolTipText(Messages.getString("ResourcesView.resetFilterAction.tooltip"));
        this.resetFilterAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("reset"));
        return this.resetFilterAction;
    }

    void doReset() {
        if (this.filterApplied) {
            this.host.applyFilter(null);
            this.filterApplied = false;
        }
        this.contributionItem.getTextWidget().setText("");
    }

    public void initialiseColumns(String reference, List<String> inTheFilter, List<String> numericInFilter) {
        if (this.currentReference != null && this.contributionItem.getTextWidget() != null) {
            this.heldFilters.put(this.currentReference, this.contributionItem.getTextWidget().getText());
        }
        this.currentReference = reference;
        if (this.currentReference != null && this.heldFilters.containsKey(this.currentReference)) {
            this.contributionItem.getTextWidget().setText(this.heldFilters.get(this.currentReference));
            this.contributionItem.validateContents(this.heldFilters.get(this.currentReference));
        } else if (this.contributionItem.getTextWidget() != null) {
            this.contributionItem.getTextWidget().setText("");
            this.enableRunButton(false);
            this.enableResetButton(false);
        }
        this.contributionItem.initialiseColumns(inTheFilter, numericInFilter);
    }

    public void revalidate() {
        this.enableFilter(true);
        this.enableResetButton(this.contributionItem.getTextWidget() != null && this.contributionItem.getTextWidget().getText().length() > 0);
    }

    @Override
    public void enableFilter(boolean b) {
        if (this.contributionItem.getTextWidget() != null) {
            this.contributionItem.getTextWidget().setEnabled(b);
            this.contributionItem.getTextWidget().setBackground(b ? Display.getDefault().getSystemColor(25) : Display.getDefault().getSystemColor(22));
            if (!b) {
                this.enableRunButton(b);
                this.enableResetButton(b);
            }
        }
    }

    @Override
    public void enableRunButton(boolean ready) {
        this.runFilterAction.setEnabled(ready);
    }

    @Override
    public void enableResetButton(boolean ready) {
        this.resetFilterAction.setEnabled(ready || this.filterApplied);
    }

    @Override
    public boolean validate(FilterElement element) {
        this.host.validate(element);
        return element.isValid();
    }

    protected FilterContributionItem getFilterComponent() {
        return this.contributionItem;
    }

    public String getContent() {
        return this.contributionItem.getTextWidget().getText();
    }

    public void forceText(String filter) {
        this.contributionItem.getTextWidget().setText(filter);
        this.contributionItem.validateContents(filter);
    }

    public void resetFilter() {
        this.enableFilter(false);
        this.enableResetButton(false);
        if (this.contributionItem.getTextWidget() != null) {
            this.contributionItem.validateContents(this.contributionItem.getTextWidget().getText());
        }
        this.filterApplied = false;
    }

    public static interface IFilterContributionAction
    extends IViewPart {
        public boolean validate(FilterElement var1);

        public void applyFilter(List<FilterElement> var1);
    }
}

