/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.remote;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.ui.ScrollLimitManager;
import com.ibm.cics.eclipse.common.Utilities;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.pa.model.ChartType;
import com.ibm.cics.pa.model.ChartingFile;
import com.ibm.cics.pa.model.CommonTree;
import com.ibm.cics.pa.model.DataKeyElement;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.TreeElement;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.model.definitions.SheetViewDefinition;
import com.ibm.cics.pa.model.definitions.SortedCombinedHistogramLineSpecificDefinitions;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.figures.ChartSelectable;
import com.ibm.cics.pa.ui.figures.SelectableColumn;
import com.ibm.cics.pa.ui.remote.ConnectivityToken;
import com.ibm.cics.pa.ui.remote.DBQueryFactoryCustomer;
import com.ibm.cics.pa.ui.remote.DatabaseCommand;
import com.ibm.cics.pa.ui.remote.HierarchicalRemoteElement;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.cics.pa.ui.remote.RemoteConnectionProvider;
import com.ibm.cics.pa.ui.remote.RemoteUniqueRecord;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.utilities.FilterElement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class RemoteEditorInput
extends ChartingFile {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private GenericDataProvider sourceProvider;
    private String initialTab;
    HierarchicalRemoteElement rootElement;
    private DataKeyElement[] dataKeys;
    private ChartSpecification chartDefinition = null;
    private String reference;
    public static final String REMOTE_EDITOR = "RemoteEditor";
    public static final String SPECIFIC_ELEMENTS = "SpecificElements";
    public static final String HIERARCHY = "Hierarchy";
    public static final String TYPE = "Type";
    public static final int rowLimiter = 10000;
    Map<Object[], IUniqueRecord> resultSet = new LinkedHashMap<Object[], IUniqueRecord>();
    private String query = null;
    private String contentDescription;
    Collection<Object> data1 = null;
    private int rowTotal;
    DBQueryFactoryCustomer customer;
    DatabaseCommand sqlCommand;
    static IViewPart temporaryPart1 = null;
    private String table;
    private ColumnDefinition lastSort;
    private EngineShell.EngineListener engineListener;
    private String previousDescription;
    private ManifestRecord manifestRecord;
    private SheetViewDefinition viewDefinition;
    private boolean isRunning = false;

    private RemoteEditorInput(GenericDataProvider sourceProvider, String ref, String contentDescription, ManifestRecord manifestrecord) {
        super(ref);
        this.sourceProvider = sourceProvider;
        this.contentDescription = contentDescription;
        this.manifestRecord = manifestrecord;
        this.initialTab = sourceProvider instanceof RemoteEditorInput ? ((RemoteEditorInput)sourceProvider).getInitialTab() : (this.getManifestRecord() != null ? this.getManifestRecord().getDescription() : "");
    }

    private RemoteEditorInput(GenericDataProvider sourceProvider, String ref, StructuredSelection elements, ChartSpecification chartDefinition) {
        super(ref);
        this.chartDefinition = chartDefinition;
        this.sourceProvider = sourceProvider;
        this.dataKeys = RemoteEditorInput.getInputDataKeyElements(elements);
        this.contentDescription = String.valueOf(sourceProvider.getAbridgedReference()) + Messages.getString("CSVDataExtract.Subset1");
        Object[] els = elements.toArray();
        if (chartDefinition != null && chartDefinition.getType() == ChartType.COMBINEDHISTOGRAMLINE) {
            this.afterSort(els, ((SortedCombinedHistogramLineSpecificDefinitions)chartDefinition.getSpecificType()).getSortColumn(), ((SortedCombinedHistogramLineSpecificDefinitions)chartDefinition.getSpecificType()).isSortDescending());
        }
        Object[] objectArray = els;
        int n = els.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.resultSet.put(((IUniqueRecord)element).getRow(), (IUniqueRecord)element);
            this.addData(((IUniqueRecord)element).getRow());
            ++n2;
        }
        this.initialTab = sourceProvider instanceof RemoteEditorInput ? ((RemoteEditorInput)sourceProvider).getInitialTab() : (this.getManifestRecord() == null ? "" : this.getManifestRecord().getDescription());
    }

    public static RemoteEditorInput createAlreadyPopulated(GenericDataProvider provider, StructuredSelection elements, ChartSpecification chartDefinition) {
        String ref = provider.deriveSubReferenceFor(String.valueOf(DataKeyElement.getAggregatedHashcode(RemoteEditorInput.getInputDataKeyElements(elements))));
        return new RemoteEditorInput(provider, ref, elements, chartDefinition);
    }

    private static RemoteEditorInput createForPopulating(RemoteConnectionProvider provider, ChartSpecification chartDefinition, String contentDescription, Selection select, ManifestRecord manifest) {
        RemoteEditorInput res = null;
        if (RemoteEditorInput.checkConnection(provider) && select != null) {
            String ref = provider.deriveSubReferenceFor(Integer.toString(select.hashCode()));
            try {
                res = new RemoteEditorInput((GenericDataProvider)provider, ref, contentDescription, manifest);
                res.table = (String)select.getTargetTables().iterator().next();
            }
            catch (Exception e) {
                Debug.error((Logger)logger, (String)"RemoteEditorInput", (String)"createRemoteEditorInput", (Throwable)e);
            }
        }
        return res;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public String getAbridgedReference() {
        if (this.contentDescription == null) {
            this.contentDescription = this.getReference();
            if (this.contentDescription.length() > 125) {
                this.contentDescription = String.valueOf(this.getSourceProvider().getAbridgedReference()) + Messages.getString("CSVDataExtract.Cont");
            }
        }
        return this.contentDescription;
    }

    @Override
    public ColumnDefinition[] getColumnDefinitions() {
        return this.getSourceProvider().getColumnDefinitions();
    }

    @Override
    public int getColumnPosition(ColumnDefinition definition) {
        return this.getSourceProvider().getColumnPosition(definition);
    }

    @Override
    public int[] getColumnPositions(DataProviderKey definition) {
        return this.getSourceProvider().getColumnPositions(definition);
    }

    @Override
    public Object[][] getData(IProgressMonitor monitor) {
        if (this.data == null && this.data1 != null) {
            this.data = (Object[][])this.data1.toArray((T[])new Object[this.data1.size()][]);
        } else if (this.data1 != null && this.data.length < this.data1.size()) {
            this.data = (Object[][])this.data1.toArray((T[])new Object[this.data1.size()][]);
        }
        return this.data;
    }

    @Override
    public DataProviderKey getDataProviderKey() {
        return this.getSourceProvider().getDataProviderKey();
    }

    @Override
    public String[] getHeaders() {
        return this.getSourceProvider().getHeaders();
    }

    @Override
    public String getId() {
        return String.valueOf(this.getSourceProvider().getId()) + (this.dataKeys != null ? Integer.valueOf(DataKeyElement.getAggregatedHashcode(this.dataKeys)) : (this.query != null ? Integer.valueOf(this.query.hashCode()) : "")) + (this.sqlCommand != null ? this.sqlCommand.getSQLString().replace(':', '-') : "");
    }

    @Override
    public String getName() {
        return this.getReference();
    }

    @Override
    public String getReference() {
        if (this.reference == null) {
            this.reference = this.getSourceProvider().getReference();
            if (this.dataKeys == null) {
                if (this.sqlCommand != null) {
                    this.reference = String.valueOf(this.reference) + this.sqlCommand.getSQLString().replace(':', '-');
                } else if (this.query != null) {
                    this.reference = String.valueOf(this.reference) + this.query.substring(this.query.toLowerCase().indexOf("where") + 6);
                }
            } else {
                int i = 0;
                while (i < this.dataKeys.length) {
                    if (i > 0) {
                        this.reference = String.valueOf(this.reference) + "+";
                    }
                    this.reference = String.valueOf(this.reference) + this.dataKeys[i].getStatusBarText();
                    ++i;
                }
                if (this.chartDefinition != null && this.chartDefinition.getSpecificType() instanceof SortedCombinedHistogramLineSpecificDefinitions) {
                    ((SortedCombinedHistogramLineSpecificDefinitions)this.chartDefinition.getSpecificType()).getSortColumn().getLabel(null);
                    this.reference = String.valueOf(this.reference) + " (" + ((SortedCombinedHistogramLineSpecificDefinitions)this.chartDefinition.getSpecificType()).getSortColumn().getLabel(null) + ")";
                }
            }
        }
        return this.reference;
    }

    @Override
    public TreeElement getRootTreeElement() {
        return this.getSourceProvider().getRootTreeElement();
    }

    @Override
    public List<ChartSelectable> getSelectableColumns(ChartSpecification chartReference, IProgressMonitor monitor) {
        this.getData(monitor);
        ArrayList<ChartSelectable> primaryColumns = new ArrayList<ChartSelectable>();
        IUniqueRecord[] iUniqueRecordArray = this.resultSet.values().toArray(new RemoteUniqueRecord[this.resultSet.values().size()]);
        int n = iUniqueRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            IUniqueRecord rec = iUniqueRecordArray[n2];
            SelectableColumn column = null;
            switch (chartReference.getSpecificType().getChartType()) {
                case HISTOGRAM: 
                case BARCHARTVIEW: 
                case COMBINEDHISTOGRAMLINE: 
                case COMPACT_HISTOGRAM: {
                    column = new SelectableColumn(rec, chartReference, this.getColumnDefinitions());
                    break;
                }
            }
            primaryColumns.add(column);
            if (monitor != null && monitor.isCanceled()) {
                return primaryColumns;
            }
            ++n2;
        }
        return primaryColumns;
    }

    public GenericDataProvider getSourceProvider() {
        return this.sourceProvider;
    }

    public RemoteConnectionProvider getRemoteConnectionProvider() {
        GenericDataProvider provid = this.getSourceProvider();
        if (provid instanceof RemoteEditorInput) {
            return ((RemoteEditorInput)provid).getRemoteConnectionProvider();
        }
        return (RemoteConnectionProvider)provid;
    }

    private static boolean checkConnection(GenericDataProvider provider) {
        return provider instanceof RemoteConnectionProvider ? ((RemoteConnectionProvider)provider).checkConnection() : ((RemoteEditorInput)provider).getRemoteConnectionProvider().checkConnection();
    }

    @Override
    public String getTabName() {
        if (this.getRemoteConnectionProvider() != null) {
            int rc = this.getTotalRows();
            if (!this.isPopulated()) {
                return String.valueOf(this.getRemoteConnectionProvider().getTabName()) + MessageFormat.format(Messages.getString("CSVDataExtract.Rows"), "0/" + rc);
            }
            String trows = "";
            if (rc > 0) {
                trows = String.valueOf(trows) + "/" + rc;
            }
            String l = this.data == null ? "0" : Integer.valueOf(this.data.length).toString();
            String dat1Size = this.data1 != null ? String.valueOf(Integer.valueOf(this.data1.size()).toString()) + trows : l;
            this.tabName = String.valueOf(this.getInitialTab()) + ' ' + MessageFormat.format(Messages.getString("CSVDataExtract.Rows"), dat1Size);
        } else {
            this.tabName = "";
        }
        if (this.chartDefinition != null && this.chartDefinition.getSpecificType() instanceof SortedCombinedHistogramLineSpecificDefinitions) {
            this.tabName = String.valueOf(this.tabName) + " (" + ((SortedCombinedHistogramLineSpecificDefinitions)this.chartDefinition.getSpecificType()).getSortColumn().getLabel(null) + ")";
        }
        return this.tabName;
    }

    @Override
    public String getToolTipText() {
        return this.getReference();
    }

    @Override
    public Object[] getValuesFor(ColumnDefinition definition) {
        return this.getSourceProvider().getValuesFor(definition);
    }

    @Override
    public boolean isPopulated() {
        return this.data != null || this.data1 != null;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.getSourceProvider().isValid();
    }

    @Override
    public IUniqueRecord locateUniqueRecordForRow(Object[] row) {
        return this.resultSet.get(row);
    }

    @Override
    public void resetOrdering() {
    }

    private static DataKeyElement[] getInputDataKeyElements(StructuredSelection element) {
        ArrayList<DataKeyElement> keys = new ArrayList<DataKeyElement>();
        Object[] objectArray = element.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object el = objectArray[n2];
            keys.add(((CommonTree)el).getDataKey());
            ++n2;
        }
        return keys.toArray(new DataKeyElement[keys.size()]);
    }

    @Override
    public Collection<IUniqueRecord> getAllResults() {
        return this.resultSet.values();
    }

    @Override
    public GenericDataProvider getRootSource() {
        return this.getRemoteConnectionProvider();
    }

    public void addData(Collection<Object> items) {
        if (this.data1 == null) {
            this.data1 = new ArrayList<Object>();
        }
        this.data1.addAll(items);
        this.data = null;
    }

    public void addData(Object item) {
        if (this.data1 == null) {
            this.data1 = new ArrayList<Object>();
        }
        this.data1.add(item);
        this.data = null;
    }

    @Override
    public int getTotalRows() {
        if (this.rowTotal == 0) {
            this.rowTotal = this.data != null ? this.data.length : 0;
        }
        return this.rowTotal;
    }

    public void setTotalRows(int total) {
        this.rowTotal = total;
    }

    public String getInitialTab() {
        return this.initialTab;
    }

    public void setInitialTab(String initialTab) {
        this.initialTab = initialTab;
    }

    public HierarchicalRemoteElement getRootElement() {
        return this.rootElement;
    }

    public Map<Object[], IUniqueRecord> getResultSet() {
        return this.resultSet;
    }

    public EngineShell.EngineListener engineListener(DatabaseCommand command, final ChartSpecification chart, DBQueryFactoryCustomer customer1) {
        this.customer = customer1;
        this.sqlCommand = command;
        return new EngineShell.EngineListener(){

            public synchronized void dataAvailable(Collection<Object> items) {
                if (RemoteEditorInput.this.customer.getCurrentCommand() == RemoteEditorInput.this.sqlCommand) {
                    HierarchicalRemoteElement[] parents = new HierarchicalRemoteElement[Math.max(RemoteEditorInput.this.getColumnPositions(RemoteEditorInput.this.getDataProviderKey()).length, 1)];
                    for (Object item : items) {
                        HierarchicalRemoteElement aChild = RemoteEditorInput.this.rootElement;
                        Object[] res = (Object[])item;
                        int j = 0;
                        while (j < parents.length) {
                            if (RemoteEditorInput.this.getRootSource().getColumnPositions(RemoteEditorInput.this.getDataProviderKey()).length > 0 && res[RemoteEditorInput.this.getRootSource().getColumnPositions(RemoteEditorInput.this.getDataProviderKey())[j]] != null) {
                                try {
                                    if (j == parents.length - 1) {
                                        aChild = (RemoteUniqueRecord)aChild.getChild(RemoteEditorInput.this.getDataProviderKey().getColumnDefinitions()[j], res[RemoteEditorInput.this.getRootSource().getColumnPositions(RemoteEditorInput.this.getDataProviderKey())[j]], RemoteEditorInput.this.getRootSource().getColumnPositions(RemoteEditorInput.this.getDataProviderKey())[j], res);
                                        RemoteEditorInput.this.resultSet.put(res, (RemoteUniqueRecord)aChild);
                                    } else {
                                        aChild = (HierarchicalRemoteElement)aChild.getChild(RemoteEditorInput.this.getDataProviderKey().getColumnDefinitions()[j], res[RemoteEditorInput.this.getRootSource().getColumnPositions(RemoteEditorInput.this.getDataProviderKey())[j]], RemoteEditorInput.this.getRootSource().getColumnPositions(RemoteEditorInput.this.getDataProviderKey())[j]);
                                    }
                                }
                                catch (ArrayIndexOutOfBoundsException ex) {
                                    logger.logp(Level.SEVERE, this.getClass().getName(), "engineListener", "Array Index error", ex);
                                }
                            }
                            ++j;
                        }
                    }
                    RemoteEditorInput.this.addData(items);
                    if (chart == null) {
                        RemoteEditorInput.this.setRunning(true);
                        RemoteEditorInput.this.customer.refresh(RemoteEditorInput.this, RemoteEditorInput.this.data1.size() > items.size());
                    }
                }
            }

            public void notifyResultCount(int count) {
                RemoteEditorInput.this.addData(new ArrayList<Object>());
                RemoteEditorInput.this.setTotalRows(count);
                RemoteEditorInput.this.customer.receiveNotification(count);
            }

            public void statusUpdate(EngineShell.EngineStatus es) {
                if (RemoteEditorInput.this.customer.getCurrentCommand() == RemoteEditorInput.this.sqlCommand) {
                    switch (es) {
                        case Cancelled: {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    IWorkbenchPart apart;
                                    ScrollLimitManager scrollLimitManager = (this).RemoteEditorInput.this.customer.getScrollLimitManager();
                                    if (scrollLimitManager != null) {
                                        scrollLimitManager.dispose();
                                    }
                                    if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null && (apart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart()) != null) {
                                        ViewHelper.setStatusInformationMessage((IWorkbenchPart)apart, (String)Messages.getString("RemoteEditorInput.SearchHalted1"));
                                    }
                                    (this).RemoteEditorInput.this.customer.abort();
                                    if (temporaryPart1 != null) {
                                        temporaryPart1.getSite().getPage().hideView(temporaryPart1);
                                        temporaryPart1 = null;
                                    }
                                }
                            });
                            break;
                        }
                        case Error: {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    IWorkbenchPart apart;
                                    ScrollLimitManager scrollLimitManager = (this).RemoteEditorInput.this.customer.getScrollLimitManager();
                                    if (scrollLimitManager != null) {
                                        scrollLimitManager.dispose();
                                    }
                                    if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null && (apart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart()) != null) {
                                        ViewHelper.setStatusInformationMessage((IWorkbenchPart)apart, (String)Messages.getString("RemoteEditorInput.SearchHalted"));
                                    }
                                    (this).RemoteEditorInput.this.customer.abort();
                                    if (temporaryPart1 != null) {
                                        temporaryPart1.getSite().getPage().hideView(temporaryPart1);
                                        temporaryPart1 = null;
                                    }
                                }
                            });
                            break;
                        }
                        case Complete: {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    RemoteEditorInput.this.setRunning(false);
                                    (this).RemoteEditorInput.this.customer.refresh(RemoteEditorInput.this, false);
                                    ScrollLimitManager scrollLimitManager = (this).RemoteEditorInput.this.customer.getScrollLimitManager();
                                    if (scrollLimitManager != null) {
                                        scrollLimitManager.dispose();
                                    }
                                    if (temporaryPart1 != null) {
                                        temporaryPart1.getSite().getPage().hideView(temporaryPart1);
                                        temporaryPart1 = null;
                                    }
                                }
                            });
                            break;
                        }
                        case Paused: {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    RemoteEditorInput.this.setRunning(false);
                                    (this).RemoteEditorInput.this.customer.refresh(RemoteEditorInput.this, false);
                                    ScrollLimitManager scrollLimitManager = (this).RemoteEditorInput.this.customer.getScrollLimitManager();
                                    if (scrollLimitManager != null) {
                                        scrollLimitManager.setCursor(null);
                                        scrollLimitManager.scrollLimitReached((Command)(this).RemoteEditorInput.this.sqlCommand);
                                        scrollLimitManager.setTaskName(MessageFormat.format(Messages.getString("SheetView.collecting"), RemoteEditorInput.this.getManifestRecord().getDescription()));
                                    }
                                    if (temporaryPart1 != null) {
                                        temporaryPart1.getSite().getPage().hideView(temporaryPart1);
                                        temporaryPart1 = null;
                                    }
                                }
                            });
                            break;
                        }
                    }
                }
            }
        };
    }

    public int dataAvailable(Collection<Object> items) {
        HierarchicalRemoteElement[] parents = new HierarchicalRemoteElement[Math.max(this.getColumnPositions(this.getDataProviderKey()).length, 1)];
        for (Object item : items) {
            HierarchicalRemoteElement aChild = this.rootElement;
            Object[] res = (Object[])item;
            int j = 0;
            while (j < parents.length) {
                if (this.getRootSource().getColumnPositions(this.getDataProviderKey()).length > 0 && res[this.getRootSource().getColumnPositions(this.getDataProviderKey())[j]] != null) {
                    try {
                        if (j == parents.length - 1) {
                            aChild = (RemoteUniqueRecord)aChild.getChild(this.getDataProviderKey().getColumnDefinitions()[j], res[this.getRootSource().getColumnPositions(this.getDataProviderKey())[j]], this.getRootSource().getColumnPositions(this.getDataProviderKey())[j], res);
                            this.resultSet.put(res, (RemoteUniqueRecord)aChild);
                        } else {
                            aChild = (HierarchicalRemoteElement)aChild.getChild(this.getDataProviderKey().getColumnDefinitions()[j], res[this.getRootSource().getColumnPositions(this.getDataProviderKey())[j]], this.getRootSource().getColumnPositions(this.getDataProviderKey())[j]);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        logger.logp(Level.SEVERE, this.getClass().getName(), "engineListener", "Array Index error", ex);
                    }
                }
                ++j;
            }
        }
        this.addData(items);
        return this.data1.size();
    }

    public void updateCustomer(DBQueryFactoryCustomer part) {
        this.customer = part;
        this.customer.upDateCommand((Command)this.sqlCommand);
    }

    public static RemoteEditorInput runQuery(DBQueryFactoryCustomer view, Selection select, Map<String, Object> parameterMap, ChartSpecification chartDefinition, String contentDescription, ManifestRecord manifestRecord, int overridePageSize) {
        if (PAConnectionTracker.getInstance().isConnected()) {
            return RemoteEditorInput.runQuery(select, view, chartDefinition, contentDescription, parameterMap, false, manifestRecord, overridePageSize);
        }
        return null;
    }

    private static synchronized RemoteEditorInput runQuery(Selection select, DBQueryFactoryCustomer recipientView, ChartSpecification chartDefinition, String contentDescription, Map<String, Object> parameterMap, boolean dynamic, ManifestRecord manifestRecord, int overridePageSize) {
        RemoteConnectionProvider rootProvider;
        Debug.enter((Logger)logger, (String)RemoteEditorInput.class.getName(), (String)"runQuery");
        RemoteEditorInput dataProvider = null;
        ConnectivityToken token = PAConnectionTracker.getInstance().createToken();
        if (token != null && Utilities.hasContent((String)token.getId()) && (dataProvider = RemoteEditorInput.createForPopulating(rootProvider = new RemoteConnectionProvider(Integer.toString(parameterMap.hashCode()), token), null, contentDescription, select, manifestRecord)) != null) {
            dataProvider.rootElement = new HierarchicalRemoteElement(rootProvider);
            final DatabaseCommand command = new DatabaseCommand(select, token, parameterMap, overridePageSize);
            dataProvider.engineListener = dataProvider.engineListener(command, chartDefinition, recipientView);
            command.addListener(dataProvider.engineListener);
            recipientView.upDateCommand((Command)command);
            command.setAsync(false);
            Job job = new Job(MessageFormat.format(Messages.getString("SheetView.collecting"), manifestRecord != null ? manifestRecord.getDescription() : "")){

                protected IStatus run(IProgressMonitor monitor) {
                    command.start();
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(30);
            IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)recipientView.getSite().getAdapter(IWorkbenchSiteProgressService.class);
            siteService.schedule(job, 100L, true);
        }
        Debug.exit((Logger)logger, (String)RemoteEditorInput.class.getName(), (String)"runQuery", dataProvider);
        return dataProvider;
    }

    public String getTable() {
        return this.table;
    }

    public void afterSort(Object[] elements, final ColumnDefinition sortColumn, final boolean sortDescending) {
        int col = -1;
        int i = this.getColumnDefinitions().length - 1;
        while (i >= 0) {
            if (sortColumn == this.getColumnDefinitions()[i]) {
                col = i;
            }
            --i;
        }
        final int column = col;
        if (column > -1) {
            Arrays.sort(elements, new java.util.Comparator<Object>(){

                @Override
                public int compare(Object a, Object b) {
                    return DataTypeUtilities.compare(sortColumn, sortDescending ? 1024 : 128, ((RemoteUniqueRecord)a).getRow()[column], ((RemoteUniqueRecord)b).getRow()[column]);
                }
            });
        }
    }

    @Override
    public GenericDataProvider sort(DBQueryFactoryCustomer recipientView, ColumnDefinition defn, int direction, int realIndex, List<FilterElement> filters) {
        StringBuffer newDescription = new StringBuffer(Utilities.hasContent((String)this.previousDescription) ? this.previousDescription : this.contentDescription);
        RemoteEditorInput dataProvider1 = null;
        Selection query = this.sqlCommand.getSelectionObject().getSelection();
        Map<String, Object> parameterMap = this.sqlCommand.getParameterMap();
        this.table = (String)query.getTargetTables().iterator().next();
        if (query.getOrderBy() != null && this.lastSort != null) {
            query.getOrderBy().removeColumn(this.lastSort.getDBColumnRef());
        }
        if (direction != 0) {
            if (query.getOrderBy() != null) {
                ColumnReference column = PresentationFactory.getInstance().createBasicColumn(defn.getDBColumnRef(), this.table, defn.getType());
                column.setDirection(direction == 128 ? Direction.ASC : Direction.DESC);
                query.getOrderBy().getColumns().add(0, column);
            } else {
                query.addOrderByCondition(defn.getDBColumnRef(), (String)query.getTargetTables().iterator().next(), direction == 128 ? Direction.ASC : Direction.DESC);
            }
        }
        if (filters == null || filters.isEmpty()) {
            parameterMap.remove("TemporaryConstraintAnd");
            parameterMap.remove("TemporaryConstraintOr");
        } else {
            newDescription.append(' ');
            Object aClause = null;
            for (FilterElement element : filters) {
                newDescription.append(element.toString());
                newDescription.append(',');
                ColumnDefinition column = (ColumnDefinition)element.getColumn();
                String attribute = element.getOperator();
                boolean isNot = false;
                Comparator comparator = Comparator.EQ;
                if (!attribute.trim().equals("=")) {
                    if (attribute.trim().equals("!=")) {
                        comparator = Comparator.EQ;
                        isNot = true;
                    } else if (attribute.trim().equals(">")) {
                        comparator = Comparator.GT;
                    } else if (attribute.trim().equals(">=")) {
                        comparator = Comparator.GE;
                    } else if (attribute.trim().equals("<")) {
                        comparator = Comparator.LT;
                    } else if (attribute.trim().equals("<=")) {
                        comparator = Comparator.LE;
                    }
                }
                String value = element.getValue();
                if (element.getAlternativeValue() != null) {
                    value = element.getAlternativeValue().getDBColumnRef();
                }
                if (value.indexOf(42) > -1) {
                    value.replace('*', '%');
                }
                if (value.indexOf(37) > -1) {
                    comparator = Comparator.LI;
                }
                aClause = aClause == null ? PresentationFactory.getInstance().createSimpleCondition(column.getDBColumnRef(), this.table, column.getType(), comparator, new Object[]{value}, isNot) : aClause.appendCondition(column.getDBColumnRef(), this.table, column.getType(), comparator, new Object[]{value}, QueryElement.Predicate.AND, isNot);
            }
            parameterMap.put("TemporaryConstraintAnd", aClause);
        }
        dataProvider1 = RemoteEditorInput.runQuery(query, recipientView, null, newDescription.toString(), parameterMap, false, this.getManifestRecord(), 0);
        dataProvider1.setPreFilterDescription(Utilities.hasContent((String)this.previousDescription) ? this.previousDescription : this.contentDescription);
        dataProvider1.setLastSortColumn(defn);
        this.data1 = null;
        this.data = null;
        this.rootElement = null;
        return dataProvider1;
    }

    public ManifestRecord getManifestRecord() {
        return this.manifestRecord;
    }

    private void setPreFilterDescription(String contentDescription2) {
        this.previousDescription = contentDescription2;
    }

    private void setLastSortColumn(ColumnDefinition defn) {
        this.lastSort = defn;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.data1 = null;
    }

    public void setSpecification(SheetViewDefinition chartReference) {
        this.viewDefinition = chartReference;
    }

    public SheetViewDefinition getViewDefinition() {
        return this.viewDefinition;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }
}

