/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.remote;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.pa.model.ChartingFile;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.TreeElement;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.ui.PAContextTracker;
import com.ibm.cics.pa.ui.remote.ConnectivityToken;
import com.ibm.cics.pa.ui.remote.HierarchicalRemoteElement;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.cics.pa.ui.remote.RemoteEditorInput;
import com.ibm.cics.pa.ui.remote.RemoteUniqueRecord;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;

public class RemoteConnectionProvider
extends ChartingFile {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    protected ConnectivityToken connectivityToken = null;
    protected Map<Object[], RemoteUniqueRecord> resultSet = new LinkedHashMap<Object[], RemoteUniqueRecord>();

    @Override
    public String getId() {
        return this.reference2 != null ? super.getId() : this.connectivityToken.getId();
    }

    public static RemoteConnectionProvider getDefault() {
        RemoteConnectionProvider provider = null;
        try {
            if (ConnectionsPlugin.getDefault().getConnectionService().getConnectionManager() != null) {
                provider = new RemoteConnectionProvider("");
            }
        }
        catch (NumberFormatException e) {
            Debug.error((Logger)logger, (String)RemoteConnectionProvider.class.getName(), (String)"getDefault", (Throwable)e);
        }
        catch (Exception e) {
            Debug.error((Logger)logger, (String)RemoteConnectionProvider.class.getName(), (String)"getDefault", (Throwable)e);
        }
        return provider;
    }

    protected RemoteConnectionProvider(String file) throws NumberFormatException, Exception {
        super(file);
        this.connectivityToken = PAConnectionTracker.getInstance().createToken();
    }

    protected RemoteConnectionProvider(String file, ConnectivityToken connectivityToken) {
        super(file);
        this.connectivityToken = connectivityToken;
    }

    @Override
    public ColumnDefinition[] getColumnDefinitions() {
        if (this.connectivityToken != null) {
            return this.connectivityToken.getColumnDefinitions();
        }
        return PAContextTracker.getInstance().getColumnDefinitions();
    }

    @Override
    public void decrementUseCount() {
        Debug.enter((Logger)logger, (String)RemoteConnectionProvider.class.getName(), (String)"decrementUseCount", (Object)this.getReference());
        --this.useCount;
        Debug.exit((Logger)logger, (String)RemoteConnectionProvider.class.getName(), (String)"decrementUseCount", (Object)(String.valueOf(this.getReference()) + " " + this.useCount));
    }

    @Override
    public int getColumnPosition(ColumnDefinition definition) {
        if (this.getColumnDefinitions() != null) {
            int i = 0;
            while (i < this.getColumnDefinitions().length) {
                if (this.getColumnDefinitions()[i] == definition) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    @Override
    public int[] getColumnPositions(DataProviderKey definition) {
        if (definition == null) {
            return new int[0];
        }
        ColumnDefinition[] definitions = definition.getColumnDefinitions();
        int[] positions = new int[definitions.length];
        int i = 0;
        while (i < positions.length) {
            positions[i] = this.getColumnPosition(definitions[i]);
            ++i;
        }
        return positions;
    }

    public boolean isCurrentConnection() {
        return this.connectivityToken != null && this.connectivityToken.isCurrentConnection();
    }

    public boolean checkConnection() {
        return this.isCurrentConnection() ? true : this.resetConnected();
    }

    @Override
    public Object[][] getData(IProgressMonitor monitor) {
        if (this.data == null) {
            this.data = new Object[0][];
        }
        return this.data;
    }

    @Override
    public DataProviderKey getDataProviderKey() {
        if (this.connectivityToken != null) {
            return this.connectivityToken.getStructureKey();
        }
        return PAContextTracker.getInstance().getStructureKey();
    }

    @Override
    public String[] getHeaders() {
        if (this.connectivityToken != null) {
            return this.connectivityToken.getHeaders();
        }
        return PAContextTracker.getInstance().getHeaders();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    @Override
    public String getName() {
        return this.getTabName();
    }

    @Override
    public TreeElement getRootTreeElement() {
        if (this.explorerViewModel == null) {
            this.explorerViewModel = HierarchicalRemoteElement.createExplorerViewModel(this);
        }
        return this.explorerViewModel;
    }

    @Override
    public String getToolTipText() {
        return new Path(this.getFileReference()).makeRelative().toString();
    }

    @Override
    public Object[] getValuesFor(ColumnDefinition definition) {
        return null;
    }

    @Override
    public boolean isPopulated() {
        return false;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public GenericDataProvider getRootSource() {
        return this;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public void connect() {
        PAContextTracker.getInstance();
        this.connectivityToken.connect();
    }

    public String getConnectionName() {
        return this.connectivityToken.getName();
    }

    public boolean resetConnected() {
        if (this.connectivityToken != null) {
            this.connectivityToken.refreshData();
            return true;
        }
        return false;
    }

    @Override
    public String getTabName() {
        return this.connectivityToken.getName();
    }

    @Override
    public int getTotalRows() {
        return this.data != null ? this.data.length : 0;
    }

    public String getInitialTab() {
        return ((RemoteEditorInput)this.getRootSource()).getInitialTab();
    }
}

