/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.remote;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.CommonTree;
import com.ibm.cics.pa.model.DataKeyElement;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.TreeElement;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.ui.remote.RemoteAppSummUniqueRecord;
import com.ibm.cics.pa.ui.remote.RemoteConnectionProvider;
import com.ibm.cics.pa.ui.remote.RemotePerfSummUniqueRecord;
import com.ibm.cics.pa.ui.remote.RemoteUniqueRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class HierarchicalRemoteElement
extends CommonTree
implements TreeElement {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    protected boolean treePopulated = false;
    public static final String REMOTE = "RemoteElement";
    private List<RemoteUniqueRecord> allChildren = new ArrayList<RemoteUniqueRecord>();

    public HierarchicalRemoteElement(ColumnDefinition column, Object label, int columnRef) {
        this.column = column;
        this.columnRef = columnRef;
        this.parent = null;
        this.label = label;
    }

    public static HierarchicalRemoteElement createExplorerViewModel(RemoteConnectionProvider adaptableObject) {
        Debug.enter((Logger)logger, (String)HierarchicalRemoteElement.class.getName(), (String)"HierarchicalRemoteElement");
        HierarchicalRemoteElement model = new HierarchicalRemoteElement(adaptableObject);
        Debug.exit((Logger)logger, (String)HierarchicalRemoteElement.class.getName(), (String)"HierarchicalRemoteElement", (Object)model);
        return model;
    }

    protected HierarchicalRemoteElement(RemoteConnectionProvider adaptableObject) {
        this.columnRef = -1;
        this.source = adaptableObject;
    }

    public HierarchicalRemoteElement(GenericDataProvider provider, DataKeyElement key) {
        this.source = provider;
        this.dataKey = key;
        Map<ColumnDefinition, Object> mapping = key.getReferenceMapping();
        if (mapping.isEmpty()) {
            this.columnRef = -1;
        } else {
            this.column = (ColumnDefinition)mapping.keySet().toArray()[mapping.size() - 1];
        }
    }

    @Override
    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    public boolean isTreePopulated() {
        return this.treePopulated;
    }

    @Override
    public void clear() {
    }

    @Override
    public Object[] getChildren() {
        return this.getChildren(this);
    }

    public Object[] getChildren(Object o) {
        if (this.allChildren.isEmpty()) {
            return this.children.values().toArray();
        }
        return this.allChildren.toArray();
    }

    protected DataProviderKey getStructureKey() {
        return this.getSourceProvider().getDataProviderKey();
    }

    @Override
    public int getColumnRef() {
        return this.columnRef;
    }

    @Override
    public ArrayList<IUniqueRecord> getAllLeafDescendents() {
        ArrayList<IUniqueRecord> collection = new ArrayList<IUniqueRecord>();
        if (this instanceof IUniqueRecord) {
            collection.add((IUniqueRecord)((Object)this));
        } else {
            Object[] objectArray = this.getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child1 = objectArray[n2];
                TreeElement child0 = (TreeElement)child1;
                if (child0 instanceof IUniqueRecord) {
                    collection.add((IUniqueRecord)child0);
                } else {
                    collection.addAll(child0.getAllLeafDescendents());
                }
                ++n2;
            }
        }
        return collection;
    }

    @Override
    public TreeElement getChild(ColumnDefinition columnDefinition, Object label, int i) {
        TreeElement child = (TreeElement)this.children.get(label);
        if (child == null) {
            child = new HierarchicalRemoteElement(columnDefinition, label, i);
            this.addChild(child);
        }
        return child;
    }

    protected void addChild(TreeElement modelItem) {
        this.children.put(modelItem.getLabel(), modelItem);
        ((HierarchicalRemoteElement)modelItem).setParent(this);
        this.treePopulated = true;
    }

    @Override
    public TreeElement getChild(ColumnDefinition columnDefinition, Object label, int i, Object[] dataRow) {
        RemoteUniqueRecord child = null;
        for (RemoteUniqueRecord record : this.allChildren) {
            if (!record.getRow().equals(dataRow)) continue;
            child = record;
        }
        if (child == null) {
            child = columnDefinition == ColumnDefinition.TRAN ? new RemotePerfSummUniqueRecord(columnDefinition, label, i, dataRow) : (columnDefinition == ColumnDefinition.ACOPERNM ? new RemoteAppSummUniqueRecord(columnDefinition, label, i, dataRow) : new RemoteUniqueRecord(columnDefinition, label, i, dataRow));
            this.allChildren.add(child);
            this.addChild(child);
        }
        return child;
    }

    @Override
    public IUniqueRecord findExplorerViewModelElement(Object[] row) {
        TreeElement model = null;
        ArrayList<IUniqueRecord> elements = new ArrayList<IUniqueRecord>();
        if (row != null) {
            Object[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                ((HierarchicalRemoteElement)children[i]).findExplorerViewModelElement(elements, row);
                ++i;
            }
            if (elements.size() > 0) {
                model = (TreeElement)elements.get(0);
            }
        }
        return (IUniqueRecord)model;
    }

    private void findExplorerViewModelElement(ArrayList<IUniqueRecord> elements, Object[] row) {
        if (row != null && row[this.getColumnRef()].equals(this.getLabel())) {
            if (this instanceof IUniqueRecord) {
                elements.add((IUniqueRecord)((Object)this));
            } else {
                Object[] children = this.getChildren();
                int i = 0;
                while (i < children.length) {
                    ((HierarchicalRemoteElement)children[i]).findExplorerViewModelElement(elements, row);
                    ++i;
                }
            }
        }
    }

    public static HierarchicalRemoteElement createForParent(GenericDataProvider provider, DataKeyElement key) {
        return new HierarchicalRemoteElement(provider, key);
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public Object getParent(Object o) {
        return this.getParent();
    }
}

