/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.preferences;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.definitions.ChartCategorisation;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Activator;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(PreferenceInitializer.class.getPackage().getName());

    public void initializeDefaultPreferences() {
        Debug.enter((Logger)logger, (String)PreferenceInitializer.class.getName(), (String)"initializeDefaultPreferences", (Object)((Object)this));
        IEclipsePreferences preferences = Activator.getDefault().getPluginDefaultPreferences();
        List<ColumnDefinition> defns = ColumnDefinition.getDefinitions();
        defns.remove(ColumnDefinition.UNKNOWN);
        for (ColumnDefinition def : defns) {
            preferences.put(def.getDBColumnRef(), StringConverter.asString((RGB)def.getColor()));
        }
        for (ChartCategorisation categorisation : EnumSet.allOf(ChartCategorisation.class)) {
            preferences.putBoolean(categorisation.name(), true);
        }
        preferences.putBoolean("Restrict", false);
        preferences.putBoolean("Include", true);
        preferences.putBoolean("BEFORE_CHECK", false);
        preferences.putBoolean("AFTER_CHECK", false);
        preferences.put("LAST_TABLE", "CMFPSUM");
        preferences.put("PRE32_TABLE", "EXPLORER_SUMMARY");
        preferences.putBoolean("com.ibm.cics.pa.ui.alert.table.ts", true);
        preferences.putBoolean("com.ibm.cics.pa.ui.alert.table.tg", false);
        preferences.putBoolean("com.ibm.cics.pa.ui.overviewlinkto.selection", true);
        preferences.putBoolean("default_column_labels", false);
        preferences.putInt("ALERT_PAGE_SIZE", 50);
        Debug.exit((Logger)logger, (String)PreferenceInitializer.class.getName(), (String)"initializeDefaultPreferences", (Object)((Object)this));
    }
}

