/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.preferences;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.ui.TextInput;
import com.ibm.cics.pa.model.Column;
import com.ibm.cics.pa.model.definitions.CategorisationHelper;
import com.ibm.cics.pa.model.definitions.ChartCategorisation;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.ColumnDefinitionHelper;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.views.IChartColorPreferenceDependent;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class ChartColorPrefs
extends PreferencePage
implements IWorkbenchPreferencePage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    private Composite colorControls;
    private Composite controlArea;
    private StackLayout controlAreaLayout;
    FilteredTree tree;
    private Group colorGroup;
    private Label bar;
    private Button colorResetButton;
    private Button colorSelectorButton;
    private ColorDialog colorDialog;
    Image swatchImagePie;
    private Text descriptionText;
    CategorizationLabelProvider labelProvider;
    Map<ColumnDefinition, RGB> colorPreferencesToReset = new HashMap<ColumnDefinition, RGB>();
    Map<ColumnDefinition, RGB> potentialColorPreferences = new HashMap<ColumnDefinition, RGB>();

    protected Control createContents(Composite parent) {
        Debug.enter((Logger)logger, (String)ChartColorPrefs.class.getName(), (String)"createContents");
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "com.ibm.cics.pa.ui.colors_preferences");
        Composite mainColumn = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        mainColumn.setFont(parent.getFont());
        mainColumn.setLayout((Layout)layout);
        GridData data = new GridData(1);
        Label label = new Label(mainColumn, 16384);
        label.setText(Messages.getString("ChartColorPrefs.0"));
        label.setLayoutData((Object)data);
        Composite controlRow = new Composite(mainColumn, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        controlRow.setLayout((Layout)layout);
        data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        controlRow.setLayoutData((Object)data);
        this.createTree(controlRow);
        Composite controlColumn = new Composite(controlRow, 0);
        data = new GridData(1040);
        controlColumn.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        controlColumn.setLayout((Layout)layout);
        this.controlArea = new Composite(controlColumn, 0);
        this.controlAreaLayout = new StackLayout();
        this.controlArea.setLayout((Layout)this.controlAreaLayout);
        this.colorControls = new Composite(this.controlArea, 0);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.colorControls.setLayout((Layout)layout);
        this.createColorControl();
        this.createDescriptionControl(mainColumn);
        this.updateTreeSelection(this.tree.getViewer().getSelection());
        Debug.exit((Logger)logger, (String)ChartColorPrefs.class.getName(), (String)"createContents");
        return mainColumn;
    }

    private void createTree(Composite parent) {
        Debug.enter((Logger)logger, (String)ChartColorPrefs.class.getName(), (String)"createTree");
        this.labelProvider = new CategorizationLabelProvider();
        this.tree = new FilteredTree(parent, 2820, new PatternFilter(){

            protected boolean isParentMatch(Viewer viewer, Object element) {
                Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element);
                if (children.length > 0 && element instanceof ChartCategorisation) {
                    return this.filter(viewer, element, children).length > 0;
                }
                return false;
            }
        }, true);
        GridData data = new GridData(784);
        data.heightHint = Math.max(275, this.convertHeightInCharsToPixels(20));
        data.grabExcessVerticalSpace = true;
        this.tree.setLayoutData((Object)data);
        Text filterText = this.tree.getFilterControl();
        this.tree.getViewer().setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tree.getViewer().setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                Object[] res = new Object[]{};
                if (parentElement instanceof ChartCategorisation) {
                    res = CategorisationHelper.appropriateColumnsFor((ChartCategorisation)((Object)parentElement));
                }
                return res;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof ChartCategorisation;
            }

            public Object[] getElements(Object inputElement) {
                return EnumSet.allOf(ChartCategorisation.class).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tree.getViewer().setInput((Object)EnumSet.allOf(ChartCategorisation.class).toArray());
        this.tree.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                Object element = s.getFirstElement();
                if (ChartColorPrefs.this.tree.getViewer().isExpandable(element)) {
                    ChartColorPrefs.this.tree.getViewer().setExpandedState(element, !ChartColorPrefs.this.tree.getViewer().getExpandedState(element));
                } else if (element instanceof ColumnDefinition) {
                    RGB rgb = ColumnDefinitionHelper.definitionRGB((ColumnDefinition)element);
                    ChartColorPrefs.this.openColorDialogFor((ColumnDefinition)element, rgb);
                }
            }
        });
        this.tree.getViewer().getTree().setToolTipText("");
        new DefaultToolTip(this.tree.getViewer().getControl(), 2, false){

            protected String getText(Event event) {
                Object o = this.getHoveredElement(event);
                if (o instanceof ColumnDefinition) {
                    Column column = Column.getFor((ColumnDefinition)o);
                    RGB rgb = column.getColor().getRGB();
                    return MessageFormat.format("{0}, {1}, {2}", new Integer(rgb.red), new Integer(rgb.green), new Integer(rgb.blue));
                }
                return ChartColorPrefs.this.labelProvider.getText(o);
            }

            protected boolean shouldCreateToolTip(Event event) {
                return this.getHoveredElement(event) != null && super.shouldCreateToolTip(event);
            }

            private Object getHoveredElement(Event event) {
                TreeItem item = ChartColorPrefs.this.tree.getViewer().getTree().getItem(new Point(event.x, event.y));
                if (item != null) {
                    return item.getData();
                }
                return null;
            }
        };
        TreeViewer viewer = this.tree.getViewer();
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChartColorPrefs.this.updateTreeSelection(event.getSelection());
            }
        });
        Debug.exit((Logger)logger, (String)ChartColorPrefs.class.getName(), (String)"createTree");
    }

    private void createColorControl() {
        Debug.enter((Logger)logger, (String)ChartColorPrefs.class.getName(), (String)"createColorControl");
        this.colorGroup = new Group(this.colorControls, 0);
        this.colorGroup.setText(Messages.getString("ChartColorPrefs.6"));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.colorGroup.setLayout((Layout)layout);
        this.bar = new Label((Composite)this.colorGroup, 4);
        GridData gd = new GridData(1808);
        gd.heightHint = 75;
        gd.widthHint = 150;
        this.bar.setLayoutData((Object)gd);
        Composite buttons = new Composite(this.colorControls, 0);
        layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.colorSelectorButton = new Button(buttons, 0x1000008);
        this.colorSelectorButton.setText(Messages.getString("ChartColorPrefs.4"));
        this.setButtonLayoutData(this.colorSelectorButton);
        this.colorSelectorButton.setToolTipText(Messages.getString("ChartColorPrefs.5"));
        this.colorSelectorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object element = ((IStructuredSelection)ChartColorPrefs.this.tree.getViewer().getSelection()).getFirstElement();
                if (element != null && element instanceof ColumnDefinition) {
                    RGB rgb = ColumnDefinitionHelper.definitionRGB((ColumnDefinition)element);
                    ChartColorPrefs.this.openColorDialogFor((ColumnDefinition)element, rgb);
                }
            }
        });
        this.colorResetButton = new Button(buttons, 0x1000008);
        this.colorResetButton.setText(Messages.getString("ChartColorPrefs.1"));
        this.setButtonLayoutData(this.colorResetButton);
        this.colorResetButton.setEnabled(false);
        this.colorResetButton.setToolTipText(Messages.getString("ChartColorPrefs.2"));
        this.colorResetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object element = ((IStructuredSelection)ChartColorPrefs.this.tree.getViewer().getSelection()).getFirstElement();
                if (element != null && element instanceof ColumnDefinition) {
                    RGB oldRGB = ChartColorPrefs.this.colorPreferencesToReset.get(element);
                    if (oldRGB != null) {
                        Column column = Column.getFor((ColumnDefinition)element);
                        column.setColor(oldRGB);
                        ChartColorPrefs.this.colorPreferencesToReset.remove(element);
                        ChartColorPrefs.this.updateColorControls((ColumnDefinition)element, oldRGB);
                    }
                    ChartColorPrefs.this.potentialColorPreferences.remove(element);
                    ChartColorPrefs.this.labelProvider.resetImageFor((ColumnDefinition)element);
                    ChartColorPrefs.this.tree.getViewer().refresh();
                }
            }
        });
        Debug.exit((Logger)logger, (String)ChartColorPrefs.class.getName(), (String)"createColorControl");
    }

    public void init(IWorkbench aWorkbench) {
    }

    private void createDescriptionControl(Composite parent) {
        Debug.enter((Logger)logger, (String)ChartColorPrefs.class.getName(), (String)"createDescriptionControl");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(5);
        data.verticalAlignment = 1024;
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 16384);
        label.setText(Messages.getString("ChartColorPrefs.3"));
        this.descriptionText = new Text(composite, 2888);
        TextInput.setAccessibleLabel((Text)this.descriptionText, (Label)label);
        data = new GridData(1808);
        this.descriptionText.setLayoutData((Object)data);
        Debug.exit((Logger)logger, (String)ChartColorPrefs.class.getName(), (String)"createDescriptionControl");
    }

    void updateTreeSelection(ISelection selection) {
        Debug.enter((Logger)logger, (String)ChartColorPrefs.class.getName(), (String)"updateTreeSelection", (Object)selection);
        if (selection.isEmpty()) {
            this.swapNoControls();
            this.updateColorControls(null, null);
        } else {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof ChartCategorisation) {
                this.swapNoControls();
                String description = ((ChartCategorisation)((Object)element)).getDescription();
                this.descriptionText.setText(description == null ? "" : description);
            } else if (element instanceof ColumnDefinition) {
                Column column = Column.getFor((ColumnDefinition)element);
                this.updateColorControls((ColumnDefinition)element, this.potentialColorPreferences.containsKey(element) ? this.potentialColorPreferences.get(element) : column.getColor().getRGB());
                String description = ((ColumnDefinition)element).getLabel(null);
                this.descriptionText.setText(description == null ? "" : description);
                this.swapColorControls();
            }
        }
        Debug.exit((Logger)logger, (String)ChartColorPrefs.class.getName(), (String)"updateTreeSelection");
    }

    protected void updateColorControls(ColumnDefinition definition, RGB colour) {
        Debug.enter((Logger)logger, (String)ChartColorPrefs.class.getName(), (String)"updateColorControls");
        if (definition == null) {
            this.colorResetButton.setEnabled(false);
            this.colorGroup.setEnabled(false);
            this.descriptionText.setText("");
            return;
        }
        this.colorResetButton.setEnabled(this.colorPreferencesToReset.containsKey(definition));
        this.colorGroup.setEnabled(true);
        this.bar.setImage(this.mergedChartImageFor(colour));
        this.colorGroup.pack();
        this.colorControls.pack();
        this.controlArea.pack();
        String description = definition.getLabel(null);
        this.descriptionText.setText(description == null ? "" : description);
        if (colour != null) {
            this.tree.getViewer().refresh((Object)definition);
        }
        Debug.exit((Logger)logger, (String)ChartColorPrefs.class.getName(), (String)"updateColorControls");
    }

    private void swapNoControls() {
        this.controlAreaLayout.topControl = null;
        this.controlArea.layout();
    }

    private void swapColorControls() {
        this.controlAreaLayout.topControl = this.colorControls;
        this.controlArea.layout();
    }

    private void setColorPreferenceValue(ColumnDefinition definition, RGB newRGB, RGB oldRGB) {
        Debug.enter((Logger)logger, (String)ChartColorPrefs.class.getName(), (String)"setColorPreferenceValue", (Object)oldRGB);
        this.potentialColorPreferences.put(definition, newRGB);
        this.labelProvider.resetImageFor(definition);
        if (!this.colorPreferencesToReset.containsKey(definition)) {
            this.colorPreferencesToReset.put(definition, oldRGB);
        }
        this.labelProvider.potentialImageFor(definition, newRGB);
        Debug.exit((Logger)logger, (String)ChartColorPrefs.class.getName(), (String)"setColorPreferenceValue", (Object)newRGB);
    }

    protected void performDefaults() {
        Debug.enter((Logger)logger, (String)ChartColorPrefs.class.getName(), (String)"performDefaults");
        super.performDefaults();
        for (ChartCategorisation cat : EnumSet.allOf(ChartCategorisation.class)) {
            ColumnDefinition[] columnDefinitionArray = CategorisationHelper.appropriateColumnsFor(cat);
            int n = columnDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnDefinition defn = columnDefinitionArray[n2];
                if (defn != null) {
                    Column.getFor(defn).resetColorToDefault();
                }
                ++n2;
            }
        }
        this.potentialColorPreferences.clear();
        this.colorPreferencesToReset.clear();
        this.colorResetButton.setEnabled(false);
        this.labelProvider.resetAllImages();
        this.tree.getViewer().refresh();
        this.updateTreeSelection(this.tree.getViewer().getSelection());
        Debug.exit((Logger)logger, (String)ChartColorPrefs.class.getName(), (String)"performDefaults");
    }

    public boolean performOk() {
        Debug.enter((Logger)logger, (String)ChartColorPrefs.class.getName(), (String)"performOk");
        for (ColumnDefinition definition : this.potentialColorPreferences.keySet()) {
            Column column = Column.getFor(definition);
            column.setColor(this.potentialColorPreferences.get(definition));
        }
        this.potentialColorPreferences.clear();
        this.colorPreferencesToReset.clear();
        this.colorResetButton.setEnabled(false);
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IViewReference[] iViewReferenceArray = page.getViewReferences();
                int n5 = iViewReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IViewReference ref = iViewReferenceArray[n6];
                    IWorkbenchPart part = ref.getPart(false);
                    if (part != null && part instanceof IChartColorPreferenceDependent) {
                        ((IChartColorPreferenceDependent)part).forceRepaint();
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        Debug.exit((Logger)logger, (String)ChartColorPrefs.class.getName(), (String)"performOk");
        return super.performOk();
    }

    public boolean performCancel() {
        for (ColumnDefinition defn : this.colorPreferencesToReset.keySet()) {
            RGB oldRGB = this.colorPreferencesToReset.get(defn);
            if (oldRGB == null) continue;
            Column column = Column.getFor(defn);
            column.setColor(oldRGB);
        }
        this.colorPreferencesToReset.clear();
        this.potentialColorPreferences.clear();
        return super.performCancel();
    }

    public void openColorDialogFor(ColumnDefinition definition, RGB rgbColor) {
        this.colorDialog = new ColorDialog(this.getShell());
        this.colorDialog.setRGB(rgbColor);
        RGB newColor = this.colorDialog.open();
        if (newColor != null) {
            this.setColorPreferenceValue(definition, newColor, rgbColor);
            this.updateColorControls(definition, newColor);
            this.labelProvider.resetImageFor(definition);
            this.tree.getViewer().refresh();
        }
    }

    private Image mergedChartImageFor(RGB colour) {
        if (this.swatchImagePie != null && !this.swatchImagePie.isDisposed()) {
            this.swatchImagePie.dispose();
        }
        Color c = new Color((Device)this.tree.getDisplay(), colour);
        this.swatchImagePie = new Image((Device)this.colorGroup.getDisplay(), 150, 75);
        GC gc = new GC((Drawable)this.swatchImagePie);
        gc.setAlpha(150);
        gc.setBackground(ColorConstants.white);
        gc.setForeground(ColorConstants.gray);
        gc.drawRectangle(5, 5, 30, 70);
        gc.drawRectangle(5, 6, 29, 69);
        gc.drawLine(112, 36, 112, 69);
        gc.drawLine(112, 36, 145, 36);
        int dimn = 75;
        gc.setLineWidth(2);
        gc.drawArc(80, 5, dimn - 10, dimn - 10, 0, 270);
        gc.setBackground(c);
        gc.fillRectangle(6, 7, 28, 68);
        gc.fillArc(80, 5, dimn - 10, dimn - 10, 0, 270);
        gc.dispose();
        c.dispose();
        return this.swatchImagePie;
    }

    private class CategorizationLabelProvider
    extends LabelProvider {
        private Map<ColumnDefinition, Image> images = new HashMap<ColumnDefinition, Image>();
        private Image categoryImage = Activator.getDefault().getImage("histogram");
        private Image categoryImageInterval = Activator.getDefault().getImage("interval");

        void potentialImageFor(ColumnDefinition definition, RGB colour) {
            ChartColorPrefs.this.potentialColorPreferences.put(definition, colour);
            this.images.remove(definition);
        }

        void resetImageFor(ColumnDefinition definition) {
            Image image = this.images.get(definition);
            if (image != null) {
                this.images.remove(definition);
                image.dispose();
            }
        }

        void resetAllImages() {
            ColumnDefinition[] columnDefinitionArray = this.images.keySet().toArray(new ColumnDefinition[this.images.size()]);
            int n = columnDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnDefinition definition = columnDefinitionArray[n2];
                this.resetImageFor(definition);
                ++n2;
            }
        }

        public void dispose() {
            super.dispose();
            this.resetAllImages();
            if (ChartColorPrefs.this.swatchImagePie != null && !ChartColorPrefs.this.swatchImagePie.isDisposed()) {
                ChartColorPrefs.this.swatchImagePie.dispose();
            }
        }

        public Image getImage(Object definition) {
            if (definition instanceof ColumnDefinition) {
                Image image = null;
                if (ChartColorPrefs.this.potentialColorPreferences.containsKey(definition)) {
                    if (this.images.containsKey(definition)) {
                        image = this.images.get(definition);
                    } else {
                        Color c = new Color((Device)ChartColorPrefs.this.tree.getDisplay(), ChartColorPrefs.this.potentialColorPreferences.get(definition));
                        image = Column.createImage(ChartColorPrefs.this.tree.getDisplay(), c);
                        c.dispose();
                        this.images.put((ColumnDefinition)definition, image);
                    }
                } else {
                    image = Column.getFor((ColumnDefinition)definition).getImage();
                }
                return image;
            }
            if (definition instanceof ChartCategorisation && (ChartCategorisation)((Object)definition) == ChartCategorisation.INTERVAL) {
                return this.categoryImageInterval;
            }
            return this.categoryImage;
        }

        public String getText(Object element) {
            String res = "";
            if (element instanceof ColumnDefinition) {
                res = ((ColumnDefinition)element).getLabel(null);
            } else if (element instanceof ChartCategorisation) {
                res = ((ChartCategorisation)((Object)element)).getLabel();
            }
            return res;
        }
    }
}

