/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.eclipse.common.historical.IHistoricalApplication;
import com.ibm.cics.eclipse.common.historical.IHistoricalApplid;
import com.ibm.cics.eclipse.common.historical.IHistoricalOperation;
import com.ibm.cics.eclipse.common.historical.IHistoricalTransaction;
import com.ibm.cics.pa.comm.PASelectionContext;
import com.ibm.cics.pa.model.AlertElement;
import com.ibm.cics.pa.model.CSVDataExtract;
import com.ibm.cics.pa.model.ChartType;
import com.ibm.cics.pa.model.DateCaveat;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.SpecificRowsFilter;
import com.ibm.cics.pa.model.definitions.AppliedLayouts;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.SheetViewDefinition;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.PAContextTracker;
import com.ibm.cics.pa.ui.dialogs.TimelineAssistDialog;
import com.ibm.cics.pa.ui.figures.ChartSelectable;
import com.ibm.cics.pa.ui.handlers.CommonHandler;
import com.ibm.cics.pa.ui.handlers.DetailBreakdownHandler;
import com.ibm.cics.pa.ui.handlers.VisualizationHandler;
import com.ibm.cics.pa.ui.remote.RemoteEditorInput;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.utilities.PredefinedTemplate;
import com.ibm.cics.pa.ui.views.Alerts;
import com.ibm.cics.pa.ui.views.ChartView;
import com.ibm.cics.pa.ui.views.Overview;
import com.ibm.cics.pa.ui.views.PerformanceAlerts;
import com.ibm.cics.pa.ui.views.PieView;
import com.ibm.cics.pa.ui.views.PlotView;
import com.ibm.cics.pa.ui.views.SheetView;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class SpreadSheetHandler
extends CommonHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2022 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    ManifestRecord record = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Debug.enter((Logger)logger, (String)SpreadSheetHandler.class.getName(), (String)"execute");
        String resId = null;
        boolean selectAll = new Boolean(event.getParameter("com.ibm.cics.pa.ui.commandSelectAll"));
        StructuredSelection selected = (StructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part instanceof SheetView) {
            Debug.event((Logger)logger, (String)VisualizationHandler.class.getName(), (String)"execute", (Object)"instanceof SheetView");
            GenericDataProvider provider1 = ((SheetView)part).getDataProvider();
            ArrayList records1 = new ArrayList(selected.toList());
            resId = this.extractRecords(part, records1.toArray(new IUniqueRecord[records1.size()]), provider1, selectAll);
            this.record = ((SheetView)part).getManifestRecord();
        } else if (part instanceof ChartView || part instanceof PieView) {
            String table;
            Debug.event((Logger)logger, (String)VisualizationHandler.class.getName(), (String)"execute", (Object)"instanceof ChartView");
            GenericDataProvider provider1 = part instanceof PieView ? ((PieView)part).getModel().getDataProvider() : ((ChartView)part).getDataProvider();
            if (provider1 instanceof RemoteEditorInput && (table = ((RemoteEditorInput)provider1).getTable()) != null) {
                this.record = ManifestRecord.getAlias(table);
            }
            ArrayList<IUniqueRecord> records1 = new ArrayList<IUniqueRecord>();
            for (Object chartElement : selected.toList()) {
                if (chartElement instanceof IUniqueRecord) {
                    records1.add((IUniqueRecord)chartElement);
                    continue;
                }
                if (!(chartElement instanceof ChartSelectable)) continue;
                records1.add(((ChartSelectable)((Object)chartElement)).getUniqueRecord());
            }
            resId = this.extractRecords(part, records1.toArray(new IUniqueRecord[records1.size()]), provider1, selectAll);
        } else if (part instanceof Overview) {
            Debug.event((Logger)logger, (String)VisualizationHandler.class.getName(), (String)"execute", (Object)"instanceof Overview");
            PASelectionContext context = (PASelectionContext)((Overview)part).getCurrentContext();
            this.dbQuery(part, context.getSummarySelection(PAContextTracker.getInstance().getShortTableReference()), context.getContentDescriptionLabel(), new HashMap<String, Object>(), SheetViewDefinition.createForType(ChartType.SHEET, null), PAContextTracker.getInstance().getCurrentManifest().getDescription(), PAContextTracker.getInstance().getCurrentManifest());
        } else if (part instanceof Alerts && selected.getFirstElement() instanceof AlertElement) {
            Debug.event((Logger)logger, (String)VisualizationHandler.class.getName(), (String)"execute", (Object)"instanceof Alerts");
            AlertElement element = (AlertElement)selected.getFirstElement();
            Selection sel = element.getSelection();
            String tabLabel = "";
            Map<ColumnDefinition, Object> parameterMap = element.getDefinitionMapping();
            ManifestRecord rec = ManifestRecord.getAlias(element.getTableAlias());
            if (rec != null) {
                tabLabel = rec.getDescription();
            }
            if (sel != null) {
                sel.applyTableMapping(ManifestRecord.getAliasMapping());
                Map<String, Object> mapping = element.getRunableMapping();
                String contentDescription = element.getLabel(ColumnDefinition.ALERT);
                DateCaveat dateCaveat = null;
                if (parameterMap.get(ColumnDefinition.START_DATE) != null && parameterMap.get(ColumnDefinition.START_TIME) != null) {
                    dateCaveat = DateCaveat.createSpecificDateCaveat(DataTypeUtilities.combineDateTime((Date)parameterMap.get(ColumnDefinition.START_DATE), (Time)parameterMap.get(ColumnDefinition.START_TIME)));
                }
                contentDescription = String.valueOf(contentDescription) + DataTypeUtilities.interpretStatsElement(mapping, dateCaveat, Collections.<String>emptyList());
                this.dbQuery(part, sel, contentDescription, element.getRunableMapping(), SheetViewDefinition.createForType(ChartType.SHEET, null), tabLabel, rec);
            }
        } else if (part instanceof PerformanceAlerts && selected.getFirstElement() instanceof AlertElement) {
            Debug.event((Logger)logger, (String)VisualizationHandler.class.getName(), (String)"execute", (Object)"instanceof Alerts");
            AlertElement element = (AlertElement)selected.getFirstElement();
            Selection sel = element.getSelection();
            String tabLabel = "";
            ManifestRecord rec = ManifestRecord.getAlias(element.getTableAlias());
            if (rec != null) {
                tabLabel = rec.getDescription();
            }
            if (sel != null) {
                sel.applyTableMapping(ManifestRecord.getAliasMapping());
                Map<String, Object> mapping = element.getRunableMapping();
                DateCaveat dateCaveat = null;
                String contentDescription = DataTypeUtilities.interpretStatsElement(mapping, dateCaveat, Arrays.asList(String.valueOf(':') + ColumnDefinition.TASKNO.getDBColumnRef()));
                String layout = element.getLabel(ColumnDefinition.ALT_FIELD_NAME);
                PredefinedTemplate template = AppliedLayouts.identifyLayout(layout);
                this.dbQuery(part, sel, contentDescription, mapping, SheetViewDefinition.createForType(ChartType.SHEET, template), tabLabel, rec);
            }
        } else if (part instanceof PlotView && selected.getFirstElement() instanceof AlertElement) {
            Debug.event((Logger)logger, (String)VisualizationHandler.class.getName(), (String)"execute", (Object)"instanceof Alerts plotview transaction performance");
            AlertElement element = (AlertElement)selected.getFirstElement();
            Selection selection = PresentationFactory.getInstance().createSelectAllForTable(PAContextTracker.getInstance().getPerformanceTableReference(), ":schema");
            selection.applyTableMapping(ManifestRecord.getAliasMapping());
            ((AlertElement)selected.getFirstElement()).applyConstraint(selection, Direction.DESC);
            String tabLabel = "";
            ManifestRecord rec = ManifestRecord.getAlias(element.getTableAlias());
            if (rec != null) {
                tabLabel = rec.getDescription();
            }
            selection.applyTableMapping(ManifestRecord.getAliasMapping());
            String contentDescription = element.getLabel(ColumnDefinition.ALERT);
            this.dbQuery(part, selection, contentDescription, element.getRunableMapping(), SheetViewDefinition.createForType(ChartType.SHEET, null), tabLabel, rec);
        } else if (this.isApplicationSelection(selected) && ManifestRecord.getAlias("CMFACSUM") != null) {
            ArrayList<String> platforms = new ArrayList<String>();
            ArrayList<String> applications = new ArrayList<String>();
            ArrayList<String> versions = new ArrayList<String>();
            ArrayList<String> operations = new ArrayList<String>();
            for (Object element1 : selected.toList()) {
                IHistoricalApplication adapter1 = (IHistoricalApplication)Platform.getAdapterManager().getAdapter(element1, IHistoricalApplication.class);
                IHistoricalOperation adapter2 = (IHistoricalOperation)Platform.getAdapterManager().getAdapter(element1, IHistoricalOperation.class);
                if (adapter1 != null) {
                    platforms.add(adapter1.getPlatformName());
                    applications.add(adapter1.getApplication());
                    versions.add(adapter1.getApplicationVersion());
                    continue;
                }
                if (adapter2 == null) continue;
                platforms.add(adapter2.getPlatformName());
                applications.add(adapter2.getApplication());
                versions.add(adapter2.getApplicationVersion());
                operations.add(adapter2.getOperation());
            }
            DateCaveat dateToken = TimelineAssistDialog.getInstance().getDateCaveat();
            PASelectionContext ctx = new PASelectionContext(dateToken, platforms, applications, versions, operations);
            this.dbQuery(part, ctx.getSummarySelection(ManifestRecord.getAlias("CMFACSUM").getName()), ctx.getContentDescriptionLabel(), new HashMap<String, Object>(), SheetViewDefinition.createForType(ChartType.SHEET, null), ManifestRecord.getAlias("CMFACSUM").getDescription(), ManifestRecord.getAlias("CMFACSUM"));
        } else if (this.isPerformanceSelection(selected) && ManifestRecord.getAlias("CMFPSUM") != null) {
            ArrayList<String> transactions = new ArrayList<String>();
            ArrayList<String> applids = new ArrayList<String>();
            for (Object element1 : selected.toList()) {
                IHistoricalApplid adapter1 = (IHistoricalApplid)Platform.getAdapterManager().getAdapter(element1, IHistoricalApplid.class);
                IHistoricalTransaction adapter2 = (IHistoricalTransaction)Platform.getAdapterManager().getAdapter(element1, IHistoricalTransaction.class);
                if (adapter1 != null) {
                    applids.add(adapter1.getApplid());
                    continue;
                }
                if (adapter2 == null) continue;
                applids.add(adapter2.getApplid());
                transactions.add(adapter2.getTransactionName());
            }
            if (!applids.isEmpty() || !transactions.isEmpty()) {
                DateCaveat dateToken = TimelineAssistDialog.getInstance().getDateCaveat();
                PASelectionContext ctx = new PASelectionContext(dateToken, applids, transactions, ColumnDefinition.TRAN);
                this.dbQuery(part, ctx.getSummarySelection(ManifestRecord.getAlias("CMFPSUM").getName()), ctx.getContentDescriptionLabel(), new HashMap<String, Object>(), SheetViewDefinition.createForType(ChartType.SHEET, null), ManifestRecord.getAlias("CMFPSUM").getDescription(), ManifestRecord.getAlias("CMFPSUM"));
            }
        }
        Debug.exit((Logger)logger, (String)DetailBreakdownHandler.class.getName(), (String)"execute", (Object)resId);
        return resId;
    }

    public String extractRecords(final IWorkbenchPart part, final IUniqueRecord[] records, final GenericDataProvider dataMinor, final boolean selectAll) {
        Job job = new Job(Messages.getString("Locating.records")){

            protected IStatus run(IProgressMonitor monitor) {
                GenericDataProvider dataStore = null;
                if (selectAll) {
                    dataStore = dataMinor;
                } else if (dataMinor.isRemote()) {
                    dataStore = RemoteEditorInput.createAlreadyPopulated(dataMinor, new StructuredSelection((Object[])records), null);
                } else {
                    SpecificRowsFilter filter = SpecificRowsFilter.specificFilterFor(dataMinor, records);
                    dataStore = CSVDataExtract.getFor(dataMinor.getRootSource(), filter);
                }
                if (monitor != null && monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                dataStore.getData();
                final GenericDataProvider finalDataStore = dataStore;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String id = finalDataStore.getFileReference();
                            IViewPart view = part.getSite().getPage().showView("com.ibm.cics.pa.ui.sheeteditor_multi", id, 1);
                            if ((this).SpreadSheetHandler.this.record != null) {
                                ((SheetView)view).setManifest((this).SpreadSheetHandler.this.record);
                            }
                        }
                        catch (PartInitException e) {
                            logger.logp(Level.SEVERE, SpreadSheetHandler.class.getName(), "specificRowsJob", "Part initialization", e);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)part.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(job, 0L, true);
        return "";
    }

    private boolean isPerformanceSelection(StructuredSelection selection) {
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object sel = objectArray[n2];
            if (Platform.getAdapterManager().hasAdapter(sel, IHistoricalApplid.class.getName()) || Platform.getAdapterManager().hasAdapter(sel, IHistoricalTransaction.class.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isApplicationSelection(StructuredSelection selection) {
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object sel = objectArray[n2];
            if (Platform.getAdapterManager().hasAdapter(sel, IHistoricalApplication.class.getName()) || Platform.getAdapterManager().hasAdapter(sel, IHistoricalOperation.class.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

