/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.pa.model.AlertElement;
import com.ibm.cics.pa.model.ChartType;
import com.ibm.cics.pa.model.DateCaveat;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.PlotModel;
import com.ibm.cics.pa.model.SpecificDateCaveat;
import com.ibm.cics.pa.model.definitions.AbstractChartDefinition;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.PieChartSpecificDefinitions;
import com.ibm.cics.pa.model.definitions.ReportStyle;
import com.ibm.cics.pa.model.definitions.SheetViewDefinition;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.dialogs.ParameterSolicitingDialog;
import com.ibm.cics.pa.ui.handlers.CommonHandler;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.views.Alerts;
import com.ibm.cics.pa.ui.views.ReportList;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ReportRunner
extends CommonHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean isEnabled = true;
    private String tabLabel = "";
    private String contentDescription = "";

    @Override
    public boolean isEnabled() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"isEnabled");
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"isEnabled", (Object)this.isEnabled);
        return this.isEnabled;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"execute");
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        StructuredSelection selected = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        String response = this.runReport(part, event.getCommand().getId(), selected);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"execute", null);
        return response;
    }

    protected String runReport(IWorkbenchPart part, String commandId, StructuredSelection selected) {
        StructuredSelection sSelection = selected;
        String response = "";
        if (part instanceof ReportList && ((ReportList)part).getPresentation() != null) {
            Presentation presentation = ((ReportList)part).getPresentation();
            Collection tables = presentation.getTargetTables();
            AbstractChartDefinition chartReference = AbstractChartDefinition.getChartDefinition(presentation);
            IUniqueRecord record = ((ReportList)part).getRecord();
            ManifestRecord table1 = ManifestRecord.getAlias((String)presentation.getSelection().getSelect().getTable().getLabels().keySet().toArray()[0]);
            if (record != null && table1 != null) {
                HashMap<ColumnDefinition, Object> parameterMap = new HashMap<ColumnDefinition, Object>();
                Map requiredDefinitions = presentation.getInputColumns();
                Map<ColumnDefinition, Object> maps1 = record.getCompleteMapping(true);
                for (ColumnReference column : requiredDefinitions.keySet()) {
                    ColumnDefinition defn = ColumnDefinition.getByDBColumnRef(column.getColumnName());
                    parameterMap.put(defn, maps1.get(defn));
                }
                boolean complete = ChartType.deriveFrom(presentation.getImplType()) != ChartType.COMPACT_HISTOGRAM;
                for (Object value : parameterMap.values()) {
                    boolean bl;
                    if (complete) {
                        if (value != null) {
                            bl = true;
                            continue;
                        }
                        bl = false;
                        continue;
                    }
                    bl = complete = false;
                }
                if (chartReference.getType() == ChartType.PIE) {
                    ((PieChartSpecificDefinitions)chartReference.getSpecificType()).setHeader(false);
                }
                if (complete && commandId.equals("com.ibm.cics.pa.ui.commands.run_report1")) {
                    ManifestRecord rec;
                    HashMap<String, Object> parameterMap1 = new HashMap<String, Object>();
                    sSelection = (StructuredSelection)((ReportList)part).getExternalSelection();
                    if (sSelection != null && !sSelection.isEmpty() && sSelection.getFirstElement() instanceof IUniqueRecord) {
                        Object[] input = sSelection.toArray();
                        int j = 0;
                        while (j < input.length) {
                            ColumnDefinition[] definitions = ((IUniqueRecord)input[j]).getSourceProvider().getColumnDefinitions();
                            Object[] row = ((IUniqueRecord)input[j]).getRow();
                            for (ColumnReference column : requiredDefinitions.keySet()) {
                                int i = 0;
                                while (i < definitions.length) {
                                    if (column.getColumnName().equals(definitions[i].getDBColumnRef()) || definitions[i].canMutateTo(column.getColumnName())) {
                                        String parmKey = (String)requiredDefinitions.get(column);
                                        if (sSelection.size() > 1) {
                                            if (j == 0) {
                                                parameterMap1.put(parmKey, row[i]);
                                            }
                                            parmKey = String.valueOf(parmKey) + j;
                                        }
                                        parameterMap1.put(parmKey, row[i]);
                                    }
                                    ++i;
                                }
                            }
                            ++j;
                        }
                    }
                    if (!tables.isEmpty() && (rec = ManifestRecord.getAlias(tables.toArray(new String[tables.size()])[0])) != null && sSelection != null) {
                        this.tabLabel = rec.getDescription();
                        this.contentDescription = sSelection.size() > 1 ? MessageFormat.format(Messages.getString("ParameterDialog.table"), sSelection.size()) : (rec.isPerformanceSummaryRecord() ? DataTypeUtilities.interpretSummaryDetails(parameterMap1, null) : DataTypeUtilities.interpretStatsElement(parameterMap1, null, Collections.<String>emptyList()));
                        presentation.getSelection().applyTableMapping(ManifestRecord.getAliasMapping());
                        response = this.dbQuery(part, presentation.getSelection(), this.contentDescription, parameterMap1, chartReference, this.tabLabel, rec);
                    }
                } else {
                    DateCaveat[] date = new DateCaveat[1];
                    ParameterSolicitingDialog dialog = new ParameterSolicitingDialog(part.getSite().getShell(), presentation.getSelection(), ReportStyle.deriveFromImplType(presentation.getImplType()), parameterMap, date);
                    if (dialog.open() == 0) {
                        ManifestRecord rec;
                        HashMap<String, Object> parameterMap1 = new HashMap<String, Object>();
                        for (ColumnDefinition key : parameterMap.keySet()) {
                            if (key == ColumnDefinition.START_DATE || key == ColumnDefinition.START_TIME) {
                                if (date[0] != null) {
                                    parameterMap1.put(":" + key.getDBColumnRef(), "*");
                                    continue;
                                }
                                parameterMap1.put(":" + key.getDBColumnRef(), parameterMap.get(key));
                                continue;
                            }
                            parameterMap1.put(":" + key.getDBColumnRef(), parameterMap.get(key));
                        }
                        if (date[0] != null) {
                            parameterMap1.put("TemporaryConstraintAnd", date[0].getConstraint(tables.toArray(new String[tables.size()])[0], false));
                        }
                        if (!tables.isEmpty() && (rec = ManifestRecord.getAlias(tables.toArray(new String[tables.size()])[0])) != null) {
                            this.tabLabel = rec.getDescription();
                            this.contentDescription = rec.isPerformanceSummaryRecord() ? DataTypeUtilities.interpretSummaryDetails(parameterMap1, date[0]) : (rec.isApplicationSummaryRecord() ? DataTypeUtilities.interpretAppSummaryDetails(parameterMap1, date[0]) : DataTypeUtilities.interpretStatsElement(parameterMap1, date[0], Collections.<String>emptyList()));
                            presentation.getSelection().applyTableMapping(ManifestRecord.getAliasMapping());
                            response = this.dbQuery(part, presentation.getSelection(), this.contentDescription, parameterMap1, chartReference, this.tabLabel, rec);
                        }
                    }
                }
            }
        } else if (part instanceof Alerts) {
            DateCaveat[] date = new DateCaveat[1];
            Object element = sSelection.getFirstElement();
            Selection sel = ((AlertElement)element).getSelection();
            String tabLabel = "";
            ManifestRecord rec = ManifestRecord.getAlias(((AlertElement)element).getTableAlias());
            if (rec != null) {
                tabLabel = rec.getDescription();
            }
            if (sel != null) {
                Map<ColumnDefinition, Object> parameterMap = ((AlertElement)element).getDefinitionMapping();
                ParameterSolicitingDialog dialog = new ParameterSolicitingDialog(part.getSite().getShell(), sel, ReportStyle.StatsLink, parameterMap, date);
                if (dialog.open() == 0) {
                    HashMap<String, Object> parameterMap1 = new HashMap<String, Object>();
                    for (ColumnDefinition key : parameterMap.keySet()) {
                        if (key == ColumnDefinition.START_DATE || key == ColumnDefinition.START_TIME) {
                            if (date[0] != null && !(date[0] instanceof SpecificDateCaveat)) {
                                parameterMap1.put(":" + key.getDBColumnRef(), "*");
                                continue;
                            }
                            parameterMap1.put(":" + key.getDBColumnRef(), parameterMap.get(key));
                            continue;
                        }
                        parameterMap1.put(":" + key.getDBColumnRef(), parameterMap.get(key));
                    }
                    if (date[0] != null && !(date[0] instanceof SpecificDateCaveat)) {
                        parameterMap1.put("TemporaryConstraintAnd", date[0].getConstraint(((AlertElement)element).getTableAlias(), false));
                    }
                    sel.applyTableMapping(ManifestRecord.getAliasMapping());
                    Map<String, Object> mapping = ((AlertElement)element).getRunableMapping();
                    String contentDescription = ((AlertElement)element).getLabel(ColumnDefinition.ALERT);
                    contentDescription = String.valueOf(contentDescription) + DataTypeUtilities.interpretStatsElement(mapping, null, Collections.<String>emptyList());
                    response = this.dbQuery(part, sel, contentDescription, parameterMap1, SheetViewDefinition.createForType(ChartType.SHEET, null), tabLabel, rec);
                }
            }
        } else if (sSelection.getFirstElement() instanceof AlertElement || sSelection.getFirstElement() instanceof PlotModel.PlotModelElement) {
            AlertElement element = (AlertElement)(sSelection.getFirstElement() instanceof AlertElement ? sSelection.getFirstElement() : ((PlotModel.PlotModelElement)sSelection.getFirstElement()).getNextAlert());
            Selection sel = element.getSelection();
            String tabLabel = "";
            ManifestRecord rec = ManifestRecord.getAlias(element.getTableAlias());
            if (rec != null) {
                tabLabel = rec.getDescription();
            }
            if (sel != null) {
                Map<ColumnDefinition, Object> parameterMap = element.getDefinitionMapping();
                HashMap<String, Object> parameterMap1 = new HashMap<String, Object>();
                for (ColumnDefinition key : parameterMap.keySet()) {
                    parameterMap1.put(":" + key.getDBColumnRef(), parameterMap.get(key));
                }
                sel.applyTableMapping(ManifestRecord.getAliasMapping());
                Map<String, Object> mapping = element.getRunableMapping();
                String contentDescription = element.getLabel(ColumnDefinition.ALERT);
                contentDescription = String.valueOf(contentDescription) + DataTypeUtilities.interpretStatsElement(mapping, null, Collections.<String>emptyList());
                response = this.dbQuery(part, sel, contentDescription, parameterMap1, SheetViewDefinition.createForType(ChartType.SHEET, null), tabLabel, rec);
            }
        }
        return response;
    }

    @Override
    public void setEnabled(Object evaluationContext) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"setEnabled");
        this.isEnabled = false;
        if (evaluationContext != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
            String id = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getId();
            if (id.equals("com.ibm.cics.pa.ui.reportview")) {
                this.isEnabled = !((ReportList)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart()).getExternalSelection().isEmpty();
            } else if (id.equals("com.ibm.cics.pa.ui.alertsview")) {
                this.isEnabled = true;
            } else if (id.equals("com.ibm.cics.pa.ui.plotview")) {
                this.isEnabled = true;
            }
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"setEnabled", (Object)this.isEnabled);
    }
}

