/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.ProfilerPairing;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.handlers.CommonHandler;
import com.ibm.cics.pa.ui.model.controller.ProfileBucketController;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.cics.pa.ui.views.profiler.ProfileView;
import com.ibm.cics.pa.ui.wizards.ProfilerWizard;
import java.sql.Time;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class ProfilerHandler
extends CommonHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ProfilerHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"execute");
        String response = Messages.getString("Resource.status.disconnected");
        if (PAConnectionTracker.getInstance().isConnected()) {
            if (event.getParameter("com.ibm.cics.pa.ui.profiler.starter").equals("toolbar")) {
                ProfilerWizard wizard = new ProfilerWizard(null);
                new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard).open();
                response = "Profile Wizard";
            } else if (event.getParameter("com.ibm.cics.pa.ui.profiler.starter").equals("single")) {
                ProfilerWizard wizard = new ProfilerWizard(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
                new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard).open();
                response = "Profile Wizard-single item";
            } else {
                Object[] elements;
                ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                if (((StructuredSelection)selection).size() == 2 && ((StructuredSelection)selection).toArray()[0] instanceof IUniqueRecord && (elements = ((StructuredSelection)selection).toArray())[0] instanceof IUniqueRecord && elements[1] instanceof IUniqueRecord) {
                    Map<ColumnDefinition, Object> e0 = ((IUniqueRecord)elements[0]).getCompleteMapping(false);
                    String baseApplid = (String)e0.get(ColumnDefinition.APPLID);
                    String baseTransaction = (String)e0.get(ColumnDefinition.TRAN);
                    Date baseDate = (Date)e0.get(ColumnDefinition.START_DATE);
                    Time baseTime = (Time)e0.get(ColumnDefinition.START_TIME);
                    Map<ColumnDefinition, Object> e1 = ((IUniqueRecord)elements[1]).getCompleteMapping(false);
                    String variantApplid = (String)e1.get(ColumnDefinition.APPLID);
                    String variantTransaction = (String)e1.get(ColumnDefinition.TRAN);
                    Date variantDate = (Date)e1.get(ColumnDefinition.START_DATE);
                    Time variantTime = (Time)e1.get(ColumnDefinition.START_TIME);
                    ProfilerPairing pairing = ProfileBucketController.getInstance().createPairing(baseApplid, baseTransaction, baseDate, baseTime, variantApplid, variantTransaction, variantDate, variantTime);
                    this.part = (IViewPart)HandlerUtil.getActivePart((ExecutionEvent)event);
                    try {
                        ProfileView view = (ProfileView)this.part.getSite().getPage().showView("com.ibm.cics.pa.profiler.view");
                        if (view != null) {
                            view.setContent(pairing);
                        }
                        response = "Profile View";
                    }
                    catch (PartInitException e) {
                        debug.error("execute", (Throwable)e);
                    }
                }
            }
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"execute", (Object)response);
        return response;
    }
}

