/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.handlers;

import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.eclipse.common.historical.IHistoricalTransaction;
import com.ibm.cics.pa.model.CSVDataExtract;
import com.ibm.cics.pa.model.CSVDataRestrictionFilter;
import com.ibm.cics.pa.model.DataKeyElement;
import com.ibm.cics.pa.model.DateCaveat;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.IPerfSummUniqueRecord;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.NullRangeDateCaveat;
import com.ibm.cics.pa.model.definitions.AbstractChartDefinition;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.ui.ChartManager;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.PAContextTracker;
import com.ibm.cics.pa.ui.dialogs.TimelineAssistDialog;
import com.ibm.cics.pa.ui.figures.ChartSelectable;
import com.ibm.cics.pa.ui.handlers.CommonHandler;
import com.ibm.cics.pa.ui.remote.RemotePerfSummUniqueRecord;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class HistoricTimelineHandler
extends CommonHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Logger logger = Logger.getLogger(HistoricTimelineHandler.class.getPackage().getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String chart = event.getParameter("com.ibm.cics.pa.ui.commandMenu");
        ChartSpecification chartReference = AbstractChartDefinition.getByName(chart);
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        StructuredSelection selection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Object selected = selection.getFirstElement();
        if (selected instanceof IPerfSummUniqueRecord && !((IPerfSummUniqueRecord)selected).getSourceProvider().isRemote()) {
            this.specificTranJob(part, (IUniqueRecord)selected, chartReference);
        } else if (selected instanceof ChartSelectable && !((ChartSelectable)((Object)selected)).getUniqueRecord().getSourceProvider().isRemote()) {
            if (selected instanceof RemotePerfSummUniqueRecord) {
                this.execute(part, chartReference, ((IPerfSummUniqueRecord)selected).getApplid(), ((IPerfSummUniqueRecord)selected).getTransactionName());
            }
            this.specificTranJob(part, ((ChartSelectable)((Object)selected)).getUniqueRecord(), chartReference);
        } else if (Platform.getAdapterManager().hasAdapter(selected, IHistoricalTransaction.class.getName())) {
            IHistoricalTransaction record = (IHistoricalTransaction)Platform.getAdapterManager().getAdapter(selected, IHistoricalTransaction.class);
            this.execute(part, chartReference, record.getApplid(), record.getTransactionName());
        }
        return null;
    }

    public String specificTranJob(final IWorkbenchPart part, final IUniqueRecord record, final ChartSpecification chartReference) {
        TimelineAssistDialog dialog = TimelineAssistDialog.getInstance();
        DateCaveat date = dialog.getDateCaveat();
        if (date == null) {
            date = dialog.checkTransientDateDialog();
        }
        Job job = new Job(Messages.getString("Locating.records")){

            protected IStatus run(IProgressMonitor monitor) {
                DataKeyElement dataKey = record.getDataKey().cloneOnColumns(DataProviderKey.APPLID_TRAN);
                if (record.getSourceProvider() != null) {
                    GenericDataProvider dataProvider = record.getSourceProvider().getRootSource();
                    CSVDataRestrictionFilter filter = CSVDataRestrictionFilter.getFilterFor(record.getSourceProvider(), new DataKeyElement[]{dataKey});
                    GenericDataProvider provider2 = CSVDataExtract.getFor(dataProvider, filter);
                    provider2.getData(monitor);
                    provider2.resetOrdering();
                    final String id = ChartManager.getInstance().createChart(chartReference, provider2, dataKey.getFullDescriptiveReference(), null, monitor);
                    if (monitor != null && monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (StringUtil.hasContent((String)id)) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (id.length() > 0) {
                                    try {
                                        IViewPart view = part.getSite().getPage().showView("com.ibm.cics.pa.ui.charteditor", id, 2);
                                        part.getSite().getPage().bringToTop((IWorkbenchPart)view);
                                    }
                                    catch (PartInitException e) {
                                        logger.logp(Level.SEVERE, HistoricTimelineHandler.class.getName(), "specificTranJob", "Part initialization", e);
                                    }
                                } else {
                                    MessageDialog.openWarning((Shell)part.getSite().getShell(), (String)Messages.getString("TimelineHandler.4"), (String)Messages.getString("PAX0103I.Results.NoData"));
                                }
                            }
                        });
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)part.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(job, 0L, true);
        return "";
    }

    private void execute(IWorkbenchPart part, ChartSpecification chartReference, String applid, String tran) {
        TimelineAssistDialog dialog = TimelineAssistDialog.getInstance();
        DateCaveat caveat = dialog.getDateCaveat();
        DateCaveat date = caveat == null ? dialog.checkTransientDateDialog() : caveat;
        Selection selectionObject1 = PresentationFactory.getInstance().createSelectAllForTable(PAContextTracker.getInstance().getPerformanceTableReference(), ":schema");
        selectionObject1.appendCondition(ColumnDefinition.APPLID.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnReference.DataType.String, Comparator.EQ, new Object[]{applid}, QueryElement.Predicate.AND, false);
        selectionObject1.appendCondition(ColumnDefinition.TRAN.getDBColumnRef(), PAContextTracker.getInstance().getShortTableReference(), ColumnReference.DataType.String, Comparator.EQ, new Object[]{tran}, QueryElement.Predicate.AND, false);
        if (date != null && !(date instanceof NullRangeDateCaveat)) {
            selectionObject1.appendCondition(date.getConstraint(null, false), QueryElement.Predicate.AND);
        }
        selectionObject1.applyTableMapping(ManifestRecord.getAliasMapping());
        this.dbQuery(part, selectionObject1, String.valueOf(applid) + '+' + tran, new HashMap<String, Object>(), chartReference, ManifestRecord.getAlias("CMFPSUM").getDescription(), ManifestRecord.getAlias("CMFPSUM"));
    }
}

