/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.DateCaveat;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.dialogs.TimelineAssistDialog;
import com.ibm.cics.pa.ui.handlers.CommonHandler;
import com.ibm.cics.pa.ui.views.ChartView;
import com.ibm.cics.pa.ui.views.SheetView;
import java.util.Calendar;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class DateSelection
extends CommonHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(DateSelection.class.getPackage().getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"execute");
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        String persistenceKey = "com.ibm.cics.pa.ui.overview";
        Item item = (Item)((Event)event.getTrigger()).widget;
        ContributionItem data = (ContributionItem)item.getData();
        if (data.getId().startsWith("com.ibm.cics.pa.ui.commands.period.overall")) {
            TimelineAssistDialog.getInstance().openDialog();
        } else if (data.getId().startsWith("com.ibm.cics.pa.ui.commands.period.yesterday")) {
            Calendar beforeCalendar = Calendar.getInstance();
            beforeCalendar.add(6, -1);
            Activator.getDefault().getPluginInstancePreferences().putInt(persistenceKey, 6);
            DateSelection.forceCaveat(item, data.getId(), beforeCalendar);
        } else if (data.getId().startsWith("com.ibm.cics.pa.ui.commands.period.week")) {
            Calendar beforeCalendar = Calendar.getInstance();
            beforeCalendar.add(4, -1);
            Activator.getDefault().getPluginInstancePreferences().putInt(persistenceKey, 4);
            DateSelection.forceCaveat(item, data.getId(), beforeCalendar);
        } else if (data.getId().startsWith("com.ibm.cics.pa.ui.commands.period.month")) {
            Calendar beforeCalendar = Calendar.getInstance();
            beforeCalendar.add(2, -1);
            Activator.getDefault().getPluginInstancePreferences().putInt(persistenceKey, 2);
            DateSelection.forceCaveat(item, data.getId(), beforeCalendar);
        } else if (data.getId().startsWith("com.ibm.cics.pa.ui.commands.period.quarter")) {
            Calendar beforeCalendar = Calendar.getInstance();
            beforeCalendar.add(2, -3);
            Activator.getDefault().getPluginInstancePreferences().putInt(persistenceKey, 3);
            DateSelection.forceCaveat(item, data.getId(), beforeCalendar);
        } else if (data.getId().startsWith("com.ibm.cics.pa.ui.commands.period.year")) {
            Calendar beforeCalendar = Calendar.getInstance();
            beforeCalendar.add(1, -1);
            Activator.getDefault().getPluginInstancePreferences().putInt(persistenceKey, 1);
            DateSelection.forceCaveat(item, data.getId(), beforeCalendar);
        } else if (data.getId().equals("com.ibm.cics.pa.ui.menus.usedates")) {
            DateCaveat caveat = null;
            if (part instanceof ChartView) {
                caveat = ((ChartView)part).getFigure().getDateRangeCovered();
            } else if (part instanceof SheetView) {
                caveat = ((SheetView)part).getDateRangeCovered();
            }
            if (caveat != null) {
                TimelineAssistDialog.getInstance().forceDateCaveat(caveat);
                Activator.getDefault().getPluginInstancePreferences().putInt("com.ibm.cics.pa.ui.overview", 0);
            }
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"execute", (Object)data.getId());
        return null;
    }

    public static void forceCaveat(Item item, String menuId, Calendar beforeCalendar) {
        Debug.enter((Logger)logger, (String)DateSelection.class.getName(), (String)"forceCaveat");
        DateCaveat caveat = DateCaveat.createRangeDateCaveat(beforeCalendar.getTime(), null);
        TimelineAssistDialog.getInstance().forceDateCaveat(caveat);
        Debug.exit((Logger)logger, (String)DateSelection.class.getName(), (String)"forceCaveat");
    }
}

