/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.handlers;

import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.ui.ScrollLimitManager;
import com.ibm.cics.eclipse.common.Utilities;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.SheetViewDefinition;
import com.ibm.cics.pa.ui.ChartManager;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.handlers.VisualizationHandler;
import com.ibm.cics.pa.ui.remote.DBQueryFactoryCustomer;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.cics.pa.ui.remote.RemoteEditorInput;
import com.ibm.cics.pa.ui.views.ChartView;
import com.ibm.cics.pa.ui.views.SheetView;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public abstract class CommonHandler
implements IHandler2 {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    IViewPart part = null;

    public String dbQuery(final IWorkbenchPart activePart, final Selection select, final String contentDescription, final Map<String, Object> parameterMap, final ChartSpecification chartReference, final String tabLabel, final ManifestRecord manifestRecord) {
        if (!activePart.getSite().getPage().getPerspective().getId().equals("com.ibm.cics.pa.ui.perspective") && !PAConnectionTracker.getInstance().isConnected()) {
            ViewHelper.setDeferredStatusErrorMessage((String)Messages.getString("PAX0102I.Not_Connected"));
            return "";
        }
        Job job = new Job(Messages.getString("PAConnections.checking")){

            protected IStatus run(IProgressMonitor monitor) {
                final int[] totalrows = new int[]{-1};
                ViewHelper.setStatusInformationMessage((IWorkbenchPart)activePart, (String)Messages.getString("Query.update"));
                DBQueryFactoryCustomer customer = new DBQueryFactoryCustomer(){
                    private Command currentEngine;

                    @Override
                    public void receiveNotification(final int total) {
                        totalrows[0] = total;
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (total > 0) {
                                    ViewHelper.setStatusInformationMessage((IWorkbenchPart)activePart, (String)MessageFormat.format(Messages.getString("Results.CollectedOf"), 0, total));
                                } else {
                                    ViewHelper.setStatusInformationMessage((IWorkbenchPart)activePart, (String)Messages.getString("PAX0103I.Results.NoData"));
                                }
                            }
                        });
                    }

                    @Override
                    public void refresh(final RemoteEditorInput dataProvider, final boolean isInterimRefresh) {
                        if (dataProvider.getColumnDefinitions() != null && totalrows[0] > 0) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    final String id = ChartManager.getInstance().createChart(chartReference, dataProvider, contentDescription, null, null);
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (Utilities.hasContent((String)id)) {
                                                try {
                                                    if (chartReference instanceof SheetViewDefinition && select.getTargetTables().size() > 0) {
                                                        dataProvider.setSpecification((SheetViewDefinition)chartReference);
                                                        (((this).this).this).CommonHandler.this.part = activePart.getSite().getPage().showView(chartReference.getType().getId(), id, 1);
                                                        if ((((this).this).this).CommonHandler.this.part != null && this.getCurrentCommand().status() == 3 && ((SheetView)(((this).this).this).CommonHandler.this.part).getScrollLimitManager() != null) {
                                                            ((SheetView)(((this).this).this).CommonHandler.this.part).getScrollLimitManager().scrollLimitReached(this.getCurrentCommand());
                                                            ((SheetView)(((this).this).this).CommonHandler.this.part).getScrollLimitManager().setTaskName(MessageFormat.format(Messages.getString("SheetView.collecting"), manifestRecord.getDescription()));
                                                            dataProvider.updateCustomer((DBQueryFactoryCustomer)(((this).this).this).CommonHandler.this.part);
                                                        }
                                                    } else {
                                                        (((this).this).this).CommonHandler.this.part = activePart.getSite().getPage().showView(chartReference.getType().getId(), id, 1);
                                                        if ((((this).this).this).CommonHandler.this.part != null && this.getCurrentCommand().status() == 3 && ((ChartView)(((this).this).this).CommonHandler.this.part).getScrollLimitManager() != null) {
                                                            ((ChartView)(((this).this).this).CommonHandler.this.part).refresh(dataProvider, isInterimRefresh);
                                                            ((ChartView)(((this).this).this).CommonHandler.this.part).getScrollLimitManager().scrollLimitReached(this.getCurrentCommand());
                                                            ((ChartView)(((this).this).this).CommonHandler.this.part).getScrollLimitManager().setTaskName(MessageFormat.format(Messages.getString("SheetView.collecting"), manifestRecord.getDescription()));
                                                            dataProvider.updateCustomer((DBQueryFactoryCustomer)(((this).this).this).CommonHandler.this.part);
                                                        }
                                                    }
                                                    ViewHelper.setStatusInformationMessage((IWorkbenchPart)activePart, null);
                                                }
                                                catch (PartInitException e) {
                                                    logger.logp(Level.SEVERE, VisualizationHandler.class.getName(), "specificTranJob", "Part initialization", e);
                                                }
                                            } else {
                                                ViewHelper.setStatusInformationMessage((IWorkbenchPart)activePart, (String)MessageFormat.format(Messages.getString("PAX0109I.Results.NoData.view"), tabLabel));
                                            }
                                        }
                                    });
                                }
                            });
                        }
                    }

                    @Override
                    public void upDateCommand(Command engine) {
                        this.currentEngine = engine;
                    }

                    @Override
                    public Command getCurrentCommand() {
                        return this.currentEngine;
                    }

                    @Override
                    public ScrollLimitManager getScrollLimitManager() {
                        return null;
                    }

                    @Override
                    public void abort() {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                IWorkbenchPart apart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
                                if (apart != null) {
                                    ViewHelper.setStatusInformationMessage((IWorkbenchPart)apart, (String)Messages.getString("PAX0101E.FailureOcurred"));
                                }
                            }
                        });
                    }

                    @Override
                    public IWorkbenchSite getSite() {
                        return activePart.getSite();
                    }
                };
                RemoteEditorInput dataProvider = RemoteEditorInput.runQuery(customer, select, parameterMap, chartReference, contentDescription, manifestRecord, 0);
                if (dataProvider != null) {
                    dataProvider.setInitialTab(tabLabel);
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        job.setPriority(20);
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)activePart.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(job, 0L, true);
        return "";
    }

    public void setEnabled(Object evaluationContext) {
    }

    protected Map<String, Object> convertToWhereParameters(IUniqueRecord record) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        Map<ColumnDefinition, Object> dataMap = record.getCompleteMapping(true);
        for (ColumnDefinition defn : dataMap.keySet()) {
            parameterMap.put(String.valueOf(':') + defn.getDBColumnRef(), dataMap.get(defn));
        }
        return parameterMap;
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

