/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.handlers;

import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.PAContextTracker;
import com.ibm.cics.pa.ui.handlers.PAContextListener;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.cics.pa.ui.views.Overview;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.jface.commands.PersistentState;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;

public class CloudOverviewHandler
implements IHandler,
PAContextListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean isEnabled;
    private List<IHandlerListener> handlerListeners = new ArrayList<IHandlerListener>();

    public CloudOverviewHandler() {
        PAContextTracker.getInstance().addPAContextListenerListener(this);
        this.isEnabled = PAConnectionTracker.getInstance().isPost32();
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
        this.handlerListeners.add(handlerListener);
    }

    public void dispose() {
        PAContextTracker.getInstance().removePAContextListenerListener(this);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part;
        if (PAConnectionTracker.getInstance().isConnected() && (part = HandlerUtil.getActivePart((ExecutionEvent)event)) instanceof Overview) {
            PersistentState state;
            ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command command = service.getCommand("com.ibm.cics.pa.ui.cloud.overview.command");
            state.setValue((Object)((Boolean)(state = (PersistentState)command.getState("org.eclipse.ui.commands.toggleState")).getValue() == false ? 1 : 0));
            state.save(Activator.getDefault().getPreferenceStore(), "org.eclipse.ui.commands.toggleState");
            ((Overview)part).tableSelected(ManifestRecord.getLastOrDefault());
        }
        return "";
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isHandled() {
        return this.isEnabled;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
        this.handlerListeners.remove(handlerListener);
    }

    @Override
    public void tableSelected(ManifestRecord manifest) {
        this.isEnabled = manifest.isPerformanceSummaryRecord();
        for (IHandlerListener handlerListener : this.handlerListeners) {
            handlerListener.handlerChanged(new HandlerEvent((IHandler)this, true, false));
        }
    }

    @Override
    public void disconnected() {
        if (this.isEnabled) {
            this.isEnabled = false;
            for (IHandlerListener handlerListener : this.handlerListeners) {
                handlerListener.handlerChanged(new HandlerEvent((IHandler)this, true, false));
            }
        }
    }
}

