/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.figures;

import com.ibm.cics.pa.model.Column;
import com.ibm.cics.pa.model.PlotModel;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.figures.IIntervalColumnFigure;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class StackingColumnFigure
extends Figure
implements IIntervalColumnFigure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PlotModel.PlotModelElement.DSAPacket packet;
    private Color colour;
    private double factor;
    private boolean isTotal;
    private ColumnDefinition defn;

    public StackingColumnFigure(PlotModel.PlotModelElement.DSAPacket packet, ColumnDefinition defn, boolean isRemainder) {
        this.packet = packet;
        this.defn = defn;
        this.colour = isRemainder ? ColorConstants.white : Column.getFor(defn).getColor();
        this.isTotal = isRemainder;
    }

    public void paint(Graphics graphics) {
        int interHeight;
        super.paint(graphics);
        Rectangle clientArea = this.getBounds().getCopy();
        graphics.setBackgroundPattern(Activator.getDefault().lightgreyPattern);
        graphics.setForegroundColor(ColorConstants.gray);
        int n = interHeight = this.isTotal ? clientArea.height : new Double((double)this.packet.getUsed() / this.factor).intValue();
        if (clientArea.height > 0) {
            graphics.setLineWidth(1);
            graphics.fillRoundRectangle(clientArea, 4, 4);
            graphics.setAlpha(100);
            graphics.setBackgroundColor(this.colour);
            graphics.fillRoundRectangle(clientArea, 4, 4);
            graphics.setAlpha(150);
            graphics.setForegroundColor(this.colour);
            graphics.drawRoundRectangle(clientArea, 4, 4);
            graphics.setForegroundColor(ColorConstants.gray);
            clientArea.x -= 2;
            clientArea.width += 4;
            graphics.setLineWidth(2);
            graphics.drawRoundRectangle(clientArea, 4, 4);
            graphics.setForegroundColor(ColorConstants.gray);
            graphics.setAlpha(this.isTotal ? 150 : 200);
            if (interHeight > 0) {
                Rectangle rectangle = new Rectangle(clientArea.x + 4, clientArea.y + clientArea.height - interHeight + 2, clientArea.width - 8, interHeight - 4);
                graphics.setBackgroundColor(this.colour);
                graphics.fillRoundRectangle(rectangle, 4, 4);
                graphics.drawRoundRectangle(rectangle, 4, 4);
            }
        }
    }

    @Override
    public Rectangle calculateBounds(Rectangle clientArea, double rangeFactor) {
        this.factor = rangeFactor;
        int totalHeight = this.isTotal ? clientArea.height - 2 : (this.packet != null ? new Double((double)this.packet.getSize() / rangeFactor).intValue() : 0);
        Rectangle myBounds = new Rectangle(clientArea.x + 4, clientArea.y + clientArea.height - totalHeight, clientArea.width - 8, totalHeight);
        return myBounds;
    }

    @Override
    public void forceRepaint() {
        if (!this.isTotal) {
            this.colour = Column.getFor(this.defn).getColor();
        }
    }
}

