/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.figures;

import com.ibm.cics.pa.model.Column;
import com.ibm.cics.pa.model.PlotModel;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.figures.IIntervalColumnFigure;
import com.ibm.cics.pa.ui.figures.IntervalPlotTooltip;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class SiblingColumnFigure
extends Figure
implements IIntervalColumnFigure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private long valuePeak;
    private long valueCurrent;
    private long valueUsed = 0L;
    private long valuePrograms = 0L;
    private int position;
    private int height;
    private int heightPeak;
    private int heightUsed;
    private int heightPrograms = 0;
    private Color colourPeak;
    private Color colourCurrent;
    private Color colourUsed;
    private Color colourPrograms;
    private ColumnDefinition peakColumnDefinition;
    private ColumnDefinition currentColumnDefinition;
    private ColumnDefinition usedColumnDefinition;
    private ColumnDefinition programsColumnDefinition;
    private Color background;
    private PlotModel.PlotModelElement element;
    private int increment_division = 21;

    protected SiblingColumnFigure(PlotModel.PlotModelElement element, int position, long valuePeak, long valueCurrent, long valueUsed, long valuePrograms, ColumnDefinition peakColumnDefinition, ColumnDefinition currentColumnDefinition, ColumnDefinition usedColumnDefinition, ColumnDefinition programsColumnDefinition, Color tooltipBackground) {
        this.valuePeak = valuePeak;
        this.valueCurrent = valueCurrent;
        this.valueUsed = valueUsed;
        this.valuePrograms = valuePrograms;
        this.position = position;
        this.peakColumnDefinition = peakColumnDefinition;
        this.currentColumnDefinition = currentColumnDefinition;
        this.usedColumnDefinition = usedColumnDefinition;
        this.programsColumnDefinition = programsColumnDefinition;
        this.element = element;
        this.background = tooltipBackground;
        if (element.getParent().isLDGRecord()) {
            this.increment_division = 32;
        }
        this.forceRepaint();
    }

    public void paint(Graphics graphics) {
        Rectangle clientArea1;
        super.paint(graphics);
        Rectangle clientArea = this.getBounds().getCopy();
        graphics.setLineStyle(1);
        graphics.setBackgroundColor(this.colourPeak);
        graphics.setAlpha(100);
        graphics.fillRectangle(this.getBounds());
        graphics.setAlpha(150);
        graphics.setLineStyle(1);
        graphics.setLineWidth(1);
        graphics.setForegroundColor(this.colourCurrent);
        graphics.drawLine(clientArea.x, clientArea.y + this.heightPeak, clientArea.x + clientArea.width, clientArea.y + this.heightPeak);
        if (this.valueUsed > -1L) {
            clientArea1 = this.getBounds().getCopy();
            clientArea1.x += 2;
            clientArea1.y += this.heightUsed + 1;
            clientArea1.width -= 4;
            clientArea1.height -= this.heightUsed + 2;
            graphics.setForegroundColor(this.colourUsed);
            graphics.drawRoundRectangle(clientArea1, 4, 4);
        }
        if (this.valuePrograms > -1L) {
            clientArea1 = this.getBounds().getCopy();
            clientArea1.x += 4;
            clientArea1.y += this.heightPrograms + 1;
            clientArea1.width -= 8;
            clientArea1.height -= this.heightPrograms + 2;
            graphics.setForegroundColor(this.colourPrograms);
            graphics.setLineWidth(2);
            graphics.setLineStyle(2);
            graphics.drawRoundRectangle(clientArea1, 4, 4);
        }
    }

    @Override
    public Rectangle calculateBounds(Rectangle clientArea, double rangeFactor) {
        this.height = Math.round(Math.round((double)this.valuePeak / rangeFactor));
        this.heightPeak = Math.round(Math.round((double)(this.valuePeak - this.valueCurrent) / rangeFactor));
        if (this.valueUsed > 0L) {
            this.heightUsed = Math.round(Math.round((double)(this.valuePeak - this.valueUsed) / rangeFactor));
        }
        if (this.valuePrograms > 0L) {
            this.heightPrograms = Math.round(Math.round((double)(this.valuePeak - this.valuePrograms) / rangeFactor));
        }
        Rectangle myBounds = new Rectangle(this.position == 0 ? clientArea.x : clientArea.x + this.increment_division * this.position, clientArea.y + clientArea.height - this.height, this.increment_division, this.height);
        return myBounds;
    }

    @Override
    public void forceRepaint() {
        this.colourPeak = Column.getFor(this.peakColumnDefinition).getColor();
        this.colourCurrent = Column.getFor(this.currentColumnDefinition).getColor();
        this.colourUsed = Column.getFor(this.usedColumnDefinition).getColor();
        if (this.programsColumnDefinition != null) {
            this.colourPrograms = Column.getFor(this.programsColumnDefinition).getColor();
        }
        if (this.valuePrograms > -1L) {
            this.setToolTip((IFigure)new IntervalPlotTooltip(this.element, new ColumnDefinition[]{this.peakColumnDefinition, this.currentColumnDefinition, this.usedColumnDefinition, this.programsColumnDefinition}, new long[]{this.valuePeak, this.valueCurrent, this.valueUsed, this.valuePrograms}, this.background));
        } else if (this.valueUsed > -1L) {
            this.setToolTip((IFigure)new IntervalPlotTooltip(this.element, new ColumnDefinition[]{this.peakColumnDefinition, this.currentColumnDefinition, this.usedColumnDefinition}, new long[]{this.valuePeak, this.valueCurrent, this.valueUsed}, this.background));
        } else if (this.valuePrograms > -1L) {
            this.setToolTip((IFigure)new IntervalPlotTooltip(this.element, new ColumnDefinition[]{this.peakColumnDefinition, this.currentColumnDefinition, this.usedColumnDefinition, this.programsColumnDefinition}, new long[]{this.valuePeak, this.valueCurrent, this.valueUsed, this.valuePrograms}, this.background));
        } else {
            this.setToolTip((IFigure)new IntervalPlotTooltip(this.element, new ColumnDefinition[]{this.peakColumnDefinition, this.currentColumnDefinition}, new long[]{this.valuePeak, this.valueCurrent}, this.background));
        }
    }
}

