/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.figures;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.Column;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Activator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;

public class PieSlice
extends Figure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(PieSlice.class);
    private int startAngle;
    private int endAngle;
    private Point topLeft;
    private int radius;
    private Column column;
    private String name;
    private boolean selected = false;
    private IFigure parent;
    private boolean parentSelection;
    private boolean isDonut = false;

    protected PieSlice(int startAngle, int endAngle, String name, Column column, IFigure parent, Boolean isDonut) {
        debug.enter("PieSlice");
        this.startAngle = startAngle;
        this.endAngle = endAngle;
        this.name = name;
        this.column = column;
        this.isDonut = isDonut;
        this.parent = parent;
        debug.exit("PieSlice");
    }

    public boolean containsPoint(int x, int y) {
        if (this.topLeft == null || this.radius == 0) {
            return false;
        }
        try {
            int yDif = this.topLeft.y + this.radius - y;
            int xDif = x - this.topLeft.x - this.radius;
            if (xDif != 0 && yDif != 0) {
                double angle = Math.toDegrees(Math.atan2(yDif, xDif));
                if (angle < 0.0) {
                    angle += 360.0;
                }
                if ((double)this.startAngle <= angle && (double)(this.startAngle + this.endAngle) >= angle && xDif < this.radius && yDif < this.radius) {
                    return true;
                }
            }
        }
        catch (NullPointerException npe) {
            debug.error("containsPoint", "hangover from devt NPE", (Throwable)npe);
        }
        return false;
    }

    protected void set(Point centre, int radius) {
        debug.enter("set", (Object)centre, (Object)radius);
        this.topLeft = centre;
        this.radius = radius;
        debug.exit("set");
    }

    public void paintFigure(Graphics g) {
        super.paintFigure(g);
        g.setBackgroundColor(this.column.getColor());
        g.setAlpha(150);
        if (this.isSelected()) {
            g.setBackgroundPattern(Activator.getDefault().bluePattern);
        } else if (this.parentSelection) {
            g.setAlpha(205);
        }
        if (this.isDonut) {
            g.fillArc(this.topLeft.x, this.topLeft.y, 2 * this.radius, 2 * this.radius, this.startAngle, this.endAngle);
            g.setBackgroundColor(ColorConstants.listBackground);
            g.setForegroundColor(ColorConstants.listBackground);
            g.setAlpha(255);
            g.fillArc(this.topLeft.x + this.radius / 2, this.topLeft.y + this.radius / 2, this.radius + 1, this.radius + 1, this.startAngle, this.endAngle);
            Point centre = new Point(this.topLeft.x + this.radius, this.topLeft.y + this.radius);
            Point startPoint = centre.getCopy();
            startPoint.x += Math.round(Math.round((double)(this.radius / 2) * Math.cos(Math.toRadians(this.startAngle))));
            startPoint.y += -Math.round(Math.round((double)(this.radius / 2) * Math.sin(Math.toRadians(this.startAngle))));
            Point endPoint = centre.getCopy();
            endPoint.x += Math.round(Math.round((double)(this.radius / 2) * Math.cos(Math.toRadians(this.endAngle + this.startAngle))));
            endPoint.y += -Math.round(Math.round((double)(this.radius / 2) * Math.sin(Math.toRadians(this.endAngle + this.startAngle))));
            g.setLineWidth(2);
            g.drawLine(centre, startPoint);
            g.drawLine(centre, endPoint);
        } else if (this.topLeft != null) {
            int decrement = this.radius / 4;
            g.fillArc(this.topLeft.x + decrement / 2, this.topLeft.y + decrement / 2, 2 * this.radius - decrement, 2 * this.radius - decrement, this.startAngle, this.endAngle);
            g.setForegroundColor(ColorConstants.white);
            Point centre = new Point(this.topLeft.x + this.radius, this.topLeft.y + this.radius);
            Point startPoint = centre.getCopy();
            startPoint.x += Math.round(Math.round((double)this.radius * Math.cos(Math.toRadians(this.startAngle))));
            startPoint.y += -Math.round(Math.round((double)this.radius * Math.sin(Math.toRadians(this.startAngle))));
            Point endPoint = centre.getCopy();
            endPoint.x += Math.round(Math.round((double)this.radius * Math.cos(Math.toRadians(this.endAngle + this.startAngle))));
            endPoint.y += -Math.round(Math.round((double)this.radius * Math.sin(Math.toRadians(this.endAngle + this.startAngle))));
            if (!startPoint.equals((Object)endPoint)) {
                g.drawLine(centre, startPoint);
                g.drawLine(centre, endPoint);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    protected boolean isSelected() {
        return this.selected;
    }

    protected void setSelected(boolean selected) {
        this.selected = selected;
    }

    public IFigure getParent() {
        return this.parent;
    }

    protected void parentSelected(boolean selected) {
        this.parentSelection = selected;
    }

    protected ColumnDefinition getColumnDefinition() {
        return this.column.getColumnDefinition();
    }
}

