/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.figures;

import com.ibm.cics.pa.model.Chart;
import com.ibm.cics.pa.model.ChartType;
import com.ibm.cics.pa.model.Pie;
import com.ibm.cics.pa.model.definitions.CategorisationHelper;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.ui.ChartManager;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.figures.BigPie;
import com.ibm.cics.pa.ui.figures.MiniPie;
import com.ibm.cics.pa.ui.views.PieView;
import java.util.ArrayList;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class PieLine
extends Figure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    FigureCanvas canvas;
    MiniPie selectedPie = null;
    private BigPie bigPie = null;
    private static final int miniIncrement = 120;
    public static final int miniHeight = 105;
    private GraphicalViewer viewer;

    public PieLine(PieView pieView, GraphicalViewer viewer, Pie model) {
        this.viewer = viewer;
        this.canvas = (FigureCanvas)viewer.getControl();
        this.canvas.setBackground(ColorConstants.white);
        this.setFocusTraversable(true);
        this.canvas.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 64) {
                    int index = PieLine.this.getChildren().indexOf((Object)PieLine.this.selectedPie);
                    if (index < PieLine.this.getChildren().size() - 1) {
                        PieLine.this.resetSelectedPie((MiniPie)((Object)PieLine.this.getChildren().get(++index)));
                        PieLine.this.canvas.getAccessible().setFocus(index);
                    }
                    event.doit = true;
                } else if (event.detail == 32) {
                    int index = PieLine.this.getChildren().indexOf((Object)PieLine.this.selectedPie);
                    if (index > 0) {
                        PieLine.this.resetSelectedPie((MiniPie)((Object)PieLine.this.getChildren().get(--index)));
                        PieLine.this.canvas.getAccessible().setFocus(index);
                    }
                    event.doit = true;
                }
            }
        });
        this.canvas.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                PieLine.this.setFocus();
            }
        });
        this.canvas.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                PieLine.this.setFocus();
            }
        });
        this.canvas.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID > -1) {
                    e.result = PieLine.this.getChild(e.childID);
                }
            }

            public void getDescription(AccessibleEvent e) {
                if (e.childID > -1) {
                    e.result = "" + e.childID + 1 + Messages.getString("PieLine_0") + PieLine.this.getChildren().size();
                }
            }
        });
        this.canvas.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = PieLine.this.getChildren().size();
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle clientArea = PieLine.this.getClientArea().getCopy();
                if (e.childID == -1) {
                    e.x = clientArea.x;
                    e.y = clientArea.y;
                    e.width = clientArea.width;
                    e.height = clientArea.height;
                } else {
                    int increment = e.childID * 120;
                    clientArea = new Rectangle(clientArea.x + increment, clientArea.y, 120, 105);
                    e.x = clientArea.x;
                    e.y = clientArea.y;
                    e.width = clientArea.width;
                    e.height = clientArea.height;
                }
            }

            public void getChildren(AccessibleControlEvent e) {
                ArrayList<Integer> ints = new ArrayList<Integer>();
                int i = 0;
                while (i < PieLine.this.getChildren().size()) {
                    ints.add(i);
                    ++i;
                }
                e.children = ints.toArray();
            }

            public void getSelection(AccessibleControlEvent e) {
                e.childID = PieLine.this.getSelectedPieIndex();
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 60;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = e.childID == -1 ? 0 : (e.childID == PieLine.this.getSelectedPieIndex() ? 20 : 0);
            }

            public void getFocus(AccessibleControlEvent e) {
                e.childID = PieLine.this.getSelectedPieIndex();
            }
        });
        viewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent ke) {
                switch (ke.keyCode) {
                    case 0x1000007: {
                        PieLine.this.resetSelectedPie((MiniPie)((Object)PieLine.this.getChildren().get(0)));
                        PieLine.this.canvas.getAccessible().setFocus(0);
                        break;
                    }
                    case 0x1000008: {
                        int index = PieLine.this.getChildren().size() - 1;
                        PieLine.this.resetSelectedPie((MiniPie)((Object)PieLine.this.getChildren().get(index)));
                        PieLine.this.canvas.getAccessible().setFocus(index);
                        break;
                    }
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClicked(MouseEvent me) {
            }

            public void mousePressed(MouseEvent me) {
            }

            public void mouseReleased(MouseEvent event) {
                Point point = new Point(event.x, event.y);
                PieLine.this.translateToRelative((Translatable)point);
                IFigure figure = PieLine.this.findFigureAt(point.x, point.y);
                if (figure instanceof MiniPie) {
                    PieLine.this.resetSelectedPie((MiniPie)figure);
                } else if (figure.getParent() instanceof MiniPie) {
                    PieLine.this.resetSelectedPie((MiniPie)figure.getParent());
                }
            }
        });
    }

    public void initialiseFigures(PieView pieView, Pie model, BigPie bigPie) {
        this.bigPie = bigPie;
        int index = this.getSelectedPieIndex() > -1 ? this.getSelectedPieIndex() : 0;
        Object[] objectArray = this.getChildren().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            this.remove((IFigure)child);
            ++n2;
        }
        MiniPie figure = null;
        int counter = 0;
        if (model != null) {
            for (ChartSpecification defn : CategorisationHelper.getPossibleSingleSelections(model.getDataProvider())) {
                String id = ChartManager.getInstance().createChart(defn, model.getDataProvider(), model.getElementName(), model.getUniqueRecord(), null);
                if (defn.getType().equals((Object)ChartType.PIE)) {
                    figure = new MiniPie(pieView, this.viewer, (Pie)Chart.getReference(id));
                    this.add((IFigure)figure);
                    if (counter == index) {
                        this.resetSelectedPie(figure);
                    }
                }
                ++counter;
            }
        }
    }

    public void paintFigure(Graphics g) {
        super.paintFigure(g);
        Rectangle clientArea = this.getClientArea().getCopy();
        int increment = 0;
        for (Object child : this.getChildren()) {
            ((IFigure)child).setBounds(new Rectangle(clientArea.x + increment, clientArea.y, 120, 105));
            increment += 120;
        }
    }

    void resetSelectedPie(MiniPie figure) {
        if (this.selectedPie != null) {
            this.selectedPie.setSelected(false);
            this.selectedPie.repaint();
        }
        this.selectedPie = figure;
        this.selectedPie.setSelected(true);
        if (this.bigPie != null) {
            this.bigPie.setSelected(figure.getModel());
        }
        figure.repaint();
    }

    public void setFocus() {
        this.canvas.setFocus();
        this.canvas.getAccessible().setFocus(this.getSelectedPieIndex());
        if (this.selectedPie != null) {
            this.selectedPie.repaint();
        }
    }

    public void setBigPie(BigPie bigPie) {
        this.bigPie = bigPie;
        this.resetSelectedPie((MiniPie)((Object)this.getChildren().get(0)));
    }

    public MiniPie getSelectedPie() {
        return this.selectedPie;
    }

    public int getSelectedPieIndex() {
        return this.getChildren().indexOf((Object)this.selectedPie);
    }

    public MenuManager getMenu() {
        return this.viewer.getContextMenu();
    }

    public String getChild(int childID) {
        return this.getChildren().get(childID).toString();
    }
}

