/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.figures;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.Pie;
import com.ibm.cics.pa.ui.figures.AbstractPieFigure;
import com.ibm.cics.pa.ui.figures.PieSector;
import com.ibm.cics.pa.ui.figures.SectorAndSegments;
import com.ibm.cics.pa.ui.views.PieView;
import java.util.logging.Logger;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.ui.IViewPart;

public class MiniPie
extends AbstractPieFigure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int labelHeight = 17;
    private SectorAndSegments sectors;
    private Label label;
    private boolean selected = false;

    protected MiniPie(PieView pieView, GraphicalViewer viewer, Pie model) {
        super((IViewPart)pieView, viewer, model);
        Debug.enter((Logger)this.logger, (String)MiniPie.class.getName(), (String)"MiniPie");
        this.sectors = this.singlePie(model.getChartReference());
        for (PieSector sector : this.sectors.getSectors()) {
            this.add((IFigure)sector.getText());
        }
        this.setToolTip((IFigure)new Label(this.startModel.getToolTipText()));
        this.label = new Label(this.toString());
        this.label.setTextAlignment(1);
        this.add((IFigure)this.label);
        Debug.exit((Logger)this.logger, (String)MiniPie.class.getName(), (String)"MiniPie");
    }

    public void paintFigure(Graphics g) {
        super.paintFigure(g);
        Rectangle boundary1 = this.getBounds().getCopy();
        g.setForegroundColor(ColorConstants.darkGray);
        this.label.setBounds(new Rectangle(boundary1.x + 2, boundary1.y + 2, boundary1.width - 4, 17));
        if (this.selected) {
            if (this.getParent().hasFocus()) {
                g.setForegroundColor(ColorConstants.darkGray);
                g.setLineStyle(1);
            } else {
                g.setForegroundColor(ColorConstants.gray);
                g.setLineStyle(3);
            }
            g.drawRectangle(boundary1.x + 1, boundary1.y + 1, boundary1.width - 2, boundary1.height - 2);
        }
        boundary1.y += 17;
        boundary1.height -= 17;
        for (PieSector portion : this.sectors.getSectors()) {
            portion.setBounds(boundary1);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    protected void setSelected(boolean selected) {
        this.selected = selected;
        for (PieSector sector : this.sectors.getSectors()) {
            sector.setPieSelected(selected);
        }
    }

    public String toString() {
        return this.startModel.getChartReference().getTitle();
    }
}

