/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.figures;

import com.ibm.cics.pa.model.DataKeyElement;
import com.ibm.cics.pa.model.DateCaveat;
import com.ibm.cics.pa.model.Histogram;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.TreeElement;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.figures.ChartSelectable;
import com.ibm.cics.pa.ui.figures.ColumnSection;
import com.ibm.cics.pa.ui.figures.CombinedLineHistogram;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.views.ChartView;
import com.ibm.cics.pa.ui.views.ScaleUtil;
import java.sql.Date;
import java.util.ArrayList;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageUtilities;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class CommonHistogram
extends Figure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int NO_SELECTION = -1;
    protected Histogram model;
    protected FigureCanvas canvas;
    protected int bottomMargin;
    boolean twistedLabels = false;
    ArrayList<ChartSelectable> selections = new ArrayList();
    ChartSelectable focusColumn = null;
    int lastSelectPosition = -1;
    private int initialShiftSelectPosition = -1;
    protected int preferrerdPixelHeight;
    protected ChartView viewPart;
    protected float zoomFactor = 1.0f;
    private CommonHistogram chart = this;
    protected boolean overlay = false;
    boolean ignoreNextMouseButton = false;
    private IFigure finalBuffer;

    public CommonHistogram(final ChartView viewPart, Histogram model, FigureCanvas figureCanvas) {
        this.model = model;
        this.canvas = figureCanvas;
        this.viewPart = viewPart;
        int i = 0;
        while (i < model.getPrimaryColumns().size()) {
            if (i == 0) {
                this.focusColumn = model.getPrimaryColumns().get(i);
                this.focusColumn.setFocussed(true);
            }
            this.add((IFigure)model.getPrimaryColumns().get(i));
            ++i;
        }
        this.finalBuffer = new Figure();
        this.finalBuffer.setBackgroundColor(ColorConstants.white);
        this.add(this.finalBuffer);
        this.bottomMargin = model.getBottomMargin();
        figureCanvas.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                ChartSelectable column = null;
                Point point = new Point(event.x, event.y);
                CommonHistogram.this.translateToRelative((Translatable)point);
                IFigure figure = CommonHistogram.this.findFigureAt(point.x, point.y);
                if (figure != null && figure instanceof ColumnSection) {
                    column = (ChartSelectable)figure.getParent();
                } else if (figure != null && figure instanceof ChartSelectable) {
                    column = (ChartSelectable)figure;
                } else if (figure != null && figure instanceof CombinedLineHistogram.CountFigure) {
                    column = ((CombinedLineHistogram.CountFigure)figure).getSelectableColumn();
                }
                if (column != null) {
                    CommonHistogram.this.setFocusColumn(column);
                    viewPart.barNodeDoubleClicked(column.getUniqueRecord());
                }
            }
        });
        figureCanvas.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                ChartSelectable column = null;
                if (event.button == 1) {
                    Point point = new Point(event.x, event.y);
                    CommonHistogram.this.translateToRelative((Translatable)point);
                    IFigure figure = CommonHistogram.this.findFigureAt(point.x, point.y);
                    if (figure != null && figure instanceof ColumnSection) {
                        column = (ChartSelectable)figure.getParent();
                    } else if (figure != null && figure instanceof ChartSelectable) {
                        column = (ChartSelectable)figure;
                    } else if (figure != null && figure instanceof CombinedLineHistogram.CountFigure) {
                        column = ((CombinedLineHistogram.CountFigure)figure).getSelectableColumn();
                    } else if (!CommonHistogram.this.ignoreNextMouseButton) {
                        CommonHistogram.this.clearSelection();
                        CommonHistogram.this.lastSelectPosition = -1;
                    }
                    if (column != null) {
                        CommonHistogram.this.setFocusColumn(column);
                        if ((event.stateMask & 0x20000) != 0) {
                            CommonHistogram.this.shiftMode(32);
                        } else if ((event.stateMask & 0x40000) != 0) {
                            CommonHistogram.this.ctrlMode(32);
                        } else {
                            CommonHistogram.this.noModifierMode(32);
                        }
                    }
                } else if (event.button == 3) {
                    Point point = new Point(event.x, event.y);
                    CommonHistogram.this.translateToRelative((Translatable)point);
                    IFigure figure = CommonHistogram.this.findFigureAt(point.x, point.y);
                    if (figure != null && figure instanceof ColumnSection) {
                        column = (ChartSelectable)figure.getParent();
                    } else if (figure != null && figure instanceof ChartSelectable) {
                        column = (ChartSelectable)figure;
                    } else if (figure != null && figure instanceof CombinedLineHistogram.CountFigure) {
                        column = ((CombinedLineHistogram.CountFigure)figure).getSelectableColumn();
                    }
                    if (column != null) {
                        CommonHistogram.this.setFocusColumn(column);
                        if (CommonHistogram.this.getCurrentSelections().isEmpty() || CommonHistogram.this.getCurrentSelections().indexOf((Object)CommonHistogram.this.focusColumn) == -1) {
                            CommonHistogram.this.noModifierMode(32);
                        }
                    }
                }
                CommonHistogram.this.ignoreNextMouseButton = false;
            }
        });
        figureCanvas.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String columnstext;
                if (e.childID == -1) {
                    e.childID = CommonHistogram.this.findPositionOfColumn(CommonHistogram.this.focusColumn);
                }
                e.result = e.childID > -1 ? (columnstext = (String)CommonHistogram.this.getModel().getItemLabels()[e.childID]) : CommonHistogram.this.getModel().getTitle();
            }

            public void getDescription(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.childID = CommonHistogram.this.findPositionOfColumn(CommonHistogram.this.focusColumn);
                }
                if (e.childID > -1) {
                    String columnstext;
                    ChartSelectable selectable = CommonHistogram.this.getModel().getPrimaryColumns().get(e.childID);
                    e.result = columnstext = selectable.getAccesibilityName();
                } else {
                    e.result = CommonHistogram.this.getModel().getName();
                }
            }
        });
        figureCanvas.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = CommonHistogram.this.getModel().getPrimaryColumns().size();
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle clientArea = e.childID > -1 ? CommonHistogram.this.getModel().getPrimaryColumns().get(e.childID).getBounds() : CommonHistogram.this.getBounds();
                e.x = clientArea.x;
                e.y = clientArea.y;
                e.width = clientArea.width;
                e.height = clientArea.height;
            }

            public void getChildren(AccessibleControlEvent e) {
                ArrayList<Integer> ints = new ArrayList<Integer>();
                int i = 0;
                while (i < CommonHistogram.this.getModel().getPrimaryColumns().size()) {
                    ints.add(i);
                    ++i;
                }
                e.children = ints.toArray();
            }

            public void getSelection(AccessibleControlEvent e) {
                ArrayList<ChartSelectable> selections = CommonHistogram.this.getCurrentSelections();
                switch (selections.size()) {
                    case 0: {
                        e.childID = -2;
                        break;
                    }
                    case 1: {
                        e.childID = CommonHistogram.this.findPositionOfColumn((ChartSelectable)((Object)selections.get(0)));
                        break;
                    }
                    default: {
                        e.childID = -3;
                    }
                }
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 34;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
                if (e.childID == -1) {
                    e.childID = CommonHistogram.this.findPositionOfColumn(CommonHistogram.this.focusColumn);
                }
                if (e.childID > -1) {
                    ChartSelectable selectable = CommonHistogram.this.getModel().getPrimaryColumns().get(e.childID);
                    if (CommonHistogram.this.selections.contains((Object)selectable)) {
                        e.detail |= 2;
                    }
                    if (((Object)((Object)selectable)).equals((Object)CommonHistogram.this.getFocusColumn())) {
                        e.detail |= 4;
                    }
                }
            }

            public void getFocus(AccessibleControlEvent e) {
                e.childID = CommonHistogram.this.findPositionOfColumn(CommonHistogram.this.focusColumn);
            }

            public void getValue(AccessibleControlEvent e) {
                if (e.childID == -1) {
                    e.childID = CommonHistogram.this.findPositionOfColumn(CommonHistogram.this.focusColumn);
                }
                if (e.childID > -1) {
                    e.result = (String)CommonHistogram.this.getModel().getItemLabels()[e.childID];
                }
            }
        });
        this.setLayoutManager((LayoutManager)new XYLayout());
    }

    void clearSelection() {
        for (ChartSelectable column : this.getCurrentSelections()) {
            column.setSelected(false);
            column.repaint();
        }
        this.selections = new ArrayList();
        this.viewPart.setSelection((ISelection)new StructuredSelection());
    }

    public void paintClientArea(Graphics g) {
        if (!this.canvas.isDisposed()) {
            org.eclipse.swt.graphics.Rectangle viewingClientArea = this.canvas.getClientArea();
            g.setBackgroundColor(ColorConstants.white);
            g.fillRectangle(this.getClientArea());
            this.preferrerdPixelHeight = viewingClientArea.height;
            this.model.primaryScalingFactor = (double)(viewingClientArea.height - this.getTopMargin() - this.bottomMargin) / this.model.getMaxValueYAxis1() * (double)this.zoomFactor;
            this.model.secondaryScalingFactor = this.model.hasDualScaling() ? (double)(viewingClientArea.height - this.getTopMargin() - this.bottomMargin) / this.model.getMaxValueYAxis2() * (double)this.zoomFactor : this.model.primaryScalingFactor;
            int ctr = 0;
            Rectangle bounds = new Rectangle();
            for (ChartSelectable column : this.model.getPrimaryColumns()) {
                int x = ctr * this.model.incrementWidth + this.getLeftMargin();
                int y = this.getTopMargin();
                int width = this.model.incrementWidth;
                int height1 = this.preferrerdPixelHeight - this.bottomMargin - this.getTopMargin();
                int height = Math.round(Math.round(Math.max(column.getTotalPrimary() * this.model.primaryScalingFactor, column.getTotalSecondary() * this.model.secondaryScalingFactor)));
                bounds = new Rectangle(x, y + height1 - height - 5, width, height + 5);
                this.setConstraint((IFigure)column, bounds);
                ++ctr;
            }
            this.setConstraint(this.finalBuffer, new Rectangle(bounds.x + this.model.incrementWidth, this.getTopMargin(), this.getRightMargin() / 2, this.preferrerdPixelHeight - this.bottomMargin - this.getTopMargin()));
            this.finalBuffer.setOpaque(true);
        }
        super.paintClientArea(g);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (!this.canvas.isDisposed()) {
            String value;
            FontData fd;
            int difference;
            float j;
            g.setBackgroundColor(ColorConstants.black);
            g.setForegroundColor(ColorConstants.black);
            this.paintLowerAxis(g);
            g.drawLine(this.getLeftMargin(), this.getTopMargin(), this.getLeftMargin(), this.preferrerdPixelHeight - this.bottomMargin);
            int leftLabelY = (this.preferrerdPixelHeight - this.getBottomMargin() + this.getTopMargin()) / 2;
            int imageHeight = 0;
            if (this.model.getSecondaryLabel() != null && this.model.getSecondaryLabel().length() > 0) {
                g.setFont(Activator.getDefault().fontArialLarge);
                Image twisted = ImageUtilities.createRotatedImageOfString((String)this.model.getSecondaryLabel(), (Font)Activator.getDefault().fontArialLarge, (Color)ColorConstants.darkGray, (Color)ColorConstants.white);
                imageHeight = twisted.getImageData().height;
                leftLabelY = (this.preferrerdPixelHeight - this.getBottomMargin() + this.getTopMargin() - imageHeight) / 2;
                g.drawImage(twisted, 5, leftLabelY);
                twisted.dispose();
            }
            g.setLineWidth(1);
            float[] scaleIncrementsYAxis1 = ScaleUtil.getRange(this.model.getMaxValueYAxis1() / (double)this.zoomFactor);
            float[] scaleIncrementsYAxis2 = ScaleUtil.getRange(this.model.getMaxValueYAxis2());
            int i = 0;
            while (i < scaleIncrementsYAxis1.length) {
                j = scaleIncrementsYAxis1[i];
                difference = this.preferrerdPixelHeight - new Double((double)j * this.model.primaryScalingFactor).intValue() - this.getBottomMargin();
                if (difference > this.getTopMargin()) {
                    g.setForegroundColor(ColorConstants.lightBlue);
                    if (i > 0) {
                        if (this.model.hasDualScaling() || this.overlay) {
                            g.drawLine(this.getLeftMargin(), difference, this.getLeftMargin(), difference);
                        } else {
                            g.drawLine(this.getLeftMargin(), difference, this.model.getPreferrerdPixelWidth() + this.getRightMargin(), difference);
                        }
                    }
                    fd = g.getFont().getFontData()[0];
                    g.setForegroundColor(ColorConstants.black);
                    value = DataTypeUtilities.getNumberAsShorterString(j);
                    Dimension dim = FigureUtilities.getStringExtents((String)value, (Font)Activator.getDefault().fontArialSmall);
                    if (j == 0.0f || !value.equals("0")) {
                        int stdPos = this.getLeftMargin() - 10;
                        if (value.length() > 6) {
                            stdPos -= 7 * (value.length() - 6);
                        }
                        if (stdPos < 18 && difference > leftLabelY && difference - fd.getHeight() < leftLabelY + imageHeight) {
                            stdPos = this.getLeftMargin();
                            value = value.substring(1);
                        }
                        g.setForegroundColor(ColorConstants.darkGreen);
                        g.drawString(value, stdPos - dim.width, difference - fd.getHeight());
                    }
                }
                ++i;
            }
            if (this.model.hasDualScaling()) {
                g.setForegroundColor(ColorConstants.black);
                g.setLineWidth(2);
                g.drawLine(this.model.getPreferrerdPixelWidth() - this.getRightMargin(), this.model.getTopMargin(), this.model.getPreferrerdPixelWidth() - this.getRightMargin(), this.preferrerdPixelHeight - this.getBottomMargin());
                if (this.model.getTertiaryLabel() != null && this.model.getTertiaryLabel().length() > 0) {
                    Image twisted = ImageUtilities.createRotatedImageOfString((String)this.model.getTertiaryLabel(), (Font)g.getFont(), (Color)g.getForegroundColor(), (Color)ColorConstants.white);
                    g.drawImage(twisted, this.model.getPreferrerdPixelWidth(), (this.preferrerdPixelHeight - this.getBottomMargin() + this.getTopMargin() - twisted.getImageData().height) / 2);
                    twisted.dispose();
                }
                g.setLineWidth(1);
                i = 0;
                while (i < scaleIncrementsYAxis2.length) {
                    j = scaleIncrementsYAxis2[i];
                    difference = this.preferrerdPixelHeight - new Double((double)j * this.model.secondaryScalingFactor).intValue() - this.getBottomMargin();
                    if (difference > this.getTopMargin()) {
                        g.drawLine(this.model.getPreferrerdPixelWidth() - 5 - this.getRightMargin(), difference, this.model.getPreferrerdPixelWidth() - this.getRightMargin() + 3, difference);
                        fd = g.getFont().getFontData()[0];
                        g.setForegroundColor(ColorConstants.black);
                        value = new Float(j).toString();
                        if ((float)Math.round(j) == j) {
                            value = new Integer(Math.round(j)).toString();
                        }
                        g.drawString(value, this.model.getPreferrerdPixelWidth() - this.getRightMargin() + 5, difference - fd.getHeight());
                    }
                    ++i;
                }
            }
        }
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public int getTopMargin() {
        return this.model.getTopMargin();
    }

    public int getLeftMargin() {
        return this.model.getLeftMargin();
    }

    public int getRightMargin() {
        return this.model.getRightMargin();
    }

    private void paintLowerAxis(Graphics g) {
        if (this.model.getPrimaryLabel() != null) {
            g.setBackgroundColor(ColorConstants.black);
            g.setForegroundColor(ColorConstants.darkGray);
            g.setFont(Activator.getDefault().fontArialLarge);
            g.drawText(this.model.getPrimaryLabel(), Math.min(this.model.getPreferrerdPixelWidth() / 3, 400), this.preferrerdPixelHeight - 20);
            g.setLineWidth(2);
            g.setForegroundColor(ColorConstants.darkBlue);
            g.drawLine(this.getLeftMargin(), this.preferrerdPixelHeight - this.bottomMargin, this.model.getPreferrerdPixelWidth(), this.preferrerdPixelHeight - this.bottomMargin);
            int multiplier = this.model.isTwinAxis() ? 2 : 1;
            int increment = this.model.isCompact() ? 20 : 1;
            int i = 0;
            while (i < this.model.getItemLabels().length) {
                g.drawLine(i * this.model.incrementWidth + this.getLeftMargin() + multiplier * this.model.barWidth / 2, this.preferrerdPixelHeight - this.getBottomMargin(), i * this.model.incrementWidth + this.getLeftMargin() + multiplier * this.model.barWidth / 2, this.preferrerdPixelHeight - this.getBottomMargin() + this.getBottomMargin() / 8);
                if (this.twistedLabels) {
                    Image twisted = ImageUtilities.createRotatedImageOfString((String)((String)this.model.getItemLabels()[i]), (Font)g.getFont(), (Color)g.getForegroundColor(), (Color)ColorConstants.white);
                    g.drawImage(twisted, i * this.model.incrementWidth + this.getLeftMargin() + this.model.barWidth / 4, this.model.getPreferrerdPixelHeight() - this.getBottomMargin() + 10);
                    twisted.dispose();
                } else {
                    g.setFont(Activator.getDefault().fontArialSmall);
                    int textLength = g.getFontMetrics().getAverageCharWidth() * ((String)this.model.getItemLabels()[i]).length();
                    if (this.flipflop(i)) {
                        g.drawText((String)this.model.getItemLabels()[i], i * this.model.incrementWidth + this.getLeftMargin() + increment + (multiplier * this.model.barWidth - textLength) / 2, this.preferrerdPixelHeight - this.getBottomMargin() + 5);
                    } else {
                        g.drawText((String)this.model.getItemLabels()[i], i * this.model.incrementWidth + this.getLeftMargin() + (multiplier * this.model.barWidth - textLength) / 2, this.preferrerdPixelHeight - this.getBottomMargin() + 15);
                    }
                }
                i += increment;
            }
        }
    }

    private boolean flipflop(int i) {
        return i == 0 || i % 2 == 0;
    }

    public void setZoom(float factor) {
        this.zoomFactor = factor;
        this.repaint();
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    public ArrayList<ChartSelectable> setSelectionNoRepaint(ISelection selection) {
        ArrayList<ChartSelectable> paintList = new ArrayList<ChartSelectable>();
        for (ChartSelectable column : this.getCurrentSelections()) {
            column.setSelected(false);
            paintList.add(column);
        }
        this.selections = null;
        if (selection != null) {
            Object[] objectArray = ((StructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                ChartSelectable col;
                Object selected = objectArray[n2];
                if (selected instanceof ChartSelectable) {
                    this.getCurrentSelections().add((ChartSelectable)((Object)selected));
                    ((ChartSelectable)((Object)selected)).setSelected(true);
                    ((ChartSelectable)((Object)selected)).repaint();
                } else if (selected instanceof Object[] && (col = (ChartSelectable)this.model.getColumnMapping().get(selected)) != null) {
                    this.getCurrentSelections().add(col);
                    col.setSelected(true);
                    paintList.add(col);
                }
                ++n2;
            }
        }
        this.canvas.getAccessible().selectionChanged();
        return paintList;
    }

    public void setSelection(ISelection selection) {
        for (ChartSelectable column : this.getCurrentSelections()) {
            column.setSelected(false);
            column.repaint();
        }
        this.selections = null;
        if (selection != null) {
            ChartSelectable col = null;
            Object[] objectArray = ((StructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selected = objectArray[n2];
                if (selected instanceof ChartSelectable) {
                    col = (ChartSelectable)((Object)selected);
                    this.getCurrentSelections().add(col);
                    col.setSelected(true);
                    col.repaint();
                } else if (selected instanceof Object[]) {
                    col = this.model.getColumnMapping().get(selected);
                    if (col != null) {
                        this.getCurrentSelections().add(col);
                        col.setSelected(true);
                        col.repaint();
                    }
                } else if (selected instanceof IUniqueRecord) {
                    col = this.model.getColumnMapping().get(selected);
                    if (col != null) {
                        this.getCurrentSelections().add(col);
                        col.setSelected(true);
                        col.repaint();
                    } else {
                        for (IUniqueRecord aKey : this.model.getColumnMapping().keySet()) {
                            if (!selected.equals(aKey)) continue;
                            col = this.model.getColumnMapping().get(aKey);
                        }
                    }
                    if (col != null) {
                        this.getCurrentSelections().add(col);
                        col.setSelected(true);
                        col.repaint();
                    }
                } else if (selected instanceof TreeElement) {
                    for (IUniqueRecord pastInst : ((TreeElement)selected).getAllLeafDescendents()) {
                        IUniqueRecord childInst = pastInst.findEquivalentIn(this.model.getColumnMapping().keySet().toArray());
                        col = this.model.getColumnMapping().get(childInst);
                        if (col == null) continue;
                        this.getCurrentSelections().add(col);
                        col.setSelected(true);
                        col.repaint();
                    }
                }
                if (col != null) {
                    this.lastSelectPosition = this.findPositionOfColumn(this.focusColumn);
                }
                ++n2;
            }
            this.canvas.getAccessible().selectionChanged();
        }
    }

    public ISelection getSelection() {
        if (this.selections == null) {
            this.selections = new ArrayList();
        }
        Object[] adapted = new IUniqueRecord[this.getCurrentSelections().size()];
        int i = 0;
        while (i < adapted.length) {
            adapted[i] = this.getCurrentSelections().get(i).getUniqueRecord();
            ++i;
        }
        return new StructuredSelection(adapted);
    }

    public ArrayList<ChartSelectable> getCurrentSelections() {
        if (this.selections == null) {
            this.selections = new ArrayList();
        }
        return this.selections;
    }

    public ChartSelectable getFocusColumn() {
        if (this.focusColumn == null) {
            this.focusColumn = this.model.getPrimaryColumns().get(0);
        }
        return this.focusColumn;
    }

    public void showFocusColumn(boolean state) {
        if (this.focusColumn == null) {
            if (!this.selections.isEmpty()) {
                this.focusColumn = this.selections.get(0);
            } else if (this.getModel().getPrimaryColumns().size() > 0) {
                this.focusColumn = this.getModel().getPrimaryColumns().get(0);
            }
        }
        if (this.focusColumn != null) {
            this.focusColumn.setFocussed(state);
            this.focusColumn.repaint();
            if (state) {
                this.ignoreNextMouseButton = true;
                this.canvas.getAccessible().setFocus(this.findPositionOfColumn(this.focusColumn));
            }
            this.canvas.getAccessible().selectionChanged();
        }
    }

    public void setFocusColumn(ChartSelectable focusColumn) {
        if (this.focusColumn != null) {
            this.focusColumn.setFocussed(false);
            this.focusColumn.repaint();
        }
        this.focusColumn = focusColumn;
        this.focusColumn.setFocussed(true);
        this.reveal(focusColumn);
        this.focusColumn.repaint();
    }

    public void noModifierMode(int key) {
        if (key == 0x1000007) {
            this.setFocusColumn(this.model.getPrimaryColumns().get(0));
            this.viewPart.setSelection(this.chart.getSelection());
            this.canvas.getAccessible().selectionChanged();
            this.canvas.getAccessible().setFocus(this.findPositionOfColumn(this.focusColumn));
        } else if (key == 0x1000008) {
            this.setFocusColumn(this.model.getPrimaryColumns().get(this.model.getPrimaryColumns().size() - 1));
            this.viewPart.setSelection(this.chart.getSelection());
            this.canvas.getAccessible().selectionChanged();
            this.canvas.getAccessible().setFocus(this.findPositionOfColumn(this.focusColumn));
        } else if (key == 0x1000003) {
            int position = this.findPositionOfColumn(this.focusColumn);
            if (position > 0) {
                --position;
            }
            this.setSelection((ISelection)new StructuredSelection(new Object[0]));
            this.setFocusColumn(this.model.getPrimaryColumns().get(position));
            this.selectTheFocussedOne();
            this.viewPart.setSelection(this.chart.getSelection());
            this.canvas.getAccessible().selectionChanged();
            this.canvas.getAccessible().setFocus(this.findPositionOfColumn(this.focusColumn));
        } else if (key == 0x1000004) {
            int position = this.findPositionOfColumn(this.focusColumn);
            if (position < this.model.getPrimaryColumns().size() - 1) {
                ++position;
            }
            this.setSelection((ISelection)new StructuredSelection(new Object[0]));
            this.setFocusColumn(this.model.getPrimaryColumns().get(position));
            this.selectTheFocussedOne();
            this.viewPart.setSelection(this.chart.getSelection());
            this.canvas.getAccessible().selectionChanged();
            this.canvas.getAccessible().setFocus(this.findPositionOfColumn(this.focusColumn));
        } else if (key == 32) {
            this.selectTheFocussedOne();
            this.canvas.getAccessible().selectionChanged();
            this.canvas.getAccessible().setFocus(this.findPositionOfColumn(this.focusColumn));
        }
    }

    private void selectTheFocussedOne() {
        if (this.lastSelectPosition == this.findPositionOfColumn(this.focusColumn)) {
            this.lastSelectPosition = -1;
            this.setSelection((ISelection)new StructuredSelection(new Object[0]));
        } else {
            this.lastSelectPosition = this.findPositionOfColumn(this.focusColumn);
            ArrayList<ChartSelectable> paintList = this.setSelectionNoRepaint((ISelection)new StructuredSelection(new Object[]{this.model.getPrimaryColumns().get(this.lastSelectPosition)}));
            for (ChartSelectable column : paintList) {
                column.repaint();
            }
            this.initialShiftSelectPosition = this.lastSelectPosition;
        }
        this.viewPart.setSelection((ISelection)new StructuredSelection((Object)this.focusColumn.getUniqueRecord()));
    }

    int findPositionOfColumn(ChartSelectable column) {
        int i = 0;
        while (i < this.model.getPrimaryColumns().size()) {
            if (this.model.getPrimaryColumns().get(i) == column) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void ctrlMode(int key) {
        if (key == 0x1000007) {
            this.setFocusColumn(this.model.getPrimaryColumns().get(0));
            this.getCurrentSelections().add(this.focusColumn);
            this.setSelection((ISelection)new StructuredSelection(this.getCurrentSelections().toArray()));
            this.canvas.getAccessible().selectionChanged();
            this.canvas.getAccessible().setFocus(this.findPositionOfColumn(this.focusColumn));
            this.viewPart.setSelection(this.chart.getSelection());
        } else if (key == 0x1000008) {
            this.setFocusColumn(this.model.getPrimaryColumns().get(this.model.getPrimaryColumns().size() - 1));
            this.getCurrentSelections().add(this.focusColumn);
            this.setSelection((ISelection)new StructuredSelection(this.getCurrentSelections().toArray()));
            this.canvas.getAccessible().selectionChanged();
            this.canvas.getAccessible().setFocus(this.findPositionOfColumn(this.focusColumn));
            this.viewPart.setSelection(this.chart.getSelection());
        } else {
            if (key == 0x1000003) {
                int position = this.findPositionOfColumn(this.focusColumn);
                if (position > 0) {
                    --position;
                }
                this.setFocusColumn(this.model.getPrimaryColumns().get(position));
                return;
            }
            if (key == 0x1000004) {
                int position = this.findPositionOfColumn(this.focusColumn);
                if (position < this.model.getPrimaryColumns().size() - 1) {
                    ++position;
                }
                this.setFocusColumn(this.model.getPrimaryColumns().get(position));
                return;
            }
            if (key == 32) {
                this.lastSelectPosition = this.findPositionOfColumn(this.focusColumn);
                if (this.getCurrentSelections().indexOf((Object)this.focusColumn) > -1) {
                    this.getCurrentSelections().remove((Object)this.focusColumn);
                    this.focusColumn.setSelected(false);
                    this.focusColumn.repaint();
                } else {
                    this.getCurrentSelections().add(this.focusColumn);
                }
                this.setSelection((ISelection)new StructuredSelection(this.getCurrentSelections().toArray()));
                this.canvas.getAccessible().selectionChanged();
                this.canvas.getAccessible().setFocus(this.findPositionOfColumn(this.focusColumn));
                this.viewPart.setSelection(this.chart.getSelection());
            }
        }
    }

    public void shiftMode(int key) {
        if (this.initialShiftSelectPosition == -1) {
            if (this.lastSelectPosition != -1) {
                this.initialShiftSelectPosition = this.findPositionOfColumn(this.focusColumn);
            } else {
                this.noModifierMode(key);
            }
        }
        if (key == 0x1000007) {
            this.setFocusColumn(this.model.getPrimaryColumns().get(0));
            ArrayList<ChartSelectable> tempSelected = new ArrayList<ChartSelectable>();
            int i = 0;
            while (i <= this.initialShiftSelectPosition) {
                tempSelected.add(this.model.getPrimaryColumns().get(i));
                ++i;
            }
            this.setSelection((ISelection)new StructuredSelection(tempSelected.toArray()));
            this.canvas.getAccessible().selectionChanged();
            this.canvas.getAccessible().setFocus(this.findPositionOfColumn(this.focusColumn));
            this.viewPart.setSelection(this.chart.getSelection());
        } else if (key == 0x1000008) {
            this.setFocusColumn(this.model.getPrimaryColumns().get(this.model.getPrimaryColumns().size() - 1));
            ArrayList<ChartSelectable> tempSelected = new ArrayList<ChartSelectable>();
            int i = this.initialShiftSelectPosition;
            while (i < this.model.getPrimaryColumns().size()) {
                tempSelected.add(this.model.getPrimaryColumns().get(i));
                ++i;
            }
            this.setSelection((ISelection)new StructuredSelection(tempSelected.toArray()));
            this.canvas.getAccessible().selectionChanged();
            this.canvas.getAccessible().setFocus(this.findPositionOfColumn(this.focusColumn));
            this.viewPart.setSelection(this.chart.getSelection());
        } else if (key == 0x1000003) {
            int position = this.findPositionOfColumn(this.focusColumn);
            if (position > 0) {
                --position;
            }
            if (this.initialShiftSelectPosition <= position) {
                ChartSelectable revisedColumn = this.model.getPrimaryColumns().get(position);
                this.getCurrentSelections().remove((Object)this.focusColumn);
                this.focusColumn.setSelected(false);
                this.focusColumn.repaint();
                this.setFocusColumn(revisedColumn);
                this.setSelection((ISelection)new StructuredSelection(this.getCurrentSelections().toArray()));
            } else {
                ChartSelectable addedColumn = this.model.getPrimaryColumns().get(position);
                this.setFocusColumn(addedColumn);
                this.getCurrentSelections().add(addedColumn);
                this.setSelection((ISelection)new StructuredSelection(this.getCurrentSelections().toArray()));
            }
            this.setFocusColumn(this.model.getPrimaryColumns().get(position));
            this.canvas.getAccessible().selectionChanged();
            this.canvas.getAccessible().setFocus(this.findPositionOfColumn(this.focusColumn));
            this.viewPart.setSelection(this.chart.getSelection());
        } else if (key == 0x1000004) {
            int position = this.findPositionOfColumn(this.focusColumn);
            if (position < this.model.getPrimaryColumns().size() - 1) {
                ++position;
            }
            if (this.initialShiftSelectPosition >= position) {
                ChartSelectable revisedColumn = this.model.getPrimaryColumns().get(position);
                this.getCurrentSelections().remove((Object)this.focusColumn);
                this.focusColumn.setSelected(false);
                this.focusColumn.repaint();
                this.setFocusColumn(revisedColumn);
                this.setSelection((ISelection)new StructuredSelection(this.getCurrentSelections().toArray()));
            } else {
                ChartSelectable addedColumn = this.model.getPrimaryColumns().get(position);
                this.getCurrentSelections().add(addedColumn);
                this.setFocusColumn(addedColumn);
                this.setSelection((ISelection)new StructuredSelection(this.getCurrentSelections().toArray()));
            }
            this.canvas.getAccessible().selectionChanged();
            this.canvas.getAccessible().setFocus(this.findPositionOfColumn(this.focusColumn));
            this.viewPart.setSelection(this.chart.getSelection());
        } else if (key == 32) {
            int position = this.findPositionOfColumn(this.focusColumn);
            ArrayList<ChartSelectable> tempSelected = new ArrayList<ChartSelectable>();
            if (position <= this.initialShiftSelectPosition) {
                int i = position;
                while (i <= this.initialShiftSelectPosition) {
                    tempSelected.add(this.model.getPrimaryColumns().get(i));
                    ++i;
                }
            } else {
                int i = this.initialShiftSelectPosition;
                while (i < position + 1) {
                    tempSelected.add(this.model.getPrimaryColumns().get(i));
                    ++i;
                }
            }
            this.setSelection((ISelection)new StructuredSelection(tempSelected.toArray()));
            this.canvas.getAccessible().selectionChanged();
            this.canvas.getAccessible().setFocus(this.findPositionOfColumn(this.focusColumn));
            this.viewPart.setSelection(this.chart.getSelection());
        }
    }

    public int reveal(ChartSelectable column) {
        Viewport port = this.canvas.getViewport();
        int original = port.getViewLocation().x;
        ChartSelectable target = column;
        Rectangle exposeRegion = target.getBounds().getCopy();
        target = target.getParent();
        while (target != null && target != port) {
            target.translateToParent((Translatable)exposeRegion);
            target = target.getParent();
        }
        exposeRegion.expand(this.model.getLeftMargin(), 0);
        Dimension viewportSize = port.getClientArea().getSize();
        Point topLeft = exposeRegion.getTopLeft();
        Point bottomRight = exposeRegion.getBottomRight().translate(viewportSize.getNegated());
        Point finalLocation = new Point();
        finalLocation.x = viewportSize.width < exposeRegion.width ? Math.min(bottomRight.x, Math.max(topLeft.x, port.getViewLocation().x)) : Math.min(topLeft.x, Math.max(bottomRight.x, port.getViewLocation().x));
        this.canvas.scrollSmoothTo(finalLocation.x, 0);
        return finalLocation.x - original;
    }

    public void selectAll() {
        this.viewPart.setSelection((ISelection)new StructuredSelection(this.model.getColumnMapping().keySet().toArray()));
    }

    public Button[] getAdditionalButtons(Canvas basicSWT) {
        return null;
    }

    public Image getCounterIcon() {
        return this.viewPart.counterIcon;
    }

    public Image getUpArrow() {
        return this.viewPart.upArrow;
    }

    public int getItemCount() {
        return this.model.getPrimaryColumns().size();
    }

    public Histogram getModel() {
        return this.model;
    }

    public boolean isContiguousSelection() {
        ChartSelectable[] slec = this.selections.toArray(new ChartSelectable[this.selections.size()]);
        int i = 0;
        while (i < this.model.getPrimaryColumns().size()) {
            if (this.model.getPrimaryColumns().get(i) == slec[0]) {
                int j = 1;
                while (j < slec.length) {
                    if (this.model.getPrimaryColumns().get(i + j) == slec[j]) {
                        return false;
                    }
                    ++j;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public DateCaveat getDateRangeCovered() {
        ChartSelectable start = this.selections.get(0);
        ChartSelectable end = this.selections.get(this.selections.size() - 1);
        DataKeyElement element1 = start.getUniqueRecord().getDataKey();
        DataKeyElement element2 = end.getUniqueRecord().getDataKey();
        Date before = element1.getACombinedDateReference();
        Date after = element2.getACombinedDateReference();
        if (after.compareTo(before) < 0) {
            Date temp = after;
            after = before;
            before = temp;
        }
        return DateCaveat.createRangeDateCaveat(before, after);
    }
}

