/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.editors;

import com.ibm.cics.pa.model.definitions.ChartCategorisation;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.ColumnAssociationMapper;
import com.ibm.cics.pa.model.definitions.ColumnContainment;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.PieChartSpecificDefinitions;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PieEditorItem {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ChartCategorisation chartCategorisation;
    private ChartSpecification chartDefinition;
    private ColumnDefinition columnDefinition;
    private ColumnContainment columnContainment;
    private Object columnValue;
    private BigDecimal accumulatedValue = new BigDecimal(0.0);
    private Object column3Value;
    private String percentageOfWhole;
    private String percentageOfParent;
    private PieEditorItem parent;
    private List<PieEditorItem> children = new ArrayList<PieEditorItem>();
    private int level;
    private boolean excludeZeroValues;
    private boolean restrictToCurrentChart;
    private Map<ColumnDefinition, Object> map;
    private String label = null;

    public static PieEditorItem createRootFor(ChartSpecification chartDefn, Map<ColumnDefinition, Object> map, boolean excludeZeros, boolean restrictToChart) {
        PieEditorItem root = new PieEditorItem(chartDefn, map, excludeZeros, restrictToChart);
        root.parent = null;
        if (chartDefn.getCategorisation().length > 0) {
            root.chartCategorisation = chartDefn.getCategorisation()[0];
        }
        ColumnContainment[] containments = ((PieChartSpecificDefinitions)chartDefn.getSpecificType()).getContainments();
        PieEditorItem item = new PieEditorItem(root, chartDefn, map, containments);
        root.addChild(item);
        if (ChartCategorisation.STORAGE == root.chartCategorisation) {
            item.label = Messages.getString("Pie.Shared.task.usage");
        } else {
            root.recalculateStep1();
            root.recalculateStep2();
        }
        if (ChartCategorisation.FILEUSAGE == root.chartCategorisation) {
            item = new PieEditorItem(root, ColumnDefinition.FCAMCT_COUNT_AVG, map, chartDefn);
            root.addChild2(item);
        } else {
            ChartCategorisation cfr_ignored_0 = root.chartCategorisation;
        }
        return root;
    }

    public static PieEditorItem createRootForStorage(ChartSpecification chartDefn, Map<ColumnDefinition, Object> map, boolean excludeZeros, boolean restrictToChart) {
        PieEditorItem root0 = new PieEditorItem(chartDefn, map, excludeZeros, restrictToChart);
        root0.parent = null;
        PieEditorItem root = new PieEditorItem(root0, chartDefn, map, null);
        root0.addChild(root);
        root.label = Messages.getString("Pie.Shared.storage.usage");
        PieEditorItem item = new PieEditorItem(root, ColumnDefinition.SC24SGET_COUNT_AVG, map, chartDefn);
        item.percentageOfWhole = DataTypeUtilities.getAsString(map.get(ColumnDefinition.SC24GSHR_COUNT_AVG) != null ? map.get(ColumnDefinition.SC24GSHR_COUNT_AVG) : Integer.valueOf(0));
        item.column3Value = map.get(ColumnDefinition.SC24FSHR_COUNT_AVG) != null ? map.get(ColumnDefinition.SC24FSHR_COUNT_AVG) : Integer.valueOf(0);
        root.addChild2(item);
        item = new PieEditorItem(root, ColumnDefinition.SC31SGET_COUNT_AVG, map, chartDefn);
        item.percentageOfWhole = DataTypeUtilities.getAsString(map.get(ColumnDefinition.SC31GSHR_COUNT_AVG) != null ? map.get(ColumnDefinition.SC31GSHR_COUNT_AVG) : Integer.valueOf(0));
        item.column3Value = map.get(ColumnDefinition.SC31FSHR_COUNT_AVG) != null ? map.get(ColumnDefinition.SC31FSHR_COUNT_AVG) : Integer.valueOf(0);
        root.addChild2(item);
        item = new PieEditorItem(root, ColumnDefinition.SC64SGET_COUNT_AVG, map, chartDefn);
        item.percentageOfWhole = DataTypeUtilities.getAsString(map.get(ColumnDefinition.SC64GSHR_COUNT_AVG) != null ? map.get(ColumnDefinition.SC64GSHR_COUNT_AVG) : Integer.valueOf(0));
        item.column3Value = map.get(ColumnDefinition.SC64FSHR_COUNT_AVG) != null ? map.get(ColumnDefinition.SC64FSHR_COUNT_AVG) : Integer.valueOf(0);
        root.addChild2(item);
        return root0;
    }

    public static PieEditorItem createRootForCPU(ChartSpecification chartDefn, Map<ColumnDefinition, Object> map, boolean excludeZeros, boolean restrictToChart, boolean plist) {
        PieEditorItem root0 = new PieEditorItem(chartDefn, map, excludeZeros, restrictToChart);
        root0.parent = null;
        PieEditorItem root = new PieEditorItem(root0, chartDefn, map, null);
        root0.addChild(root);
        root.label = Messages.getString("ChartDefinition.CPU_TIME_ANALYSIS");
        PieEditorItem item = new PieEditorItem(root, plist ? ColumnDefinition.CPUONCP_TIME : ColumnDefinition.CPUONCP_TIME_AVG, map, chartDefn);
        item.percentageOfWhole = DataTypeUtilities.getAs2PositionPercentageString((Number)map.get(plist ? ColumnDefinition.CPUONCP_TIME : ColumnDefinition.CPUONCP_TIME_AVG), (Number)map.get(plist ? ColumnDefinition.CPU_TIME : ColumnDefinition.CPU_TIME_AVG));
        root.addChild2(item);
        PieEditorItem item2 = new PieEditorItem(root, ColumnDefinition.CPUONCPE_TIME_AVG, map, chartDefn);
        item2.percentageOfWhole = DataTypeUtilities.getAs2PositionPercentageString((Number)map.get(plist ? ColumnDefinition.CPUONCPE_TIME : ColumnDefinition.CPUONCPE_TIME_AVG), (Number)map.get(plist ? ColumnDefinition.CPU_TIME : ColumnDefinition.CPU_TIME_AVG));
        item.addChild2(item2);
        item = new PieEditorItem(root, ColumnDefinition.CPUONSP_TIME_AVG, map, chartDefn);
        item.percentageOfWhole = DataTypeUtilities.getAs2PositionPercentageString((Number)map.get(plist ? ColumnDefinition.CPUONSP_TIME : ColumnDefinition.CPUONSP_TIME_AVG), (Number)map.get(plist ? ColumnDefinition.CPU_TIME : ColumnDefinition.CPU_TIME_AVG));
        root.addChild2(item);
        item = new PieEditorItem(root, ColumnDefinition.CPUISSPE_TIME_AVG, map, chartDefn);
        item.percentageOfWhole = DataTypeUtilities.getAs2PositionPercentageString((Number)map.get(plist ? ColumnDefinition.CPUISSPE_TIME : ColumnDefinition.CPUISSPE_TIME_AVG), (Number)map.get(plist ? ColumnDefinition.CPU_TIME : ColumnDefinition.CPU_TIME_AVG));
        root0.addChild2(item);
        return root0;
    }

    public static PieEditorItem createRootForContainments(ChartSpecification chartDefn, Map<ColumnDefinition, Object> map, ColumnContainment[] containments, String label, boolean excludeZeros, boolean restrictToChart) {
        PieEditorItem root = new PieEditorItem(chartDefn, map, excludeZeros, restrictToChart);
        root.parent = null;
        if (chartDefn.getCategorisation().length > 0) {
            root.chartCategorisation = chartDefn.getCategorisation()[0];
        }
        PieEditorItem item = new PieEditorItem(root, chartDefn, map, containments);
        item.label = label;
        root.addChild(item);
        root.recalculateStep1();
        root.recalculateStep2();
        return root;
    }

    private PieEditorItem(ChartSpecification chartDefn, Map<ColumnDefinition, Object> map, boolean excludeZeros, boolean restrictToChart) {
        this.chartDefinition = chartDefn;
        this.excludeZeroValues = excludeZeros;
        this.restrictToCurrentChart = restrictToChart;
        this.map = map;
        this.level = -1;
        if (chartDefn.getCategorisation().length > 0) {
            this.chartCategorisation = chartDefn.getCategorisation()[0];
        }
    }

    private PieEditorItem(PieEditorItem parent, ChartSpecification chartDefn, Map<ColumnDefinition, Object> map, ColumnContainment[] containments) {
        this.chartDefinition = chartDefn;
        this.parent = parent;
        this.level = 0;
        if (chartDefn.getCategorisation().length > 0) {
            this.chartCategorisation = chartDefn.getCategorisation()[0];
        }
        this.columnDefinition = ((PieChartSpecificDefinitions)this.chartDefinition.getSpecificType()).getTopHeading();
        if (containments != null) {
            this.createPieEditorItemsFor(containments, chartDefn, map);
            ColumnDefinition countDefinition = null;
            if (ChartCategorisation.STORAGE == this.chartCategorisation) {
                countDefinition = ColumnAssociationMapper.getGetmainToOccupancy(this.columnDefinition);
                this.percentageOfWhole = countDefinition == null ? "" : DataTypeUtilities.getAsString(map.get(countDefinition));
                countDefinition = ColumnAssociationMapper.getGetmainToHighwater(this.columnDefinition);
            } else {
                countDefinition = ColumnAssociationMapper.getTimeToCount(this.columnDefinition);
            }
            this.column3Value = countDefinition == null ? "" : map.get(countDefinition);
        }
    }

    private PieEditorItem(PieEditorItem parent, ColumnDefinition columnDefinition, Map<ColumnDefinition, Object> map, ChartSpecification chartDefn) {
        this.columnDefinition = columnDefinition;
        this.parent = parent;
        this.level = parent.level + 1;
        if (chartDefn.getCategorisation().length > 0) {
            this.chartCategorisation = chartDefn.getCategorisation()[0];
        }
        this.columnValue = map.get(columnDefinition);
        if (ChartCategorisation.STORAGE == this.chartCategorisation) {
            ColumnDefinition countDefinition = ColumnAssociationMapper.getGetmainToOccupancy(columnDefinition);
            this.percentageOfWhole = countDefinition == null ? "" : DataTypeUtilities.getAsString(map.get(countDefinition));
            countDefinition = ColumnAssociationMapper.getGetmainToHighwater(columnDefinition);
            this.column3Value = countDefinition == null ? "0" : DataTypeUtilities.getAsString(map.get(countDefinition));
        } else {
            ColumnDefinition countDefinition = ColumnAssociationMapper.getTimeToCount(columnDefinition);
            this.column3Value = countDefinition == null ? "0" : (map.get(countDefinition) == null ? "0" : map.get(countDefinition));
        }
    }

    public void createPieEditorItemsFor(ColumnContainment[] columnContainments, ChartSpecification chartDefn, Map<ColumnDefinition, Object> map) {
        ColumnContainment[] columnContainmentArray = columnContainments;
        int n = columnContainments.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnContainment columnContainment = columnContainmentArray[n2];
            PieEditorItem item = new PieEditorItem(this, columnContainment.getPrimary(), map, chartDefn);
            item.setColumnContainment(columnContainment);
            this.addChild(item);
            ColumnDefinition[] columnDefinitionArray = columnContainment.getColumnRef();
            int n3 = columnDefinitionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ColumnDefinition columnDefinition = columnDefinitionArray[n4];
                ColumnContainment columnContainment1 = ColumnContainment.getByColumnDefinition(columnDefinition);
                if (columnContainment1 != null && !this.isRestrictToCurrentChart()) {
                    item.createPieEditorItemsFor(new ColumnContainment[]{columnContainment1}, chartDefn, map);
                } else {
                    PieEditorItem item1 = new PieEditorItem(item, columnDefinition, map, chartDefn);
                    item.addChild(item1);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void setColumnContainment(ColumnContainment columnContainment) {
        this.columnContainment = columnContainment;
    }

    public boolean includesCounts() {
        return true;
    }

    public PieEditorItem[] getChildren() {
        return this.children.toArray(new PieEditorItem[this.children.size()]);
    }

    public String testString() {
        String res = "\n";
        int i = 0;
        while (i < this.level) {
            res = String.valueOf(res) + "\t";
            ++i;
        }
        res = String.valueOf(res) + this.toString();
        PieEditorItem[] pieEditorItemArray = this.getChildren();
        int n = pieEditorItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            PieEditorItem child = pieEditorItemArray[n2];
            res = String.valueOf(res) + child.testString();
            ++n2;
        }
        return res;
    }

    public String toString() {
        String res = "";
        if (this.isRoot()) {
            res = String.valueOf(res) + "root";
        } else if (this.columnDefinition != null) {
            int avgIndex = this.columnDefinition.getDBColumnRef().indexOf("_AVG");
            res = avgIndex > -1 && ColumnDefinition.getByDBColumnRef(this.columnDefinition.getDBColumnRef().substring(0, avgIndex)) != null ? String.valueOf(res) + ColumnDefinition.getByDBColumnRef(this.columnDefinition.getDBColumnRef().substring(0, avgIndex)).getLabel(null) : String.valueOf(res) + this.columnDefinition.getLabel(null);
        } else if (this.chartDefinition != null) {
            res = String.valueOf(res) + this.chartDefinition.getTitle();
        }
        return res;
    }

    private boolean isRoot() {
        return this.parent == null;
    }

    public String getLabel() {
        return this.label == null ? this.toString() : this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        String res = "";
        if (this.isRoot()) {
            res = String.valueOf(res) + "root";
        } else if (this.chartDefinition != null) {
            res = String.valueOf(res) + this.chartDefinition.getTitle();
        } else if (this.columnDefinition != null) {
            PieChartSpecificDefinitions defns = (PieChartSpecificDefinitions)this.getChartDefinition().getSpecificType();
            String[] tooltips = defns.getTooltips();
            res = String.valueOf(res) + this.columnDefinition.getLabel(null) + ' ' + tooltips[1] + Messages.getString("ColumnSection.Equal") + this.getValue() + ' ' + tooltips[2] + Messages.getString("ColumnSection.Equal") + this.getColumn3Value() + ' ' + tooltips[3] + Messages.getString("ColumnSection.Equal") + this.getColumn4Value() + ' ' + tooltips[4] + Messages.getString("ColumnSection.Equal") + this.getColumn5Value();
        }
        return res;
    }

    public String getValue() {
        if (this.level == 0 && this.columnDefinition != ColumnDefinition.FCAMCT_COUNT_AVG) {
            if (this.children.size() > 1) {
                if (this.accumulatedValue.doubleValue() < 1.0E-6) {
                    return "0";
                }
                return DataTypeUtilities.getAsString(this.accumulatedValue.doubleValue());
            }
        } else {
            if (this.columnValue != null) {
                if (this.columnValue instanceof Double && (Double)this.columnValue < 1.0E-6) {
                    return "0";
                }
                return DataTypeUtilities.getAsString(this.columnValue);
            }
            if (this.level == 1) {
                if (this.accumulatedValue.doubleValue() < 1.0E-6) {
                    return "0";
                }
                return DataTypeUtilities.getAsString(this.accumulatedValue.doubleValue());
            }
        }
        return this.getColumnDefinition() != null && this.getColumnDefinition().getType().isNumeric() ? "0" : "";
    }

    private String getColumn3Value() {
        return DataTypeUtilities.getAsString(this.column3Value);
    }

    public ColumnDefinition getColumnDefinition() {
        return this.columnDefinition;
    }

    public boolean isExcludeZeroValues() {
        if (this.isRoot()) {
            return this.excludeZeroValues;
        }
        return this.parent.isExcludeZeroValues();
    }

    public boolean isRestrictToCurrentChart() {
        if (this.isRoot()) {
            return this.restrictToCurrentChart;
        }
        return this.parent.isRestrictToCurrentChart();
    }

    public Map<ColumnDefinition, Object> getMap() {
        if (this.isRoot()) {
            return this.map;
        }
        return this.parent.getMap();
    }

    public ChartSpecification getChartDefinition() {
        if (this.chartDefinition == null && this.parent != null) {
            return this.parent.getChartDefinition();
        }
        return this.chartDefinition;
    }

    private void addChild(PieEditorItem item) {
        Object value;
        if (this.isExcludeZeroValues() && this.chartDefinition == null && ((value = this.getMap().get(item.getColumnDefinition())) == null || value instanceof Number && ((Number)value).doubleValue() == 0.0)) {
            return;
        }
        this.children.add(item);
    }

    private void addChild2(PieEditorItem item) {
        Object value;
        if (this.isExcludeZeroValues() && this.level > 0 && ((value = this.getMap().get(item.getColumnDefinition())) == null || value instanceof Number && ((Number)value).doubleValue() == 0.0)) {
            return;
        }
        this.children.add(item);
    }

    public Object getColumnContainment() {
        return this.columnContainment;
    }

    public PieEditorItem findChild(ColumnContainment containment) {
        for (PieEditorItem item : this.children) {
            if (item.getColumnContainment() != null && item.getColumnContainment().equals(containment)) {
                return item;
            }
            PieEditorItem subItem = item.findChild(containment);
            if (subItem == null) continue;
            return subItem;
        }
        return null;
    }

    public PieEditorItem findChild(ColumnDefinition definition) {
        for (PieEditorItem item : this.children) {
            if (item.getColumnDefinition() != null && item.getColumnDefinition().equals(definition)) {
                return item;
            }
            PieEditorItem subItem = item.findChild(definition);
            if (subItem == null) continue;
            return subItem;
        }
        return null;
    }

    private void recalculateStep1() {
        PieEditorItem[] pieEditorItemArray = this.getChildren();
        int n = pieEditorItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            PieEditorItem item = pieEditorItemArray[n2];
            item.recalculateStep1();
            if (this.columnValue == null) {
                if (item.columnValue != null) {
                    this.accumulatedValue = this.accumulatedValue.add(new BigDecimal(((Number)item.columnValue).doubleValue()));
                } else if (item.accumulatedValue != null) {
                    this.accumulatedValue = this.accumulatedValue.add(new BigDecimal(((Number)item.accumulatedValue).doubleValue()));
                }
            }
            ++n2;
        }
        if (this.columnValue != null) {
            this.accumulatedValue = new BigDecimal(((Number)this.columnValue).doubleValue());
        }
    }

    private void recalculateStep2() {
        PieEditorItem[] pieEditorItemArray = this.getChildren();
        int n = pieEditorItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            PieEditorItem item = pieEditorItemArray[n2];
            if (item.columnValue != null && this.getAccumulatedValue().doubleValue() > 0.0) {
                BigDecimal p1 = new BigDecimal(((Number)item.columnValue).doubleValue()).multiply(new BigDecimal(100)).divide(this.getOverallAccumulation(), RoundingMode.HALF_UP).setScale(2, 4);
                item.percentageOfWhole = p1.doubleValue() == 0.0 ? Messages.getString("ExplodingPieChart.Dash") : String.valueOf((double)p1.intValue() == p1.doubleValue() ? new Integer(p1.intValue()).toString() : p1.toString()) + Messages.getString("ExplodingPieChart.percent");
                p1 = new BigDecimal(((Number)item.columnValue).doubleValue()).multiply(new BigDecimal(100)).divide(this.getAccumulatedValue(), RoundingMode.HALF_UP).setScale(2, 4);
                item.percentageOfParent = p1.doubleValue() == 0.0 ? Messages.getString("ExplodingPieChart.Dash") : String.valueOf((double)p1.intValue() == p1.doubleValue() ? new Integer(p1.intValue()).toString() : p1.toString()) + Messages.getString("ExplodingPieChart.percent");
            } else {
                item.percentageOfWhole = Messages.getString("ExplodingPieChart.Dash");
                item.percentageOfParent = Messages.getString("ExplodingPieChart.Dash");
            }
            item.recalculateStep2();
            ++n2;
        }
    }

    private BigDecimal getOverallAccumulation() {
        if (this.isRoot()) {
            return new BigDecimal(0);
        }
        if (this.level == 0) {
            return this.accumulatedValue;
        }
        return this.parent.getOverallAccumulation();
    }

    private String getColumn4Value() {
        return this.percentageOfWhole;
    }

    public String getColumn5Value() {
        return this.percentageOfParent;
    }

    public BigDecimal getAccumulatedValue() {
        if (this.columnValue != null) {
            return new BigDecimal(((Number)this.columnValue).doubleValue());
        }
        return this.accumulatedValue;
    }

    public String getColumnValue(int column) {
        String text = "";
        switch (column) {
            case 0: {
                text = this.getLabel();
                break;
            }
            case 1: {
                if (this.level < 1 && ChartCategorisation.CPUTIME == this.chartCategorisation) {
                    if (this.columnValue instanceof Double && (Double)this.columnValue < 1.0E-6) {
                        return "0";
                    }
                    return DataTypeUtilities.getAsString(this.columnValue);
                }
                if (this.level < 1 && ChartCategorisation.STORAGE == this.chartCategorisation) break;
                text = this.getValue();
                break;
            }
            case 2: {
                if (this.level < 1 && ChartCategorisation.STORAGE == this.chartCategorisation) break;
                text = this.getColumn3Value();
                break;
            }
            case 3: {
                if (this.level < 1 && ChartCategorisation.STORAGE == this.chartCategorisation) break;
                text = this.getColumn4Value();
                break;
            }
            case 4: {
                if (this.level < 1 && ChartCategorisation.STORAGE == this.chartCategorisation) break;
                text = this.getColumn5Value();
                break;
            }
        }
        return text;
    }
}

