/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.dialogs;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.definitions.TableCategorisationEnum;
import com.ibm.cics.pa.ui.Activator;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class TableSelectorContentProvider
implements ITreeContentProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Object input;
    private static final Debug debug = new Debug(TableSelectorContentProvider.class);

    public TableSelectorContentProvider(Object input) {
        debug.enter("TableSelectorContentProvider");
        this.input = input;
        debug.exit("TableSelectorContentProvider", input);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TableCategorisationEnum) {
            return this.process(((TableCategorisationEnum)((Object)parentElement)).getChildren());
        }
        return new Object[0];
    }

    private Object[] process(Object[] group) {
        boolean exclude = Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "EXCLUNAV", false, null);
        ArrayList<Object> children = new ArrayList<Object>();
        Object[] objectArray = group;
        int n = group.length;
        int n2 = 0;
        while (n2 < n) {
            Object id = objectArray[n2];
            if (id instanceof String) {
                ManifestRecord record = ManifestRecord.getAlias((String)id);
                if (record != null) {
                    if (!record.isDateChecked() || record.isPresent() || !exclude) {
                        children.add(record);
                    }
                } else if (!exclude) {
                    children.add(id);
                }
            } else if (id instanceof TableCategorisationEnum) {
                children.add(id);
            }
            ++n2;
        }
        return children.toArray();
    }

    public Object[] getElements(Object inputElement) {
        if (this.input != null && this.input instanceof TableCategorisationEnum) {
            return this.process(((TableCategorisationEnum)((Object)this.input)).getChildren());
        }
        boolean cfr_ignored_0 = inputElement instanceof ManifestRecord;
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return !(element instanceof String);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.input = newInput;
    }
}

