/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.dialogs;

import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.utilities.PredefinedTemplate;
import com.ibm.cics.pa.ui.utilities.SheetViewPersistenceManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class SelectTemplateDialog
extends Dialog
implements ISelectionChangedListener,
IDoubleClickListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    TableViewer list;
    private Button okButton;
    private Object templateName;
    private boolean ignoreSelection = false;
    String templateType;
    IViewPart view;
    private static final int LIST_WIDTH = 40;
    private static final int LIST_HEIGHT = 14;

    public SelectTemplateDialog(IViewPart sheetView, String templateType) {
        super(sheetView.getSite().getShell());
        this.view = sheetView;
        this.templateType = templateType;
        this.setShellStyle(this.getShellStyle() | 0x10000000);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("SelectTemplate_shellTitle"));
        shell.setImage(this.view.getTitleImage());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "com.ibm.cics.pa.ui.sheetview_template_dialog");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateButtons();
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = (Composite)super.createDialogArea(parent);
        Label descLabel = new Label(composite, 64);
        descLabel.setText(MessageFormat.format(Messages.getString("SelectTemplateDialog_description"), this.templateType));
        descLabel.setFont(parent.getFont());
        this.list = new TableViewer(composite, 2816);
        this.list.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return SelectTemplateDialog.this.view.getTitleImage();
            }

            public String getText(Object element) {
                if (element instanceof PredefinedTemplate) {
                    return ((PredefinedTemplate)((Object)element)).getLabel();
                }
                return super.getText(element);
            }
        });
        this.list.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return SelectTemplateDialog.this.getTemplates(SelectTemplateDialog.this.templateType).toArray();
            }
        });
        this.list.setComparator(new ViewerComparator());
        this.list.addSelectionChangedListener((ISelectionChangedListener)this);
        this.list.getTable().setFont(font);
        this.list.setInput(this.getTemplates(this.templateType));
        this.list.addDoubleClickListener((IDoubleClickListener)this);
        Control ctrl = this.list.getControl();
        GridData spec = new GridData(1808);
        spec.widthHint = this.convertWidthInCharsToPixels(40);
        spec.heightHint = this.convertHeightInCharsToPixels(14);
        ctrl.setLayoutData((Object)spec);
        final IAction delete = this.deleteAction();
        MenuManager menuManager = new MenuManager();
        Menu popUpMenu = menuManager.createContextMenu(this.list.getControl());
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (SelectTemplateDialog.this.list.getSelection().isEmpty()) {
                    return;
                }
                manager.add(delete);
            }
        });
        menuManager.setRemoveAllWhenShown(true);
        this.list.getTable().setMenu(popUpMenu);
        this.list.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    SelectTemplateDialog.this.doDelete();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        return composite;
    }

    private IAction deleteAction() {
        Action deleteItem = new Action(Messages.getString("SaveTemplate.delete.template")){

            public void run() {
                SelectTemplateDialog.this.doDelete();
            }

            public ImageDescriptor getImageDescriptor() {
                return Activator.getDefault().getImageDescriptor("delete");
            }
        };
        return deleteItem;
    }

    protected void doDelete() {
        if (this.templateName instanceof String && !Messages.getString("current.label").equals(this.templateName)) {
            String message = NLS.bind((String)Messages.getString("SaveTemplate_deleteQuestion"), (Object)this.templateName);
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            MessageDialog d = new MessageDialog(this.getShell(), Messages.getString("SaveTemplate_confirmDelete"), null, message, 3, buttons, 0){

                protected int getShellStyle() {
                    return super.getShellStyle() | 0x10000000;
                }
            };
            if (d.open() == 0) {
                SheetViewPersistenceManager.getInstance(this.templateType).removeTemplateFilter((String)this.templateName);
                this.templateName = "";
                this.list.setInput(this.getTemplates(this.templateType));
            }
        }
    }

    public Object getTemplateName() {
        return this.templateName;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.ignoreSelection) {
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)this.list.getSelection();
        if (!sel.isEmpty()) {
            this.templateName = sel.getFirstElement();
        }
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.okButton != null) {
            this.okButton.setEnabled(!this.list.getSelection().isEmpty());
        }
    }

    Collection<Object> getTemplates(String templateType) {
        ArrayList<Object> templates = new ArrayList<Object>();
        templates.add(Messages.getString("current.label"));
        templates.addAll(SheetViewPersistenceManager.getInstance(templateType).getTemplates());
        ManifestRecord manifestRecord = ManifestRecord.getAlias(templateType);
        if (manifestRecord != null) {
            for (PredefinedTemplate template : PredefinedTemplate.getCollectionFor(templateType)) {
                templates.add((Object)template);
            }
        }
        Collections.sort(templates, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof PredefinedTemplate) {
                    if (o2 instanceof String) {
                        return -1;
                    }
                    if (o2 instanceof PredefinedTemplate) {
                        return ((PredefinedTemplate)((Object)o1)).getLabel().compareTo(((PredefinedTemplate)((Object)o2)).getLabel());
                    }
                } else if (o2 instanceof PredefinedTemplate) {
                    if (o1 instanceof String) {
                        return 1;
                    }
                } else {
                    return ((String)o1).compareTo((String)o2);
                }
                return 0;
            }
        });
        return templates;
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection sel = (IStructuredSelection)this.list.getSelection();
        if (!sel.isEmpty() && sel.getFirstElement() != null) {
            this.setReturnCode(0);
            this.close();
        }
    }
}

