/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.dialogs;

import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.ReportStyle;
import com.ibm.cics.pa.model.definitions.TableCategorisationEnum;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import java.text.MessageFormat;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeColumnViewerLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class PATreeColumnViewerLabelProvider
extends TreeColumnViewerLabelProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Font boldFont = new Font((Device)Display.getDefault(), "Arial", 8, 1);

    public PATreeColumnViewerLabelProvider(final Boolean withCorners) {
        super((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ManifestRecord) {
                    String append = " (";
                    append = ManifestRecord.limitManifestRead ? String.valueOf(append) + (((ManifestRecord)element).isPresent() ? DataTypeUtilities.getAsString(((ManifestRecord)element).getEarliestRecord()) : Messages.getString("TableDialog.unavailable")) + ")" : String.valueOf(append) + (((ManifestRecord)element).isPresent() ? MessageFormat.format(Messages.getString("Date.fromto"), DataTypeUtilities.getAsString(((ManifestRecord)element).getEarliestRecord()), ((ManifestRecord)element).isRecent() ? ">" + DataTypeUtilities.getAsString(((ManifestRecord)element).getLatestRecord()) + "<" : DataTypeUtilities.getAsString(((ManifestRecord)element).getLatestRecord())) : Messages.getString("TableDialog.unavailable")) + ")";
                    return String.valueOf(((ManifestRecord)element).getDescription()) + append;
                }
                if (element instanceof TableCategorisationEnum) {
                    return ((TableCategorisationEnum)((Object)element)).getLabel();
                }
                if (element instanceof String) {
                    return (String)element;
                }
                if (element instanceof Presentation) {
                    String menu = ((Presentation)element).getMenu();
                    if (Messages.hasString(menu)) {
                        menu = Messages.getString(menu);
                    } else if (!((Presentation)element).getCode().startsWith("/") && !Messages.getString("Menu." + ((Presentation)element).getCode()).startsWith("!")) {
                        menu = Messages.getString("Menu." + ((Presentation)element).getCode());
                    }
                    return menu;
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof TableCategorisationEnum) {
                    switch ((TableCategorisationEnum)((Object)element)) {
                        case TYPE1: 
                        case TYPE345: 
                        case TYPE111: {
                            return Activator.getDefault().getImage("smfcategory");
                        }
                    }
                    return Activator.getDefault().getImage("smf");
                }
                if (element instanceof Presentation) {
                    return ReportStyle.deriveFromImplType(((Presentation)element).getImplType()).getImage();
                }
                if (element instanceof ManifestRecord) {
                    return ((ManifestRecord)element).getImage();
                }
                if (withCorners.booleanValue() && element instanceof TableCategorisationEnum) {
                    return Activator.getDefault().getImage("tree_filler");
                }
                if (element instanceof String) {
                    return Activator.getDefault().getImage("missingman");
                }
                return null;
            }
        });
        this.setProviders(new IColorProvider(){

            public Color getForeground(Object element) {
                if (element instanceof ManifestRecord) {
                    if (((ManifestRecord)element).isRecent()) {
                        return ColorConstants.darkBlue;
                    }
                    if (((ManifestRecord)element).isPresent()) {
                        return ColorConstants.blue;
                    }
                } else if (element instanceof Presentation) {
                    return ColorConstants.blue;
                }
                return ColorConstants.darkGray;
            }

            public Color getBackground(Object element) {
                return null;
            }
        });
    }

    public String getToolTipText(Object element) {
        if (element instanceof ManifestRecord) {
            if (!((ManifestRecord)element).isPresent()) {
                return MessageFormat.format(Messages.getString("Overview.notable"), ((ManifestRecord)element).getDescription(), ((ManifestRecord)element).getAlias());
            }
            return String.valueOf(this.getText(element)) + (StringUtil.hasContent((String)((ManifestRecord)element).getVRM()) ? String.valueOf('\n') + ColumnDefinition.VRM.getLabel(null) + ' ' + ((ManifestRecord)element).getVRM() : "");
        }
        if (element instanceof String) {
            return MessageFormat.format(Messages.getString("Overview.missing"), element);
        }
        return this.getText(element);
    }

    public void dispose() {
        super.dispose();
        if (this.boldFont != null && !this.boldFont.isDisposed()) {
            this.boldFont.dispose();
        }
    }

    public Font getFont(Object element) {
        if (element instanceof ManifestRecord && ((ManifestRecord)element).isRecent()) {
            return this.boldFont;
        }
        if (element instanceof ManifestRecord || element instanceof String || this.boldFont == null || this.boldFont.isDisposed()) {
            return null;
        }
        return null;
    }
}

