/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.builder;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.ui.QueryCache;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class ResourceChangeListener
implements IResourceChangeListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Logger logger = Logger.getLogger(ResourceChangeListener.class.getPackage().getName());

    public void resourceChanged(IResourceChangeEvent event) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"resourceChanged");
        if (event.getType() == 1) {
            IResourceDelta rootDelta = event.getDelta();
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isAccessible()) {
                    try {
                        if (project.hasNature("com.ibm.cics.pa.ui.panature")) {
                            this.analyseDelta(rootDelta.findMember(project.getFullPath()));
                        }
                    }
                    catch (CoreException e) {
                        Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"resourceChanged", (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"resourceChanged");
    }

    private void analyseDelta(IResourceDelta delta) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"analyseDelta", (Object)delta);
        if (delta != null) {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren(7);
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta delta1 = iResourceDeltaArray[n2];
                this.analyseDelta(delta1);
                ++n2;
            }
            try {
                new XMLFileVisitor().visit(delta);
            }
            catch (CoreException e) {
                Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"analyseDelta", (Throwable)e);
            }
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"analyseDelta");
    }

    void checkXML(IResource resource) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"checkXML");
        if (resource instanceof IFile && resource.getFileExtension().equalsIgnoreCase("xml") && resource.isAccessible()) {
            try {
                QueryCache.getInstance().updateReference(((IFile)resource).getContents(), (IFile)resource);
            }
            catch (CoreException e) {
                Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"checkXML", (Throwable)e);
            }
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"checkXML");
    }

    void removeXML(IResource resource) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"removeXML");
        if (resource instanceof IFile && resource.getFileExtension().equalsIgnoreCase("xml") && resource.isAccessible()) {
            QueryCache.getInstance().removeReference(((IFile)resource).getFullPath().toString());
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"removeXML");
    }

    class XMLFileVisitor
    implements IResourceDeltaVisitor {
        XMLFileVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"visit");
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    ResourceChangeListener.this.checkXML(resource);
                    break;
                }
                case 2: {
                    ResourceChangeListener.this.removeXML(resource);
                    break;
                }
                case 4: {
                    ResourceChangeListener.this.checkXML(resource);
                }
            }
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"visit", (Object)true);
            return true;
        }
    }
}

