/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui;

import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.pa.model.Chart;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.Histogram;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.Pie;
import com.ibm.cics.pa.model.PlotModel;
import com.ibm.cics.pa.model.SortedCSVFile;
import com.ibm.cics.pa.model.TransactionPerformanceListModel;
import com.ibm.cics.pa.model.YardStick;
import com.ibm.cics.pa.model.definitions.ChartCategorisation;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.ColumnAssociationMapper;
import com.ibm.cics.pa.model.definitions.ColumnContainment;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.HistogramChartSpecificDefinitions;
import com.ibm.cics.pa.model.definitions.IntervalSpecificDefinitions;
import com.ibm.cics.pa.model.definitions.PersistedChartDefinition;
import com.ibm.cics.pa.model.definitions.PieChartSpecificDefinitions;
import com.ibm.cics.pa.model.definitions.SortedCombinedHistogramLineSpecificDefinitions;
import com.ibm.cics.pa.ui.figures.ChartSelectable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChartManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static ChartManager instance = null;
    private double accumulator = 0.0;
    private static final List<ColumnDefinition> defaultCompatibilityList = Arrays.asList(ColumnDefinition.START_DATE, ColumnDefinition.START_TIME);
    private static final List<ColumnDefinition> defaultCompatibilityList1 = Arrays.asList(ColumnDefinition.START, ColumnDefinition.STOP);
    private Map<String, PlotModel> followUpList = new HashMap<String, PlotModel>();

    public static boolean isCompatible(GenericDataProvider dataProvider) {
        if (dataProvider == null) {
            return false;
        }
        ArrayList<ColumnDefinition> headers = new ArrayList<ColumnDefinition>();
        int i = 0;
        while (i < dataProvider.getColumnDefinitions().length) {
            headers.add(dataProvider.getColumnDefinitions()[i]);
            ++i;
        }
        return headers.containsAll(defaultCompatibilityList) || headers.containsAll(defaultCompatibilityList1);
    }

    public String createChart(ChartSpecification chartReference, GenericDataProvider dataProvider, String elementName, IUniqueRecord record, IProgressMonitor monitor) {
        if (chartReference != null && ChartManager.isCompatible(dataProvider)) {
            switch (chartReference.getType()) {
                case YARDSTICK: {
                    return this.createYardStick(chartReference, dataProvider, elementName, record, monitor);
                }
                case PIE: {
                    return this.createPieChart(chartReference, dataProvider, elementName, record);
                }
                case SHEET: {
                    return dataProvider.getFileReference();
                }
                case COMBINEDHISTOGRAMLINE: {
                    if (!dataProvider.isRemote()) {
                        SortedCSVFile altDataProvider = SortedCSVFile.getFor(dataProvider, ((SortedCombinedHistogramLineSpecificDefinitions)chartReference.getSpecificType()).getSortColumn(), ((SortedCombinedHistogramLineSpecificDefinitions)chartReference.getSpecificType()).isSortDescending());
                        return this.createHistogram(chartReference, altDataProvider, record, monitor);
                    }
                }
                case HISTOGRAM: 
                case COMPACT_HISTOGRAM: {
                    return this.createHistogram(chartReference, dataProvider, record, monitor);
                }
                case INTERVAL_PLOT: {
                    return this.createInterval(chartReference, dataProvider, elementName, record, monitor);
                }
                case PERFORMANCE_RECORD: {
                    return this.createPerformanceRecord(chartReference, dataProvider, elementName, record, monitor);
                }
            }
        }
        return "";
    }

    private String createPerformanceRecord(ChartSpecification chartReference, GenericDataProvider dataProvider, String elementName, IUniqueRecord record, IProgressMonitor monitor) {
        Map<ColumnDefinition, Object> map = this.populateSingleRowValues(dataProvider);
        if (map.isEmpty()) {
            return "";
        }
        TransactionPerformanceListModel model = new TransactionPerformanceListModel(chartReference, dataProvider, map, elementName);
        return model.getChartId();
    }

    private String createInterval(ChartSpecification chartReference, GenericDataProvider dataProvider, String elementName, IUniqueRecord record, IProgressMonitor monitor) {
        String key;
        PlotModel originalModel;
        if (elementName == null) {
            return "";
        }
        if (!this.followUpList.isEmpty() && (originalModel = this.followUpList.get(key = Chart.calculateReference(chartReference, elementName))) != null) {
            PlotModel modelAdditional = new PlotModel(chartReference, dataProvider, elementName);
            originalModel.augmentWith(modelAdditional);
            this.followUpList.remove(key);
            return null;
        }
        PlotModel model = new PlotModel(chartReference, dataProvider, elementName);
        Presentation presentation2 = ((IntervalSpecificDefinitions)chartReference.getSpecificType()).getMergePresentation();
        if (presentation2 != null) {
            String id = Chart.calculateReference(PersistedChartDefinition.getDefinition(presentation2), elementName);
            this.followUpList.put(id, model);
        }
        return model.getChartId();
    }

    public String createYardStick(ChartSpecification chartReference, GenericDataProvider dataStore, String key, IUniqueRecord record, IProgressMonitor monitor) {
        Object[][] rows = dataStore.getData(monitor);
        if (rows.length == 0) {
            return "";
        }
        Map<ColumnDefinition, Object> vals = this.populateSingleRowValuesExplodingPie(chartReference, dataStore.getColumnDefinitions(), rows[0]);
        YardStick model = new YardStick(chartReference, dataStore, vals, key, record);
        return model.getChartId();
    }

    private String createPieChart(ChartSpecification chartReference, GenericDataProvider dataStore, String key, IUniqueRecord record) {
        IUniqueRecord revisedrecord = record;
        Collection<IUniqueRecord> results = dataStore.getAllResults();
        if (revisedrecord == null && !results.isEmpty()) {
            IUniqueRecord[] fist = results.toArray(new IUniqueRecord[results.size()]);
            revisedrecord = fist[0];
        }
        if (revisedrecord == null) {
            return "";
        }
        Map<ColumnDefinition, Object> vals = this.populateSingleRowValuesExplodingPie(chartReference, dataStore.getColumnDefinitions(), revisedrecord.getRow());
        Pie model = new Pie(chartReference, dataStore, vals, key, revisedrecord);
        model.setNoHeader(!((PieChartSpecificDefinitions)chartReference.getSpecificType()).isHeader());
        return model.getChartId();
    }

    public String createHistogram(ChartSpecification chartReference, GenericDataProvider dataStore, IUniqueRecord record, IProgressMonitor monitor) {
        int[] columnData = new int[((HistogramChartSpecificDefinitions)chartReference.getSpecificType()).getPrimaryReqts().length];
        String[] keyReferencesAxis1 = new String[((HistogramChartSpecificDefinitions)chartReference.getSpecificType()).getPrimaryReqts().length];
        int ctr = 0;
        ColumnDefinition[] columnDefinitionArray = ((HistogramChartSpecificDefinitions)chartReference.getSpecificType()).getPrimaryReqts();
        int n = columnDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition lookup = columnDefinitionArray[n2];
            columnData[ctr] = this.getKeyColumn(dataStore.getColumnDefinitions(), lookup);
            keyReferencesAxis1[ctr] = lookup.label();
            ++ctr;
            ++n2;
        }
        if (monitor != null && monitor.isCanceled()) {
            return "";
        }
        int[] secondaryColumnData = new int[((HistogramChartSpecificDefinitions)chartReference.getSpecificType()).getSecondaryReqts().length];
        String[] keyReferencesAxis2 = new String[((HistogramChartSpecificDefinitions)chartReference.getSpecificType()).getSecondaryReqts().length];
        ctr = 0;
        ColumnDefinition[] columnDefinitionArray2 = ((HistogramChartSpecificDefinitions)chartReference.getSpecificType()).getSecondaryReqts();
        int n3 = columnDefinitionArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            ColumnDefinition lookup = columnDefinitionArray2[n4];
            secondaryColumnData[ctr] = this.getKeyColumn(dataStore.getColumnDefinitions(), lookup);
            keyReferencesAxis2[ctr] = lookup.label();
            ++ctr;
            ++n4;
        }
        if (monitor != null && monitor.isCanceled()) {
            return "";
        }
        List<ChartSelectable> primaryColumns = dataStore.getSelectableColumns(chartReference, monitor);
        if (monitor != null && monitor.isCanceled()) {
            return "";
        }
        Histogram model = new Histogram(chartReference, dataStore, record, primaryColumns);
        return model.getChartId();
    }

    public static ChartManager getInstance() {
        if (instance == null) {
            instance = new ChartManager();
        }
        return instance;
    }

    private int getKeyColumn(ColumnDefinition[] columnDefinition, ColumnDefinition columnLookup) {
        int column = 0;
        int i = 0;
        while (i < columnDefinition.length) {
            if (columnLookup.equals(columnDefinition[i])) {
                return i;
            }
            ++i;
        }
        return column;
    }

    private Map<ColumnDefinition, Object> populateSingleRowValues(GenericDataProvider dataProvider) {
        ColumnDefinition[] columnDefinitions = dataProvider.getColumnDefinitions();
        HashMap<ColumnDefinition, Object> map = new HashMap<ColumnDefinition, Object>();
        if (dataProvider.getData().length > 0) {
            Object[] row = dataProvider.getData()[0];
            int i = 0;
            while (i < columnDefinitions.length) {
                map.put(columnDefinitions[i], row[i]);
                ++i;
            }
        }
        return map;
    }

    private Map<ColumnDefinition, Object> populateSingleRowValuesExplodingPie(ChartSpecification chartReference, ColumnDefinition[] columnDefinitions, Object[] row) {
        int otherCount3;
        ColumnDefinition[] i22;
        ColumnDefinition count2;
        int i;
        int i32;
        int n;
        this.accumulator = 0.0;
        ColumnContainment[] columnLookup = ((PieChartSpecificDefinitions)chartReference.getSpecificType()).getContainments();
        HashMap<ColumnDefinition, Object> map = new HashMap<ColumnDefinition, Object>();
        Object[] objectArray = columnLookup;
        int n2 = columnLookup.length;
        int n3 = 0;
        while (n3 < n2) {
            ColumnContainment lookup = objectArray[n3];
            if (lookup.getPrimary() != ColumnDefinition.UNKNOWN) {
                int i4 = 0;
                while (i4 < columnDefinitions.length) {
                    Object value;
                    if (lookup.getPrimary() == ColumnDefinition.UNCAPTURED_WAIT_TIME_AVG) {
                        if (ColumnDefinition.SUSPEND_TIME_AVG.equals(columnDefinitions[i4]) && (value = row[i4]) != null && value instanceof Number && ((Number)value).doubleValue() > 0.0) {
                            value = (Double)value - this.accumulator;
                            map.put(lookup.getPrimary(), value);
                            this.accumulator = 0.0;
                        }
                    } else if (lookup.getPrimary().equals(columnDefinitions[i4]) && (value = row[i4]) != null && value instanceof Number && ((Number)value).doubleValue() > 0.0) {
                        map.put(lookup.getPrimary(), value);
                        this.accumulator += ((Number)value).doubleValue();
                    }
                    ++i4;
                }
            }
            ColumnDefinition[] columnDefinitionArray = lookup.getColumnRef();
            n = columnDefinitionArray.length;
            int value = 0;
            while (value < n) {
                ColumnDefinition column = columnDefinitionArray[value];
                i32 = 0;
                while (i32 < columnDefinitions.length) {
                    Object value2;
                    if (column.equals(columnDefinitions[i32]) && (value2 = row[i32]) != null && value2 instanceof Number && ((Number)value2).doubleValue() > 0.0) {
                        map.put(column, value2);
                        this.accumulator += ((Number)value2).doubleValue();
                    }
                    ++i32;
                }
                ++value;
            }
            ++n3;
        }
        if (ChartCategorisation.FILEUSAGE == chartReference.getCategorisation()[0]) {
            double otherTime = 0.0;
            double otherCount2 = 0.0;
            int i5 = 0;
            while (i5 < columnDefinitions.length) {
                if (ColumnDefinition.SUSPEND_TIME_AVG == columnDefinitions[i5] && row[i5] instanceof Number) {
                    map.put(ColumnDefinition.SUSPEND_TIME_AVG, row[i5]);
                    map.put(ColumnDefinition.OTHER_SUSPEND_TIME, otherTime += ((Number)row[i5]).doubleValue());
                } else if (ColumnDefinition.SUSPEND_COUNT_AVG == columnDefinitions[i5] && row[i5] instanceof Number) {
                    map.put(ColumnDefinition.OTHER_SUSPEND_COUNT, otherCount2 += ((Number)row[i5]).doubleValue());
                }
                ++i5;
            }
            ArrayList<ColumnDefinition> defns = new ArrayList<ColumnDefinition>();
            ColumnDefinition[] i32 = ColumnContainment.SUSPEND_TIME_AVG.getColumnRef();
            int n4 = i32.length;
            n = 0;
            while (n < n4) {
                ColumnDefinition defn = i32[n];
                ColumnDefinition alternateCount = ColumnAssociationMapper.getTimeToCount(defn);
                if (alternateCount != null) {
                    defns.add(alternateCount);
                }
                ++n;
            }
            i32 = ColumnContainment.SUSPEND_TIME_AVG.getColumnRef();
            n4 = i32.length;
            n = 0;
            while (n < n4) {
                ColumnDefinition countDefinition = i32[n];
                if (countDefinition != null) {
                    int i22 = 0;
                    while (i22 < columnDefinitions.length) {
                        if (countDefinition == columnDefinitions[i22] && row[i22] instanceof Number) {
                            map.put(countDefinition, row[i22]);
                            map.put(ColumnDefinition.OTHER_SUSPEND_TIME, otherTime -= ((Number)row[i22]).doubleValue());
                        }
                        ++i22;
                    }
                }
                ++n;
            }
            for (ColumnDefinition countDefinition2 : defns) {
                if (countDefinition2 == null) continue;
                int i6 = 0;
                while (i6 < columnDefinitions.length) {
                    if (countDefinition2 == columnDefinitions[i6] && row[i6] instanceof Number) {
                        map.put(countDefinition2, row[i6]);
                        map.put(ColumnDefinition.OTHER_SUSPEND_COUNT, otherCount2 -= ((Number)row[i6]).doubleValue());
                    }
                    ++i6;
                }
            }
        } else if (ChartCategorisation.TRANSIENT_DATA == chartReference.getCategorisation()[0]) {
            double otherTime = 0.0;
            double otherCount3 = 0.0;
            double suspendOtherTime = 0.0;
            i = 0;
            while (i < columnDefinitions.length) {
                if (ColumnDefinition.TDTOTAL_COUNT_AVG == columnDefinitions[i] && row[i] instanceof Number) {
                    map.put(ColumnDefinition.TDTOTAL_COUNT_AVG, row[i]);
                    map.put(ColumnDefinition.TDOTHER_COUNT_AVG, otherTime += ((Number)row[i]).doubleValue());
                } else if (ColumnDefinition.SUSPEND_TIME_AVG == columnDefinitions[i] && row[i] instanceof Number) {
                    map.put(ColumnDefinition.SUSPEND_TIME_AVG, row[i]);
                    map.put(ColumnDefinition.OTHER_SUSPEND_TIME, suspendOtherTime += ((Number)row[i]).doubleValue());
                    count2 = ColumnAssociationMapper.getTimeToCount(ColumnDefinition.SUSPEND_TIME_AVG);
                    if (count2 != null) {
                        map.put(ColumnDefinition.OTHER_SUSPEND_COUNT, otherCount3);
                    }
                } else if (ColumnDefinition.SUSPEND_COUNT_AVG == columnDefinitions[i] && row[i] instanceof Number) {
                    map.put(ColumnDefinition.OTHER_SUSPEND_COUNT, otherCount3 += ((Number)row[i]).doubleValue());
                }
                ++i;
            }
            i22 = ColumnContainment.TDTOTAL_COUNT_AVG.getColumnRef();
            i32 = i22.length;
            int count2 = 0;
            while (count2 < i32) {
                ColumnDefinition countDefinition = i22[count2];
                if (countDefinition != null) {
                    int i7 = 0;
                    while (i7 < columnDefinitions.length) {
                        if (countDefinition == columnDefinitions[i7] && row[i7] instanceof Number) {
                            map.put(countDefinition, row[i7]);
                            map.put(ColumnDefinition.TDOTHER_COUNT_AVG, otherTime -= ((Number)row[i7]).doubleValue());
                        }
                        ++i7;
                    }
                }
                ++count2;
            }
            ArrayList<ColumnDefinition> defns = new ArrayList<ColumnDefinition>();
            ColumnDefinition[] i7 = ColumnContainment.SUSPEND_TIME_AVG2.getColumnRef();
            int i22 = i7.length;
            i32 = 0;
            while (i32 < i22) {
                ColumnDefinition defn = i7[i32];
                ColumnDefinition alternateCount = ColumnAssociationMapper.getTimeToCount(defn);
                if (alternateCount != null) {
                    defns.add(alternateCount);
                }
                ++i32;
            }
            i7 = ColumnContainment.SUSPEND_TIME_AVG2.getColumnRef();
            i22 = i7.length;
            i32 = 0;
            while (i32 < i22) {
                ColumnDefinition countDefinition = i7[i32];
                if (countDefinition != null) {
                    int i8 = 0;
                    while (i8 < columnDefinitions.length) {
                        if (countDefinition == columnDefinitions[i8] && row[i8] instanceof Number) {
                            map.put(countDefinition, row[i8]);
                            map.put(ColumnDefinition.OTHER_SUSPEND_TIME, suspendOtherTime -= ((Number)row[i8]).doubleValue());
                        }
                        ++i8;
                    }
                }
                ++i32;
            }
            for (ColumnDefinition countDefinition : defns) {
                if (countDefinition == null) continue;
                i22 = 0;
                while (i22 < columnDefinitions.length) {
                    if (countDefinition == columnDefinitions[i22] && row[i22] instanceof Number) {
                        map.put(countDefinition, row[i22]);
                        map.put(ColumnDefinition.OTHER_SUSPEND_COUNT, otherCount3 -= ((Number)row[i22]).doubleValue());
                    }
                    ++i22;
                }
            }
        } else if (ChartCategorisation.CPUTIME == chartReference.getCategorisation()[0]) {
            objectArray = new ColumnDefinition[]{ColumnDefinition.CPUISSPE_TIME_AVG, ColumnDefinition.CPUONCPE_TIME_AVG, ColumnDefinition.CPUONCP_TIME_AVG, ColumnDefinition.CPUONSP_TIME_AVG};
            otherCount3 = objectArray.length;
            n3 = 0;
            while (n3 < otherCount3) {
                Object countDefinition = objectArray[n3];
                if (countDefinition != null) {
                    int i9 = 0;
                    while (i9 < columnDefinitions.length) {
                        if (countDefinition == columnDefinitions[i9] && row[i9] instanceof Number) {
                            map.put((ColumnDefinition)countDefinition, row[i9]);
                        }
                        ++i9;
                    }
                }
                ++n3;
            }
        } else if (ChartCategorisation.RMI == chartReference.getCategorisation()[0]) {
            objectArray = new ColumnContainment[]{ColumnContainment.RMITIME_COUNT_AVG};
            otherCount3 = objectArray.length;
            n3 = 0;
            while (n3 < otherCount3) {
                Object contain = objectArray[n3];
                ColumnDefinition[] countDefinition = ((ColumnContainment)contain).getColumnRef();
                int defns = countDefinition.length;
                int countDefinition2 = 0;
                while (countDefinition2 < defns) {
                    ColumnDefinition countDefinition3 = countDefinition[countDefinition2];
                    if (countDefinition3 != null) {
                        i32 = 0;
                        while (i32 < columnDefinitions.length) {
                            if (countDefinition3 == columnDefinitions[i32] && row[i32] instanceof Number) {
                                map.put(countDefinition3, row[i32]);
                            }
                            ++i32;
                        }
                    }
                    ++countDefinition2;
                }
                ++n3;
            }
        } else if (ChartCategorisation.TEMPORARY_STORAGE == chartReference.getCategorisation()[0]) {
            double otherTime = 0.0;
            double otherCount4 = 0.0;
            double suspendOtherTime = 0.0;
            i = 0;
            while (i < columnDefinitions.length) {
                if (ColumnDefinition.TSTOTAL_COUNT_AVG == columnDefinitions[i] && row[i] instanceof Number) {
                    map.put(ColumnDefinition.TSTOTAL_COUNT_AVG, row[i]);
                    map.put(ColumnDefinition.TSOTHER_COUNT_AVG, otherTime += ((Number)row[i]).doubleValue());
                } else if (ColumnDefinition.SUSPEND_TIME_AVG == columnDefinitions[i] && row[i] instanceof Number) {
                    map.put(ColumnDefinition.SUSPEND_TIME_AVG, row[i]);
                    map.put(ColumnDefinition.OTHER_SUSPEND_TIME, suspendOtherTime += ((Number)row[i]).doubleValue());
                    count2 = ColumnAssociationMapper.getTimeToCount(ColumnDefinition.SUSPEND_TIME_AVG);
                    if (count2 != null) {
                        map.put(ColumnDefinition.OTHER_SUSPEND_COUNT, otherCount4);
                    }
                } else if (ColumnDefinition.SUSPEND_COUNT_AVG == columnDefinitions[i] && row[i] instanceof Number) {
                    map.put(ColumnDefinition.OTHER_SUSPEND_COUNT, otherCount4 += ((Number)row[i]).doubleValue());
                }
                ++i;
            }
            i22 = ColumnContainment.TSTOTAL_COUNT_AVG.getColumnRef();
            i32 = i22.length;
            int count3 = 0;
            while (count3 < i32) {
                ColumnDefinition countDefinition = i22[count3];
                if (countDefinition != null) {
                    int i10 = 0;
                    while (i10 < columnDefinitions.length) {
                        if (countDefinition == columnDefinitions[i10] && row[i10] instanceof Number) {
                            map.put(countDefinition, row[i10]);
                            map.put(ColumnDefinition.TSOTHER_COUNT_AVG, otherTime -= ((Number)row[i10]).doubleValue());
                        }
                        ++i10;
                    }
                }
                ++count3;
            }
            ArrayList<ColumnDefinition> defns = new ArrayList<ColumnDefinition>();
            ColumnDefinition[] columnDefinitionArray = ColumnContainment.SUSPEND_TIME_AVG1.getColumnRef();
            int i11 = columnDefinitionArray.length;
            i32 = 0;
            while (i32 < i11) {
                ColumnDefinition defn = columnDefinitionArray[i32];
                ColumnDefinition alternateCount = ColumnAssociationMapper.getTimeToCount(defn);
                if (alternateCount != null) {
                    defns.add(alternateCount);
                }
                ++i32;
            }
            columnDefinitionArray = ColumnContainment.SUSPEND_TIME_AVG1.getColumnRef();
            i11 = columnDefinitionArray.length;
            i32 = 0;
            while (i32 < i11) {
                ColumnDefinition countDefinition = columnDefinitionArray[i32];
                if (countDefinition != null) {
                    int i12 = 0;
                    while (i12 < columnDefinitions.length) {
                        if (countDefinition == columnDefinitions[i12] && row[i12] instanceof Number) {
                            map.put(countDefinition, row[i12]);
                            map.put(ColumnDefinition.OTHER_SUSPEND_TIME, suspendOtherTime -= ((Number)row[i12]).doubleValue());
                        }
                        ++i12;
                    }
                }
                ++i32;
            }
            for (ColumnDefinition countDefinition : defns) {
                if (countDefinition == null) continue;
                i11 = 0;
                while (i11 < columnDefinitions.length) {
                    if (countDefinition == columnDefinitions[i11] && row[i11] instanceof Number) {
                        map.put(countDefinition, row[i11]);
                        map.put(ColumnDefinition.OTHER_SUSPEND_COUNT, otherCount4 -= ((Number)row[i11]).doubleValue());
                    }
                    ++i11;
                }
            }
        }
        if (!map.isEmpty()) {
            objectArray = columnLookup;
            int n5 = columnLookup.length;
            n3 = 0;
            while (n3 < n5) {
                Object lookup = objectArray[n3];
                if (map.get(((ColumnContainment)lookup).getPrimary()) == null) {
                    Double value = 0.0;
                    ColumnDefinition[] i13 = ((ColumnContainment)lookup).getColumnRef();
                    int n6 = i13.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        ColumnDefinition column = i13[n7];
                        if (map.get(column) != null) {
                            value = value + ((Number)map.get(column)).doubleValue();
                        }
                        ++n7;
                    }
                    if (value > 0.0) {
                        map.put(((ColumnContainment)lookup).getPrimary(), value);
                        this.accumulator += ((Number)value).doubleValue();
                    }
                }
                ++n3;
            }
        }
        objectArray = map.keySet().toArray();
        int n8 = objectArray.length;
        n3 = 0;
        while (n3 < n8) {
            Object columnDefinition = objectArray[n3];
            ColumnDefinition[] columnDefinitionArray = new ColumnDefinition[]{ColumnAssociationMapper.getTimeToCount((ColumnDefinition)columnDefinition), ColumnAssociationMapper.getGetmainToFreemainBytes((ColumnDefinition)columnDefinition), ColumnAssociationMapper.getGetmainToSharedBytes((ColumnDefinition)columnDefinition), ColumnAssociationMapper.getGetmainToOccupancy((ColumnDefinition)columnDefinition), ColumnAssociationMapper.getGetmainToHighwater((ColumnDefinition)columnDefinition), ColumnAssociationMapper.getFileSpecific((ColumnDefinition)columnDefinition)};
            int n9 = columnDefinitionArray.length;
            int n10 = 0;
            while (n10 < n9) {
                ColumnDefinition countDefinition = columnDefinitionArray[n10];
                if (countDefinition != null) {
                    int i14 = 0;
                    while (i14 < columnDefinitions.length) {
                        if (countDefinition == columnDefinitions[i14]) {
                            map.put(countDefinition, row[i14]);
                        }
                        ++i14;
                    }
                }
                ++n10;
            }
            ++n3;
        }
        return map;
    }
}

