/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.ApplicationType;
import com.ibm.cics.core.model.PlatformType;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.eclipse.common.IConnectionPasswordStorage;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ui.ModelUIPlugin;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.PAContextTracker;
import com.ibm.cics.pa.ui.QueryCache;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.etools.zusage.core.UsagePlugin;
import com.ibm.etools.zusage.core.model.IOfferingUsageRegistry;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2022 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    public static final String PLUGIN_ID = "com.ibm.cics.pa.ui";
    public static final String IMGD_PIE = "pie";
    public static final String IMGD_LINE = "line";
    public static final String IMGD_HISTOGRAM = "histogram";
    public static final String IMGD_DATASHEET = "table";
    public static final String IMGD_DATASHEET_D = "table_d";
    public static final String IMGD_DATASRC = "dataSource";
    public static final String IMGD_LEGEND = "legend";
    public static final String IMG_UPARROW = "upArrow";
    public static final String IMG_DOWNARROW = "downArrow";
    public static final String IMGD_TRAN = ColumnDefinition.TRAN.getDBColumnRef();
    public static final String IMGD_DATE = ColumnDefinition.START_DATE.getDBColumnRef();
    public static final String IMGD_DATE_D = "date_d";
    public static final String IMGD_REGION = ColumnDefinition.APPLID.getDBColumnRef();
    public static final String IMGD_WAITING = ColumnDefinition.START_TIME.getDBColumnRef();
    public static final String IMGD_CTG = "ctg";
    public static final String IMGD_TSQUEUE = "tsq";
    public static final String IMGD_TRANSIENT = "transient";
    public static final String IMGD_LOG = "log";
    public static final String IMGD_COUNT = "count";
    public static final String IMGD_CALLEES = "callees";
    public static final String IMGD_MISC = "misc";
    public static final String IMGD_EVENT = "event";
    public static final String PACONNECTION = "PARef";
    public static final String IMGD_SNA = "sna";
    public static final String IMG_ADD = "add";
    public static final String IMG_REFRESH = "refresh";
    public static final String IMGD_ID_MAP = "idmap";
    public static final String IMGD_LINK = "link";
    public static final String IMGD_WARN = "warning";
    public static final String IMGD_INFO = "information";
    public static final String IMGD_CRITICAL = "critical";
    public static final String IMGD_CORNER = "tree_filler";
    public static final String IMGD_RUN = "run";
    public static final String IMGD_CLEAR = "clear";
    public static final String IMG_OVERVIEW = "prod-ov-nav";
    public static final String IMGD_RESET = "reset";
    public static final String IMGD_DELETE_SORT = "deletesort";
    public static final String IMGD_RESOURCE_GROUP_DEFINITION = "resourceGroup";
    public static final String IMGD_TREE = "ntree";
    public static final String IMGD_PROPERTIES = "properties";
    public static final String IMG_DELETE = "delete";
    public static final String IMG_CLOUD = "cloud";
    public static final String IMG_MONITOR = "monitor";
    public static final String IMG_ANALYSIS_HISTORY = "anal_history";
    public static final String IMG_IMPORT_LAYOUT = "import_layout";
    public static final String IMG_EXPORT_LAYOUT = "export_layout";
    public static final String IMG_CHECKPOINT = "check_point";
    public static final String IMG_ALERT = "alert";
    public static final String IMG_ALERT_ICON = "alert_icon";
    public static final String IMG_CHEAT = "cheat";
    public static final String IMG_INTERVAL = "interval";
    public static final String IMG_SMF = "smf";
    public static final String IMG_SMF_CAT = "smfcategory";
    public static final String IMG_MISSING_MANIFEST = "missingman";
    public static final String IMG_CUSTOM_COLUMNS = "custcols";
    public static final String IMG_PROFILER_LARGE = "largepro";
    public static final String IMG_PROFILER_SMALL = "smallpro";
    public static final String IMG_SECURITY = "security";
    public static final String OPTION_DEBUG_GENERAL = "com.ibm.cics.pa.ui/general";
    public static boolean DEBUG_GENERAL = "true".equals(Platform.getDebugOption((String)"com.ibm.cics.pa.ui/general"));
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String CONNECTIONS = "connections";
    public static final String PA_REMOTE = "remote.pasource";
    private static Color offWhite;
    public static final int ALPHA = 150;
    public static final int MINI_ALPHA = 200;
    public static final int ALPHA_MAX = 255;
    public static final String TIME_FORMAT = "HH.mm.ss";
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.SSSSSS";
    public static final String CSV_TIME_FORMAT = "HH:mm:ss.SSS";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String CSV_DATE_FORMAT = "dd/MM/yyyy";
    public static final String ALT_CSV_DATE_FORMAT = "dd-MM-yyyy";
    public Pattern greyPattern = null;
    public Pattern lightgreyPattern = null;
    public Pattern altlightgreyPattern = null;
    public Pattern SMTPattern = null;
    public Pattern bluePattern = null;
    private IConnectionPasswordStorage passwordStorage;
    public Font fontArialLarge;
    public Font fontArialSmall;
    public Font fontArial;
    public static boolean EXPERIMENT;
    public static final String CSV_TIMESTAMP_FORMAT = "yyyy-MM-dd-HH:mm:ss";
    ColorRegistry colorRegistry;
    private static Activator plugin;

    static {
        EXPERIMENT = true;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        offWhite = new Color((Device)Display.getDefault(), 204, 204, 204);
        this.lightgreyPattern = new Pattern(null, 8.0f, 0.0f, 0.0f, 8.0f, ColorConstants.lightGray, 100, ColorConstants.white, 250);
        this.altlightgreyPattern = new Pattern(null, 0.0f, 0.0f, 8.0f, 8.0f, ColorConstants.lightGray, 100, ColorConstants.white, 250);
        this.SMTPattern = new Pattern(null, 0.0f, 2.0f, 2.0f, 0.0f, ColorConstants.orange, 50, ColorConstants.white, 250);
        this.greyPattern = new Pattern(null, 2.0f, 0.0f, 0.0f, 2.0f, ColorConstants.gray, ColorConstants.white);
        this.bluePattern = new Pattern(null, 0.0f, 0.0f, 4.0f, 4.0f, ColorConstants.darkBlue, ColorConstants.lightGray);
        if (DEBUG_GENERAL) {
            logger.setLevel(Level.FINER);
        }
        logger.setUseParentHandlers(true);
        QueryCache.getInstance();
        try {
            Class.forName("com.ibm.db2.jcc.DB2Driver");
        }
        catch (ClassNotFoundException e) {
            Debug.event((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"start", (Object)e);
        }
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Activator.this.colorRegistry = new ColorRegistry(PlatformUI.getWorkbench().getDisplay());
                }
            });
        } else {
            this.colorRegistry = new ColorRegistry(Display.getCurrent());
        }
        PAContextTracker.getInstance();
        this.fontArial = new Font(null, "Arial", 8, 0);
        this.fontArialSmall = new Font(null, "Arial", 8, 1);
        this.fontArialLarge = new Font(null, "Arial", 10, 1);
        String pid = "5655Y23";
        String name = Messages.getString("productName");
        IOfferingUsageRegistry offeringRegistry = UsagePlugin.getOfferingRegistry();
        offeringRegistry.findOrRegisterOffering(pid, name);
    }

    public void stop(BundleContext context) throws Exception {
        this.getPluginInstancePreferences().flush();
        if (this.lightgreyPattern != null && !this.lightgreyPattern.isDisposed()) {
            this.lightgreyPattern.dispose();
        }
        if (this.altlightgreyPattern != null && !this.altlightgreyPattern.isDisposed()) {
            this.altlightgreyPattern.dispose();
        }
        if (this.SMTPattern != null && !this.SMTPattern.isDisposed()) {
            this.SMTPattern.dispose();
        }
        if (this.greyPattern != null && !this.greyPattern.isDisposed()) {
            this.greyPattern.dispose();
        }
        if (this.bluePattern != null && !this.bluePattern.isDisposed()) {
            this.bluePattern.dispose();
        }
        this.fontArial.dispose();
        this.fontArialSmall.dispose();
        this.fontArialLarge.dispose();
        offWhite.dispose();
        plugin = null;
        PAConnectionTracker.getInstance().stop();
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public ImageDescriptor createImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public ImageDescriptor getImageDescriptor(String key) {
        return this.getImageRegistry().getDescriptor(key);
    }

    public Image getImage(String key) {
        return this.getImageRegistry().get(key);
    }

    public IConnectionPasswordStorage getPasswordStorage() {
        if (this.passwordStorage == null) {
            this.passwordStorage = IConnectionPasswordStorage.Factory.create((String)PLUGIN_ID);
        }
        return this.passwordStorage;
    }

    public IEclipsePreferences getPluginInstancePreferences() {
        return InstanceScope.INSTANCE.getNode(this.getBundle().getSymbolicName());
    }

    public IEclipsePreferences getPluginDefaultPreferences() {
        return DefaultScope.INSTANCE.getNode(this.getBundle().getSymbolicName());
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put(IMGD_EVENT, this.createImageDescriptor("icons/eventlog_obj.gif"));
        reg.put(IMGD_TSQUEUE, this.createImageDescriptor("icons/tsqueue.gif"));
        reg.put(IMGD_MISC, this.createImageDescriptor("icons/misc.gif"));
        reg.put(IMGD_PIE, this.createImageDescriptor("icons/piechrt.gif"));
        reg.put(IMGD_LINE, this.createImageDescriptor("icons/areachrt.gif"));
        reg.put(IMGD_HISTOGRAM, this.createImageDescriptor("icons/chart_obj.gif"));
        reg.put(IMGD_DATASHEET, this.createImageDescriptor("icons/table.gif"));
        reg.put(IMGD_DATASHEET_D, this.createImageDescriptor("icons/table_d.gif"));
        reg.put(IMGD_DATASRC, this.createImageDescriptor("icons/dtasrc_obj.gif"));
        reg.put(IMGD_LEGEND, this.createImageDescriptor("icons/legend_co.gif"));
        reg.put(IMG_UPARROW, this.createImageDescriptor("icons/search_prev.gif"));
        reg.put(IMG_DOWNARROW, this.createImageDescriptor("icons/down_arrow.gif"));
        reg.put(IMGD_SNA, this.createImageDescriptor("icons/sna.gif"));
        reg.put(IMGD_CTG, this.createImageDescriptor("icons/GatewayConnected.gif"));
        reg.put(IMGD_LOG, this.createImageDescriptor("icons/system_log.gif"));
        reg.put(IMGD_ID_MAP, this.createImageDescriptor("icons/idMap.gif"));
        reg.put(IMGD_DATE, this.createImageDescriptor("icons/dates.gif"));
        reg.put(IMGD_DATE_D, this.createImageDescriptor("icons/dates_d.gif"));
        reg.put(IMGD_TRANSIENT, this.createImageDescriptor("icons/transient.gif"));
        reg.put(IMGD_WAITING, this.createImageDescriptor("icons/waiting.gif"));
        reg.put(IMGD_COUNT, this.createImageDescriptor("icons/scatter_point.gif"));
        reg.put(IMGD_CALLEES, this.createImageDescriptor("/icons/callees.gif"));
        reg.put(IMGD_LINK, this.createImageDescriptor("/icons/linked_records.gif"));
        reg.put(IMGD_CRITICAL, this.createImageDescriptor("/icons/error.gif"));
        reg.put(IMGD_WARN, this.createImageDescriptor("/icons/warn.gif"));
        reg.put(IMGD_INFO, this.createImageDescriptor("/icons/info.gif"));
        reg.put(IMGD_CORNER, this.createImageDescriptor("/icons/tree_filler.gif"));
        reg.put(IMGD_CLEAR, this.createImageDescriptor("/icons/clear_filter.gif"));
        reg.put(IMGD_RUN, this.createImageDescriptor("/icons/run.gif"));
        reg.put(IMGD_RESET, this.createImageDescriptor("/icons/action_reset_module.gif"));
        reg.put(IMGD_DELETE_SORT, this.createImageDescriptor("/icons/deletesort.gif"));
        reg.put(IMG_CLOUD, this.createImageDescriptor("/icons/devcloud16.gif"));
        reg.put(IMG_MONITOR, this.createImageDescriptor("/icons/mntr_context.gif"));
        reg.put(IMG_ANALYSIS_HISTORY, this.createImageDescriptor("/icons/analysishistory_obj.gif"));
        reg.put(IMG_EXPORT_LAYOUT, this.createImageDescriptor("/icons/export_connections.gif"));
        reg.put(IMG_IMPORT_LAYOUT, this.createImageDescriptor("/icons/import_connections.gif"));
        reg.put(IMG_CHECKPOINT, this.createImageDescriptor("/icons/checkpoint_obj.gif"));
        reg.put(IMG_ALERT, this.createImageDescriptor("/icons/alert_view.gif"));
        reg.put(IMG_ALERT_ICON, this.createImageDescriptor("/icons/icon_alerts.gif"));
        reg.put(IMG_CHEAT, this.createImageDescriptor("/icons/start_cheatsheet.gif"));
        reg.put(IMG_INTERVAL, this.createImageDescriptor("/icons/linechrt.gif"));
        reg.put(IMG_SMF, this.createImageDescriptor("/icons/wbitrc_obj.gif"));
        reg.put(IMG_SMF_CAT, this.createImageDescriptor("/icons/trace_cat.gif"));
        reg.put(IMG_MISSING_MANIFEST, this.createImageDescriptor("/icons/missing.gif"));
        reg.put(IMG_OVERVIEW, this.createImageDescriptor("/icons/prod-ov-nav.gif"));
        reg.put(IMGD_TREE, this.createImageDescriptor("/icons/module-tree-mode.gif"));
        reg.put(IMG_PROFILER_LARGE, this.createImageDescriptor("/icons/profiler_large.gif"));
        reg.put(IMG_PROFILER_SMALL, this.createImageDescriptor("/icons/profiler.gif"));
        reg.put(ColumnDefinition.BUNDLE_NAME.getDBColumnRef(), this.createImageDescriptor("/icons/bundle.gif"));
        reg.put(ColumnDefinition.LOGSTREAM_NAME.getDBColumnRef(), this.createImageDescriptor("/icons/log.gif"));
        reg.put(ColumnDefinition.SUBPOOL_NAME.getDBColumnRef(), this.createImageDescriptor("/icons/storage_manager.gif"));
        reg.put(ColumnDefinition.LOCATION.getDBColumnRef(), this.createImageDescriptor("/icons/storage_manager.gif"));
        reg.put(ColumnDefinition.DSA_NAME.getDBColumnRef(), this.createImageDescriptor("/icons/storage_manager.gif"));
        reg.put(ColumnDefinition.LSR_POOL_NUMBER.getDBColumnRef(), this.createImageDescriptor("/icons/resource_pool.gif"));
        reg.put(ColumnDefinition.CONNECTION_NAME.getDBColumnRef(), this.createImageDescriptor("/icons/connection.gif"));
        reg.put(ColumnDefinition.QUEUE_MANAGER_NAME.getDBColumnRef(), this.createImageDescriptor("/icons/tsqueue.gif"));
        reg.put(ColumnDefinition.MODE_NAME.getDBColumnRef(), this.createImageDescriptor("/icons/isource_connection.gif"));
        reg.put(ColumnDefinition.APPC_SYSTEM_NAME.getDBColumnRef(), this.createImageDescriptor("/icons/isource_connection.gif"));
        reg.put(ColumnDefinition.DUMP_CODE.getDBColumnRef(), this.createImageDescriptor("/icons/dump.gif"));
        reg.put(ColumnDefinition.REQMODEL_NAME.getDBColumnRef(), this.createImageDescriptor("/icons/request_model.gif"));
        reg.put(ColumnDefinition.DOCTEMPLATE_NAME.getDBColumnRef(), this.createImageDescriptor("/icons/template.gif"));
        reg.put(ColumnDefinition.DB2CONN_NAME.getDBColumnRef(), this.createImageDescriptor("/icons/db2database.gif"));
        reg.put(ColumnDefinition.MQCONN_NAME.getDBColumnRef(), this.createImageDescriptor("/icons/mq.gif"));
        reg.put(ColumnDefinition.JOURNAL_NAME.getDBColumnRef(), this.createImageDescriptor("/icons/log.gif"));
        reg.put(ColumnDefinition.LOGSTREAM_NAME.getDBColumnRef(), this.getImageDescriptor(ColumnDefinition.JOURNAL_NAME.getDBColumnRef()));
        reg.put(ColumnDefinition.PIPELINE_NAME.getDBColumnRef(), this.createImageDescriptor("/icons/pipe.gif"));
        reg.put(ColumnDefinition.TCPIP_SERVICE.getDBColumnRef(), this.createImageDescriptor("icons/tcpip.gif"));
        reg.put(ColumnDefinition.WEBSERVICE_NAME.getDBColumnRef(), this.createImageDescriptor("/icons/webserv.gif"));
        reg.put(ColumnDefinition.DB2ENTRY_NAME.getDBColumnRef(), this.createImageDescriptor("/icons/db2entry.gif"));
        reg.put(ColumnDefinition.TARGET_NAME.getDBColumnRef(), this.createImageDescriptor("/icons/fepitarget.gif"));
        reg.put(ColumnDefinition.BEAN_NAME.getDBColumnRef(), this.createImageDescriptor("/icons/ejb.gif"));
        reg.put(ColumnDefinition.LIBRARY_NAME.getDBColumnRef(), this.createImageDescriptor("/icons/library.gif"));
        reg.put(ColumnDefinition.POOL_NAME.getDBColumnRef(), this.createImageDescriptor("/icons/fepipool.gif"));
        reg.put(ColumnDefinition.JVMSERVER_NAME.getDBColumnRef(), this.createImageDescriptor("/icons/server.gif"));
        reg.put(ColumnDefinition.CORBASERVER_NAME.getDBColumnRef(), this.getImageDescriptor(ColumnDefinition.JVMSERVER_NAME.getDBColumnRef()));
        reg.put(ColumnDefinition.DISPATCHER_START_G.getDBColumnRef(), this.createImageDescriptor("/icons/dispatcher.gif"));
        reg.put(ColumnDefinition.TCB_ADDRESS.getDBColumnRef(), this.createImageDescriptor("icons/tcpip.gif"));
        reg.put(ColumnDefinition.ACAPPLVR.getDBColumnRef(), this.createImageDescriptor("icons/version_history.gif"));
        reg.put(ColumnDefinition.ACAPPLNM.getDBColumnRef(), ModelUIPlugin.getTypeImage((ICICSType)ApplicationType.getInstance()));
        reg.put(ColumnDefinition.ACPLATNM.getDBColumnRef(), ModelUIPlugin.getTypeImage((ICICSType)PlatformType.getInstance()));
        reg.put(IMGD_PROPERTIES, this.createImageDescriptor("/icons/prop_ps.gif"));
        reg.put(ColumnDefinition.TD_QUEUE_ID.getDBColumnRef(), this.createImageDescriptor("/icons/tsqueue.gif"));
        reg.put(IMG_SECURITY, this.createImageDescriptor("/icons/keylock16x16.png"));
        try {
            reg.put(IMG_REFRESH, ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.ibm.cics.eclipse.common/icons/full/elcl16/refresh.gif")).createImage());
            reg.put(IMG_ADD, ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.ibm.cics.eclipse.common/icons/full/elcl16/add.gif")).createImage());
            reg.put(IMG_DELETE, ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.ibm.cics.eclipse.common/icons/full/elcl16/delete.gif")).createImage());
            reg.put(ColumnDefinition.ACOPERNM.getDBColumnRef(), ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.ibm.cics.core.ui/icons/OPERATION.GIF")).createImage());
            reg.put(IMGD_REGION, ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.ibm.cics.core.ui/icons/CICSRGN.GIF")).createImage());
            reg.put(ColumnDefinition.ATOMSERVICE_NAME.getDBColumnRef(), ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.ibm.cics.model.ui/icons/cicstypes/ATOMSERV.GIF")).createImage());
            reg.put(ColumnDefinition.IPCONN_NAME.getDBColumnRef(), ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.ibm.cics.model.ui/icons/cicstypes/IPCONN.GIF")).createImage());
            reg.put(ColumnDefinition.TERMINAL_ID.getDBColumnRef(), ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.ibm.cics.model.ui/icons/cicstypes/TERMNL.GIF")).createImage());
            reg.put(ColumnDefinition.TCLASS_NAME.getDBColumnRef(), ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.ibm.cics.model.ui/icons/cicstypes/TRANCLAS.GIF")).createImage());
            reg.put(ColumnDefinition.URIMAP_NAME.getDBColumnRef(), ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.ibm.cics.model.ui/icons/cicstypes/URIMAP.GIF")).createImage());
            reg.put(IMGD_TRAN, ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.ibm.cics.core.ui/icons/TRAN.GIF")).createImage());
            reg.put(ColumnDefinition.EVENTBINDING_NAME.getDBColumnRef(), ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.ibm.cics.model.ui/icons/cicstypes/EVNTBIND.GIF")).createImage());
            reg.put(IMGD_RESOURCE_GROUP_DEFINITION, ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.ibm.cics.core.ui/icons/RESGROUP.GIF")).createImage());
            reg.put(ColumnDefinition.JVM_PROFILE_NAME.getDBColumnRef(), ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.ibm.cics.model.ui/icons/cicstypes/JVMPROF.GIF")).createImage());
            reg.put(ColumnDefinition.PROGRAM_NAME.getDBColumnRef(), ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.ibm.cics.model.ui/icons/cicstypes/PROGRAM.GIF")).createImage());
            reg.put(ColumnDefinition.FILE_NAME.getDBColumnRef(), ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.ibm.cics.core.ui/icons/FILE.GIF")).createImage());
            reg.put(IMG_CUSTOM_COLUMNS, ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.ibm.cics.core.ui/icons/full/elcl16/customize_columns.gif")).createImage());
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, Activator.class.getName(), "initializeImageRegistry", "Reusing base graphics", e);
        }
        reg.put(ColumnDefinition.XMLTRANSFORM_NAME.getDBColumnRef(), this.createImageDescriptor("/icons/xmltransformation.gif"));
        reg.put(ColumnDefinition.TRAN_ID.getDBColumnRef(), this.getImageDescriptor(ColumnDefinition.TRAN.getDBColumnRef()));
    }

    public void init(IWorkbenchWindow workbenchWindow) {
        Debug.enter((Logger)logger, (String)UIPlugin.class.getName(), (String)"init", (Object)((Object)this), (Object)workbenchWindow);
        Debug.exit((Logger)logger, (String)UIPlugin.class.getName(), (String)"init");
    }

    public ColorRegistry getColorRegistry() {
        return this.colorRegistry;
    }
}

