/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model.definitions;

import com.ibm.cics.pa.model.ChartType;
import com.ibm.cics.pa.model.definitions.ChartSpecificDefinitions;
import com.ibm.cics.pa.model.definitions.ColumnContainment;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.utilities.MessagePackage;
import java.util.ArrayList;
import java.util.List;

public class YardStickSpecificDefinitions
implements ChartSpecificDefinitions {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ColumnDefinition[] sectors;
    private ColumnContainment[] sectorSegments;
    private String[] headings;
    private String[] heading_tooltips;
    private MessagePackage titleLabel;

    @Override
    public ChartType getChartType() {
        return ChartType.YARDSTICK;
    }

    public YardStickSpecificDefinitions(MessagePackage titleLabel, ColumnContainment[] sectorSegments, String[] headings, String[] tooltips) {
        this.titleLabel = titleLabel;
        this.sectorSegments = sectorSegments;
        this.headings = headings;
        this.heading_tooltips = tooltips;
    }

    public YardStickSpecificDefinitions(MessagePackage titleLabel, ColumnDefinition[] sectors) {
        this.titleLabel = titleLabel;
        this.sectors = sectors;
    }

    public ColumnDefinition[] getPrimaryColumns() {
        return this.sectors;
    }

    public ColumnContainment[] getContainments() {
        return this.sectorSegments;
    }

    public MessagePackage getPkg() {
        return this.titleLabel;
    }

    @Override
    public List<ColumnDefinition> getAllColumns() {
        int i;
        ArrayList<ColumnDefinition> results = new ArrayList<ColumnDefinition>();
        if (this.sectors != null) {
            i = 0;
            while (i < this.sectors.length) {
                results.add(this.sectors[i]);
                ++i;
            }
        }
        if (this.sectorSegments != null) {
            i = 0;
            while (i < this.sectorSegments.length) {
                results.add(this.sectorSegments[i].getPrimary());
                ColumnDefinition[] columnDefinitionArray = this.sectorSegments[i].getColumnRef();
                int n = columnDefinitionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ColumnDefinition defn = columnDefinitionArray[n2];
                    results.add(defn);
                    ++n2;
                }
                ++i;
            }
        }
        results.addAll(this.titleLabel.getColumns());
        return results;
    }

    @Override
    public int getDefaultIncrementWidth() {
        return 0;
    }

    @Override
    public int getDefaultWidth() {
        return 0;
    }

    public String[] getHeadings() {
        return this.headings;
    }

    public String[] getTooltips() {
        return this.heading_tooltips;
    }
}

