/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model.definitions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.pa.model.ChartType;
import com.ibm.cics.pa.model.definitions.AbstractChartDefinition;
import com.ibm.cics.pa.model.definitions.ChartCategorisation;
import com.ibm.cics.pa.model.definitions.ChartSpecificDefinitions;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.utilities.PredefinedTemplate;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.resource.ImageDescriptor;

public class SheetViewDefinition
extends AbstractChartDefinition {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(SheetViewDefinition.class.getPackage().getName());
    Presentation presentation = null;
    private ChartType type = ChartType.SHEET;
    private PredefinedTemplate layout;

    private SheetViewDefinition(Presentation presentation) {
        super(presentation != null ? presentation.getCode() : "");
        this.presentation = presentation;
    }

    public static ChartSpecification createForPresentation(Presentation presentation) {
        Debug.enter((Logger)logger, (String)SheetViewDefinition.class.getName(), (String)"createForPresentation");
        SheetViewDefinition defn = new SheetViewDefinition(presentation);
        Debug.exit((Logger)logger, (String)SheetViewDefinition.class.getName(), (String)"createForPresentation", (Object)defn);
        return defn;
    }

    public static SheetViewDefinition createForType(ChartType type, PredefinedTemplate layout) {
        Debug.enter((Logger)logger, (String)SheetViewDefinition.class.getName(), (String)"createForType");
        SheetViewDefinition defn = new SheetViewDefinition(null);
        defn.type = type;
        defn.layout = layout;
        Debug.exit((Logger)logger, (String)SheetViewDefinition.class.getName(), (String)"createForType", (Object)defn);
        return defn;
    }

    @Override
    public List<ColumnDefinition> getAllColumnDefinitions() {
        return new ArrayList<ColumnDefinition>();
    }

    @Override
    public ChartCategorisation[] getCategorisation() {
        return EnumSet.allOf(ChartCategorisation.class).toArray(new ChartCategorisation[EnumSet.allOf(ChartCategorisation.class).size()]);
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return Activator.getDefault().getImageDescriptor("table");
    }

    @Override
    public ChartSpecificDefinitions getSpecificType() {
        return null;
    }

    @Override
    public String getTitle() {
        return Messages.getString(this.type == ChartType.SHEET ? "SpreadSheet.Spreadsheet" : "SpreadSheet.alertdetail");
    }

    public PredefinedTemplate getLayout() {
        return this.layout;
    }

    @Override
    public ChartType getType() {
        return this.type;
    }

    @Override
    public String name() {
        return Messages.getString(this.type == ChartType.SHEET ? "SpreadSheet.Spreadsheet" : "SpreadSheet.alertdetail");
    }
}

