/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model.definitions;

import com.ibm.cics.pa.model.ChartType;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import org.eclipse.swt.graphics.Image;

public enum ReportStyle {
    Ranging(Messages.getString("Inquiries.Type.Ranging"), new ChartType[]{ChartType.HISTOGRAM, ChartType.COMBINEDHISTOGRAMLINE}),
    Timeline(Messages.getString("Inquiries.Type.Timeline"), new ChartType[]{ChartType.COMPACT_HISTOGRAM}),
    Detail(Messages.getString("Inquiries.Type.Detail"), new ChartType[]{ChartType.PIE}),
    StatsLink(Messages.getString("Inquiries.Type.StatsLink"), new ChartType[]{ChartType.SHEET});

    private ChartType[] implementations;
    private String text;

    public ChartType[] getImplementations() {
        return this.implementations;
    }

    public String getText() {
        return this.text;
    }

    private ReportStyle(String text, ChartType[] implementations) {
        this.text = text;
        this.implementations = implementations;
    }

    public ReportStyle getByName(String name) {
        if (name.equals(Ranging.name())) {
            return Ranging;
        }
        if (name.equals(Timeline.name())) {
            return Timeline;
        }
        if (name.equals(Detail.name())) {
            return Detail;
        }
        if (name.equals(StatsLink.name())) {
            return StatsLink;
        }
        return null;
    }

    public static ReportStyle deriveFromImplType(String ctype) {
        ChartType type = ChartType.deriveFrom(ctype);
        switch (type) {
            case HISTOGRAM: {
                return Ranging;
            }
            case COMPACT_HISTOGRAM: {
                return Timeline;
            }
            case SHEET: {
                return StatsLink;
            }
            case PIE: {
                return Detail;
            }
        }
        return Ranging;
    }

    public Image getImage() {
        switch (this) {
            case Ranging: {
                return Activator.getDefault().getImage("histogram");
            }
            case Timeline: {
                return Activator.getDefault().getImage("line");
            }
            case Detail: {
                return Activator.getDefault().getImage("pie");
            }
            case StatsLink: {
                return Activator.getDefault().getImage("link");
            }
        }
        return null;
    }
}

