/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model.definitions;

import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Messages;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;

public enum ProfilerLayout {
    CPU(Messages.getString("ChartDefinition.CPU_TIME_ANALYSIS"), new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.QRCPU_TIME_AVG, ColumnDefinition.MSCPU_TIME_AVG, ColumnDefinition.KY8CPU_TIME_AVG, ColumnDefinition.KY9CPU_TIME_AVG}),
    STORAGE(Messages.getString("ChartDefinition.MULTIROW_STORAGE_ANALYSIS"), new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.SC24CGET_COUNT_AVG, ColumnDefinition.SC24UGET_COUNT_AVG, ColumnDefinition.SC31CGET_COUNT_AVG, ColumnDefinition.SC31UGET_COUNT_AVG, ColumnDefinition.SC64CGET_COUNT_AVG, ColumnDefinition.SC64UGET_COUNT_AVG}),
    RESPONSE(Messages.getString("ChartDefinition.MULTIROW_RESPONSE_TIME_ANALYSIS"), new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.SUSPEND_TIME_AVG, ColumnDefinition.DISPWAIT_TIME_AVG, ColumnDefinition.DISPATCH_TIME_AVG, ColumnDefinition.CPU_TIME_AVG}),
    FILES(Messages.getString("ChartDefinition.FILE_USAGE_TRANSACTION"), new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.FCGET_COUNT_AVG, ColumnDefinition.FCPUT_COUNT_AVG, ColumnDefinition.FCBROWSE_COUNT_AVG, ColumnDefinition.FCADD_COUNT_AVG, ColumnDefinition.FCDELETE_COUNT_AVG}),
    ALLREFS(Messages.getString(""), new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.QRCPU_TIME_AVG, ColumnDefinition.MSCPU_TIME_AVG, ColumnDefinition.KY9CPU_TIME_AVG, ColumnDefinition.KY8CPU_TIME_AVG, ColumnDefinition.SC24CGET_COUNT_AVG, ColumnDefinition.SC24UGET_COUNT_AVG, ColumnDefinition.SC31CGET_COUNT_AVG, ColumnDefinition.SC31UGET_COUNT_AVG, ColumnDefinition.SC64CGET_COUNT_AVG, ColumnDefinition.SC64UGET_COUNT_AVG, ColumnDefinition.SUSPEND_TIME_AVG, ColumnDefinition.DISPWAIT_TIME_AVG, ColumnDefinition.DISPATCH_TIME_AVG, ColumnDefinition.CPU_TIME_AVG, ColumnDefinition.FCGET_COUNT_AVG, ColumnDefinition.FCPUT_COUNT_AVG, ColumnDefinition.FCBROWSE_COUNT_AVG, ColumnDefinition.FCADD_COUNT_AVG, ColumnDefinition.FCDELETE_COUNT_AVG});

    private ColumnDefinition[] definitions;
    private String label;
    private static HashMap<ColumnDefinition, Integer> lookup;

    private ProfilerLayout(String label, ColumnDefinition[] definitions) {
        this.setDefinitions(definitions);
        this.setLabel(label);
    }

    public ColumnDefinition[] getDefinitions() {
        return this.definitions;
    }

    private void setDefinitions(ColumnDefinition[] definitions) {
        this.definitions = definitions;
    }

    public static ColumnDefinition[] allColumns() {
        return ProfilerLayout.ALLREFS.definitions;
    }

    public static int getPositionOf(ColumnDefinition definition) {
        Integer result;
        if (lookup == null) {
            lookup = new HashMap();
            int i = 0;
            while (i < ProfilerLayout.allColumns().length) {
                lookup.put(ProfilerLayout.allColumns()[i], new Integer(i));
                ++i;
            }
        }
        if ((result = lookup.get(definition)) == null) {
            return -1;
        }
        return result;
    }

    public String getLabel() {
        return this.label;
    }

    private void setLabel(String label) {
        this.label = label;
    }

    public static ProfilerLayout getByName(String layout) {
        for (ProfilerLayout layout1 : EnumSet.allOf(ProfilerLayout.class)) {
            if (!layout1.name().equals(layout)) continue;
            return layout1;
        }
        return CPU;
    }

    public List<ColumnDefinition> getDefinitionsAsArray() {
        return Arrays.asList(this.definitions);
    }
}

